package com.bcxin.risk.report.enums;


/**
 * 任务状态
 * @author luopeng
 *
 */
public enum TaskStatus {
	
	

	NON{@Override public String getValue(){return "1";} @Override public String getName(){return "未完成";}},
	
	CONTINUE{@Override public String getValue(){return "2";} @Override public String getName(){return "进行中";}},
	
	COMPLETE {@Override public String getValue(){return "3";} @Override public String getName(){return "已完成";}},
	
	CLOSE {@Override public String getValue(){return "4";} @Override public String getName(){return "任务关闭";}},
	
	ASSIGNED {@Override public String getValue(){return "5";} @Override public String getName(){return "已分配";}};

    public abstract String getValue();
    
    public abstract String getName();
    
    public static TaskStatus convert_value(String value){
    	if ( "1".equals(value) ) {
    		return TaskStatus.NON;
    	} else if ("2".equals(value)) {
    		return TaskStatus.CONTINUE;
    	} else if ("3".equals(value)) {
    		return TaskStatus.COMPLETE;
    	} else if ("4".equals(value)) {
    		return TaskStatus.CLOSE;
    	} else if ("5".equals(value)) {
    		return TaskStatus.ASSIGNED;
    	}
    	return null;
    }
    
    public static TaskStatus convertName(String name){
    	if ( "NON".equals(name) ) {
    		return TaskStatus.NON;
    	} else if ("CONTINUE".equals(name)) {
    		return TaskStatus.CONTINUE;
    	} else if ("COMPLETE".equals(name)) {
    		return TaskStatus.COMPLETE;
    	} else if ("CLOSE".equals(name)) {
    		return TaskStatus.CLOSE;
    	}else if ("ASSIGNED".equals(name)) {
    		return TaskStatus.ASSIGNED;
    	}
    	return null;
    }
}
