package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum ReportWritingType {

	DATANO {
		public String getValue() {
			return "1";
		}

		public String getName() {
			return "资料未下载";
		}
	}, 

	DATAYES {
		public String getValue() {
			return "2";
		}

		public String getName() {
			return "资料已下载";
		}
	}, 

	REPORTNO {
		public String getValue() {
			return "3";
		}

		public String getName() {
			return "报告未提交";
		}
	}, 
	REPORTYES {
		public String getValue() {
			return "4";
		}

		public String getName() {
			return "报告已提交";
		}
	},
	COMPLETE{
		public String getValue() {
			return "5";
		}

		public String getName() {
			return "已完成";
		}
	};

	public abstract String getValue();

	public abstract String getName();

	public static ReportWritingType convert_value(String value) {
		if ("1".equals(value)) {
			return ReportWritingType.DATANO;
		} else if ("2".equals(value)) {
			return ReportWritingType.DATAYES;
		} else if ("3".equals(value)) {
			return ReportWritingType.REPORTNO;
		} else if ("4".equals(value)) {
			return ReportWritingType.REPORTYES;
		}else if ("5".equals(value)) {
			return ReportWritingType.COMPLETE;
		}else{
			return null;
		}
	}

	public static List<ReportWritingType> assginList() {
		List<ReportWritingType> list = new ArrayList<ReportWritingType>();
		list.add(ReportWritingType.DATANO);
		list.add(ReportWritingType.DATAYES);
		list.add(ReportWritingType.REPORTNO);
		list.add(ReportWritingType.REPORTYES);
		list.add(ReportWritingType.COMPLETE);
		return list;
	}
}
