package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum AddressType {

	/**场外*/
	OUTSIDE{public String getValue(){return "1";} public String getName(){return "室外";}},

	/**场内*/
    INSIDE{public String getValue(){return "2";} public String getName(){return "室内";}},

    /**场外场内*/
    INSIDEANDOUTSIDE{public String getValue(){return "3";} public String getName(){return "室内+室外";}};


    public abstract String getValue();

    public abstract String getName();

    public static AddressType convert_name(String name){
    	if ( "OUTSIDE".equals(name) ) {
    		return AddressType.OUTSIDE;
    	} else if ("INSIDE".equals(name)) {
    		return AddressType.INSIDE;
    	}
    	else if ("INSIDEANDOUTSIDE".equals(name)) {
    		return AddressType.INSIDEANDOUTSIDE;
    	}
    	return null;
    }

    public static AddressType convertName(String name){
    	if ( "室外".equals(name) ) {
    		return AddressType.OUTSIDE;
    	} else if ("室内".equals(name)) {
    		return AddressType.INSIDE;
    	}else if ("室内+室外".equals(name)) {
    		return AddressType.INSIDEANDOUTSIDE;
    	}
    	return OUTSIDE;
    }

    public static AddressType convert_value(String value){
    	if ( "1".equals(value) ) {
    		return AddressType.OUTSIDE;
    	} else if ("2".equals(value)) {
    		return AddressType.INSIDE;
    	}else if ("3".equals(value)) {
    		return AddressType.INSIDEANDOUTSIDE;
    	}
    	return null;
    }
    
    
    public static List<AddressType> list(){
    	List<AddressType> list = new ArrayList<AddressType>();
    
      	list.add(AddressType.INSIDE);
    	list.add(AddressType.OUTSIDE);
      	list.add(AddressType.INSIDEANDOUTSIDE);

    	return list;
    }
}
