package com.bcxin.risk.policy.domain;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.policy.enums.Gender;
import com.bcxin.risk.policy.enums.IdType;
import com.bcxin.risk.policy.enums.RelatedToRoleCode;
import com.bcxin.risk.policy.enums.RoleKind;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 保单（角色）
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_RoleInPolicy")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class RoleInPolicy extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = InsurancePolicy.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "policy_id")
	private InsurancePolicy insurancePolicy;

	@Enumerated(EnumType.STRING)
	private RoleKind roleKind; 
	
	@Enumerated(EnumType.STRING)
	private RelatedToRoleCode relatedToRoleCode; 

	private String fullName;//姓名

	@Enumerated(EnumType.STRING)
	private IdType idType; //证件类型

	private String idNumber;//证件号码

	private String occupationClass;//职业代码

	private String occupationDescription;//职业描述

	private String addressLines;//家庭住址

	private String phone;//手机号码

	@Temporal(TemporalType.DATE)
	private Date birthDate;//出生日期

	private String age;//年龄

	@Enumerated(EnumType.STRING)
	private Gender gender;//性别

	private String email;//邮箱地址
	
	private String contactName;
	
	private String contactPhone;
	
	private String businessLicense;
	

}
