package com.bcxin.risk.policy.domain;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.fasterxml.jackson.annotation.JsonBackReference;

/**
 * 产品介绍
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ProductIntroduce")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ProductIntroduce extends BaseBean {
	
	private static final long serialVersionUID = 1L;
	
	@ManyToOne(targetEntity = InsuranceProduct.class)
	@JoinColumn(name = "product_id")
	@JsonBackReference
	private InsuranceProduct product;//产品

	private String feature;//特色
	
	private String usable;//适应范围
	
	private String mainDuty;
	
	private String additionDuty;
	
	private String deductible;
	
	private String policyStructure;
	
	private String logo_src;//产品logo地址
	
	private String introduce_src;//产品介绍
	
	private String insureFlow_src;//投保流程
	
	private String plan_src;//保险方案
	
	private String claim_src;//理赔须知
	
	private String clause_src;//条款
	

}
