
package com.bcxin.risk.order.dto.data;


import com.bcxin.risk.base.domain.util.CipherDESUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

/**
 * 订单信息dto
 */
@Data
public class OrderFormDataDTO {

	private String updateOn;

	private String typename;

	private String orderId;

	private String activityId;

	private String orderNo;

	private String activityName;

	private String activitySource;

	private String createOn;

	private String orderDate;

	private String payDate;

	private String activityType;

	private String history;

	private String paymentMode;

	private String orderStatus;

	private String activityStatus;

	private String approvalStatus;

	private String comment;

	private String reportStatus;

	private String primaryStatus;

	private String sourceAmount;

	private String sourceReportAmount;

	private String amount;

	private String refundAmount;

	private String total;

	private Page page;

	private String reportAmount;

	private String discountAmount;

	private String province;

	private String city;

	private String area;

	private String alias;

	private String payOrg;

	private String serviceOrgType;

	private String submitMaterial; //需要上传材料 1为需要，0为不需要

	private String token;

	private String address;

	private String startDate;

	private String endDate;

	private String sponsor;

	private String approvalstatus;


	private String gov;

	private String pgjgCount;

	private String fyxm;  // 费用项目

	private String name;  // 机构名称

	private String contactName; // 联系人

	private String contactPhone; // 联系电话

	private String chooseAssess; // 是否选择评估机构

	private String isVirtualContractor; // 是否是虚拟单位

	private String pgOrgName; // 评估机构名称

	// 任务id
	private String taskId;

	// 支付方式，现金/转账
	private String paymentType;

	// 延后支付
	private String delayPhoto;

	private String isBackUp;

	private String sbApprovalStatus;
	// 发票类型
	private String invoiceType;

	public OrderFormDataDTO(Map<String,Object> map){
		String delayPhoto=safeTransfor(map.get("delayPhoto"));
		if(StringUtil.isNotEmpty(delayPhoto)){
			String [] s = delayPhoto.split("\\|\\|");
			if(s.length>1){
				this.delayPhoto=s[1];
			}
		}
		this.sbApprovalStatus=safeTransfor(map.get("sbApprovalStatus"));
		this.isBackUp=safeTransfor(map.get("isBackUp"));
		this.sponsor = safeTransfor(map.get("sponsor"));
		this.orderId = safeTransfor(map.get("orderId"));
		this.activityId = safeTransfor(map.get("activityId"));
		this.startDate = safeTransfor(map.get("startDate"));
		this.endDate = safeTransfor(map.get("endDate"));
		this.address = safeTransfor(map.get("address"));
		this.orderNo = safeTransfor(map.get("orderNo"));
		this.activityName = safeTransfor(map.get("activityName"));
		this.activitySource = safeTransfor(map.get("activitySource"));
		this.history = safeTransfor(map.get("history"));
		this.orderDate = safeTransfor(map.get("orderDate"));
		this.createOn = safeTransfor(map.get("createOn"));
		this.updateOn = safeTransfor(map.get("updateOn"));
		this.payDate = safeTransfor(map.get("payDate"));
		this.paymentMode = safeTransfor(map.get("paymentMode"));
		this.activityType = safeTransfor(map.get("activityType"));
		this.orderStatus = safeTransfor(map.get("orderStatus"));
		this.amount = safeTransfor(map.get("amount"));
		this.sourceAmount = safeTransfor(map.get("sourceAmount"));
		if(StringUtil.isEmpty(this.sourceAmount)){
			this.sourceAmount =this.amount;
		}
		this.refundAmount = safeTransfor(map.get("refundAmount"));
		this.total = safeTransfor(map.get("total"));
		this.activityStatus = safeTransfor(map.get("activityStatus"));
		this.approvalStatus = safeTransfor(map.get("approvalStatus"));
		this.primaryStatus = safeTransfor(map.get("primaryStatus"));
		this.reportStatus = safeTransfor(map.get("reportStatus"));
		this.reportAmount =safeTransfor(map.get("reportAmount"));
		this.sourceReportAmount=safeTransfor(map.get("sourceReportAmount"));
		if(StringUtil.isEmpty(this.sourceReportAmount)){
			this.sourceReportAmount =this.reportAmount;
		}
		this.discountAmount =safeTransfor(map.get("discountAmount"));
		this.province =safeTransfor(map.get("province"));
		this.city =safeTransfor(map.get("city"));
		this.area =safeTransfor(map.get("area"));
		this.alias =safeTransfor(map.get("alias"));
		this.typename = safeTransfor(map.get("typename"));
		this.isVirtualContractor = safeTransfor(map.get("isVirtualContractor"));
		this.pgOrgName=safeTransfor(map.get("pgOrgName"));
		if ("1".equals(this.isVirtualContractor)){
			this.payOrg = this.sponsor;
		} else {
			this.payOrg = StringUtil.isEmpty(safeTransfor(map.get("payOrg")))?safeTransfor(map.get("orgName")):safeTransfor(map.get("payOrg"));
		}
		this.serviceOrgType =safeTransfor(map.get("serviceOrgType"));
		this.approvalstatus =safeTransfor(map.get("approvalstatus"));
		this.gov =safeTransfor(map.get("gov"));
		this.pgjgCount =safeTransfor(map.get("pgjgCount"));
		this.fyxm =safeTransfor(map.get("fyxm"));
		this.name =safeTransfor(map.get("name"));
		this.contactName =safeTransfor(map.get("contactName"));
		this.contactPhone =safeTransfor(map.get("contactPhone"));
		this.chooseAssess =safeTransfor(map.get("chooseAssess"));
		if( StringUtil.isNotEmpty(this.serviceOrgType)){
			if("2,4,5,6,7".contains(this.serviceOrgType)){
				this.submitMaterial = "1";
			} else {
				this.submitMaterial = "0";
			}
		}
		this.token = CipherDESUtil.encrypt(this.orderId);
		this.taskId=safeTransfor(map.get("taskId"));
		this.paymentType=safeTransfor(map.get("paymentType"));
		this.comment = safeTransfor(map.get("comment"));
		this.invoiceType=safeTransfor(map.get("invoiceType"));
	}


	/**
	 *
	 * <b>Function 将Object安全转换为String</b>
	 *
	 * @param obj
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月22日 下午5:17:02
	 * @注意事项 </b>
	 * <b>
	 */
	private static String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
}