package com.bcxin.risk.order;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 线下交易
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_TransactionOnline")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class TransactionOnline extends Transaction {

	private static final long serialVersionUID = 1L;

	private String payOrderNo;//第三方支付平台订单号

	private String product;//支付平台的商品名称

	private String paymentType;//支付类型（支付宝、银联、微信等）(字典)

	private String requestUrl;//支付请求地址

	private String callBackResult;//支付回调结果

}
