package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 短信流水日志表
 */
@Entity
@Table(name = "LOG_SMSLOG")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = SMSLog.class)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SMSLog extends BaseBean {

	private static final long serialVersionUID = 1L;

	private String phone;
	
	private String content;

	/**
	 * 发送是否成功，0代表失败，1代表成功
	 */
	private String success;


}
