package com.bcxin.risk.expert.dto;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class ExpertPublicDto {

    private String oid;
    private String realName;
    private String level;
    private String expertCategory;
    private String taskQuote;
    private String professional;
    private String jobLiveAddr;
    private String jobLiveAddrCode;
    private String professionalName;
    private String keyword;
    private String userType;
    private String expertSource;
    private String selectAll;
    private String selectProvince;

    private Page page;

    public ExpertPublicDto(){

    }

    public ExpertPublicDto(Map<String,Object> map){
        this.oid=safeTransfer(map.get("oid"));
        this.realName=safeTransfer(map.get("realName"));
        this.level=safeTransfer(map.get("level"));
        this.expertCategory=safeTransfer(map.get("expertCategory"));
        this.taskQuote=safeTransfer(map.get("taskQuote"));
        this.jobLiveAddr=safeTransfer(map.get("jobLiveAddr"));
        this.jobLiveAddrCode=safeTransfer(map.get("jobLiveAddrCode"));
        this.professionalName=safeTransfer(map.get("professionalName"));
        this.professional=safeTransfer(map.get("professional"));
    }

    private String safeTransfer(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }

}
