package com.bcxin.risk.enums;

public enum ExpertTaskTypeEnum {

    REPORT_CHECK("100","报告审核任务"),
    SURVEY("200","现场勘查任务"),
    GUIDE("300","勘查指导任务");

    private String key;
    private String alias;

    ExpertTaskTypeEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(ExpertTaskTypeEnum e : ExpertTaskTypeEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
