package com.bcxin.risk.enums;

/**
 * 单据类型
 */
public enum BillTypeEnum {

    ACTIVITY_INFO("ACTIVITY_INFO","活动基本信息"),
    MATERIAL_MODULE_INFO("MATERIAL_MODULE_INFO","材料主体信息"),
    MATERIAL_INFO("MATERIAL_INFO","材料信息");

    private String key;
    private String alias;

    BillTypeEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(BillTypeEnum e : BillTypeEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
