package com.bcxin.risk.common.vo;

import java.util.ArrayList;
import java.util.List;

import com.bcxin.risk.report.enums.EmailMsgType;

public class EmailModel {
	private String subject;
	private EmailMsgType emailType; 
	private String to;
	private String content;
	private List<String> filePath = new ArrayList<String>();

	public EmailModel(){}
	
	public EmailModel(String subject,String content){
		this.subject = subject; 
		this.content = content;
	}
	
	
	public EmailModel(EmailMsgType type,String content) {
		switch (type) {
		case ACCOUTN:
			this.subject = "百川信更换邮箱验证";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">请勿回复本邮件.点击下面的链接,重设邮箱&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p><p style=\"text-indent:2em;\"><a href="
					+ content + " target='_BLANK'>点击我重新设置邮箱</a></p>"
					+ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<p style=\"text-indent:2em;\">提示:本邮件超过30分钟,链接将会失效，需要重新申请'重设邮箱'。</p>"
					+ "<p style=\"text-indent:2em;\">如有疑问请及时致电4009979696进行咨询。</p>";
			break;
		case PWVALIDATE:
			this.subject = "百川信找回密码验证";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">请勿回复本邮件.点击下面的链接,重设密码&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p><p style=\"text-indent:2em;\"><a href="
					+ content + " target='_BLANK'>点击我重新设置密码</a></p>"
					+ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<p style=\"text-indent:2em;\">提示:本邮件超过30分钟,链接将会失效，需要重新申请'找回密码'。</p>"
					+ "<p style=\"text-indent:2em;\">如有疑问请及时致电4009979696进行咨询。</p>";
			break;
		case RESETPASS:
			this.subject = "更换邮箱账号";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">请勿回复本邮件.点击下面的链接,重设邮箱&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p><p style=\"text-indent:2em;\"><a href="
					+ content + " target='_BLANK'>点击我重新设置邮箱</a></p>"
					+ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<p style=\"text-indent:2em;\">提示:本邮件超过30分钟,链接将会失效，需要重新申请'重设邮箱'。</p>"
					+ "<p style=\"text-indent:2em;\">如有疑问请及时致电4009979696进行咨询。</p>";
			break;
		case FORGETPASSWORD:
			this.subject = "勘察员身份绑定验证码";
			this.content = "亲爱的用户：<br>&nbsp;&nbsp;&nbsp;&nbsp;您好！验证码为："  + content ;
			break;	
		default:
			break;
		}
	}
	
	
	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public EmailMsgType getEmailType() {
		return emailType;
	}

	public void setEmailType(EmailMsgType emailType) {
		this.emailType = emailType;
	}

	public String getTo() {
		return to;
	}

	public void setTo(String to) {
		this.to = to;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public List<String> getFilePath() {
		return filePath;
	}

	public void setFilePath(List<String> filePath) {
		this.filePath = filePath;
	}

	public void addFilePath(String filePath) {
		if(this.filePath == null) {
			this.filePath = new ArrayList<String>();
		}
		this.filePath.add(filePath);
	}
}
