package com.bcxin.risk.common.dto.data;


import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

/**
 * 订单信息dto
 */
@Data
public class RegionDataDto {

    private String oid; //  区域ID

    private String area ; // 区域

    private String parent_id;  //  父级区域ID

    private String level; //  区域级别

    private String xzbz; //  选择标志

    private Page page;


    public RegionDataDto(Map<String,Object> map){
        this.oid = safeTransfor(map.get("oid"));
        this.area = safeTransfor(map.get("area"));
        this.parent_id = safeTransfor(map.get("parent_id"));
        this.level = safeTransfor(map.get("level"));
        this.xzbz = safeTransfor(map.get("xzbz"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author llc
     * @date 2017年5月6日
     * @注意事项 </b>
     * <b>
     */
    private static String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}

