
package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;


/**
 * 价格模板对应省市区
 */
@Entity
@Table(name = "risk_quotationRegion")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class QuotationRegion extends BaseBean {

    //报价模板
    @ManyToOne(targetEntity = Quotation.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
    @JoinColumn(name = "quotation_id")
    private Quotation quotation;

    private String region_Id;

    private String level;//城市（2），区县（3）

}
