/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.policy.enums;

import com.bcxin.risk.policy.enums.InsuranceCompany;
import java.util.HashMap;
import java.util.Map;

public enum Policy_ActivityQuota {
    CPIC_LEVEL_ONE{

        @Override
        public String getValue() {
            return "1";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e01400\u4e07\u2264\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\uff1c\u4eba\u6c11\u5e01600\u4e07";
        }
    }
    ,
    CPIC_LEVEL_TWO{

        @Override
        public String getValue() {
            return "2";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e01600\u4e07\u2264\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\uff1c\u4eba\u6c11\u5e01800\u4e07";
        }
    }
    ,
    CPIC_LEVEL_THREE{

        @Override
        public String getValue() {
            return "3";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e01800\u4e07\u2264\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\uff1c\u4eba\u6c11\u5e011000\u4e07";
        }
    }
    ,
    CPIC_LEVEL_FOUR{

        @Override
        public String getValue() {
            return "4";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e011000\u4e07\u2264\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\uff1c\u4eba\u6c11\u5e011500\u4e07";
        }
    }
    ,
    CPIC_LEVEL_FIVE{

        @Override
        public String getValue() {
            return "5";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e011500\u4e07\u2264\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\uff1c\u4eba\u6c11\u5e012000\u4e07";
        }
    }
    ,
    CPIC_LEVEL_SIX{

        @Override
        public String getValue() {
            return "6";
        }

        @Override
        public String getName() {
            return "\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\u2265\u4eba\u6c11\u5e012000\u4e07";
        }
    }
    ,
    HT_LEVEL_ONE{

        @Override
        public String getValue() {
            return "11";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e01500\u4e07\u2264\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\uff1c\u4eba\u6c11\u5e013500\u4e07";
        }
    }
    ,
    HT_LEVEL_TWO{

        @Override
        public String getValue() {
            return "12";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e011000\u4e07\u2264\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\uff1c\u4eba\u6c11\u5e013500\u4e07";
        }
    }
    ,
    HT_LEVEL_THREE{

        @Override
        public String getValue() {
            return "13";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e011500\u4e07\u2264\u7d2f\u8ba1\u8d54\u507f\u9650\u989d\uff1c\u4eba\u6c11\u5e013500\u4e07";
        }
    }
    ,
    HT_LEVEL_FOUR{

        @Override
        public String getValue() {
            return "14";
        }

        @Override
        public String getName() {
            return "\u4eba\u6c11\u5e012000\u4e07<\u4eba\u6c11\u5e013500\u4e07";
        }
    };


    public abstract String getValue();

    public abstract String getName();

    public static Policy_ActivityQuota calc(String number, String days, InsuranceCompany company) {
        int num = Integer.parseInt(number);
        int day = Integer.parseInt(days);
        if (InsuranceCompany.CPIC_PROPERTY.equals((Object)company)) {
            if (10000 <= num && day <= 3) {
                return CPIC_LEVEL_ONE;
            }
            if (10000 < num && num <= 50000 && day <= 3) {
                return CPIC_LEVEL_TWO;
            }
            if (50000 < num && day <= 3) {
                return CPIC_LEVEL_THREE;
            }
            if (10000 <= num && day > 3) {
                return CPIC_LEVEL_FOUR;
            }
            if (10000 < num && num <= 50000 && day > 3) {
                return CPIC_LEVEL_FIVE;
            }
            if (50000 < num && day > 3) {
                return CPIC_LEVEL_SIX;
            }
        }
        if (InsuranceCompany.HT.equals((Object)company)) {
            if (num <= 5000) {
                return HT_LEVEL_ONE;
            }
            if (5000 < num && num <= 10000) {
                return HT_LEVEL_TWO;
            }
            if (10000 < num && num <= 50000) {
                return HT_LEVEL_THREE;
            }
            if (50000 < num) {
                return HT_LEVEL_FOUR;
            }
        }
        return null;
    }

    public static Policy_ActivityQuota getLevel(String number) {
        int num = Integer.parseInt(number);
        if (num < 1000) {
            return HT_LEVEL_ONE;
        }
        if (num < 1500) {
            return HT_LEVEL_TWO;
        }
        if (num < 2000) {
            return HT_LEVEL_THREE;
        }
        if (num <= 3500) {
            return HT_LEVEL_FOUR;
        }
        return HT_LEVEL_ONE;
    }

    public static Map<String, String> calcLimit(Policy_ActivityQuota quota) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CPIC_LEVEL_ONE.equals((Object)quota)) {
            map.put("minLimit", "400");
            map.put("maxLimit", "600");
        } else if (CPIC_LEVEL_TWO.equals((Object)quota)) {
            map.put("minLimit", "600");
            map.put("maxLimit", "800");
        } else if (CPIC_LEVEL_THREE.equals((Object)quota)) {
            map.put("minLimit", "800");
            map.put("maxLimit", "1000");
        } else if (CPIC_LEVEL_FOUR.equals((Object)quota)) {
            map.put("minLimit", "1000");
            map.put("maxLimit", "1500");
        } else if (CPIC_LEVEL_FIVE.equals((Object)quota)) {
            map.put("minLimit", "1500");
            map.put("maxLimit", "2000");
        } else if (CPIC_LEVEL_SIX.equals((Object)quota)) {
            map.put("minLimit", "2000");
            map.put("maxLimit", "10000");
        } else if (HT_LEVEL_ONE.equals((Object)quota)) {
            map.put("minLimit", "500");
            map.put("maxLimit", "3500");
        } else if (HT_LEVEL_TWO.equals((Object)quota)) {
            map.put("minLimit", "1000");
            map.put("maxLimit", "3500");
        } else if (HT_LEVEL_THREE.equals((Object)quota)) {
            map.put("minLimit", "1500");
            map.put("maxLimit", "3500");
        } else if (HT_LEVEL_FOUR.equals((Object)quota)) {
            map.put("minLimit", "2000");
            map.put("maxLimit", "3500");
        }
        return map;
    }
}

