﻿-- 专家简历表增加专家奶浴，任务报价字段
ALTER TABLE `risk_expertcheckinfo`
ADD COLUMN `expertSource`  varchar(50) NULL COMMENT '专家来源:public,private' AFTER `level`;
ALTER TABLE `risk_expertcheckinfo`
ADD COLUMN `taskQuote`  varchar(50) NULL COMMENT '任务报价' AFTER `expertSource`;

-- 修改历史数据
update `risk_expertcheckinfo` set expertSource='private';



-- 专家用户表增加专家奶浴，专家等级，任务报价字段
ALTER TABLE `risk_expertuser`
ADD COLUMN `expertSource`  varchar(50) NULL COMMENT '专家来源:public,private' AFTER `personAchievement`;
ALTER TABLE `risk_expertuser`
ADD COLUMN `level`  varchar(50) NULL COMMENT '专家等级' AFTER `expertSource`;
ALTER TABLE `risk_expertuser`
ADD COLUMN `taskQuote`  varchar(50) NULL COMMENT '任务报价' AFTER `level`;

-- 修改历史数据
update `risk_expertuser` set expertSource='private';
update risk_expertuser set level='1' where expertCategory='初级';
update risk_expertuser set level='2' where expertCategory='中级';
update risk_expertuser set level='3' where expertCategory='高级';


-- 新增数据字典
insert into sys_dict(description,label,sort,type,value)
values('报告撰写状态','待专家接单','7','REPORTSUBSTATUS','40');
insert into sys_dict(description,label,sort,type,value)
values('报告撰写状态','专家已拒绝','8','REPORTSUBSTATUS','41');

insert into sys_dict(description,label,sort,type,value)
values('任务状态','待接单','12','TASKSTATUS','6');
insert into sys_dict(description,label,sort,type,value)
values('任务状态','已拒绝','13','TASKSTATUS','7');


-- 新增共享专家订单表
CREATE TABLE `risk_expertorderform_public` (
  `oid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `activityId` bigint(20) DEFAULT NULL,
  `orgId` bigint(20) DEFAULT NULL,
  `orderNo` varchar(50) DEFAULT NULL,
  `reportId` bigint(20) DEFAULT NULL,
  `taskId` bigint(20) DEFAULT NULL,
  `taskType` varchar(255) DEFAULT NULL COMMENT '任务类型',
  `userId` bigint(20) DEFAULT NULL COMMENT '专家id',
  `taskQuote` varchar(50) DEFAULT NULL COMMENT '任务报价',
  `taskStatus` varchar(50) DEFAULT NULL COMMENT '任务状态',
  `expertSource` varchar(50) DEFAULT NULL COMMENT '专家来源',
  `createOn` datetime DEFAULT NULL,
  `updateOn` datetime DEFAULT NULL,
  PRIMARY KEY (`oid`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COMMENT='共享专家订单';





