-- hzp
-- 2018-07-11
-- 新增专家简历审核表
CREATE TABLE `risk_expertcheckinfo` (
  `oid` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '待审核的专家信息',
  `userId` bigint(20) DEFAULT NULL COMMENT '专家用户id',
  `orgId` bigint(20) DEFAULT NULL COMMENT '所属机构',
  `realName` varchar(100) DEFAULT NULL COMMENT '真实名称',
  `email` varchar(100) DEFAULT NULL COMMENT '邮箱',
  `phone` varchar(20) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL COMMENT '电子签名',
  `cardNo` varchar(20) DEFAULT NULL COMMENT '身份证号',
  `sex` varchar(10) DEFAULT NULL COMMENT '性别',
  `birthday` varchar(10) DEFAULT NULL COMMENT '出生年月',
  `political` varchar(50) DEFAULT NULL COMMENT '政治面貌',
  `nation` varchar(50) DEFAULT NULL COMMENT '民族',
  `marital` varchar(50) DEFAULT NULL COMMENT '婚姻状况',
  `education` varchar(255) DEFAULT NULL COMMENT '最高学历',
  `educationNo` varchar(50) DEFAULT NULL COMMENT '学历证号',
  `nativeInfoCode` varchar(50) DEFAULT NULL COMMENT '籍贯code',
  `nativeInfo` varchar(50) DEFAULT NULL COMMENT '籍贯',
  `companyOrDept` varchar(100) DEFAULT NULL COMMENT '任职公司部门',
  `position` varchar(100) DEFAULT NULL COMMENT '职务',
  `workTitle` varchar(100) DEFAULT NULL COMMENT '职称',
  `aptitude_cert` varchar(2000) DEFAULT NULL COMMENT '资质证书',
  `jobLiveAddrCode` varchar(50) DEFAULT NULL COMMENT '工作居住地code',
  `jobLiveAddr` varchar(100) DEFAULT NULL COMMENT '工作居住地',
  `industryCategory` varchar(255) DEFAULT NULL COMMENT '所属行业',
  `professional` varchar(255) DEFAULT NULL COMMENT '擅长专业',
  `educationExperience` varchar(1000) DEFAULT NULL COMMENT '教育经历',
  `workExperience` varchar(1000) DEFAULT NULL COMMENT '工作经历',
  `learningExperience` varchar(1000) DEFAULT NULL COMMENT '学术团体任职经历',
  `projectExperience` varchar(1000) DEFAULT NULL COMMENT '曾主持/参加的课题、项目经历',
  `learningPaper` varchar(1000) DEFAULT NULL COMMENT '曾发表的学术文章',
  `successExperience` varchar(1000) DEFAULT NULL COMMENT '曾获得的成功',
  `personAchievement` varchar(1000) DEFAULT NULL COMMENT '个人业绩实例',
  `remarks` varchar(255) DEFAULT NULL COMMENT '备注',
  `createOn` datetime DEFAULT NULL,
  `updateOn` datetime DEFAULT NULL,
  `checkStatus` varchar(10) DEFAULT NULL COMMENT '审核状态，待审核 1，通过 2、不通过3',
  `checkOpinion` varchar(255) DEFAULT NULL COMMENT '审核意见',
  `level` varchar(255) DEFAULT NULL COMMENT '等级（1：初级，2：中级，3：高级）',
  PRIMARY KEY (`oid`),
  KEY `INX_EXPERTINFO_USERID` (`userId`) USING BTREE,
  KEY `INX_EXPERTINFO_ORGID` (`orgId`) USING BTREE,
  KEY `INX_EXPERTINFO_CHECKSTATUS` (`checkStatus`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8mb4 COMMENT='待审核专家信息';



-- hzp
-- 2018-07-06
-- 专家用户表新增专家明细字段
ALTER TABLE `risk_expertuser`
ADD COLUMN `checkStatus`  varchar(10) NULL DEFAULT 0 COMMENT '审核状态 0 待完善 1待审核 2 审核通过 3审核不通过' AFTER `expertOrg_id`,
ADD COLUMN `cardNo`  varchar(18) NULL COMMENT '身份证' AFTER `checkStatus`,
ADD COLUMN `birthday`  varchar(20) NULL DEFAULT NULL COMMENT '出生年月' AFTER `cardNo`,
ADD COLUMN `nation`  varchar(50) NULL COMMENT '民族' AFTER `birthday`,
ADD COLUMN `marital`  varchar(10) NULL COMMENT '婚姻状况' AFTER `nation`,
ADD COLUMN `educationNo`  varchar(255) NULL COMMENT '学历证号' AFTER `marital`,
ADD COLUMN `nativeInfo`  varchar(100) NULL COMMENT '籍贯' AFTER `educationNo`,
ADD COLUMN `nativeInfoCode`  varchar(100) NULL COMMENT '籍贯编码' AFTER `nativeInfo`,
ADD COLUMN `companyOrDept`  varchar(255) NULL COMMENT '任职公司或部门' AFTER `nativeInfoCode`,
ADD COLUMN `position`  varchar(100) NULL COMMENT '职务' AFTER `companyOrDept`,
ADD COLUMN `jobLiveAddr`  varchar(255) NULL COMMENT '工作居住地' AFTER `position`,
ADD COLUMN `jobLiveAddrCode`  varchar(255) NULL COMMENT '工作居住地编码' AFTER `jobLiveAddr`,
ADD COLUMN `professional`  varchar(255) NULL COMMENT '擅长专业' AFTER `jobLiveAddrCode`,
ADD COLUMN `educationExperience`  varchar(1000) NULL COMMENT '教育经历' AFTER `professional`,
ADD COLUMN `learningExperience`  varchar(1000) NULL COMMENT '学术团体任职经历' AFTER `educationExperience`,
ADD COLUMN `projectExperience`  varchar(1000) NULL COMMENT '曾主持/参加的课题、项目' AFTER `learningExperience`,
ADD COLUMN `learningPaper`  varchar(1000) NULL COMMENT '曾发表的学术文章' AFTER `projectExperience`,
ADD COLUMN `successExperience`  varchar(100) NULL COMMENT '曾获得的成功' AFTER `learningPaper`,
ADD COLUMN `personAchievement`  varchar(1000) NULL COMMENT '个人业绩实例' AFTER `successExperience`;

-- 修改存储最低报价字段类型
ALTER TABLE `risk_serviceorg`
MODIFY COLUMN `minQuote`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '报价最低限额' AFTER `umpayMerId`;

-- hzp
-- 2018-07-19
-- 新增机构账户信息记录表
CREATE TABLE `risk_org_account` (
  `oid` bigint(20) NOT NULL AUTO_INCREMENT,
  `orgId` bigint(20) DEFAULT NULL COMMENT '机构id',
  `bankNo` varchar(50) DEFAULT NULL COMMENT '银行卡号',
  `bankName` varchar(255) DEFAULT NULL COMMENT '银行名称',
  `unitName` varchar(255) DEFAULT NULL COMMENT '单位名称',
  `confirmTel` varchar(50) DEFAULT NULL COMMENT '确认电话',
  `createOn` datetime DEFAULT NULL,
  `updateOn` datetime DEFAULT NULL,
  PRIMARY KEY (`oid`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='评估机构转账信息';

-- 修改专家用户资质证书大小
ALTER TABLE `risk_expertuser`
MODIFY COLUMN `aptitude_cert`  varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '资质证书' AFTER `workYear`;

-- 日志表新增字段
ALTER TABLE `risk_syslog`
ADD COLUMN `url`  varchar(255) NULL AFTER `object_id`,
ADD COLUMN `reqParam`  varchar(255) NULL AFTER `url`,
ADD COLUMN `userAgent`  varchar(255) NULL AFTER `reqParam`,
ADD COLUMN `ip`  varchar(255) NULL AFTER `userAgent`,
ADD COLUMN `method`  varchar(255) NULL AFTER `ip`;

ALTER TABLE `risk_syslog`
MODIFY COLUMN `exception`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '异常信息' AFTER `content`;








