package com.bcxin.oa.old.service.task.bbd;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.*;
import com.bcxin.oa.old.dto.ComShiftDto;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.app.AppPerTaskCardRecordDTO;
import com.bcxin.oa.old.dto.bbd.BbdTaskCardRecord;
import com.bcxin.oa.old.dto.bbd.BbdTaskSchedul;
import com.bcxin.oa.old.dto.bbd.BbdTaskShift;
import com.bcxin.oa.old.entity.enterprise.company.ComBaseInfo;
import com.bcxin.oa.old.entity.log.SysInterfaceLog;
import com.bcxin.oa.old.entity.task.ComShiftRule;
import com.bcxin.oa.old.entity.task.ComTask;
import com.bcxin.oa.old.entity.task.ComTaskSchedul;
import com.bcxin.oa.old.mapper.ComBaseInfoMapper;
import com.bcxin.oa.old.mapper.ComTaskInsidePushMapper;
import com.bcxin.oa.old.mapper.ComTaskMapper;
import com.bcxin.oa.old.mapper.ComTaskSchedulMapper;
import com.bcxin.oa.old.mapper.log.SysInterfaceLogMapper;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.service.system.CacheServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.ScheduledThreadPoolExecutor;

/**
 * 百保盾联调
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
@Service
@Transactional
public class BbdTestServiceImpl implements BbdTestService {
    private static Logger logger = LoggerFactory.getLogger(BbdTestServiceImpl.class);
    @Resource
    private CommonService commonService;
    @Resource
    private ComTaskMapper comTaskMapper;
    @Resource
    private ComTaskInsidePushMapper comTaskInsidePushMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private CacheServiceImpl cacheService;
    @Resource
    private SysInterfaceLogMapper sysInterfaceLogMapper;

    @Resource
    private ComTaskSchedulMapper comTaskSchedulMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 获取当前请求对象
     *
     * @return
     */
    public HttpServletRequest getRequest() {
        try {
            return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        } catch (Exception e) {
            return null;
        }
    }

    /****** 驻勤点信息 **************/
    @Override
    public void bbdSaveOrUpdateTask(ComTaskDto comTaskDto) {
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(comTaskDto.getComId());
        if (comBaseInfoDB != null) {
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            comTaskDto.setSessionId(bbdToken);
            /*** 查询出任务人员名单 ***/
            List<Map<String, String>> taskPerList = comTaskInsidePushMapper.getTaskPerNew(comTaskDto.getComTaskId(),
                    comTaskDto.getComId());
            comTaskDto.setPerList(taskPerList);
            comTaskDto.setPerNum(String.valueOf(taskPerList.size()));
            Map<String, Object> stringObjectMap = new HashMap<>(10);
            stringObjectMap.put("comTask", JSON.toJSONString(comTaskDto));
            stringObjectMap.put("sid", comTaskDto.getSessionId());
            runBbdSaveOrUpdateTask(stringObjectMap, configURL, BBDServiceConst.ZQD_SAVE_TASK, JSON.toJSONString(stringObjectMap), InterfaceTypeConst.INTERFACETYPE_1107);
        }
    }


    @Override
    public void bbdDeleteTask(ComTaskDto comTaskDto) {
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(comTaskDto.getComId());
        if (comBaseInfoDB != null) {
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            comTaskDto.setSessionId(bbdToken);
            // 开始执行删除任务信息
            Map<String, Object> stringObjectMap = new HashMap<>(10);
            stringObjectMap.put("comTask", JSON.toJSONString(comTaskDto));
            stringObjectMap.put("sid", comTaskDto.getSessionId());
            runBbdSaveOrUpdateTask(stringObjectMap, configURL, BBDServiceConst.ZQD_SAVE_TASK, JSON.toJSONString(stringObjectMap), InterfaceTypeConst.INTERFACETYPE_1108);
        }
    }

    /**
     * 通用方法
     * 创建/保存任务信息 用于调task/save.json。
     *
     * @param stringObjectMap 请求参数Map
     * @param configURL       接口地址通用部分
     * @param type            接口地址个性化部分
     * @param jsonStr         将请求参数Map转成string插入日志表
     * @param logType         日志类型或者代码
     */
    public void runBbdSaveOrUpdateTask(Map<String, Object> stringObjectMap, String configURL, String type, String jsonStr, String logType) {
        // 记录接口日志
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        try {
            Long interfaceLogId = idWorker.nextId();
            sysInterfaceLog.setInterfaceLogId(interfaceLogId);
            sysInterfaceLog.setCreateTime(new Date());
            sysInterfaceLog.setCreateBy((Long) stringObjectMap.get("createBy"));
            sysInterfaceLog.setInterfaceType(logType);
            sysInterfaceLog.setStartTime(new Date());
            sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
            sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
            sysInterfaceLog.setParameters(jsonStr);
            String url = configURL + type;
            sysInterfaceLog.setUrl(url);
            Result result = BBDService.common(stringObjectMap, configURL, type);
            if (result != null && Result.SUCCESS.equals(result.getRetType())) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        /*** 开线程插入业务日志表 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });
        /*** 如果同步失败回滚 ***/
        if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
        }
    }


    /**
     * 新增任务人员
     * @param dto
     * @param perIdList
     * @auth llc
     * @date 2020-04-17
     */
    @Override
    public void bbdAddTaskPer(ComTaskDto dto,List<String> perIdList){
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(dto.getComId());
        if (comBaseInfoDB != null) {
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            dto.setSessionId(bbdToken);
            // 开线程执行修改公司班次信息
            runBbdAddTaskPer(dto, perIdList, configURL);
        }
    }

    public void runBbdAddTaskPer(ComTaskDto dto,List<String> perIdList, String configURL) {

        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("comTaskId", dto.getComTaskId());
        paramMap.put("perIdListStr", StringUtils.join(perIdList, ","));
        paramMap.put("createBy", dto.getCreateBy());
        paramMap.put("sid", dto.getSessionId());

        /*** 记录接口日志 ***/
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1132);
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));

        String url = configURL + BBDServiceConst.ADD_TASK_PER;
        sysInterfaceLog.setUrl(url);
        try {
            Result result = BBDService.addTaskPer(paramMap,url);
            if (result != null && Result.SUCCESS.equals(result.getRetType())) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        /*** 开线程插入业务日志表 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });
        /*** 如果同步失败回滚 ***/
        if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
        }
    }

    /**
     * 移除任务人员
     * @param dto
     * @param perIdList
     * @auth llc
     * @date 2020-04-17
     */
    @Override
    public void bbdRemoveTaskPer(ComTaskDto dto,List<String> perIdList){
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(dto.getComId());
        if (comBaseInfoDB != null) {
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            dto.setSessionId(bbdToken);
            // 开线程执行修改公司班次信息
            runBbdRemoveTaskPer(dto, perIdList, configURL);
        }
    }

    public void runBbdRemoveTaskPer(ComTaskDto dto,List<String> perIdList, String configURL) {

        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("comTaskId", dto.getComTaskId());
        paramMap.put("perIdListStr", StringUtils.join(perIdList, ","));
        paramMap.put("createBy", dto.getCreateBy());
        paramMap.put("sid", dto.getSessionId());

        /*** 记录接口日志 ***/
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1133);
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));

        String url = configURL + BBDServiceConst.REMOVE_TASK_PER;
        sysInterfaceLog.setUrl(url);
        try {
            Result result = BBDService.removeTaskPer(paramMap,url);
            if (result != null && Result.SUCCESS.equals(result.getRetType())) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        /*** 开线程插入业务日志表 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });
        /*** 如果同步失败回滚 ***/
        if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
        }
    }


    /**
     * 保存企业驻勤点班次
     *
     * @param comShiftDto
     * @param ruleList
     * @auth llc
     * @date 2020-03-26
     */
    @Override
    public void bbdSaveComTaskShift(ComShiftDto comShiftDto, List<ComShiftRule> ruleList) {
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(comShiftDto.getComId());
        if (comBaseInfoDB != null) {
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            comShiftDto.setSessionId(bbdToken);
            // 开线程执行修改公司班次信息
            runbbdSaveComTaskShift(comShiftDto, ruleList, configURL);
        }
    }

    public void runbbdSaveComTaskShift(ComShiftDto dto, List<ComShiftRule> ruleList, String configURL) {

        BbdTaskShift bbdTaskShift = new BbdTaskShift();
        ObjectUtils.copyProperties(bbdTaskShift, dto);
        bbdTaskShift.setComShiftRuleList(ruleList);

        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("taskShiftStr", JSONObject.toJSONString(bbdTaskShift));
        paramMap.put("sid", dto.getSessionId());

        /*** 记录接口日志 ***/
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1109);
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));

        String url = configURL + BBDServiceConst.SAVE_COM_SHIFT;
        sysInterfaceLog.setUrl(url);
        try {
            Result result = BBDService.syncComShift(paramMap,url);
            if (result != null && Result.SUCCESS.equals(result.getRetType())) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        /*** 开线程插入业务日志表 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });
        /*** 如果同步失败回滚 ***/
        if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
        }
    }


    /**
     * 删除企业驻勤点班次
     *
     * @param comShiftDto
     * @auth llc
     * @date 2020-03-26
     */
    @Override
    public void bbdDeleteComTaskShift(ComShiftDto comShiftDto) {
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(comShiftDto.getComId());
        if (comBaseInfoDB != null) {
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            comShiftDto.setSessionId(bbdToken);
            // 开线程执行删除公司班次信息
            runBbdDeleteComTaskShift(comShiftDto, configURL);
        }
    }

    public void runBbdDeleteComTaskShift(ComShiftDto dto, String configURL) {
        Map paramMap = new HashMap<>();
        paramMap.put("shiftId", dto.getShiftId());
        paramMap.put("sid", dto.getSessionId());
        /*** 记录接口日志 ***/
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1110);
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));

        String url = configURL + BBDServiceConst.DELETE_COM_SHIFT;
        sysInterfaceLog.setUrl(url);
        try {
            Result result = BBDService.deleteComShift(paramMap, url);
            if (result != null && Result.SUCCESS.equals(result.getRetType())) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        /*** 开线程插入业务日志表 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });
        /*** 如果同步失败回滚 ***/
        if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
        }
    }



    /**
     * 同步驻勤排班信息
     *
     * @param list
     * @param dto
     * @author llc
     * @date 2020-03-24
     */
    @Override
    public void bbdSyncTaskSchedul(List<ComTaskSchedul> list, ParamDTO dto) {
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String openSubstation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(dto.getComId());
        if (comBaseInfoDB != null) {
            // 保安行业才需要访问百保盾接口
            if (!ObjectUtil.equal(DictConst.INDUSTRYTYPE_BAXY, comBaseInfoDB.getIndustryType())) {
                return;
            }
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(openSubstation) && openSubstation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            dto.setSessionId(bbdToken);
            runBbdSyncTaskSchedul(list, dto, configURL);
        }
    }

    public void runBbdSyncTaskSchedul(List<ComTaskSchedul> taskSchedulList, ParamDTO dto, String configURL) {

        List<String> perIdList = StrSplitter.split(dto.getPerIds(), CommonConst.COMMA, true, true);
        List<BbdTaskSchedul> bbdTaskSchedulList = new ArrayList<>();
        for (String perId : perIdList) {
            BbdTaskSchedul bbdTaskSchedul = new BbdTaskSchedul();
            bbdTaskSchedul.setPerId(perId);
            List<ComTaskSchedul> list = new ArrayList<>();
            for (ComTaskSchedul comTaskSchedul : taskSchedulList) {
                if (comTaskSchedul.getPerId().toString().equals(perId)) {
                    list.add(comTaskSchedul);
                }
            }
            bbdTaskSchedul.setTaskSchedulList(list);
            /*** 因为本次excel的导入排班可能把原有的排班删除,所以空的数据也要传给百保盾 ***/
            bbdTaskSchedulList.add(bbdTaskSchedul);
        }
        // 记录接口日志
        Map paramMap = new HashMap<>();
        paramMap.put("persons", JSONArray.toJSONString(bbdTaskSchedulList));
        paramMap.put("comTaskId", dto.getComTaskId());
        paramMap.put("startDate", dto.getDate());
        paramMap.put("endDate", dto.getDate());
        paramMap.put("sid", dto.getSessionId());
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1150);
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));
        String url = configURL + BBDServiceConst.SAVE_TASK_SCHEDUL;
        sysInterfaceLog.setUrl(url);
        try {
            Result result = BBDService.syncTaskSchedulForArs(paramMap, url);
            if (result.getRetType().equals(Result.SUCCESS)) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        /*** 开线程插入业务日志表 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });

        /*** 如果同步失败回滚 ***/
        if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
        }
    }

    /**
     * 批量同步驻勤排班信息
     *
     * @param perIdList
     * @param dto
     * @author llc
     * @date 2020-03-24
     */
    @Override
    public void bbdBatchSyncTaskSchedul(List<String> perIdList, ParamDTO dto) {
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String openSubstation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(dto.getComId());
        if (comBaseInfoDB != null) {
            // 保安行业才需要访问百保盾接口
            if (!ObjectUtil.equal(DictConst.INDUSTRYTYPE_BAXY, comBaseInfoDB.getIndustryType())) {
                return;
            }
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(openSubstation) && openSubstation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            dto.setSessionId(bbdToken);
            runBbdBatchSyncTaskSchedul(perIdList, dto, configURL);
        }
    }

    public void runBbdBatchSyncTaskSchedul(List<String> perIdList, ParamDTO dto, String configURL) {
        /*** 查询相应月份的排班记录同步百保盾 ***/

        String today = DateUtils.formatDate(new Date());
        ComTask comTask = comTaskMapper.getByPrimaryKey(dto.getComTaskId());

        /*** 查询目前有效的人员ID ***/

        String monthfirstDay = dto.getMonth() + "-01";
        String monthLastDay = DateUtils.formatDate(DateUtil.endOfMonth(DateUtils.parseDate(monthfirstDay)));

        /*** 比较求目前导入影响的最小日期范围,今天不和任务结束日期比较是因为任务结束状态无法导入***/
        String startDate = "";
        String endDate = "";
        if (DateUtils.dateCompare(monthfirstDay, today)) {
            startDate = today;
        } else {
            startDate = monthfirstDay;
        }
        if (DateUtils.dateCompare(startDate, DateUtils.formatDate(comTask.getStartDate()))) {
            startDate = DateUtils.formatDate(comTask.getStartDate());
        }

        if (DateUtils.dateCompare(monthLastDay, DateUtils.formatDate(comTask.getEndDate()))) {
            endDate = monthLastDay;
        } else {
            endDate = DateUtils.formatDate(comTask.getEndDate());
        }

        List<ComTaskSchedul> taskSchedulList = comTaskSchedulMapper.getSyncTaskSchedulList(dto.getComTaskId(), startDate, endDate, perIdList);

        List<BbdTaskSchedul> bbdTaskSchedulList = new ArrayList<>();
        for (String perId : perIdList) {
            BbdTaskSchedul bbdTaskSchedul = new BbdTaskSchedul();
            bbdTaskSchedul.setPerId(perId);
            List<ComTaskSchedul> list = new ArrayList<>();
            for (ComTaskSchedul comTaskSchedul : taskSchedulList) {
                if (comTaskSchedul.getPerId().toString().equals(perId)) {
                    list.add(comTaskSchedul);
                }
            }
            bbdTaskSchedul.setTaskSchedulList(list);
            /*** 因为本次excel的导入排班可能把原有的排班删除,所以空的数据也要传给百保盾 ***/
            bbdTaskSchedulList.add(bbdTaskSchedul);
        }

        if (bbdTaskSchedulList != null && bbdTaskSchedulList.size() > 0) {
            /*** 由于人员排班数据可能非常多，会超过post接口最大长度，这里做100提交一次 ***/
            int listSize = bbdTaskSchedulList.size();
            int i = 0;
            while (listSize > 100) {
                // 记录接口日志
                Map paramMap = new HashMap<>();
                paramMap.put("persons", JSONArray.toJSONString(bbdTaskSchedulList.subList(i, i + 100)));
                paramMap.put("comTaskId", dto.getComTaskId());
                paramMap.put("startDate", startDate);
                paramMap.put("endDate", endDate);
                paramMap.put("sid", dto.getSessionId());
                SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
                Long interfaceLogId = idWorker.nextId();
                sysInterfaceLog.setInterfaceLogId(interfaceLogId);
                sysInterfaceLog.setCreateTime(new Date());
                sysInterfaceLog.setCreateBy(dto.getCreateBy());
                sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1150);
                sysInterfaceLog.setStartTime(new Date());
                sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
                sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
                sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));
                String url = configURL + BBDServiceConst.SAVE_TASK_SCHEDUL;
                sysInterfaceLog.setUrl(url);
                try {
                    Result result = BBDService.syncTaskSchedulForArs(paramMap, url);
                    if (result.getRetType().equals(Result.SUCCESS)) {
                        sysInterfaceLog.setInterfaceExecStatus("1");
                    } else {
                        sysInterfaceLog.setInterfaceExecStatus("0");
                        sysInterfaceLog.setResult(result.getMsg());
                    }
                } catch (Exception e) {
                    sysInterfaceLog.setInterfaceExecStatus("0");
                    sysInterfaceLog.setResult("接口调用失败");
                }
                sysInterfaceLog.setEndTime(new Date());
                /*** 开线程插入业务日志表 ***/
                ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
                threadPool.execute(new Runnable() {
                    @Override
                    public void run() {
                        sysInterfaceLogMapper.insert(sysInterfaceLog);
                    }
                });

                /*** 如果同步失败回滚 ***/
                if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
                    throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
                }

                i = i + 100;
                listSize = listSize - 100;
            }
            if (listSize > 0) {
                // 记录接口日志
                Map paramMap = new HashMap<>();
                paramMap.put("persons", JSONArray.toJSONString(bbdTaskSchedulList.subList(i, i + listSize)));
                paramMap.put("comTaskId", dto.getComTaskId());
                paramMap.put("startDate", startDate);
                paramMap.put("endDate", endDate);
                paramMap.put("sid", dto.getSessionId());
                SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
                Long interfaceLogId = idWorker.nextId();
                sysInterfaceLog.setInterfaceLogId(interfaceLogId);
                sysInterfaceLog.setCreateTime(new Date());
                sysInterfaceLog.setCreateBy(dto.getCreateBy());
                sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1150);
                sysInterfaceLog.setStartTime(new Date());
                sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
                sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
                sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));
                String url = configURL + BBDServiceConst.SAVE_TASK_SCHEDUL;
                sysInterfaceLog.setUrl(url);
                try {
                    Result result = BBDService.syncTaskSchedulForArs(paramMap, url);
                    if (result.getRetType().equals(Result.SUCCESS)) {
                        sysInterfaceLog.setInterfaceExecStatus("1");
                    } else {
                        sysInterfaceLog.setInterfaceExecStatus("0");
                        sysInterfaceLog.setResult(result.getMsg());
                    }
                } catch (Exception e) {
                    sysInterfaceLog.setInterfaceExecStatus("0");
                    sysInterfaceLog.setResult("接口调用失败");
                }
                sysInterfaceLog.setEndTime(new Date());
                /*** 开线程插入业务日志表 ***/
                ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
                threadPool.execute(new Runnable() {
                    @Override
                    public void run() {
                        sysInterfaceLogMapper.insert(sysInterfaceLog);
                    }
                });

                /*** 如果同步失败回滚 ***/
                if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
                    throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
                }
            }
        }
    }

    /**
     * 同步任务打卡记录
     * @param dto
     * @author llc
     * @date 2020-03-26
     */
    @Override
    public void bbdSyncPerTaskCardRecord(AppPerTaskCardRecordDTO dto){
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        HttpServletRequest request = getRequest();
        String openSubstation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(dto.getComId());
        if (comBaseInfoDB != null) {
            // 保安行业才需要访问百保盾接口
            if (!ObjectUtil.equal(DictConst.INDUSTRYTYPE_BAXY, comBaseInfoDB.getIndustryType())) {
                return;
            }
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(openSubstation) && openSubstation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
            String bbdToken = cacheService.getBbdAccessToken(comBaseInfoDB.getComId(),configURL);
            dto.setSessionId(bbdToken);
            runBbdSyncPerTaskCardRecord(dto,configURL);
        }
    }

    public void runBbdSyncPerTaskCardRecord(AppPerTaskCardRecordDTO dto, String configURL) {

        // 记录接口日志
        BbdTaskCardRecord bbdTaskCardRecord = new BbdTaskCardRecord();
        ObjectUtils.copyProperties(bbdTaskCardRecord, dto);
        Map paramMap = new HashMap<>();
        paramMap.put("cardRecord", JSONArray.toJSONString(bbdTaskCardRecord));
        paramMap.put("sid", dto.getSessionId());
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_2000);
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));
        String url = configURL + BBDServiceConst.SAVE_TASK_CARD;
        sysInterfaceLog.setUrl(url);
        try {
            Result result = BBDService.syncTaskCard(paramMap, url);
            if (result.getRetType().equals(Result.SUCCESS)) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        sysInterfaceLogMapper.insert(sysInterfaceLog);
    }


    @Override
    public void bbdDeleteTaskBatch(ComTaskDto dto,List<Long> taskIdList) throws BusinessException {
        if(dto.getComId()==null){
            throw new BusinessException(Result.BUSINESS_ERROR,"comId不能为空");
        }
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        Integer province = null;
        ComBaseInfo comBaseInfoDB = comBaseInfoMapper.selectByID(dto.getComId());
        if (comBaseInfoDB != null) {
            province = comBaseInfoDB.getRegProvince();
        }
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        /*** 未配置的省份不调接口 by llc 2019-03-18 ***/
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            // 开线程执行修改公司班次信息
            runBbdDeleteTaskBatch(dto, taskIdList, configURL);
        }
    }



    public void runBbdDeleteTaskBatch(ComTaskDto dto,List<Long> taskIdList, String configURL) throws BusinessException {

        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("taskIdList",taskIdList);
        paramMap.put("sid", dto.getSessionId());

        /*** 记录接口日志 ***/
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1134);
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));

        String url = configURL + BBDServiceConst.DELETE_TASK_BATCH;
        sysInterfaceLog.setUrl(url);
        try {
            Result result = BBDService.removeTaskPer(paramMap,url);
            if (result != null && Result.SUCCESS.equals(result.getRetType())) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        /*** 开线程插入业务日志表 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });
        /*** 如果同步失败回滚 ***/
        if (CommonConst.N.equals(sysInterfaceLog.getInterfaceExecStatus())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "发生未知错误");
        }
    }

    /**
     * <b> 校验人员是否有人口库照片接口 </b>
     * @author ZXF
     * @create 2020/09/09 0009 14:36
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result bbdCheckPersonBaseHeadImg(Integer province,String idCardNo) throws BusinessException {
        if(province==null){
            throw new BusinessException(Result.BUSINESS_ERROR,"province不能为空");
        }
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            Map<String,Object> paramMap = new HashMap<>();
            paramMap.put("idnum",idCardNo);
            String url = configURL + BBDServiceConst.CHECK_PERSON_HEADIMG;
            try {
                return BBDService.checkPersonBaseHeadImg(paramMap,url);
            } catch (Exception e) {
                return Result.fail("接口调用失败，ERR："+e.getMessage());
            }
        }
        return Result.fail("未配置到有效服务");
    }

    /**
     * <b> 联名卡申请前向百保盾发起资格证推送状态变更 </b>
     * @author ZXF
     * @create 2020/09/15 0015 13:30
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result bbdApplyBeforeSend(Integer province,String idCardNo) throws BusinessException {
        if(province==null){
            throw new BusinessException(Result.BUSINESS_ERROR,"province不能为空");
        }
        String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        String configURL = ""; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + province);
        }
        if (StringUtils.isNotEmpty(configURL) && !configURL.equalsIgnoreCase("null")) {
            Map<String,Object> paramMap = new HashMap<>();
            String url = configURL + BBDServiceConst.UPDATE_PERSON_ZGZ_STATUS.replace("{idnum}",idCardNo);
            try {
                return BBDService.applyBeforeSend(paramMap,url);
            } catch (Exception e) {
                return Result.fail("接口调用失败，ERR："+e.getMessage());
            }
        }
        return Result.fail("未配置到有效服务");
    }

}