package com.bcxin.oa.old.service.task.app;

import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.FirstLetterUtil;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.mapper.app.AppComTaskMapper;
import com.bcxin.oa.old.mapper.app.ComAttendMapper;
import com.bcxin.oa.old.entity.task.*;
import com.bcxin.oa.old.dto.ComTaskAdjustApproveDto;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.app.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * APP任务列表
 *
 * @author zhangye
 * @since 2018-03-16 10:47:41
 */

/*** 作为服务提供者，需继承 ITxTransaction 事务 by llc 2019-02-28 ***/
@Service
@Transactional
public class AppComTaskServiceImpl implements AppComTaskService {

	@Resource
	private AppComTaskMapper appComTaskMapper;

	@Resource
	private ComTaskAttendAddressMapper comTaskAttendAddressMapper;

	@Resource
	private ComAttendMapper comAttendMapper;

	@Resource
	private CommonService commonService;

	@Resource
	private ComTaskMapper comTaskMapper;

	@Resource
	private ComTaskInsidePushMapper comTaskInsidePushMapper;

	@Resource
	private ComTaskImplementMapper comTaskImplementMapper;

	@Resource
	private ComTaskSchedulMapper comTaskSchedulMapper;

	@Resource
	private ComTaskBehalfMapper comTaskBehalfMapper;

	@Resource
	private ComShiftRuleMapper comShiftRuleMapper;

	@Resource
	private IdWorker idWorker;

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public Result pageTask(AppComTaskDTO appComTaskDTO) throws BusinessException {
		PageHelper.startPage(appComTaskDTO.getPageNumber(), appComTaskDTO.getPageSize());
		List<AppComTaskDTO> list = appComTaskMapper.pageTask(appComTaskDTO);
		if (list != null && list.size() > 0) {
			// 正在执行中的轮次信息
			AppComTaskSmallShiftDTO runingTaskRound = getRuningRound(appComTaskDTO);
			for (AppComTaskDTO item : list) {
				String currentTaskStatus = item.getCurrentTaskStatus(); // 当前任务状态
				Long comTaskId = item.getTaskId();// 任务ID
				String tipText = "";// 轮次执行时长
				/**
				 * 列表副标题一 1、任务状态为执行中：除了紧急任务，放的是任务的开始时间-结束时间(时间格式：XXXX年XX月XX日)
				 * 2、任务状态为即将开始：除了紧急任务，放的是任务的下一轮次的开始时间-结束时间(时间格式：XXXX年XX月XX日
				 * HH:mm) 3、任务状态为已完成：放的是任务的最后一轮次的签退时间(时间格式：XXXX年XX月XX日 HH:mm)
				 * 4、紧急任务即将开始、即将执行中：放的是任务的发布时间(时间格式：XXXX年XX月XX日 HH:mm)
				 * 5、任务状态为已结束：放的是任务的开始时间-结束时间(时间格式：XXXX年XX月XX日)
				 */
				String subTitle1 = "";// 列表副标题一
				/**
				 * 列表副标题二： 未结束的紧急任务放的接受时间(时间格式：XXXX年XX月XX日 HH:mm)其它都是放是任务地址
				 */
				String subTitle2 = "";// 列表副标题二
				if (DictConst.CURRENTTASKSTATUS_YJS.equals(currentTaskStatus)) {
					// 已结束
					subTitle1 = DateUtils.formatDate(item.getStartDate(), "yyyy年MM月dd日") + "-"
							+ DateUtils.formatDate(item.getEndDate(), "yyyy年MM月dd日");
					subTitle2 = item.getAddress();
					item.setSubTitle1(subTitle1);
					item.setSubTitle2(subTitle2);
				} else {
					// 获取最近轮次状态：正在执行>即将进行>已完成
					currentTaskStatus = "";
					AppComTaskDTO appComAttendParamDTO = new AppComTaskDTO();
					appComAttendParamDTO.setTaskId(comTaskId);
					appComAttendParamDTO.setPerId(appComTaskDTO.getPerId());
					List<AppComTaskRoundDTO> appComTaskRoundDTOList = appComTaskMapper
							.getLastDayTaskRound(appComAttendParamDTO);
					if (appComTaskRoundDTOList != null && appComTaskRoundDTOList.size() > 0) {
						for (AppComTaskRoundDTO appComTaskRoundDTO : appComTaskRoundDTOList) {
							Date startDate = appComTaskRoundDTO.getCanSignInDate();// 上班时间
							Date canSignInDate = appComTaskRoundDTO.getCanSignInDate();// 可上班打卡日期
							Date canSignOutDate = appComTaskRoundDTO.getCanSignOutDate();// 下班最迟打卡日期
							String clockInDate = appComTaskRoundDTO.getClockInDate();// 上班打卡日期
							String signInTime = appComTaskRoundDTO.getSignInTime();// 轮次签到时间
							Date toDate = new Date();
							String signInStatus = appComTaskRoundDTO.getSignInStatus();// 上班出勤状态
							String signOutStatus = appComTaskRoundDTO.getSignOutStatus();// 下班出勤状态
							String taskDateInfo = appComTaskRoundDTO.getTaskDateInfo();// 日期详情
							String clockLimitSwitch = appComTaskRoundDTO.getClockLimitSwitch();// 打卡时限开关
							// 获取正在执行轮次
							if (StringUtils.isNotEmpty(signInStatus) && StringUtils.isEmpty(signOutStatus)) {
								if (StringUtils.isNotEmpty(clockLimitSwitch)
										&& clockLimitSwitch.equals(DictConst.CLOCKLIMITSWITCHSTATUS_OPEN)) {
									/*** 班次状态：可下班 ***/
									if (toDate.getTime() > canSignInDate.getTime() && signInStatus != null
											&& toDate.getTime() <= canSignOutDate.getTime()) {
										currentTaskStatus = DictConst.CURRENTTASKSTATUS_JXZ;
										// 判断最近正在执行的班次是否已经过期
										if (runingTaskRound == null) {
											currentTaskStatus = "";
										} else {
											if (!runingTaskRound.getSmallShiftId()
													.equals(appComTaskRoundDTO.getSmallShiftId())) {
												currentTaskStatus = "";
											}
										}
									}
								} else {
									if (StringUtils.isNotEmpty(signInStatus)) {
										// 正在执行
										currentTaskStatus = DictConst.CURRENTTASKSTATUS_JXZ;
										/**
										 * 判断最近正在执行的班次是否已经过期
										 */
										if (runingTaskRound == null) {
											currentTaskStatus = "";
										} else {
											if (!runingTaskRound.getSmallShiftId()
													.equals(appComTaskRoundDTO.getSmallShiftId())) {
												currentTaskStatus = "";
											}
										}
									}
								}
							}
							// 正在执行轮次获取任务下一轮次时间情况
							if (currentTaskStatus.equals(DictConst.CURRENTTASKSTATUS_JXZ)) {
								Date signInDate = DateUtils.parseDate(clockInDate + " " + signInTime);
								tipText = "已执行时长：" + DateUtils.hourDiff(signInDate, toDate);
								subTitle1 = taskDateInfo;
								subTitle2 = item.getAddress();
								break;
							}
							// 获取即将执行轮次
							if (StringUtils.isEmpty(signInStatus) && StringUtils.isEmpty(signOutStatus)
									&& toDate.getTime() <= canSignOutDate.getTime()) {
								currentTaskStatus = DictConst.CURRENTTASKSTATUS_JJJX;
								if (startDate.getTime() >= toDate.getTime()) {
									tipText = "还有" + DateUtils.hourDiff(toDate, startDate) + "开始";
								} else {
									tipText = "已迟到" + DateUtils.hourDiff(startDate, toDate);
								}
								subTitle1 = taskDateInfo;
								subTitle2 = item.getAddress();
								break;
							}
						}
					}
					if (StringUtils.isEmpty(currentTaskStatus)) {
						currentTaskStatus = DictConst.CURRENTTASKSTATUS_YWC;
					}
					item.setCurrentTaskStatus(currentTaskStatus);
					item.setTipText(tipText);
					item.setSubTitle1(subTitle1);
					item.setSubTitle2(subTitle2);
				}
			}
		}
		PageInfoUtils pageInfoUtils = new PageInfoUtils(list);
		return Result.success(Result.SUCCESS_MSG, pageInfoUtils);
	}


	/**
	 * 获取个人APP任务列表
	 *
	 * @param dto
	 * @author llc
	 * @date 2020-04-10
	 * @return
	 */
	@Override
	public Result getPerTaskList(ComTaskDto dto) throws BusinessException {

		if(StringUtils.isEmpty(dto.getTaskEffect())){
           return  Result.fail("驻勤有效性不能为空");
		}
		if (dto.getPageNumber() == null) {
			return Result.fail("第几页不能为空");
		}
		if (dto.getPageSize() == null) {
			return Result.fail("每页多少行不能为空");
		}
		List<Map<String,String>>  list = new ArrayList<>();
		if(dto.getTaskEffect().equals(DictConst.TASKEFFECT_WSX)){
			list =  comTaskMapper.getPerNoEffectTaskList(dto);
		}else if(dto.getTaskEffect().equals(DictConst.TASKEFFECT_YSX)){
			list =  comTaskMapper.getPerEffectTaskList(dto);
		}else{

		}
		PageInfoUtils pageInfo = new PageInfoUtils(list);
		return Result.success(Result.SUCCESS_MSG, pageInfo);
	}


	@Override
	public Result getTaskDetails(AppComTaskDTO appComTaskDTO) throws BusinessException {
		String selectDate = "";
		Long perId = appComTaskDTO.getPerId();
		// 如果没传递请求显示年或者请求显示月，则默认取当前日期
		if (appComTaskDTO.getYear() == null || appComTaskDTO.getMonth() == null) {
			selectDate = DateUtils.getDate();
		} else {
			// 如果有传递请求显示年或者请求显示月，则默认取传递年月的1号
			selectDate = appComTaskDTO.getYear() + "-" + appComTaskDTO.getMonth() + "-" + "01";
		}
		// 1、获取任务详情基本信息
		appComTaskDTO.setSelectDate(selectDate);
		AppComTaskDetailsDTO appComTaskDetailsDTO = appComTaskMapper.getTaskDetails(appComTaskDTO);
		if (appComTaskDetailsDTO == null) {
			throw new BusinessException(Result.ERROR, "查找不到任务详情信息");
		}
		String taskStatus = appComTaskDetailsDTO.getCurrentTaskStatus();// 任务状态
		// 获取正在执行中的轮次信息
		AppComTaskSmallShiftDTO runingTaskRound = getRuningRound(appComTaskDTO);
		List<AppComTaskInsidePushDTO> persons = new ArrayList<AppComTaskInsidePushDTO>();
		// 获取负责人信息
		appComTaskDetailsDTO.setComId(appComTaskDTO.getComId());
		AppComTaskInsidePushDTO inChargePerson = appComTaskMapper.getInChargePerson(appComTaskDetailsDTO);
		if (inChargePerson != null) {
			persons.add(inChargePerson);
		}
		// 获取2条任务成员
		List<AppComTaskInsidePushDTO> noChargePersons = appComTaskMapper.getNoChargePerson(appComTaskDetailsDTO);
		if (noChargePersons != null && noChargePersons.size() > 0) {
			persons.addAll(noChargePersons);
		}
		appComTaskDetailsDTO.setPersons(persons);
		// 2、获取任务考勤日历
		appComTaskDetailsDTO.setPerId(perId);
		appComTaskDetailsDTO.setSelectDate(selectDate);
		AppComTaskCalendarDTO appComTaskCalendarDTO = appComTaskMapper.getComTaskCalendar(appComTaskDetailsDTO);
		appComTaskCalendarDTO.setPerId(perId);
		appComTaskCalendarDTO.setSelectDate(selectDate);
		appComTaskCalendarDTO.setTaskId(appComTaskDTO.getTaskId());
		if (appComTaskCalendarDTO != null) {
			// 异常任务信息
			List<AppComTaskExceptionDTO> arrExceptionTask = new ArrayList<AppComTaskExceptionDTO>();
			// 3、获取任务考勤班次
			List<AppComTaskShiftDTO> arrShifts = appComTaskMapper.getComTaskShiftList(appComTaskCalendarDTO);
			Date cardDate = null; // 最近可打卡班次
			if (arrShifts != null && arrShifts.size() > 0) {
				List<ComTaskAttendAddress> arrCoords = comTaskAttendAddressMapper
						.listComTaskAttendAddress(appComTaskDTO.getTaskId());
				if (arrCoords != null && arrCoords.size() > 0) {
					appComTaskCalendarDTO.setArrCoords(arrCoords);
					appComTaskCalendarDTO.setScope(arrCoords.get(0).getAddressRange());
				}
				// 4、获取查询年月任务考勤轮次信息
				List<AppComTaskSmallShiftDTO> arrSmallShifts = appComTaskMapper
						.getComTaskSmallShiftList(appComTaskCalendarDTO);
				if (arrSmallShifts != null && arrSmallShifts.size() > 0) {
					// 任务补卡模板状态
					String isActiveStr = comAttendMapper.getIsActive(appComTaskDTO.getComId(), "52");
					int isActive = 0;
					if (StringUtil.isNotEmpty(isActiveStr)) {
						isActive = Integer.parseInt(isActiveStr);
					}
					for (AppComTaskShiftDTO appComTaskShiftDTOItem : arrShifts) {
						appComTaskShiftDTOItem.setIsActive(isActive);// 只有异常才有补卡情况，才需要确定补卡状态
						// 记录异常任务信息
						// 班次状态 (1：未开始，2：可上班打卡，3：可下班打卡，4：已结束)
						AppComTaskExceptionDTO taskException = new AppComTaskExceptionDTO();
						boolean exception = false;// 是否存在异常考勤
						int exceptDay = appComTaskShiftDTOItem.getDay();// IOS异常日期(日)
						Date exceptDate = null; // 安卓异常日期(年月日)
						try {
							exceptDate = DateUtils.parseDate(appComTaskShiftDTOItem.getShiftDate(), "yyyy-MM-dd");
						} catch (Exception e) {

						}
						String shiftTime = commonService.listChangeToString(appComTaskShiftDTOItem.getShiftId(), false,
								false);
						appComTaskShiftDTOItem.setShiftTime(shiftTime);
						List<AppComTaskSmallShiftDTO> appComTaskSmallShiftDTOList = new ArrayList<AppComTaskSmallShiftDTO>();
						for (AppComTaskSmallShiftDTO appComTaskSmallShiftDTO : arrSmallShifts) {
							Date startWorkDate = appComTaskSmallShiftDTO.getStartWorkDate();// 可上班打卡日期
							Date endWorkDate = appComTaskSmallShiftDTO.getEndWorkDate();// 下班最迟打卡日期
							String clockLimitSwitch = appComTaskSmallShiftDTO.getClockLimitSwitch();// 打卡时限开关
							Date toDate = new Date(); // 系统当前日期
							Integer signInStatus = appComTaskSmallShiftDTO.getSignInStatus();// 签到状态(1:正常，2：迟到，5：漏打卡，7：请假)
							Integer signOutStatus = appComTaskSmallShiftDTO.getSignOutStatus();// 签退状态（1:正常，3：早退，5：漏打卡，7：请假）
							int smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 1：已完成，2：可签到，3：可下班，4：未开始
							if (appComTaskShiftDTOItem.getDates().equals(appComTaskSmallShiftDTO.getDates())
									&& appComTaskShiftDTOItem.getShiftId()
											.equals(appComTaskSmallShiftDTO.getShiftId())) {
								// 已完成
								if (signInStatus != null && signOutStatus != null) {
									smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
								} else {
									if (StringUtils.isNotEmpty(clockLimitSwitch)
											&& clockLimitSwitch.equals(DictConst.CLOCKLIMITSWITCHSTATUS_OPEN)) {
										if (toDate.getTime() > endWorkDate.getTime()) {
											/**** 班次已完成 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
											if (signInStatus == null) {
												// 上班漏打卡
												signInStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
											}
											if (signOutStatus == null) {
												// 下班漏打卡
												signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
											}
										} else if (toDate.getTime() > startWorkDate.getTime()
												&& (signInStatus == null
														|| signInStatus == Integer.valueOf(DictConst.ATTENDSTATUS_QJ))
												&& toDate.getTime() <= endWorkDate.getTime()) {
											/**** 请假和未打卡班次可签到 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD);
											if (cardDate == null) {
												cardDate = startWorkDate;
											} else {
												if (startWorkDate.getTime() > cardDate.getTime()) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 未开始
												}
											}
											// 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
											if (runingTaskRound != null) {
												if (!runingTaskRound.getSmallShiftId()
														.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 未开始
												}
											}
										} else if (toDate.getTime() > startWorkDate.getTime() && signInStatus != null
												&& toDate.getTime() <= endWorkDate.getTime()) {
											/**** 班次可下班,上班非请假 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB);
											// 判断最近正在执行的班次是否已经过期 ：
											if (runingTaskRound == null) {
												smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
												signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
											} else {
												if (!runingTaskRound.getSmallShiftId()
														.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
													signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
												}
											}
										}
									} else {
										if (toDate.getTime() > endWorkDate.getTime()) {
											/**** 班次已完成 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
											if (signInStatus == null) {
												// 上班漏打卡
												signInStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
												// 下班漏打卡
												if (signOutStatus == null) {
													signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
												} else {
													// 下班不是请假状态、正常、早退状态的设置缺卡
													if (signOutStatus != Integer.valueOf(DictConst.ATTENDSTATUS_QJ)
															&& signOutStatus != Integer
																	.valueOf(DictConst.ATTENDSTATUS_ZC)
															&& signOutStatus != Integer
																	.valueOf(DictConst.ATTENDSTATUS_ZT)) {
														signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
													}
												}

											} else {
												// 判断下一轮次是否要开始执行，如果下一轮次打卡时间到，则设置已完成并且下班漏打卡，否则为可下班状态
												smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB);
												// 判断最近正在执行的班次是否已经过期 ：
												// 1、设置下班打卡时限：则下班打卡时限已经到了，用户未打卡，则正在执行的班次设置为漏打卡状态
												// 2、未设置下班打卡时限：则下一个班次已开始打卡，则正在执行的班次设置为漏打卡状态
												if (runingTaskRound == null) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
													signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
												} else {
													if (!runingTaskRound.getSmallShiftId()
															.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
														smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
														signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
													}
												}
											}
										} else if ((signInStatus == null
												|| signInStatus == Integer.valueOf(DictConst.ATTENDSTATUS_QJ))
												&& toDate.getTime() <= endWorkDate.getTime()) {
											/**** 班次可签到 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD);
											if (cardDate == null) {
												cardDate = startWorkDate;
											} else {
												if (startWorkDate.getTime() > cardDate.getTime()) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);
												}
											}
											// 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
											// if (runingTaskRound != null) {
											// if
											// (!runingTaskRound.getSmallShiftId()
											// .equals(appComTaskSmallShiftDTO.getSmallShiftId()))
											// {
											// smallShiftType =
											// Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);//
											// 未开始
											// }
											// }
											// 班次开始日期为次日则不能“可签到”，要设置成“未开始”
											if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD)) {
												Long d1 = Long.valueOf(DateUtils.formatDate(startWorkDate, "yyyyMMdd"));
												Long d2 = Long.valueOf(DateUtils.formatDate(toDate, "yyyyMMdd"));
												if (d1 > d2) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 未开始
												}
											}
										} else if (signInStatus != null) {
											/**** 班次可下班 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB);
											// 判断最近正在执行的班次是否已经过期 ：
											// 1、设置下班打卡时限：则下班打卡时限已经到了，用户未打卡，则正在执行的班次设置为漏打卡状态
											// 2、未设置下班打卡时限：则下一个班次已开始打卡，则正在执行的班次设置为漏打卡状态
											if (runingTaskRound == null) {
												smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
												signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
											} else {
												if (!runingTaskRound.getSmallShiftId()
														.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
													signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
												}
											}
										}
									}
								}

								// 任务状态如果是已结束，则未下班的班次自动设置漏打卡，班次完成状态
								if (StringUtils.isNotEmpty(taskStatus) && taskStatus.equals(DictConst.TASKSTATUS_YJS)) {
									// 可签到，设置上下班漏打卡
									if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD)) {
										signInStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
										signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
										smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
									}
									// 可下班，设置下班漏打卡
									if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB)) {
										signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
										smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
									}
								}

								appComTaskSmallShiftDTO.setSignInStatus(signInStatus == null ? 0 : signInStatus);
								appComTaskSmallShiftDTO.setSignOutStatus(signOutStatus == null ? 0 : signOutStatus);
								appComTaskSmallShiftDTO.setSmallShiftType(smallShiftType);
								appComTaskSmallShiftDTOList.add(appComTaskSmallShiftDTO);
								/**** 上班考勤状态 ****/
								if (appComTaskSmallShiftDTO.getSignInStatus() != null) {
									// 迟到
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignInStatus())
											.equals(DictConst.ATTENDSTATUS_CD)) {
										exception = true;
									}
									// 缺岗
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignInStatus())
											.equals(DictConst.ATTENDSTATUS_QK)) {
										exception = true;

									}
									// 请假
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignInStatus())
											.equals(DictConst.ATTENDSTATUS_QJ)) {
										exception = true;
									}
								}
								/**** 下班考勤状态 ****/
								if (appComTaskSmallShiftDTO.getSignOutStatus() != null) {

									// 早退
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignOutStatus())
											.equals(DictConst.ATTENDSTATUS_ZT)) {
										exception = true;
									}
									// 漏卡
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignOutStatus())
											.equals(DictConst.ATTENDSTATUS_QK)) {
										exception = true;
									}
									// 请假
									if (String.valueOf(appComTaskSmallShiftDTO.getSignOutStatus())
											.equals(DictConst.ATTENDSTATUS_QJ)) {
										exception = true;
									}
								}
							} else {
								/**** 打卡时限开关状态 ：打开 ****/
								if (StringUtils.isNotEmpty(clockLimitSwitch)
										&& clockLimitSwitch.equals(DictConst.CLOCKLIMITSWITCHSTATUS_OPEN)) {
									if (toDate.getTime() > startWorkDate.getTime() && signInStatus == null
											&& toDate.getTime() <= endWorkDate.getTime()) {

										/**** 班次可签到 ****/
										if (cardDate == null) {
											cardDate = startWorkDate;
										}
										// 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
										if (runingTaskRound != null) {
											if (!runingTaskRound.getSmallShiftId()
													.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
												cardDate = null;
											}
										}
									}
								} else {
									/**** 打卡时限开关状态 ：关闭 ****/
									/**** 班次可签到 ****/
									if (signInStatus == null && toDate.getTime() <= endWorkDate.getTime()) {
										if (cardDate == null) {
											cardDate = startWorkDate;
										}
										// 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
										if (runingTaskRound != null) {
											if (!runingTaskRound.getSmallShiftId()
													.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
												cardDate = null;
											}
										}
									}
								}
							}
						}
						if (exception) {
							taskException.setDay(exceptDay);
							taskException.setDate(exceptDate);
							taskException.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD));// 异常
							arrExceptionTask.add(taskException);
						}
						appComTaskShiftDTOItem.setArrSmallShifts(appComTaskSmallShiftDTOList);
					}
				}
				appComTaskCalendarDTO.setArrShifts(arrShifts);
			}
			/**
			 * 所有班次状态均为正常，则日历显示班 所有班次状态均为漏签，则日历显示缺
			 * 班次存在多种状态，则日历显示异，所有班次状态为请假，则日历显示假
			 */

			// if (arrExceptionTask != null && arrExceptionTask.size() > 0) {
			//
			// Map<Integer, AppComTaskExceptionDTO> map = new HashMap<Integer,
			// AppComTaskExceptionDTO>();
			// // 是否全部缺勤状态
			// for (AppComTaskExceptionDTO item : arrExceptionTask) {
			// if (map == null || map.size() < 1) {
			// if (item.getAttendStatus() !=
			// Integer.valueOf(DictConst.ATTENDSTATUS_QG)) {
			// if (item.getAttendStatus() ==
			// Integer.valueOf(DictConst.ATTENDSTATUS_QJ)) {
			// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QJ));
			// // 请假
			// } else {
			// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD));
			// // 异常
			// }
			// } else {
			// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QG));
			// // 缺岗
			// }
			// map.put(item.getDay(), item);
			// } else {
			// if (item.getAttendStatus() !=
			// Integer.valueOf(DictConst.ATTENDSTATUS_QG)) {
			// if (item.getAttendStatus() ==
			// Integer.valueOf(DictConst.ATTENDSTATUS_QJ)) {
			// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QJ));
			// // 请假
			// } else {
			// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD));
			// // 异常
			// }
			// } else {
			// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QG));
			// // 缺岗
			// }
			// if (map.containsKey(item.getDay())) {
			// AppComTaskExceptionDTO exits = map.get(item.getDay());
			// if (exits.getAttendStatus() != item.getAttendStatus()) {
			// if (exits.getAttendStatus() !=
			// Integer.valueOf(DictConst.ATTENDSTATUS_CD)) {
			// exits.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD));
			// }
			// }
			// } else {
			// map.put(item.getDay(), item);
			// }
			// }
			// }
			// if (map != null && map.size() > 0) {
			// arrExceptionTask.clear();
			// for (Map.Entry<Integer, AppComTaskExceptionDTO> m :
			// map.entrySet()) {
			// arrExceptionTask.add(m.getValue());
			// }
			// }
			// }
			appComTaskCalendarDTO.setArrExceptionAttendance(arrExceptionTask);
			appComTaskDetailsDTO.setCalendarData(appComTaskCalendarDTO);
		}
		return Result.success(Result.SUCCESS_MSG, appComTaskDetailsDTO);
	}

	@Override
	public Result getRuningTaskRound(AppComTaskDTO appComTaskDTO) throws BusinessException {
		AppComTaskSmallShiftDTO runingTaskRound = getRuningRound(appComTaskDTO);
		return Result.success(Result.SUCCESS_MSG, runingTaskRound);
	}

	private AppComTaskSmallShiftDTO getRuningRound(AppComTaskDTO appComTaskDTO) {
		AppComTaskSmallShiftDTO arrSmallShift = appComTaskMapper.getRuningTaskRound(appComTaskDTO);
		/**
		 * 判断最近正在执行的班次是否已经过期 ： 1、设置下班打卡时限：则下班打卡时限已经到了，用户未打卡，则正在执行的班次设置为漏打卡状态
		 * 2、未设置下班打卡时限：则下一个班次已开始打卡，则正在执行的班次设置为漏打卡状态
		 */
		Date toDate = new Date(); // 系统当前日期
		if (arrSmallShift != null) {
			if (StringUtils.isNotEmpty(arrSmallShift.getClockLimitSwitch())
					&& arrSmallShift.getClockLimitSwitch().equals(DictConst.CLOCKLIMITSWITCHSTATUS_OPEN)) {
				// 设置下班打卡时限
				if (toDate.getTime() > arrSmallShift.getEndWorkDate().getTime()) {
					arrSmallShift = null;
				}
			} else {
				// 未设置下班打卡时限，则判断下一个轮次是否已开始上班打卡
				AppComTaskSmallShiftDTO nextAppComTaskSmallShiftDTO = appComTaskMapper
						.getNextTaskRoundByEndWorkDate(appComTaskDTO.getPerId(), arrSmallShift.getEndWorkDate());
				if (nextAppComTaskSmallShiftDTO != null) {
					if (toDate.getTime() > nextAppComTaskSmallShiftDTO.getStartWorkDate().getTime()) {
						arrSmallShift = null;
					}
				}
				if (arrSmallShift != null) {
					// 上班请假，则不能设置正在进行中
					if (arrSmallShift.getSignInStatus().equals(Integer.valueOf(DictConst.ATTENDSTATUS_QJ))) {
						arrSmallShift = null;
					}
				}
			}
		}
		return arrSmallShift;
	}

	@Override
	public Result getTaskPerson(AppComTaskDTO appComTaskDTO) throws BusinessException {

		List<AppComTaskInsidePushDTO> persons = new ArrayList<AppComTaskInsidePushDTO>();
		// 获取负责人信息
		AppComTaskDetailsDTO appComTaskDetailsDTO = appComTaskMapper.getTaskDetails(appComTaskDTO);
		appComTaskDetailsDTO.setComId(appComTaskDTO.getComId());
		AppComTaskInsidePushDTO inChargePerson = appComTaskMapper.getInChargePerson(appComTaskDetailsDTO);
		if (inChargePerson != null) {
			if (StringUtils.isEmpty(inChargePerson.getPerName())) {
				inChargePerson.setPerName("无姓名");
				inChargePerson.setInitialname("#");
			} else {
				inChargePerson.setInitialname(
						FirstLetterUtil.getFirstLetter(inChargePerson.getPerName().substring(0, 1)).toUpperCase());
			}
			persons.add(inChargePerson);
		}
		// 获取任务成员列表
		List<AppComTaskInsidePushDTO> taskPersonList = appComTaskMapper.getTaskPerson(appComTaskDTO);
		if (taskPersonList != null && taskPersonList.size() > 0) {
			for (AppComTaskInsidePushDTO item : taskPersonList) {
				if (inChargePerson.getPerId().equals(item.getPerId())) {
					continue;
				}
				if (StringUtils.isEmpty(item.getPerName())) {
					item.setPerName("无姓名");
					item.setInitialname("#");
				} else {
					item.setInitialname(
							FirstLetterUtil.getFirstLetter(item.getPerName().substring(0, 1)).toUpperCase());
				}
				persons.add(item);
			}
		}
		return Result.success(Result.SUCCESS_MSG, persons);
	}

	@Override
	public Result getTaskShiftImplement(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException {
		// 如果没传递请求显示年或者请求显示月，则默认取当前日期
		if (StringUtils.isEmpty(appComTaskImplementDto.getSelectDate())) {
			throw new BusinessException(Result.ERROR, "日历选择年月不能为空!");
		}
		String selectDate = appComTaskImplementDto.getSelectDate() + "-" + "1";// 当前日历选择年月
		Long perId = appComTaskImplementDto.getPerId();
		Long taskImplementId = appComTaskImplementDto.getTaskImplementId();// 任务执行情况ID
		// 查询任务执行情况信息
		ComTaskImplement comTaskImplement = comTaskImplementMapper.getByPrimaryKey(taskImplementId);
		if (comTaskImplement == null) {
			throw new BusinessException(Result.ERROR, "查找不到任务执行情况信息");
		}
		// String taskStatus = appComTaskImplementDto.getCurrentTaskStatus();//
		// 任务状态
		// 正在执行中的轮次信息
		AppComTaskDTO appComTaskDTO = new AppComTaskDTO();
		appComTaskDTO.setPerId(perId);
		AppComTaskSmallShiftDTO runingTaskRound = getRuningRound(appComTaskDTO);
		// 获取班次信息
		List<AppComTaskShiftDTO> arrShifts = appComTaskMapper.getTaskShiftImplement(perId, taskImplementId);
		AppComTaskShiftDTO appComTaskShiftDTOItem = new AppComTaskShiftDTO();
		if (arrShifts == null || arrShifts.size() < 1) {
			throw new BusinessException(Result.ERROR, "查找不到任务班次信息");
		} else {
			appComTaskShiftDTOItem = arrShifts.get(0);
		}
		// 获取班次执行情况
		Date cardDate = null; // 最近可打卡班次
		// 4、获取查询年月任务考勤轮次信息
		AppComTaskCalendarDTO appComTaskCalendarDTO = new AppComTaskCalendarDTO();
		appComTaskCalendarDTO.setPerId(perId);
		appComTaskCalendarDTO.setSelectDate(selectDate);
		appComTaskCalendarDTO.setTaskId(comTaskImplement.getComTaskId());
		// 获取选择年月轮次信息
		List<AppComTaskSmallShiftDTO> arrSmallShifts = appComTaskMapper.getComTaskSmallShiftList(appComTaskCalendarDTO);
		if (arrSmallShifts != null && arrSmallShifts.size() > 0) {
			String shiftTime = commonService.listChangeToString(appComTaskShiftDTOItem.getShiftId(), false, false);
			appComTaskShiftDTOItem.setShiftTime(shiftTime);
			Long tip = null;// 已执行时长
			Long countDown = null;// 倒计时时长(未执行)
			List<AppComTaskSmallShiftDTO> appComTaskSmallShiftDTOList = new ArrayList<AppComTaskSmallShiftDTO>();
			// 计算任务所有批次上下班状态
			for (AppComTaskSmallShiftDTO appComTaskSmallShiftDTO : arrSmallShifts) {

				Date startWorkDate = appComTaskSmallShiftDTO.getStartWorkDate();// 可上班打卡日期
				Date endWorkDate = appComTaskSmallShiftDTO.getEndWorkDate();// 下班最迟打卡日期
				String clockLimitSwitch = appComTaskSmallShiftDTO.getClockLimitSwitch();// 打卡时限开关
				Date toDate = new Date(); // 系统当前日期
				Integer signInStatus = appComTaskSmallShiftDTO.getSignInStatus();// 签到状态(1:正常，2：迟到，5：漏打卡，7：请假)
				Integer signOutStatus = appComTaskSmallShiftDTO.getSignOutStatus();// 签退状态（1:正常，3：早退，5：漏打卡，7：请假）
				int smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 1：已完成，2：可签到，3：可下班，4：未开始
				if (appComTaskShiftDTOItem.getDates().equals(appComTaskSmallShiftDTO.getDates())
						&& appComTaskShiftDTOItem.getShiftId().equals(appComTaskSmallShiftDTO.getShiftId())) {
					// 已完成
					if (signInStatus != null && signOutStatus != null) {
						smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
					} else {
						if (toDate.getTime() > endWorkDate.getTime()) {
							smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
							if (signInStatus == null) {
								// 上班漏打卡
								signInStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
								// 下班漏打卡
								if (signOutStatus == null) {
									signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
								} else {
									// 下班不是请假状态、正常、早退状态的设置缺卡
									if (signOutStatus != Integer.valueOf(DictConst.ATTENDSTATUS_QJ)
											&& signOutStatus != Integer.valueOf(DictConst.ATTENDSTATUS_ZC)
											&& signOutStatus != Integer.valueOf(DictConst.ATTENDSTATUS_ZT)) {
										signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
									}
								}
							} else {
								// 判断下一轮次是否要开始执行，如果下一轮次打卡时间到，则设置已完成并且下班漏打卡，否则为可下班状态
								smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB);
								/**
								 * 判断最近正在执行的班次是否已经过期 ：
								 * 1、设置下班打卡时限：则下班打卡时限已经到了，用户未打卡，则正在执行的班次设置为漏打卡状态
								 * 2、未设置下班打卡时限：则下一个班次已开始打卡，则正在执行的班次设置为漏打卡状态
								 */
								if (runingTaskRound == null) {
									smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
									signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
								} else {
									if (!runingTaskRound.getSmallShiftId()
											.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
										smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
										signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
									}
								}
							}
						} else if ((signInStatus == null || signInStatus == Integer.valueOf(DictConst.ATTENDSTATUS_QJ))
								&& toDate.getTime() <= endWorkDate.getTime()) {
							// 可签到
							smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD);
							if (cardDate == null) {
								cardDate = startWorkDate;
							} else {
								if (startWorkDate.getTime() > cardDate.getTime()) {
									smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);
								}
							}
							if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD)) {
								Long d1 = Long.valueOf(DateUtils.formatDate(startWorkDate, "yyyyMMdd"));
								Long d2 = Long.valueOf(DateUtils.formatDate(toDate, "yyyyMMdd"));
								if (d1 > d2) {
									smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 未开始
								}
							}
						} else if (signInStatus != null) {
							// 可下班
							smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB);
							/**
							 * 判断最近正在执行的班次是否已经过期 ：
							 * 1、设置下班打卡时限：则下班打卡时限已经到了，用户未打卡，则正在执行的班次设置为漏打卡状态
							 * 2、未设置下班打卡时限：则下一个班次已开始打卡，则正在执行的班次设置为漏打卡状态
							 */
							if (runingTaskRound == null) {
								smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
								signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
							} else {
								if (!runingTaskRound.getSmallShiftId()
										.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
									smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
									signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
								}
							}
						}
					}
					appComTaskSmallShiftDTO.setSignInStatus(signInStatus == null ? 0 : signInStatus);
					appComTaskSmallShiftDTO.setSignOutStatus(signOutStatus == null ? 0 : signOutStatus);
					appComTaskSmallShiftDTO.setSmallShiftType(smallShiftType);
					// 可下班状态
					if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB)) {
						// 下班倒计时
						countDown = DateUtils.getDateSubDateToSeconds(new Date(),
								appComTaskSmallShiftDTO.getEndWorkDate());
						// 汇总执行时长：已完成+可下班
						Date signInTime = DateUtils.parseDate(appComTaskSmallShiftDTO.getClockInDate() + " "
								+ appComTaskSmallShiftDTO.getSignInTime());
						Long runingSecond = DateUtils.getDateSubDateToSeconds(signInTime, new Date());
						if (tip == null) {
							tip = runingSecond;
						} else {
							tip = tip + runingSecond;
						}
					}
					// 已完成状态
					if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC)) {
						// 汇总执行时长：已完成+可下班,排除漏打卡
						if (appComTaskSmallShiftDTO.getSignOutTime() != null) {
							Date signInTime = DateUtils.parseDate(appComTaskSmallShiftDTO.getClockInDate() + " "
									+ appComTaskSmallShiftDTO.getSignInTime());
							Date signOutTime = DateUtils.parseDate(appComTaskSmallShiftDTO.getClockOutDate() + " "
									+ appComTaskSmallShiftDTO.getSignOutTime());
							Long runingSecond = DateUtils.getDateSubDateToSeconds(signInTime, signOutTime);
							if (tip == null) {
								tip = runingSecond;
							} else {
								tip = tip + runingSecond;
							}
						}
					}
					appComTaskSmallShiftDTOList.add(appComTaskSmallShiftDTO);
				} else {
					if (StringUtils.isNotEmpty(clockLimitSwitch)
							&& clockLimitSwitch.equals(DictConst.CLOCKLIMITSWITCHSTATUS_OPEN)) {
						// 打卡时限开关状态:开启
						if (toDate.getTime() > startWorkDate.getTime() && signInStatus == null
								&& toDate.getTime() <= endWorkDate.getTime()) {
							// 可签到
							if (cardDate == null) {
								cardDate = startWorkDate;
							}
							/**
							 * 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
							 */
							if (runingTaskRound != null) {
								if (!runingTaskRound.getSmallShiftId()
										.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
									cardDate = null;
								}
							}
						}
					} else {
						// 打卡时限开关状态:关闭
						if (signInStatus == null && toDate.getTime() <= endWorkDate.getTime()) {
							// 可签到
							if (cardDate == null) {
								cardDate = startWorkDate;
							}
							/**
							 * 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
							 */
							if (runingTaskRound != null) {
								if (!runingTaskRound.getSmallShiftId()
										.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
									cardDate = null;
								}
							}
						}
					}
				}
			}
			appComTaskShiftDTOItem.setArrSmallShifts(appComTaskSmallShiftDTOList);
			appComTaskShiftDTOItem.setCountDown(countDown == null ? "" : String.valueOf(countDown));
			appComTaskShiftDTOItem.setTip(tip == null ? "" : String.valueOf(tip));
		}
		return Result.success(Result.SUCCESS_MSG, appComTaskShiftDTOItem);
	}

	@Override
	public Result getTaskStatus(AppComTaskDTO appComTaskDTOParam) throws BusinessException {
		if (appComTaskDTOParam == null || appComTaskDTOParam.getTaskId() == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "任务ID不能为空");
		}
		AppComTaskDetailsDTO appComTaskDetailsDTO = appComTaskMapper.getTaskStatus(appComTaskDTOParam);
		return Result.success(Result.SUCCESS_MSG, appComTaskDetailsDTO);
	}


	/**
	 * 获取某人某天某任务的排班班次
	 *
	 * @param comTaskSchedul
	 * @return
	 * @author llc
	 * @date 2019-02-21
	 */
	@Override
	public Result getPerDateTaskShift(ComTaskSchedul comTaskSchedul) throws BusinessException {
		if (comTaskSchedul == null || comTaskSchedul.getComTaskId() == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "任务ID不能为空");
		}
		if (comTaskSchedul == null || comTaskSchedul.getSchedulDate() == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "排班日期不能为空");
		}
		Map<String,String> map = comTaskSchedulMapper.getPerDateTaskShift(comTaskSchedul);
		return Result.success(Result.SUCCESS_MSG, map);
	}

	/**
	 * 外勤代班审批通过业务实现
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2019-02-21
	 */
	@Override
	public Result completeTaskAdjustApprove(ComTaskAdjustApproveDto dto) throws BusinessException  {

		if(dto == null){
			throw new BusinessException(Result.BUSINESS_ERROR, "参数不能为空");
		}else{
			if(StringUtils.isEmpty(dto.getDates())){
				throw new BusinessException(Result.BUSINESS_ERROR, "调班日期不能为空");
			}
			if(StringUtils.isEmpty(dto.getPerId().toString())){
				throw new BusinessException(Result.BUSINESS_ERROR, "被代班人员ID不能为空");
			}
			if(StringUtils.isEmpty(dto.getComTaskId().toString())){
				throw new BusinessException(Result.BUSINESS_ERROR, "任务ID不能为空");
			}
			if(StringUtils.isEmpty(dto.getShiftId().toString())){
				throw new BusinessException(Result.BUSINESS_ERROR, "班次ID不能为空");
			}
			if(StringUtils.isEmpty(dto.getComId().toString())){
				throw new BusinessException(Result.BUSINESS_ERROR, "企业ID不能为空");
			}
			if(StringUtils.isEmpty(dto.getApproveApplyId().toString())){
				throw new BusinessException(Result.BUSINESS_ERROR, "审批ID不能为空");
			}
			if(StringUtils.isEmpty(dto.getAcceptPerIds())){
				throw new BusinessException(Result.BUSINESS_ERROR, "代班人员ID不能为空");
			}
		}

		/*** 例如张三2019-02-22请假，他在A任务的班次由李四顶替 ***/

		/*** 1.把李四插入A任务(如果李四已在A任务且有效时间段包含当前日期，不做处理) ***/

		try {
		List<String> acceptPerIds = Arrays.asList(dto.getAcceptPerIds().split(","));

		if(acceptPerIds == null || acceptPerIds.size() == 0){
			return Result.success(Result.ERROR, "代班人员ID不能为空");
		}

		List<ComTaskInsidePush> comTaskInsidePushList = new ArrayList<>();
		for(String perId : acceptPerIds){
			ComTaskInsidePush comTaskInsidePush = new ComTaskInsidePush();
			comTaskInsidePush.setInsidePushId(idWorker.nextId());
			comTaskInsidePush.setPerId(Long.parseLong(perId));
			comTaskInsidePushList.add(comTaskInsidePush);
		}

		comTaskInsidePushMapper.insertBehalfPer(
				comTaskInsidePushList,
				dto.getCreateBy(),
				dto.getComId(),
				dto.getComTaskId(),
				dto.getDates());

		/*** 2.删除李四2019-02-22不在A任务的排班记录(休息的不处理) 或者在A任务的排班记录 ***/

		comTaskSchedulMapper.deleteSchedulByBehalf(
				acceptPerIds,
				dto.getComId(),
				dto.getDates(),
				dto.getComTaskId());

		/*** 3.删除李四2019-02-22不在A任务的任务执行情况(休息的不处理) 或者在A任务的任务执行情况 ***/

		comTaskImplementMapper.deleteImplementByBehalf(
				acceptPerIds,
				dto.getComId(),
				dto.getDates(),
				dto.getComTaskId());

		/*** 4.插入李四2019-02-22在A任务的排班记录 ***/

		Date now = new Date();

		int weekDay = DateUtils.dayOfWeek(dto.getDates()); // 获取星期几

		List<ComTaskSchedul> comTaskSchedulList = new ArrayList<>();
		for(String acceptPerId : acceptPerIds){
			ComTaskSchedul comTaskSchedul = new ComTaskSchedul();
			comTaskSchedul.setTaskSchedulId(idWorker.nextId());
			comTaskSchedul.setCreateTime(now);
			comTaskSchedul.setCreateBy(dto.getCreateBy());
			comTaskSchedul.setComId(dto.getComId());
			comTaskSchedul.setSchedulDate(DateUtils.parseDate(dto.getDates()));
			comTaskSchedul.setIsRest(CommonConst.N);
			comTaskSchedul.setPerId(Long.parseLong(acceptPerId));
			comTaskSchedul.setComTaskId(dto.getComTaskId());
			comTaskSchedul.setShiftId(dto.getShiftId());
			comTaskSchedulList.add(comTaskSchedul);
		}
		if(comTaskSchedulList != null && comTaskSchedulList.size()>0){
			comTaskSchedulMapper.insertBatch(comTaskSchedulList);
		}

		/*** 5.插入李四2019-02-22在A任务的任务执行情况 ***/

		List<ComShiftRule> shiftRuleList = comShiftRuleMapper.getShiftRuleByShiftId(dto.getShiftId());

		List<ComTaskImplement> taskImplementList = new ArrayList<>();

		for(String acceptPerId : acceptPerIds) {
			for (ComShiftRule comShiftRule : shiftRuleList) {
				ComTaskImplement comTaskImplement = new ComTaskImplement();
				comTaskImplement.setTaskImplementId(idWorker.nextId());
				comTaskImplement.setCreateTime(now);
				comTaskImplement.setCreateBy(dto.getCreateBy());
				comTaskImplement.setComId(dto.getComId());
				comTaskImplement.setWeekDay(weekDay);
				comTaskImplement.setDates(DateUtils.parseDate(dto.getDates()));
				comTaskImplement.setIsRest(CommonConst.N);
				comTaskImplement.setAttendType(DictConst.ATTENDTYPE_PBZ);
				comTaskImplement.setPerId(Long.parseLong(acceptPerId));
				comTaskImplement.setComTaskId(dto.getComTaskId());
				comTaskImplement.setAttendStatus(null);
				comTaskImplement.setShiftId(dto.getShiftId());
				comTaskImplement.setShiftRuleId(comShiftRule.getShiftRuleId());
				taskImplementList.add(comTaskImplement);
			}
		}
		if(taskImplementList != null && taskImplementList.size()>0){
			comTaskImplementMapper.insertBatch(taskImplementList);
		}

		/*** 6.更新张三2019-02-22在A任务的排班记录为休息 ***/
		comTaskSchedulMapper.updateSchedulByBehalf(dto.getPerId(), dto.getCreateBy(), dto.getDates(), dto.getComTaskId());

		/*** 7.清除张三2019-02-22在A任务的任务执行情况 ***/

		comTaskImplementMapper.deleteImplementByTask(dto.getDates(),dto.getPerId(),dto.getComTaskId());

		/*** 8.插入张三2019-02-22在A任务的任务执行情况为休息 ***/

		ComTaskImplement comTaskImplement = new ComTaskImplement();
		comTaskImplement.setTaskImplementId(idWorker.nextId());
		comTaskImplement.setCreateTime(now);
		comTaskImplement.setCreateBy(dto.getCreateBy());
		comTaskImplement.setComId(dto.getComId());
		comTaskImplement.setWeekDay(weekDay);
		comTaskImplement.setDates(DateUtils.parseDate(dto.getDates()));
		comTaskImplement.setIsRest(CommonConst.Y);
		comTaskImplement.setAttendType(DictConst.ATTENDTYPE_PBZ);
		comTaskImplement.setPerId(dto.getPerId());
		comTaskImplement.setComTaskId(dto.getComTaskId());

		comTaskImplementMapper.insert(comTaskImplement);

		/*** 9.插入代班记录 ***/

		List<ComTaskBehalf> comTaskBehalfList = new ArrayList<>();
		for(String acceptPerId : acceptPerIds){
			ComTaskBehalf comTaskBehalf = new ComTaskBehalf();
			comTaskBehalf.setTaskBehalfId(idWorker.nextId());
			comTaskBehalf.setCreateTime(now);
			comTaskBehalf.setCreateBy(dto.getCreateBy());
			comTaskBehalf.setComId(dto.getComId());
			comTaskBehalf.setBehalfDate(DateUtils.parseDate(dto.getDates()));
			comTaskBehalf.setBehalfPerId(Long.parseLong(acceptPerId)); // 代班人员ID
			comTaskBehalf.setBeBehalfPerId(dto.getPerId()); // 被代班人员ID
			comTaskBehalf.setComTaskId(dto.getComTaskId());
			comTaskBehalf.setShiftId(dto.getShiftId());
			comTaskBehalf.setApproveApplyId(dto.getApproveApplyId());
			comTaskBehalfList.add(comTaskBehalf);
		}
		if(comTaskBehalfList != null && comTaskBehalfList.size()>0){
			comTaskBehalfMapper.insertBatch(comTaskBehalfList);
		}
       }catch (Exception e) {
		   throw new BusinessException(Result.ERROR, "服务出错！");
	   }
		return Result.success(Result.SUCCESS_MSG, null);
	}


	/**
	 * 查询个人的外勤详情
	 * （基于getTaskDetails方法整改）
	 * @param appComTaskDTO
	 * * @author llc
	 * @date 2019-02-25
	 * @return
	 * @throws BusinessException
	 */

	@Override
	public Result getTaskDetailsByPerId(AppComTaskDTO appComTaskDTO) throws BusinessException {

		if(StringUtils.isEmpty(appComTaskDTO.getSelectDate())){
			return Result.fail("日期不能为空!");
		}

		String selectDate = appComTaskDTO.getSelectDate();
		Long perId = appComTaskDTO.getPerId();

		// 1、获取任务详情基本信息
		appComTaskDTO.setSelectDate(selectDate);
		AppComTaskDetailsDTO appComTaskDetailsDTO = appComTaskMapper.getTaskDetails(appComTaskDTO);
		if (appComTaskDetailsDTO == null) {
			throw new BusinessException(Result.ERROR, "查找不到任务详情信息");
		}
		String taskStatus = appComTaskDetailsDTO.getCurrentTaskStatus();// 任务状态
		// 获取正在执行中的轮次信息
		AppComTaskSmallShiftDTO runingTaskRound = getRuningRound(appComTaskDTO);
		List<AppComTaskInsidePushDTO> persons = new ArrayList<AppComTaskInsidePushDTO>();
		// 获取负责人信息
		appComTaskDetailsDTO.setComId(appComTaskDTO.getComId());
		AppComTaskInsidePushDTO inChargePerson = appComTaskMapper.getInChargePerson(appComTaskDetailsDTO);
		if (inChargePerson != null) {
			persons.add(inChargePerson);
		}
		// 获取2条任务成员
		List<AppComTaskInsidePushDTO> noChargePersons = appComTaskMapper.getNoChargePerson(appComTaskDetailsDTO);
		if (noChargePersons != null && noChargePersons.size() > 0) {
			persons.addAll(noChargePersons);
		}
		appComTaskDetailsDTO.setPersons(persons);
		// 2、获取任务考勤日历
		appComTaskDetailsDTO.setPerId(perId);
		appComTaskDetailsDTO.setSelectDate(selectDate);
		AppComTaskCalendarDTO appComTaskCalendarDTO = appComTaskMapper.getComTaskCalendar(appComTaskDetailsDTO);
		appComTaskCalendarDTO.setPerId(perId);
		appComTaskCalendarDTO.setSelectDate(selectDate);
		appComTaskCalendarDTO.setTaskId(appComTaskDTO.getTaskId());
		if (appComTaskCalendarDTO != null) {
			// 异常任务信息
			List<AppComTaskExceptionDTO> arrExceptionTask = new ArrayList<AppComTaskExceptionDTO>();
			// 3、获取任务考勤班次
			List<AppComTaskShiftDTO> arrShifts = appComTaskMapper.getComTaskShiftList(appComTaskCalendarDTO);
			Date cardDate = null; // 最近可打卡班次
			if (arrShifts != null && arrShifts.size() > 0) {
				List<ComTaskAttendAddress> arrCoords = comTaskAttendAddressMapper
						.listComTaskAttendAddress(appComTaskDTO.getTaskId());
				if (arrCoords != null && arrCoords.size() > 0) {
					appComTaskCalendarDTO.setArrCoords(arrCoords);
					appComTaskCalendarDTO.setScope(arrCoords.get(0).getAddressRange());
				}
				// 4、获取查询年月任务考勤轮次信息
				List<AppComTaskSmallShiftDTO> arrSmallShifts = appComTaskMapper
						.getComTaskSmallShiftList(appComTaskCalendarDTO);
 				if (arrSmallShifts != null && arrSmallShifts.size() > 0) {
					// 任务补卡模板状态
					String isActiveStr = comAttendMapper.getIsActive(appComTaskDTO.getComId(), "52");
					int isActive = 0;
					if (StringUtil.isNotEmpty(isActiveStr)) {
						isActive = Integer.parseInt(isActiveStr);
					}
					for (AppComTaskShiftDTO appComTaskShiftDTOItem : arrShifts) {
						appComTaskShiftDTOItem.setIsActive(isActive);// 只有异常才有补卡情况，才需要确定补卡状态
						// 记录异常任务信息
						// 班次状态 (1：未开始，2：可上班打卡，3：可下班打卡，4：已结束)
						AppComTaskExceptionDTO taskException = new AppComTaskExceptionDTO();
						boolean exception = false;// 是否存在异常考勤
						int exceptDay = appComTaskShiftDTOItem.getDay();// IOS异常日期(日)
						Date exceptDate = null; // 安卓异常日期(年月日)
						try {
							exceptDate = DateUtils.parseDate(appComTaskShiftDTOItem.getShiftDate(), "yyyy-MM-dd");
						} catch (Exception e) {

						}
						String shiftTime = commonService.listChangeToString(appComTaskShiftDTOItem.getShiftId(), false,
								false);
						appComTaskShiftDTOItem.setShiftTime(shiftTime);
						List<AppComTaskSmallShiftDTO> appComTaskSmallShiftDTOList = new ArrayList<AppComTaskSmallShiftDTO>();
						for (AppComTaskSmallShiftDTO appComTaskSmallShiftDTO : arrSmallShifts) {
							Date startWorkDate = appComTaskSmallShiftDTO.getStartWorkDate();// 可上班打卡日期
							Date endWorkDate = appComTaskSmallShiftDTO.getEndWorkDate();// 下班最迟打卡日期
							String clockLimitSwitch = appComTaskSmallShiftDTO.getClockLimitSwitch();// 打卡时限开关
							Date toDate = new Date(); // 系统当前日期
							Integer signInStatus = appComTaskSmallShiftDTO.getSignInStatus();// 签到状态(1:正常，2：迟到，5：漏打卡，7：请假)
							Integer signOutStatus = appComTaskSmallShiftDTO.getSignOutStatus();// 签退状态（1:正常，3：早退，5：漏打卡，7：请假）
							int smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 1：已完成，2：可签到，3：可下班，4：未开始
							if (appComTaskShiftDTOItem.getDates().equals(appComTaskSmallShiftDTO.getDates())
									&& appComTaskShiftDTOItem.getShiftId()
									.equals(appComTaskSmallShiftDTO.getShiftId())) {
								// 已完成
								if (signInStatus != null && signOutStatus != null) {
									smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
								} else {
									if (StringUtils.isNotEmpty(clockLimitSwitch)
											&& clockLimitSwitch.equals(DictConst.CLOCKLIMITSWITCHSTATUS_OPEN)) {
										if (toDate.getTime() > endWorkDate.getTime()) {
											/**** 班次已完成 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
											if (signInStatus == null) {
												// 上班漏打卡
												signInStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
											}
											if (signOutStatus == null) {
												// 下班漏打卡
												signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
											}
										} else if (toDate.getTime() > startWorkDate.getTime()
												&& (signInStatus == null
												|| signInStatus == Integer.valueOf(DictConst.ATTENDSTATUS_QJ))
												&& toDate.getTime() <= endWorkDate.getTime()) {
											/**** 请假和未打卡班次可签到 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD);
											if (cardDate == null) {
												cardDate = startWorkDate;
											} else {
												if (startWorkDate.getTime() > cardDate.getTime()) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 未开始
												}
											}
											// 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
											if (runingTaskRound != null) {
												if (!runingTaskRound.getSmallShiftId()
														.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 未开始
												}
											}
										} else if (toDate.getTime() > startWorkDate.getTime() && signInStatus != null
												&& toDate.getTime() <= endWorkDate.getTime()) {
											/**** 班次可下班,上班非请假 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB);
											// 判断最近正在执行的班次是否已经过期 ：
											if (runingTaskRound == null) {
												smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
												signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
											} else {
												if (!runingTaskRound.getSmallShiftId()
														.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
													signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
												}
											}
										}
									} else {
										if (toDate.getTime() > endWorkDate.getTime()) {
											/**** 班次已完成 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
											if (signInStatus == null) {
												// 上班漏打卡
												signInStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
												// 下班漏打卡
												if (signOutStatus == null) {
													signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
												} else {
													// 下班不是请假状态、正常、早退状态的设置缺卡
													if (signOutStatus != Integer.valueOf(DictConst.ATTENDSTATUS_QJ)
															&& signOutStatus != Integer
															.valueOf(DictConst.ATTENDSTATUS_ZC)
															&& signOutStatus != Integer
															.valueOf(DictConst.ATTENDSTATUS_ZT)) {
														signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
													}
												}

											} else {
												// 判断下一轮次是否要开始执行，如果下一轮次打卡时间到，则设置已完成并且下班漏打卡，否则为可下班状态
												smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB);
												// 判断最近正在执行的班次是否已经过期 ：
												// 1、设置下班打卡时限：则下班打卡时限已经到了，用户未打卡，则正在执行的班次设置为漏打卡状态
												// 2、未设置下班打卡时限：则下一个班次已开始打卡，则正在执行的班次设置为漏打卡状态
												if (runingTaskRound == null) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
													signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
												} else {
													if (!runingTaskRound.getSmallShiftId()
															.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
														smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
														signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
													}
												}
											}
										} else if ((signInStatus == null
												|| signInStatus == Integer.valueOf(DictConst.ATTENDSTATUS_QJ))
												&& toDate.getTime() <= endWorkDate.getTime()) {
											/**** 班次可签到 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD);
											if (cardDate == null) {
												cardDate = startWorkDate;
											} else {
												if (startWorkDate.getTime() > cardDate.getTime()) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);
												}
											}
											// 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
											// if (runingTaskRound != null) {
											// if
											// (!runingTaskRound.getSmallShiftId()
											// .equals(appComTaskSmallShiftDTO.getSmallShiftId()))
											// {
											// smallShiftType =
											// Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);//
											// 未开始
											// }
											// }
											// 班次开始日期为次日则不能“可签到”，要设置成“未开始”
											if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD)) {
												Long d1 = Long.valueOf(DateUtils.formatDate(startWorkDate, "yyyyMMdd"));
												Long d2 = Long.valueOf(DateUtils.formatDate(toDate, "yyyyMMdd"));
												if (d1 > d2) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS);// 未开始
												}
											}
										} else if (signInStatus != null) {
											/**** 班次可下班 ****/
											smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB);
											// 判断最近正在执行的班次是否已经过期 ：
											// 1、设置下班打卡时限：则下班打卡时限已经到了，用户未打卡，则正在执行的班次设置为漏打卡状态
											// 2、未设置下班打卡时限：则下一个班次已开始打卡，则正在执行的班次设置为漏打卡状态
											if (runingTaskRound == null) {
												smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
												signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
											} else {
												if (!runingTaskRound.getSmallShiftId()
														.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
													smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);// 已完成
													signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);// 下班漏打卡
												}
											}
										}
									}
								}

								// 任务状态如果是已结束，则未下班的班次自动设置漏打卡，班次完成状态
								if (StringUtils.isNotEmpty(taskStatus) && taskStatus.equals(DictConst.TASKSTATUS_YJS)) {
									// 可签到，设置上下班漏打卡
									if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_KQD)) {
										signInStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
										signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
										smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
									}
									// 可下班，设置下班漏打卡
									if (smallShiftType == Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB)) {
										signOutStatus = Integer.valueOf(DictConst.ATTENDSTATUS_QK);
										smallShiftType = Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC);
									}
								}

								appComTaskSmallShiftDTO.setSignInStatus(signInStatus == null ? 0 : signInStatus);
								appComTaskSmallShiftDTO.setSignOutStatus(signOutStatus == null ? 0 : signOutStatus);
								appComTaskSmallShiftDTO.setSmallShiftType(smallShiftType);
								appComTaskSmallShiftDTOList.add(appComTaskSmallShiftDTO);
								/**** 上班考勤状态 ****/
								if (appComTaskSmallShiftDTO.getSignInStatus() != null) {
									// 迟到
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignInStatus())
											.equals(DictConst.ATTENDSTATUS_CD)) {
										exception = true;
									}
									// 缺岗
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignInStatus())
											.equals(DictConst.ATTENDSTATUS_QK)) {
										exception = true;

									}
									// 请假
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignInStatus())
											.equals(DictConst.ATTENDSTATUS_QJ)) {
										exception = true;
									}
								}
								/**** 下班考勤状态 ****/
								if (appComTaskSmallShiftDTO.getSignOutStatus() != null) {

									// 早退
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignOutStatus())
											.equals(DictConst.ATTENDSTATUS_ZT)) {
										exception = true;
									}
									// 漏卡
									if (exception == false && String.valueOf(appComTaskSmallShiftDTO.getSignOutStatus())
											.equals(DictConst.ATTENDSTATUS_QK)) {
										exception = true;
									}
									// 请假
									if (String.valueOf(appComTaskSmallShiftDTO.getSignOutStatus())
											.equals(DictConst.ATTENDSTATUS_QJ)) {
										exception = true;
									}
								}
							} else {
								/**** 打卡时限开关状态 ：打开 ****/
								if (StringUtils.isNotEmpty(clockLimitSwitch)
										&& clockLimitSwitch.equals(DictConst.CLOCKLIMITSWITCHSTATUS_OPEN)) {
									if (toDate.getTime() > startWorkDate.getTime() && signInStatus == null
											&& toDate.getTime() <= endWorkDate.getTime()) {

										/**** 班次可签到 ****/
										if (cardDate == null) {
											cardDate = startWorkDate;
										}
										// 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
										if (runingTaskRound != null) {
											if (!runingTaskRound.getSmallShiftId()
													.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
												cardDate = null;
											}
										}
									}
								} else {
									/**** 打卡时限开关状态 ：关闭 ****/
									/**** 班次可签到 ****/
									if (signInStatus == null && toDate.getTime() <= endWorkDate.getTime()) {
										if (cardDate == null) {
											cardDate = startWorkDate;
										}
										// 判断是否有正在执行的轮次，如果有则其它可打卡设置成未开始
										if (runingTaskRound != null) {
											if (!runingTaskRound.getSmallShiftId()
													.equals(appComTaskSmallShiftDTO.getSmallShiftId())) {
												cardDate = null;
											}
										}
									}
								}
							}
						}
						if (exception) {
							taskException.setDay(exceptDay);
							taskException.setDate(exceptDate);
							taskException.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD));// 异常
							arrExceptionTask.add(taskException);
						}
						appComTaskShiftDTOItem.setArrSmallShifts(appComTaskSmallShiftDTOList);
					}
				}
				appComTaskCalendarDTO.setArrShifts(arrShifts);
			}
			/**
			 * 所有班次状态均为正常，则日历显示班 所有班次状态均为漏签，则日历显示缺
			 * 班次存在多种状态，则日历显示异，所有班次状态为请假，则日历显示假
			 */


			appComTaskCalendarDTO.setArrExceptionAttendance(arrExceptionTask);
			appComTaskDetailsDTO.setCalendarData(appComTaskCalendarDTO);
		}
		return Result.success(Result.SUCCESS_MSG, appComTaskDetailsDTO);
	}


}