package com.bcxin.oa.old.service.task;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.Week;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.ExcelEnum;
import com.bcxin.oa.old.common.utils.file.BcxinFileUtils;
import com.bcxin.oa.old.mapper.ComAttendTaskImportMapper;
import com.bcxin.oa.old.mapper.ComTaskMapper;
import com.bcxin.oa.old.mapper.ComTaskShiftMapper;
import com.bcxin.oa.old.entity.task.ComTask;
import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.entity.task.TempTaskSchedulCheck;
import com.bcxin.oa.old.dto.ComShiftDto;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.system.CacheService;
import com.bcxin.oa.old.service.task.bbd.BbdTestService;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.Result;
import org.apache.commons.lang3.StringUtils;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.utils.ExcelUtil;
import com.github.pagehelper.StringUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: wangjianjun
 * @Date: 2019/9/27
 */
@Service
@Slf4j
@Transactional
public class ComAttendTaskSchedulServiceImpl implements ComAttendTaskSchedulService {
    @Resource
    public CacheService cacheService;
    @Resource
    private ComTaskPerShiftService comTaskPerShiftService;
    @Resource
    private ComTaskShiftMapper comTaskShiftMapper;
    @Resource
    private ComAttendTaskImportMapper comAttendTaskImportMapper;
    @Resource
    private ComTaskMapper comTaskMapper;
    @Resource
    private IdWorker idWorker;

    @Resource
    private BbdTestService bbdTestService;
    /**
     * 导出 excel
     *
     * @param response
     * @param paramDTO month（2019-09） comId（机构ID） comTaskId（任务ID）
     * @return
     * @throws BusinessException
     */
    @Override
    public Result export(HttpServletResponse response, ParamDTO paramDTO) throws BusinessException {
        {
            if (paramDTO.getComTaskId() == null) {
                return Result.fail("驻勤任务ID不能为空！");
            }
            if (StringUtil.isEmpty(paramDTO.getMonth())) {
                return Result.fail("排班月份不能为空！");
            }
            //获取指定月份所有日期集合
            final List<String> dayListOfMonth = DateUtils.getDatesByMonth(paramDTO.getMonth());//格式是2019-01-01
            //获取周末的集合
            final List<String> dayListWeekend = dayListOfMonth.stream().filter(weekend -> Lists.newArrayList(Week.SUNDAY, Week.SATURDAY).contains(DateUtil.dayOfWeekEnum(DateUtil.parse(weekend, "yyyy-MM-dd")))).collect(Collectors.toList());
            //获取考勤班次详情
            Result result = comTaskPerShiftService.pagePerShiftExport(paramDTO);
            Map<String, Object> resultMap = JSONObject.parseObject(JSONObject.toJSONString(result.getData()), Map.class);
            List<Map<String, String>> perShiftAllMap = (List<Map<String, String>>) resultMap.get("perShiftAllMap");
            Map<String, Object> comTaskMap = (Map<String, Object>) resultMap.get("comTask");
            OutputStream os = null;
            XSSFWorkbook wb = new XSSFWorkbook();
            try {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");//改为office2017格式
                response.setHeader("Content-Disposition",
                        "attachment;fileName=" + new String("排班表模板.xlsx".getBytes("gb2312"), "ISO8859-1"));
                os = response.getOutputStream();
                XSSFSheet sheet1 = wb.createSheet("排班表");
                XSSFSheet sheet2 = wb.createSheet("下拉列表");
                XSSFSheet sheet3 = wb.createSheet("隐藏数据");
                wb.setSheetHidden(1, true);
                wb.setSheetHidden(2, true);

                /**** excel标题栏 ****/
                String headerTitle = comTaskMap.get("taskName") + paramDTO.getMonth() + " 排班表";
                String subHeaderTitle = "注意：\n" +
                        "1、请根据日期设置员工的每日排班情况，每次仅支持一个月排班；\n" +
                        "2、请选择或填入单元格中的班次，不能输入其他班次名称，否则无法识别；\n" +
                        "3、排班表须导入相应任务，否则无法导入；\n"+
                        "4、系统仅识别明日之后的排班数据，且根据设置的班次信息覆盖原有的排班信息；\n"+
                        "5、若排班表导入失败，可下载失败文件查看失败原因，并在原排班表中调整后重新导入排班；\n"+
                        "6、建议每次排班时，重新下载排班表，以防任务信息调整或人员调整后，造成无法导入；\n";
                StringBuilder subSubHeaderTitle = new StringBuilder("排班信息: ");
                //查出班次类型，把ID和名称放shiftAliasAlphaMap里
                List<ComShiftDto> shifts = comTaskShiftMapper.selectComTaskShiftByTaskId(paramDTO.getComTaskId());
                //班次类型Map
                Map shiftAliasAlphaMap = new LinkedHashMap();
                for (ComShiftDto c : shifts) {
                    shiftAliasAlphaMap.put(String.valueOf(c.getShiftId()), c.getShiftName());
                    subSubHeaderTitle.append(c.getShiftName()).append(": ").append(c.getShiftRuleDetail()).append(";    ");
                }
                shiftAliasAlphaMap.put("0", "休");
                subSubHeaderTitle.append("休: 当天休息 ");
                String[] shiftAliasAlpha = (String[]) shiftAliasAlphaMap.values().toArray(new String[0]);
                /*** 下拉框数据 需要校验是否需要填充 ***/
                List<Integer> selectRowList = Lists.newArrayList();
                List<String[]> selectData = new ArrayList<String[]>();
                if (shifts.size() > 0) {
                    for (int i = 1; i <= dayListOfMonth.size(); i++) {
                        selectData.add(shiftAliasAlpha);
                    }
                }
                List<Integer> dayList = new ArrayList<>();//
                List<Integer> dayWeekend = new ArrayList<>();//周末的集合

                for (int i = 0; i < dayListOfMonth.size(); i++) {
                    if (dayListWeekend.contains(dayListOfMonth.get(i))) {//周末
                        dayWeekend.add(i + 5);
                    }
                    dayList.add(i + 5);//从第6列开始创建抬头的数字集合，从5开始
                }
                selectRowList.addAll(dayList);
                /*** 下拉表的序号数组 ***/
                Integer[] selectRows = new Integer[selectRowList.size()];
                selectRowList.toArray(selectRows);
                /*** 填充必填样式 ***/
                CellStyle style1 = ExcelUtil.getNecessaryTitleStyle2007(wb);
                /*** 填充非必填样式 ***/
                CellStyle style2 = ExcelUtil.getCommonTitleStyle2007(wb);
                /*** 填充文本样式 ***/
                CellStyle stringStyle = ExcelUtil.getStringStyle2007(wb);
                /**** 生成sheet1的内容 ***/
                XSSFRow rowFirst = sheet1.createRow(0); // 第一个sheet的第一行为标题
                XSSFFont titleFont = wb.createFont();
                XSSFCellStyle titleStyle = wb.createCellStyle();
                titleFont.setFontHeightInPoints((short) 20);
                titleFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
                titleFont.setFontName("黑体");
                titleStyle.setFont(titleFont);
                titleStyle.setAlignment(HorizontalAlignment.CENTER);
                titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
                titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);//填充单元格
                titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.SKY_BLUE.getIndex());//设置单元格背景色
                titleStyle.setWrapText(true);
                rowFirst.setHeight((short) (1000));
                sheet1.addMergedRegion(new CellRangeAddress(0, (short) 0, 0, 10));
                XSSFCell titleCell = rowFirst.createCell(0);
                titleCell.setCellValue(headerTitle);
                titleCell.setCellStyle(titleStyle);

                /***生成第二行的内容***/
                XSSFRow rowFirst2 = sheet1.createRow(1);
                XSSFFont titleFont2 = wb.createFont();
                XSSFCellStyle titleStyle2 = wb.createCellStyle();
                sheet1.addMergedRegion(new CellRangeAddress(1, (short) 1, 0, 30));
                titleFont2.setFontHeightInPoints((short) 11);
                titleFont2.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
                titleFont2.setFontName("黑体");
                titleStyle2.setFont(titleFont2);
                titleStyle2.setAlignment(HorizontalAlignment.CENTER);
                titleStyle2.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
                titleStyle2.setWrapText(true);
                rowFirst2.setHeight((short) (3000));
                XSSFCell titleCell2 = rowFirst2.createCell(0);
                titleCell2.setCellValue(subHeaderTitle);
                titleCell2.setCellStyle(titleStyle2);

                /***生成第三行的内容***/
                sheet1.addMergedRegion(new CellRangeAddress(2, (short) 2, 0, 30));
                XSSFRow rowFirst3 = sheet1.createRow(2);
                XSSFFont titleFont3 = wb.createFont();
                XSSFCellStyle titleStyle3 = wb.createCellStyle();
                titleFont3.setFontHeightInPoints((short) 10);
                titleFont3.setColor(HSSFColor.HSSFColorPredefined.DARK_YELLOW.getIndex());
                titleFont3.setFontName("黑体");
                titleStyle3.setFont(titleFont3);
                titleStyle3.setAlignment(HorizontalAlignment.CENTER);
                titleStyle3.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
                titleStyle3.setWrapText(true);
                rowFirst3.setHeight((short) (800));
                XSSFCell titleCell3 = rowFirst3.createCell(0);
                titleCell3.setCellValue(subSubHeaderTitle.toString());
                titleCell3.setCellStyle(titleStyle3);
                //设置非锁定样式
                XSSFCellStyle titleStyleUnLocked = wb.createCellStyle();
                titleStyleUnLocked.setAlignment(HorizontalAlignment.CENTER);
                titleStyleUnLocked.setVerticalAlignment(VerticalAlignment.CENTER);
                titleStyleUnLocked.setWrapText(true);
                titleStyleUnLocked.setLocked(false);

                XSSFRow rowSecond = sheet1.createRow(3);
                rowSecond.setHeight((short) 500);
                /*** 写第四行，即抬头行 ***/
                String[] handers = {"人员ID", "部门", "身份证号", "手机号码", "姓名"};
                //后面加一个月的日期
                handers = (String[]) ArrayUtils.addAll(handers, dayListOfMonth.toArray());
                int column;
                for (int i = 0; i < handers.length; i++) {
                    XSSFCell cell = rowSecond.createCell(i); // 获取第四行的每个单元格
                    switch (i) {
                        case 2:
                            column = 5000;
                            break;
                        default:
                            column = 4000;
                            break;
                    }
                    sheet1.setColumnWidth(i, column); // 设置每列的列宽
                    sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                    if (!dayWeekend.contains(i)) {
                        cell.setCellStyle(style2); // 必填项目
                    } else {
                        cell.setCellStyle(style1);// 必填项目 周末设置为红色
                    }
                    cell.setCellValue(handers[i]); // 往单元格里写数据
                }
                /**** 填充下拉框数据 ***/
                String[] arr = {"A", "B", "C", "D", "E"};
                List<String> temp = Lists.newArrayList(arr);
                //从5列开始，创建表格最上方的A\B\C\E\F\G\H\I\J\K\L\M\N\AB这种抬头
                for (Integer t : dayList) {
                    temp.add(getKey(t));
                }
                arr = temp.toArray(new String[temp.size()]);
                int index = 0;
                XSSFRow row = null;
                for (int r = 0; r < selectRows.length; r++) {
                    String[] dlData = selectData.get(r);// 获取下拉对象
                    if (dlData != null) {
                        int rownum = selectRows[r];
                        /*** 1.设置有效性 ***/
                        String strFormula = "下拉列表!$" + arr[index] + "$1:$" + arr[index] + "$" + dlData.length; // Sheet2第A1到A10000作为下拉列表来源数据
                        // 设置数据有效性加载在哪个单元格上,参数分别是：从sheet3获取A1到A10000作为一个下拉的数据、起始行、终止行、起始列、终止列
                        sheet1.addValidationData(ExcelUtil.setDataValidation2007(sheet1, strFormula, 4, 10000, rownum, rownum, "请下拉选择班次", "请选择排班信息中的班次，不可随意输入。")); // 下拉列表元素很多的情况
                        /*** 2、生成sheet2内容 ***/
                        for (int j = 0; j < dlData.length; j++) {
                            if (index == 0) { // 第1个下拉选项，直接创建行、列
                                row = sheet2.createRow(j); // 创建数据行
                                sheet2.setColumnWidth(j, 5000); // 设置每列的列宽
                                row.createCell(0).setCellValue(dlData[j]); // 设置对应单元格的值
                            } else { // 非第1个下拉选项
                                int rowCount = sheet2.getLastRowNum();
                                if (j <= rowCount) { // 前面创建过的行，直接获取行，创建列
                                    // 获取行，创建列
                                    sheet2.getRow(j).createCell(index).setCellValue(dlData[j]); // 设置对应单元格的值
                                } else { // 未创建过的行，直接创建行、创建列
                                    sheet2.setColumnWidth(j, 5000); // 设置每列的列宽
                                    // 创建行、创建列
                                    sheet2.createRow(j).createCell(index).setCellValue(dlData[j]); // 设置对应单元格的值
                                }
                            }
                        }
                    }
                    index++;
                }
                /**** 填充隐藏数据 ***/
                BigDecimal bdComTaskId = new BigDecimal(paramDTO.getComTaskId());
                BigDecimal bdComId = new BigDecimal(paramDTO.getComId());
                XSSFRow hiddenRow = sheet3.createRow(0); // 创建数据行
                sheet3.setDefaultColumnStyle(0, titleStyleUnLocked); // 设置单元格格式 --文本格式
                sheet3.setDefaultColumnStyle(1, titleStyleUnLocked); // 设置单元格格式 --文本格式
                sheet3.setDefaultColumnStyle(2, titleStyleUnLocked); // 设置单元格格式 --文本格式
                hiddenRow.createCell(0).setCellValue(paramDTO.getMonth());
                hiddenRow.createCell(1).setCellValue(bdComTaskId.toPlainString());
                hiddenRow.createCell(2).setCellValue(bdComId.toPlainString());
                sheet3.protectSheet(RandomUtil.randomNumbers(6));//密码设置为6位数随机数

                /**** 读入已经存在的数据 ***/
                List<Map<String, String>> dataList = perShiftAllMap;
                //从第四行开始读入数据
                int rowIndex = 4;
                for (Map<String, String> map : dataList) {
                    row = sheet1.createRow(rowIndex);
                    row.createCell(0).setCellValue(map.get("perId"));
                    row.createCell(1).setCellValue(map.get("departName"));
                    row.createCell(2).setCellValue(map.get("idCardNo"));
                    row.createCell(3).setCellValue(map.get("mobilePhone"));
                    row.createCell(4).setCellValue(map.get("name"));
                    //从第6列开始批量填充数据
                    for (int i = 5; i < dayListOfMonth.size() + 5; i++) {
                        XSSFCell cell = row.createCell(i);
                        String value = map.get(dayListOfMonth.get(i - 5));
                        if (!value.isEmpty()) {
                            value = shiftAliasAlphaMap.get(value).toString();
                        }
                        cell.setCellValue(value);
                        cell.setCellStyle(titleStyleUnLocked);
                    }
                    rowIndex++;
                }
                //隐藏excel的第一列,从0开始
                sheet1.setColumnHidden(0, true);
                sheet1.protectSheet(RandomUtil.randomNumbers(6));//密码设置为6位数随机数
                wb.write(os);
                os.close();
            } catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException(Result.ERROR, "导出Excel组织架构模板失败");
            } finally {
                if (os != null || wb != null) {
                    try {
                        os.close();// 输入流关闭
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return Result.success("导出Excel组织架构模板成功");
        }
    }

    /**
     * 导入excel
     *
     * @param xfile
     * @param paramDTO
     * @return
     * @throws BusinessException
     */
    @Override
    public Result importExcel(MultipartFile xfile, ParamDTO paramDTO) {
        /*** 校验文件格式 ***/
        String fileType = xfile.getOriginalFilename().substring(xfile.getOriginalFilename().lastIndexOf(".") + 1)
                .toLowerCase();// 文件类型
        if (xfile != null && xfile.getSize() > 0) {
            if (!fileType.equals(ExcelEnum.EXCEL_TYPE_XLSX.getValue())) {
                return Result.fail("上传文件格式不正确，后缀名为xlsx  ！");
            }
        }
        InputStream inputStream = null;
        Integer importCount = 0;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>(); // 数据库校验的list
        List<Map<String, String>> faildList = new ArrayList<Map<String, String>>(); // 定义失败的list
        List<TempTaskSchedulCheck> checkFailDetailList = new ArrayList<>(); // 定义具体某人某天的失败记录
        List<ComShiftDto> shifts = null;
        List<String> perIdList = new ArrayList<>();
        try {
            inputStream = xfile.getInputStream();
            Workbook workBook = WorkbookFactory.create(inputStream);
            Sheet sheet3 = workBook.getSheetAt(2);
            String month = sheet3.getRow(0).getCell(0).getStringCellValue();
            //排班表的任务Id，和前端传的任务id是否一致
            String excelComTaskId = sheet3.getRow(0).getCell(1).getStringCellValue();
            if (!org.apache.commons.lang3.StringUtils.equals(excelComTaskId, String.valueOf(paramDTO.getComTaskId()))) {
                return Result.fail("注意，您导入的排班表，不是从当前任务导出的，无法适用！");
            }

            paramDTO.setMonth(month.trim());
            //查出班次类型，放到ID和名称放shiftAliasAlphaMap里
            shifts = comTaskShiftMapper.selectComTaskShiftByTaskId(paramDTO.getComTaskId());
            //班次类型Map
            Map shiftAliasAlphaMap = new LinkedHashMap();
            for (ComShiftDto c : shifts) {
                shiftAliasAlphaMap.put(String.valueOf(c.getShiftId()), c.getShiftName());
            }
            //手动添加一个班次类型
            shiftAliasAlphaMap.put("0", "休");
            //键值反转，将班次ID变成value，中文名称变成key，前提是值不重复
            Map<String, String> reverseMap = MapUtil.reverse(shiftAliasAlphaMap);
            Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet
            boolean flag = true;
            final int startRow=4;// 设置初始行第5行
            int rowNo = startRow;
            final int startColumn = 5;//设置第6列开始
            final int endColumn = 35;//设置第36列结束
            while (flag) {
                Row row = sheet.getRow(rowNo);
                if (row != null) {
                    Map<String, String> data = new HashMap<String, String>();
                    StringBuffer errorMsg = new StringBuffer(); // 校验错误信息

                    /*** 人员id ***/
                    String perId = ExcelUtil.getCellValue(row.getCell(0));
                    perId = perId.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                    perIdList.add(perId);

                    /*** 部门名称 ***/
                    String departName = ExcelUtil.getCellValue(row.getCell(1));
                    departName = departName.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");

                    /*** 证件号码 ***/
                    String idCardNo = ExcelUtil.getCellValue(row.getCell(2));
                    idCardNo = idCardNo.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ",
                            "");
                    /*** 因为客户之前的excel身份证号可能存在科学计数法 ***/
                    if (idCardNo.contains("E") && idCardNo.contains(".")) {
                        BigDecimal bd = new BigDecimal(idCardNo);
                        idCardNo = bd.toPlainString();
                    }
                    /*** 手机号码 ***/
                    String mobilePhone = ExcelUtil.getCellValue(row.getCell(3));
                    mobilePhone = mobilePhone.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                    /*** 因为客户之前的excel手机号可能存在科学计数法 ***/
                    if (mobilePhone.contains("E") && mobilePhone.contains(".")) {
                        BigDecimal bd = new BigDecimal(mobilePhone);
                        mobilePhone = bd.toPlainString();
                    }

                    /*** 姓名 ***/
                    String name = ExcelUtil.getCellValue(row.getCell(4));
                    name = name.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");

                    /*** 日期集合 ***/
                    //这里将班次值的汉字转成系统能识别的id，休息转成0,使用前面的键值转换Map进行转换
                    String date1 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(5)));
                    String date2 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(6)));
                    String date3 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(7)));
                    String date4 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(8)));
                    String date5 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(9)));
                    String date6 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(10)));
                    String date7 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(11)));
                    String date8 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(12)));
                    String date9 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(13)));
                    String date10 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(14)));
                    String date11 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(15)));
                    String date12 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(16)));
                    String date13 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(17)));
                    String date14 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(18)));
                    String date15 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(19)));
                    String date16 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(20)));
                    String date17 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(21)));
                    String date18 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(22)));
                    String date19 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(23)));
                    String date20 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(24)));
                    String date21 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(25)));
                    String date22 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(26)));
                    String date23 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(27)));
                    String date24 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(28)));
                    String date25 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(29)));
                    String date26 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(30)));
                    String date27 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(31)));
                    String date28 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(32)));
                    String date29 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(33)));
                    String date30 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(34)));
                    String date31 = reverseMap.get(ExcelUtil.getCellValue(row.getCell(35)));
                    data.put("perId", perId);
                    data.put("departName", departName);
                    data.put("idCardNo", idCardNo);
                    data.put("mobilePhone", mobilePhone);
                    data.put("name", name);
                    data.put("date1", StringUtils.isEmpty(date1) ? null : date1);
                    data.put("date2", StringUtils.isEmpty(date2) ? null : date2);
                    data.put("date3", StringUtils.isEmpty(date3) ? null : date3);
                    data.put("date4", StringUtils.isEmpty(date4) ? null : date4);
                    data.put("date5", StringUtils.isEmpty(date5) ? null : date5);
                    data.put("date6", StringUtils.isEmpty(date6) ? null : date6);
                    data.put("date7", StringUtils.isEmpty(date7) ? null : date7);
                    data.put("date8", StringUtils.isEmpty(date8) ? null : date8);
                    data.put("date9", StringUtils.isEmpty(date9) ? null : date9);
                    data.put("date10", StringUtils.isEmpty(date10) ? null : date10);
                    data.put("date11", StringUtils.isEmpty(date11) ? null : date11);
                    data.put("date12", StringUtils.isEmpty(date12) ? null : date12);
                    data.put("date13", StringUtils.isEmpty(date13) ? null : date13);
                    data.put("date14", StringUtils.isEmpty(date14) ? null : date14);
                    data.put("date15", StringUtils.isEmpty(date15) ? null : date15);
                    data.put("date16", StringUtils.isEmpty(date16) ? null : date16);
                    data.put("date17", StringUtils.isEmpty(date17) ? null : date17);
                    data.put("date18", StringUtils.isEmpty(date18) ? null : date18);
                    data.put("date19", StringUtils.isEmpty(date19) ? null : date19);
                    data.put("date20", StringUtils.isEmpty(date20) ? null : date20);
                    data.put("date21", StringUtils.isEmpty(date21) ? null : date21);
                    data.put("date22", StringUtils.isEmpty(date22) ? null : date22);
                    data.put("date23", StringUtils.isEmpty(date23) ? null : date23);
                    data.put("date24", StringUtils.isEmpty(date24) ? null : date24);
                    data.put("date25", StringUtils.isEmpty(date25) ? null : date25);
                    data.put("date26", StringUtils.isEmpty(date26) ? null : date26);
                    data.put("date27", StringUtils.isEmpty(date27) ? null : date27);
                    data.put("date28", StringUtils.isEmpty(date28) ? null : date28);
                    data.put("date29", StringUtils.isEmpty(date29) ? null : date29);
                    data.put("date30", StringUtils.isEmpty(date30) ? null : date30);
                    data.put("date31", StringUtils.isEmpty(date31) ? null : date31);

                    /***** 校验excel字段 ****/
                    /*** 校验日期下方对应的班次值是否有效 ***/
                    for (int t = startColumn; t < endColumn; t++) {
                        String temp = ExcelUtil.getCellValue(row.getCell(t));
                        if (StringUtils.isNotBlank(temp)) {
                            if (!reverseMap.containsKey(temp)) {
                                errorMsg.append(StringUtil.isEmpty(errorMsg.toString()) ? ExcelUtil.getCellValue(sheet.getRow(startRow - 1).getCell(startColumn)) + "列无效" : " || " + ExcelUtil.getCellValue(sheet.getRow(startRow - 1).getCell(t)) + "列无效");
                                data.put("date" + (t - 4), temp);
                            }
                        }
                    }
                    importCount++;
                    if (StringUtils.isNotBlank(errorMsg)) {
                        data.put("errorMsg", errorMsg.toString());
                        faildList.add(data);
                    } else {
                        list.add(data);
                    }
                } else {
                    flag = false;
                }
                rowNo++;
            }
            /** 如果客户没上传内容 **/
            if (list.size() == 0 && faildList.size() == 0) {
                return Result.fail("导入模板没有信息");
            }
            /**** 处理业务逻辑 ***/
            if (list != null && list.size() > 0) {
                Map<String, String> checkResultMap = saveImportTaskSchedulInfo(list, paramDTO);
                List<Map> tempImportTaskSchedulList = JSON.parseArray(checkResultMap.get("tempImportTaskSchedulList"),Map.class);

                /*** 此校验失败列表是为了控制失败空格显示红色用 ***/
                if(StringUtils.isNotEmpty(checkResultMap.get("tempImportTaskSchedulList"))){
                    checkFailDetailList = JSON.parseArray(checkResultMap.get("checkFailList"),TempTaskSchedulCheck.class);
                }
                List<Map<String, String>> checkFaildList = new ArrayList<>();
                for (Map<String, String> map : tempImportTaskSchedulList) {
                    if (map.get("isSuccess").equals(CommonConst.N)) { // 失败排班记录
                        checkFaildList.add(map);
                    }
                }

                /**** 如果校验的导入人员信息有误 ****/
                if (checkFaildList != null && checkFaildList.size() > 0) {
                    faildList.addAll(checkFaildList);
                }
            }
            //log.error("importCount==" + importCount);
        } catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e1) {

                }
            }
            e.printStackTrace();
            throw new BusinessException(Result.ERROR, "表格数据有误");
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e1) {

                }
            }
        }

        /*** 同步排班信息到百保盾 ***/
        bbdTestService.bbdBatchSyncTaskSchedul(perIdList,paramDTO);

        /*** 如果有失败人员信息,生成失败的人员信息文件 ***/
        String resultMsg = MessageFormat.format("本次导入条数【{0}】,其中成功条数:【{1}】,失败条数:【{2}】", importCount,
                importCount - faildList.size(), faildList.size());
        if (faildList.size() > 0) {
            String fileUrl = "";
            try {
                fileUrl = buildFaildExcel(paramDTO, faildList, shifts,checkFailDetailList);
            } catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException(Result.ERROR, "生成错误失败人员文件错误");
            }
            return Result.fail(resultMsg, fileUrl);
        } else {
            return Result.success(resultMsg);
        }
    }

    /**
     * 生成excel表头，A-Z;AA-ZZ;AAA-ZZZ支持无限
     *
     * @param index
     * @return
     */
    public String getKey(int index) {
        String colCode = "";
        char key = 'A';
        int loop = index / 26;
        if (loop > 0) {
            colCode += getKey(loop - 1);
        }
        key = (char) (key + index % 26);
        colCode += key;
        return colCode;
    }


    /**
     * @Description: 生成导入失败的信息
     * @Author: wangjianjun
     * @Date: 2019/9/26
     * @return:
     */
    public String buildFaildExcel(ParamDTO paramDTO, List<Map<String, String>> failList, List<ComShiftDto> shifts,List<TempTaskSchedulCheck> checkFailDetailList) throws BusinessException {
        FileOutputStream fileOut = null;
        try {
            String dirDate = DateUtil.today(); // 当前日期
            Date now = new Date();
            String upload_path = cacheService.getSystemConfig("SYS_PIC_PATH");
            String dirPaht = upload_path + "temp/" + dirDate;
            File dir = new File(dirPaht);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = now.getTime() + RandomUtil.randomNumbers(6) + ".xlsx";
            String filePath = dirPaht + "/" + fileName;
            File file = new File(filePath);
            //获取指定月份所有日期集合
            final List<String> dayListOfMonth = DateUtils.getDatesByMonth(paramDTO.getMonth());//格式是2019/1/1
            final List<String> dateList = DateUtils.getDatesByMonth(paramDTO.getMonth());//格式是2019-10-01
            //获取周末的集合
            final List<String> dayListWeekend = dayListOfMonth.stream().filter(weekend -> Lists.newArrayList(Week.SUNDAY, Week.SATURDAY).contains(DateUtil.dayOfWeekEnum(DateUtil.parse(weekend, "yyyy-MM-dd")))).collect(Collectors.toList());
            //获取考勤班次详情
            Result result = comTaskPerShiftService.pagePerShiftExport(paramDTO);
            Map<String, Object> resultMap = JSONObject.parseObject(JSONObject.toJSONString(result.getData()), Map.class);
            Map<String, Object> comTaskMap = (Map<String, Object>) resultMap.get("comTask");
            XSSFWorkbook wb = new XSSFWorkbook();

            XSSFSheet sheet1 = wb.createSheet("排班表导入情况");
            XSSFSheet sheet2 = wb.createSheet("下拉列表");
            wb.setSheetHidden(1, true);

            /**** excel标题栏 ****/
            String headerTitle = comTaskMap.get("taskName") + " 排班表导入情况";
            String subHeaderTitle = "注意：\n" +
                    "1、请根据日期设置员工的每日排班情况，每次仅支持一个月排班；\n" +
                    "2、请选择或填入单元格中的班次，不能输入其他班次名称，否则无法识别；\n" +
                    "3、排班表须导入相应任务，否则无法导入；\n"+
                    "4、系统仅识别明日之后的排班数据，且根据设置的班次信息覆盖原有的排班信息；\n"+
                    "5、若排班表导入失败，可下载失败文件查看失败原因，并在原排班表中调整后重新导入排班；\n"+
                    "6、建议每次排班时，重新下载排班表，以防任务信息调整或人员调整后，造成无法导入；\n";
            StringBuilder subSubHeaderTitle = new StringBuilder("排班信息: ");
            Map shiftAliasAlphaMap = new LinkedHashMap();
            for (ComShiftDto c : shifts) {
                shiftAliasAlphaMap.put(String.valueOf(c.getShiftId()), c.getShiftName());
                subSubHeaderTitle.append(c.getShiftName()).append(": ").append(c.getShiftRuleDetail()).append(";    ");
            }
            shiftAliasAlphaMap.put("0", "休");
            subSubHeaderTitle.append("休: 当天休息 ");
            String[] shiftAliasAlpha = (String[]) shiftAliasAlphaMap.values().toArray(new String[0]);
            /*** 下拉框数据 需要校验是否需要填充 ***/
            List<Integer> selectRowList = Lists.newArrayList();
            List<String[]> selectData = new ArrayList<String[]>();
            if (shifts.size() > 0) {
                for (int i = 1; i <= dayListOfMonth.size(); i++) {
                    selectData.add(shiftAliasAlpha);
                }
            }
            List<Integer> dayList = new ArrayList<>();//
            List<Integer> dayWeekend = new ArrayList<>();//周末的集合

            for (int i = 0; i < dayListOfMonth.size(); i++) {
                if (dayListWeekend.contains(dayListOfMonth.get(i))) {//周末
                    dayWeekend.add(i + 5);
                }
                dayList.add(i + 5);//从第6列开始创建抬头的数字集合，从5开始
            }
            selectRowList.addAll(dayList);
            /*** 下拉表的序号数组 ***/
            Integer[] selectRows = new Integer[selectRowList.size()];
            selectRowList.toArray(selectRows);

            /*** 填充必填样式 ***/
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle2007(wb);
            /*** 填充非必填样式 ***/
            CellStyle style2 = ExcelUtil.getCommonTitleStyle2007(wb);
            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle2007(wb);
            /**** 生成sheet1的内容 ***/
            XSSFRow rowFirst = sheet1.createRow(0); // 第一个sheet的第一行为标题
            XSSFFont titleFont = wb.createFont();
            XSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 20);
            titleFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            titleFont.setFontName("黑体");
            titleStyle.setFont(titleFont);
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);//填充单元格
            titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.SKY_BLUE.getIndex());//设置单元格背景色
            titleStyle.setWrapText(true);

            rowFirst.setHeight((short) (1000));
            sheet1.addMergedRegion(new CellRangeAddress(0, (short) 0, 0, 10));
            XSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle);

            //生成第二行的内容
            XSSFRow rowFirst2 = sheet1.createRow(1);
            XSSFFont titleFont2 = wb.createFont();
            XSSFCellStyle titleStyle2 = wb.createCellStyle();
            sheet1.addMergedRegion(new CellRangeAddress(1, (short) 1, 0, 30));
            titleFont2.setFontHeightInPoints((short) 11);
            titleFont2.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
            titleFont2.setFontName("黑体");
            titleStyle2.setFont(titleFont2);
            titleStyle2.setAlignment(HorizontalAlignment.CENTER);
            titleStyle2.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            titleStyle2.setWrapText(true);
            rowFirst2.setHeight((short) (3000));
            XSSFCell titleCell2 = rowFirst2.createCell(0);
            titleCell2.setCellValue(subHeaderTitle);
            titleCell2.setCellStyle(titleStyle2);

            //生成第三行的内容
            sheet1.addMergedRegion(new CellRangeAddress(2, (short) 2, 0, 30));
            XSSFRow rowFirst3 = sheet1.createRow(2);
            XSSFFont titleFont3 = wb.createFont();
            XSSFCellStyle titleStyle3 = wb.createCellStyle();
            titleFont3.setFontHeightInPoints((short) 10);
            titleFont3.setColor(HSSFColor.HSSFColorPredefined.DARK_YELLOW.getIndex());
            titleFont3.setFontName("黑体");
            titleStyle3.setFont(titleFont3);
            titleStyle3.setAlignment(HorizontalAlignment.CENTER);
            titleStyle3.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            titleStyle3.setWrapText(true);
            rowFirst3.setHeight((short) (800));
            XSSFCell titleCell3 = rowFirst3.createCell(0);
            titleCell3.setCellValue(subSubHeaderTitle.toString());
            titleCell3.setCellStyle(titleStyle3);
            //设置非锁定样式
            XSSFCellStyle titleStyleUnLocked = wb.createCellStyle();
            titleStyleUnLocked.setAlignment(HorizontalAlignment.CENTER);
            titleStyleUnLocked.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyleUnLocked.setLocked(false);

            // 设置错误醒目提醒样式
            XSSFCellStyle errorStyle = wb.createCellStyle();
            XSSFFont errorFont = wb.createFont();
            errorFont.setFontHeightInPoints((short) 10);
            errorFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            errorFont.setFontName("黑体");
            errorStyle.setFont(errorFont);
            errorStyle.setAlignment(HorizontalAlignment.CENTER);
            errorStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            errorStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);//填充单元格
            errorStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());    //填红色
            errorStyle.setWrapText(true);
            errorStyle.setLocked(false);

            XSSFRow rowSecond = sheet1.createRow(3);
            rowSecond.setHeight((short) 500);
            /*** 写第四行，即抬头行 ***/
            String[] handers = {"人员ID", "部门", "身份证号", "手机号码", "姓名"};
            //后面加一个月的日期
            handers = (String[]) ArrayUtils.addAll(handers, dayListOfMonth.toArray());
            int column;
            for (int i = 0; i < handers.length; i++) {
                XSSFCell cell = rowSecond.createCell(i); // 获取第四行的每个单元格
                switch (i) {
                    case 2:
                        column = 5000;
                        break;
                    default:
                        column = 4000;
                        break;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                if (!dayWeekend.contains(i)) {
                    cell.setCellStyle(style2); // 必填项目
                } else {
                    cell.setCellStyle(style1);// 必填项目 周末设置为红色
                }
                cell.setCellValue(handers[i]); // 往单元格里写数据
            }
            /**** 填充下拉框数据 ***/
            String[] arr = {"A", "B", "C", "D", "E"};
            List<String> temp = Lists.newArrayList(arr);
            //从5列开始，创建表格最上方的A\B\C\E\F\G\H\I\J\K\L\M\N\AB这种抬头
            for (Integer t : dayList) {
                temp.add(getKey(t));
            }
            arr = temp.toArray(new String[temp.size()]);
            int index = 0;
            XSSFRow row = null;
            for (int r = 0; r < selectRows.length; r++) {
                String[] dlData = selectData.get(r);// 获取下拉对象
                if (dlData != null) {
                    int rownum = selectRows[r];
                    /*** 1.设置有效性 ***/
                    String strFormula = "下拉列表!$" + arr[index] + "$1:$" + arr[index] + "$" + dlData.length; // Sheet2第A1到A10000作为下拉列表来源数据
                    // 设置数据有效性加载在哪个单元格上,参数分别是：从sheet3获取A1到A10000作为一个下拉的数据、起始行、终止行、起始列、终止列
                    sheet1.addValidationData(ExcelUtil.setDataValidation2007(sheet1, strFormula, 4, 10000, rownum, rownum, "请下拉选择班次", "请选择排班信息中的班次，不可随意输入。")); // 下拉列表元素很多的情况
                    /*** 2、生成sheet2内容 ***/
                    for (int j = 0; j < dlData.length; j++) {
                        if (index == 0) { // 第1个下拉选项，直接创建行、列
                            row = sheet2.createRow(j); // 创建数据行
                            sheet2.setColumnWidth(j, 5000); // 设置每列的列宽
                            row.createCell(0).setCellValue(dlData[j]); // 设置对应单元格的值
                        } else { // 非第1个下拉选项
                            int rowCount = sheet2.getLastRowNum();
                            if (j <= rowCount) { // 前面创建过的行，直接获取行，创建列
                                // 获取行，创建列
                                sheet2.getRow(j).createCell(index).setCellValue(dlData[j]); // 设置对应单元格的值
                            } else { // 未创建过的行，直接创建行、创建列
                                sheet2.setColumnWidth(j, 5000); // 设置每列的列宽
                                // 创建行、创建列
                                sheet2.createRow(j).createCell(index).setCellValue(dlData[j]); // 设置对应单元格的值
                            }
                        }
                    }
                }
                index++;
            }
            /**** 读入已经存在的数据 ***/
            //从第四行开始读入数据
            int rowIndex = 4;
            for (Map<String, String> map : failList) {
                row = sheet1.createRow(rowIndex);
                row.createCell(0).setCellValue(map.get("perId"));
                row.createCell(1).setCellValue(map.get("departName"));
                row.createCell(2).setCellValue(map.get("idCardNo"));
                row.createCell(3).setCellValue(map.get("mobilePhone"));
                row.createCell(4).setCellValue(map.get("name"));
                row.createCell(36).setCellValue(map.get("errorMsg"));//固定使用第37列存放错误信息

                //从第6列开始批量填充数据

                for (int i = 5; i < dateList.size() + 5; i++) {
                    XSSFCell cell = row.createCell(i);
                    String value = map.get("date" + (i - 4));
                    if (value != null && !value.isEmpty()) {
                        value = shiftAliasAlphaMap.get(value) == null ? value : shiftAliasAlphaMap.get(value).toString();
                    }
                    cell.setCellValue(value);
                    cell.setCellStyle(titleStyleUnLocked);

                    /*** 下面这段代码逻辑是定位某个人哪一天出现导入失败定位醒目提醒 ***/
                    if(checkFailDetailList != null && checkFailDetailList.size()>0){
                        for(TempTaskSchedulCheck tempTaskSchedulCheck:checkFailDetailList){
                             if(Objects.equals(map.get("perId"),tempTaskSchedulCheck.getPerId().toString())){
                                 // 如果日期位是个位数
                                 String dates = "";
                                 if ((i-4)<10) {
                                     dates = paramDTO.getMonth() + "-"+"0"+ (i-4);
                                 }else{
                                     dates = paramDTO.getMonth() + "-"+(i-4);
                                 }
                                 /*** 如果日期匹配的上，则标红 ***/
                                 if(Objects.equals(dates,DateUtils.formatDate(tempTaskSchedulCheck.getDates()))){
                                     cell.setCellStyle(errorStyle);
                                     break;
                                 }
                             }
                        }
                    }
                }
                rowIndex++;
            }
            //隐藏excel的第一列,用0表示
            sheet1.setColumnHidden(0, true);
            sheet1.protectSheet(RandomUtil.randomNumbers(6));//密码设置为6位数随机数
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            String platform = cacheService.getSystemConfig("PLATFORM_SIGN");
            String aliUrl = BcxinFileUtils.huaweiOBSFileUpload(file, platform, "xlsx");
            file.delete();
            return aliUrl;
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException(Result.ERROR, "导出Excel组织架构模板失败");
        } finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                } catch (IOException e1) {
                }
            }
        }
    }

    /**
     * @Description: 任务排班的校验逻辑
     * @Author: llc
     * @Date: 2019-10-15
     * @return:
     */
    public Map<String, String> saveImportTaskSchedulInfo(List<Map<String, String>> taskSchedulList, ParamDTO paramDTO)
            throws BusinessException {
        Long importBatchId = idWorker.nextId();
        /***** 批量插入导入人员临时表 ****/

        /**** 数据量太大导致java内存溢出 ,这里分批插入 ****/
        int insertLength = taskSchedulList.size();
        int i = 0;
        while (insertLength > 1000) {
            comAttendTaskImportMapper.insertTempBatchTaskSchedulImport(taskSchedulList.subList(i, i + 1000), importBatchId);
            i = i + 1000;
            insertLength = insertLength - 1000;
        }
        if (insertLength > 0) {
            comAttendTaskImportMapper.insertTempBatchTaskSchedulImport(taskSchedulList.subList(i, i + insertLength), importBatchId);
        }

        /***** 导入逻辑 ***/

        /*** 2.批量任务排班导入-校验导入的人员ID是否有效 ***/
        comAttendTaskImportMapper.checkPerId(importBatchId, paramDTO.getComTaskId());//校验导入的人员ID是否有效
        /*** 3.批量任务排班导入-校验导入的人员ID是否存在重复 ***/
        comAttendTaskImportMapper.checkPerIdNoRepeat(importBatchId);

        /*** 3.1 获取（人员有效性）校验成功的日期排班 ***/
        List<Map<String, Object>> list = comAttendTaskImportMapper.getPerDateSchedulList(importBatchId);

        ComTask comtask = comTaskMapper.getComTaskByPrimaryKey(paramDTO.getComTaskId());

        String today = DateUtils.formatDate(new Date());

        List<TempTaskSchedulCheck> taskSchedulCheckList = new ArrayList<>(); // 任务排班校验表

        for (Map<String, Object> map : list) {
            String perId = map.get("perId").toString(); // 人员ID

            Iterator iterator = map.entrySet().iterator();
            Map.Entry entry;
            String name = "";
            while (iterator.hasNext()) {
                entry = (Map.Entry) iterator.next();
                name = (String) entry.getKey();
                Object valueObj = entry.getValue();
                /*** 如果列是以date开头 ***/
                if (name.startsWith("date")) {
                    String dd = name.replaceAll("date", "");
                    /*** 拼接日期 如果日期为一位数，则前面拼接个0 ***/
                    if (dd.length() == 1) {
                        dd = "0" + dd;
                    }
                    String dateStr = paramDTO.getMonth() + "-" + dd;
                    // TODO: 2019/9/30 0030  校验日期合法性,不合法则直接continue

                    /*** 日期大于当前日期且日期小于结束日期（因为任务开始日期始终早于或者等于当前日期） ***/
                    if (!DateUtils.dateCompare(dateStr, today) && DateUtils.dateCompare(dateStr, DateUtils.formatDate(comtask.getEndDate())) ) {
                        TempTaskSchedulCheck tempTaskSchedulCheck = new TempTaskSchedulCheck();
                        tempTaskSchedulCheck.setTaskSchedulId(idWorker.nextId());
                        tempTaskSchedulCheck.setPerId(Long.parseLong(perId));
                        tempTaskSchedulCheck.setDates(DateUtils.parseDate(dateStr));
                        tempTaskSchedulCheck.setShiftId(valueObj != null ? Long.parseLong(valueObj.toString()) : null);
                        taskSchedulCheckList.add(tempTaskSchedulCheck);
                    }
                }
            }
        }

        /*** 4.插入任务排班校验表 ***/
        if (taskSchedulCheckList != null && taskSchedulCheckList.size() > 0) {
            comAttendTaskImportMapper.insertTempTaskSchedulCheck(importBatchId, taskSchedulCheckList);
        }

        /*** 5.校验此人员排班是否和其他任务存在冲突 ***/

        comAttendTaskImportMapper.checkPerSchedulConflict(importBatchId, paramDTO.getComId(), paramDTO.getComTaskId());

        /*** 6.清除旧的排班记录  ***/

        comAttendTaskImportMapper.deleteOldTaskSchedul(importBatchId, paramDTO.getComId(), paramDTO.getComTaskId());

        /*** 7.清除旧的任务执行情况  ***/

        comAttendTaskImportMapper.deleteOldTaskImplement(importBatchId, paramDTO.getComId(), paramDTO.getComTaskId());

        /*** 8.插入新的排班记录  ***/

        comAttendTaskImportMapper.insertNewTaskSchedul(importBatchId, paramDTO.getComId(), paramDTO.getComTaskId(), paramDTO.getCreateBy());

        /*** 9.插入新的任务执行情况  ***/

        List<ComTaskImplement> newTaskImplementList = comAttendTaskImportMapper.getNewTaskImplementList(importBatchId, paramDTO.getComId());

        /*** 存在有效的排班数据则插入任务执行情况 ***/
        if (newTaskImplementList != null && newTaskImplementList.size() > 0) {
            for (ComTaskImplement comTaskImplement : newTaskImplementList) {
                comTaskImplement.setTaskImplementId(idWorker.nextId());
                comTaskImplement.setComId(paramDTO.getComId());
                comTaskImplement.setComTaskId(paramDTO.getComTaskId());
                comTaskImplement.setCreateBy(paramDTO.getCreateBy());
            }
            /*** 10.批量任务排班导入-插入新的任务执行情况 ***/
            comAttendTaskImportMapper.insertNewTaskImplement(paramDTO.getCreateBy(), newTaskImplementList);
        }

        /*** 11.批量任务排班导入-获取排班校验表失败记录  ***/
        List<TempTaskSchedulCheck> checkFailList = comAttendTaskImportMapper.getTempTaskSchedulCheckFailList(importBatchId);

        /*** 把失败记录多行转成每人一行
         * 例如张三 存在两条失败记录，合并成一条 ***/
        if (checkFailList != null && checkFailList.size() > 0) {
            Multimap<String, String> multimap = ArrayListMultimap.create();
            for (TempTaskSchedulCheck tempTaskSchedulCheck : checkFailList) {
                multimap.put(tempTaskSchedulCheck.getPerId().toString(), tempTaskSchedulCheck.getErrorMsg());
            }
            List<Map<String, Object>> perCheckFailList = new ArrayList<>();
            for (String perId : multimap.keySet()) {
                String errorMsg = "";
                Collection<String> errorMsgList = multimap.get(perId);
                Iterator<String> it = errorMsgList.iterator();
                while (it.hasNext()) {
                    errorMsg += it.next() + "||";
                }
                Map<String, Object> map = new HashMap<>();
                map.put("perId", Long.parseLong(perId));
                map.put("errorMsg", errorMsg.substring(0, errorMsg.length() - 2)); // 去除最后两个||
                perCheckFailList.add(map);
            }
            if (perCheckFailList.size() > 0) {
                /*** 12.批量任务排班导入- 更新排班导入临时表 ***/
                comAttendTaskImportMapper.updateTempBatchTaskImport(importBatchId, perCheckFailList);
            }
        }

        /***** 13.批量任务排班导入- 查询本次校验失败的导入人员信息 ****/
        List<Map<String, String>> tempImportTaskSchedulList = comAttendTaskImportMapper.getTempImportTaskSchedulList(importBatchId);

        /***** 14.批量任务排班导入- 删除导入校验数据 ****/
        comAttendTaskImportMapper.deleteTempTaskSchedulCheck(importBatchId);

        /***** 15.批量任务排班导入- 删除临时表的导入数据 ****/
        comAttendTaskImportMapper.deleteTempBatchTaskSchedulImport(importBatchId);

        /*** 返回数据 ***/
        Map<String,String> map = new HashMap<>();
        map.put("tempImportTaskSchedulList",JSON.toJSONString(tempImportTaskSchedulList));
        if (checkFailList != null && checkFailList.size() > 0) {
            map.put("checkFailList",JSON.toJSONString(checkFailList));
        }else{
            map.put("checkFailList","");
        }
        return map;
    }
}