package com.bcxin.oa.old.service.system;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.DOM;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.dto.ComSocialInsSchemeDTO;
import com.bcxin.oa.old.dto.MedicalSocialRecDTO;
import com.bcxin.oa.old.dto.PaymentSettingDTO;
import com.bcxin.oa.old.dto.PaymentSettingListDTO;
import com.bcxin.oa.old.entity.system.ComSocialInsScheme;
import com.bcxin.oa.old.entity.system.ComSocialInsSchemeDetail;
import com.bcxin.oa.old.entity.system.PerSocialInsPayDetail;
import com.bcxin.oa.old.entity.system.PerSocialInsSchemeRela;
import com.bcxin.oa.old.mapper.*;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 陈堂君
 * <p>
 * 类描述: 医社保
 * <p>
 * 
 * @apiNote 作者 陈堂君
 * @since 创建于 2017/12/22 10:51
 */
@Service
@Transactional
public class MedicalSocialRecServiceImpl implements MedicalSocialRecService {

	@Resource
	private ComSocialInsSchemeMapper comSocialInsSchemeMapper;

	@Resource
	private ComSocialInsSchemeDetailMapper comSocialInsSchemeDetailMapper;

	@Resource
	private PerSocialInsPayDetailMapper perSocialInsPayDetailMapper;

	@Resource
	private PerSocialInsSchemeRelaMapper perSocialInsSchemeRelaMapper;

	@Resource
	private MedicalSocialRecMapper medicalSocialRecMapper;
	@Resource
	private IdWorker idWorker;

	private String toDoubleStr(int i) {
		if (i == 1) {
			return "01";
		} else if (i == 2) {
			return "02";
		} else if (i == 3) {
			return "03";
		} else if (i == 4) {
			return "03";
		} else if (i == 5) {
			return "03";
		} else if (i == 6) {
			return "03";
		} else if (i == 7) {
			return "03";
		} else if (i == 8) {
			return "03";
		} else if (i == 9) {
			return "03";
		} else {
			return i + "";
		}
	}

	@Override
	public Result taskGenerateHisRec(Map p) throws BusinessException {
		MedicalSocialRecDTO dto = new MedicalSocialRecDTO();
		if (p.get("payPeriod") != null) {
			dto.setPayPeriod(String.valueOf(p.get("payPeriod")));
		}
		if (p.get("comId") != null) {
			dto.setComId(Long.valueOf(String.valueOf(p.get("comId"))));
		}
		if (dto.getPayPeriod() == null) { // 保证月份一定要有值，如果为空，使用日期默认值
			Date date = DateUtil.date();
			dto.setPayPeriod(DateUtil.format(date, "yyyy-MM"));
		}
		// 企业ID可以为空，为空时全局计算
		List<PerSocialInsPayDetail> list = medicalSocialRecMapper.getHisPerRecByComId(dto.getComId(),
				dto.getPayPeriod());
		// 过滤企业id为空的记录
		List<PerSocialInsPayDetail> nlist = Lists.newArrayList();
		for (PerSocialInsPayDetail rec : list) { // 生成数据后，给标记下时间和表主键
			rec.setPayPeriod(dto.getPayPeriod());
			rec.setInsPayDetailId(idWorker.nextId());
			rec.setCreateTime(new Date());
			if(rec.getComId() !=null){
				nlist.add(rec);
			}
		}
		// 查询企业或者全部企业是否存在
		List<Map> l = medicalSocialRecMapper.getRecByPeriod(dto.getComId(), dto.getPayPeriod());
		if (l.size() != 0) {
			throw new BusinessException(Result.ERROR, "该月份已经有数据" + dto.getPayPeriod());
		}
		if (nlist.size() != 0) {
			int size = perSocialInsPayDetailMapper.batchInsert(nlist);
			return Result.success("成功生成数据" + size);
		} else {
			throw new BusinessException(Result.ERROR, "没有需要数据生成");
		}

	}

	/**
	 * 提示用户设置方案
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/27 22:31
	 */
	@Override
	public Result promptUserToSetScheme(MedicalSocialRecDTO dto) {
		// 查询这个企业下的所有方案
		List<ComSocialInsScheme> listAll = comSocialInsSchemeMapper.selectByComId(dto.getComId(), "false");
		// 如果没有方案，那么提示：未设置缴交比例无法生成每月医社保缴交明细，请进入医社保缴交比例管理！ setStatus=0
		if (listAll.size() == 0) {
			return Result.success("未设置缴交比例无法生成每月五险一金缴交明细，请进入五险一金缴交比例管理！", 0);
		}
		// 查询这个企业下的所有过期的方案
		List<ComSocialInsScheme> listExpired = comSocialInsSchemeMapper.selectByComId(dto.getComId(), "true");
		// 如果发现过期的方案，那么提示：当月有X条缴交方案已过期，为避免医社保信息遗漏，请及时更新方案！ setStatus=1
		if (listExpired.size() > 0) {
			return Result.success("当月有" + listExpired.size() + "条缴交方案已过期，为避免五险一金信息遗漏，请及时更新方案！", 1);
		}
		return Result.success("不需要提示", 2);
	}

	/**
	 * 获得医社保缴费记录查询
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 10:31
	 */
	@Override
	public Result getHisRecListPage(MedicalSocialRecDTO dto) throws BusinessException {
		if (dto.getComId() == null) {
			throw new BusinessException(Result.ERROR, "参数comId不能为空");
		}
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		dto.setIsExport(0);
		List<Map<String, Object>> list = medicalSocialRecMapper.getHisRecListPage(DOM.dtm(dto));
		return Result.success("", new PageInfoUtils(list));
	}

	/**
	 * 获得医社保缴费记录查询
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 10:31
	 */
	@Override
	public List<Map<String, Object>> getHisRecListPageExport(MedicalSocialRecDTO dto) {
		List<Map<String, Object>> list = medicalSocialRecMapper.getHisRecListPage(DOM.dtm(dto));
		return list;
	}

	/**
	 * 医社保历史缴费记录 缴费记录统计按月
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 10:31
	 */
	@Override
	public Result statHisRecList(MedicalSocialRecDTO dto) throws BusinessException {
		if (dto.getComId() == null) {
			throw new BusinessException(Result.ERROR, "参数comId不能为空");
		}
		if (dto.getPayPeriod() == null) {
			throw new BusinessException(Result.ERROR, "参数payPeriod不能为空");
		}
		Map m = medicalSocialRecMapper.statHisRecList(dto.getComId(), dto.getPayPeriod());
		return Result.success("", m);
	}

	/**
	 * 查询缴费设置分页
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 10:48
	 */
	@Override
	public Result getPaymentSettingPage(PaymentSettingListDTO dto) throws BusinessException {
		if (dto.getComId() == null) {
			throw new BusinessException(Result.ERROR, "参数comId不能为空");
		}
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map> list = medicalSocialRecMapper.getPaymentSettingPage(DOM.dtm(dto));
		return Result.success("", new PageInfoUtils(list));
	}

	/**
	 * 删除缴费设置
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 10:50
	 */
	@Override
	public Result delPaymentSetting(PaymentSettingListDTO dto) throws BusinessException {
		// 数据保护，如果有一个人绑定，都不可以删除
		Map<String, Long> m = medicalSocialRecMapper.statPerCntBySchemeId(dto.getPaySchemeIds());
		if (m.get("cnt") != 0L) {
			throw new BusinessException(Result.ERROR, "有方案还有绑定人员，请检查");
		}

		if (comSocialInsSchemeMapper.deleteByIds(dto.getPaySchemeIds()) == 0) {
			throw new BusinessException(Result.ERROR, "无数据更新");
		}
		return Result.success("删除方案成功");
	}

	/**
	 * 添加人员，插入关系数据
	 *
	 * @param dto
	 *            paySchemeId 5x1j缴费方案ID perIds 人员列表逗号分隔的字符串
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 11:05
	 */
	@Override
	public Result addPerson(PaymentSettingDTO dto) {
		if (dto.getPerIds() == null) {
			return Result.success("无人员选择，跳过保存");
		}
		if (dto.getPerIds().length == 0) {
			return Result.success("无人员选择，跳过保存");
		}
		List<PerSocialInsSchemeRela> list = new ArrayList();
		StringBuffer sb = new StringBuffer("");
		for (String perId : dto.getPerIds()) {
			PerSocialInsSchemeRela rec = new PerSocialInsSchemeRela();
			rec.setCreateBy(dto.getCreateBy());
			rec.setCreateTime(new Date());
			rec.setPaySchemeId(dto.getPaySchemeId());
			rec.setPerId(Long.valueOf(perId));
			// 根据perId查出人员和方案的关系表，如果不存在就直接插入，如果存在，那么比较方案ID，
			Map<String, Object> checkMap = perSocialInsSchemeRelaMapper.selectByPerId(rec.getPerId());
			if (checkMap != null) { // 一个人只能有一个方案，所以不为空就报错
				sb.append(checkMap.get("name") + " 已经存在方案 " + checkMap.get("schemeName") + " 中;");
				continue;
			}
			list.add(rec);
		}
		if (!sb.toString().equals("")) {
			return Result.fail(sb.toString());
		} else {
			int size = medicalSocialRecMapper.batchInsert(list);
		}
		return Result.success("添加人员成功");
	}

	/**
	 * 移除人员，删除关系数据
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 11:06
	 */
	@Override
	public Result delPerson(PaymentSettingDTO dto) {
		int size = perSocialInsSchemeRelaMapper.deleteByIds(dto.getPaySchemeId(), dto.getPerIds());
		if (size == 0) {
			return Result.fail("");
		}
		return Result.success("");
	}

	/**
	 * 人员选择列表分页，根据企业ID和缴交方案ID查询出本公司的所有人员
	 *
	 * @param dto
	 *            paySchemeId方案ID comId企业ID
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 11:06
	 */
	@Override
	public Result multiselPersonPage(ComSocialInsSchemeDTO dto) throws BusinessException {
		if (dto.getComId() == null) {
			throw new BusinessException(Result.ERROR, "参数comId不能为空");
		}
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map> list = medicalSocialRecMapper.multiselPersonPage(dto.getComId(), dto.getPaySchemeId());
		return Result.success("", new PageInfoUtils(list));
	}

	/**
	 * 缴交方案新增保存，一对多5险
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 11:06
	 */
	@Override
	public Result savePaymentSetting(ComSocialInsSchemeDTO dto) throws BusinessException {
		// (1)保存方案表
		// Object savePoint =
		// TransactionAspectSupport.currentTransactionStatus().createSavepoint();
		// //事务超时
		int cnt = 0;
		if (dto.getPaySchemeId() == null) {
			dto.setPaySchemeId(idWorker.nextId());
			cnt = comSocialInsSchemeMapper.insert(dto);// 保存方案
		} else {
			cnt = comSocialInsSchemeMapper.update(dto);// 修改方案
		}
		if (cnt == 0) {
			throw new BusinessException(Result.ERROR, "保存方案失败");
		}

		// (2)保存方案明细表，5险，5条记录
		List<ComSocialInsSchemeDetail> list = JSON.parseArray(dto.getSchemeDetails(), ComSocialInsSchemeDetail.class);

		// 插入或者修改，1v5 所有必填，不需要考虑少的情况
		StringBuffer checkMsg = new StringBuffer("保存方案明细失败");
		int cntDetail = 0;
		for (ComSocialInsSchemeDetail rec : list) {
			BigDecimal OneHander = new BigDecimal(100);
			rec.setComPayProp(NumberUtil.div(rec.getComPayProp(), 100, 4));
			rec.setPerPayProp(NumberUtil.div(rec.getPerPayProp(), 100, 4));
			rec.setPaySchemeId(dto.getPaySchemeId());
			rec.setComId(dto.getComId());
			if (rec.getPerPayProp().compareTo(BigDecimal.ONE) == 1
					|| rec.getComPayProp().compareTo(BigDecimal.ONE) == 1) {
				checkMsg.append("个人比例或公司比例不能超过100%！");
				break;
			}
			// 除重复，通过社保险种和方案ID
			Map cmap = medicalSocialRecMapper.checkRepeatSchemeDetail(rec.getSocialInsType(), dto.getPaySchemeId());
			if ("0".equals(String.valueOf(cmap.get("cnt")))) { // 已经存在该记录 修改
				rec.setPaySchemeDetailId(idWorker.nextId()); // TODO 表的主键生成机制
				rec.setCreateBy(dto.getCreateBy());
				rec.setCreateTime(dto.getCreateTime());
				cntDetail += comSocialInsSchemeDetailMapper.insert(rec);
			} else { // 不存在 插入
				rec.setUpdateBy(dto.getUpdateBy());
				rec.setUpdateTime(dto.getUpdateTime());
				cntDetail += comSocialInsSchemeDetailMapper.updateByIds(rec);
			}
		}
		if (cntDetail != list.size() || !checkMsg.toString().equals("保存方案明细失败")) {
			throw new BusinessException("YSB-ERR-500", checkMsg.toString());
		}
		return Result.success("", String.valueOf(dto.getPaySchemeId()));
	}

	/**
	 * 缴交方案详情查询，通过缴交方案ID
	 *
	 * @param dto
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 11:06
	 */
	@Override
	public Result getPaymentSettingById(ComSocialInsSchemeDTO dto) {
		// (1)获取缴费方案
		ComSocialInsScheme rec = comSocialInsSchemeMapper.selectById(dto.getPaySchemeId());

		// (2)获取缴费方案安明细
		List<ComSocialInsSchemeDetail> recDetails = medicalSocialRecMapper.selectSocialInsDetail(dto.getPaySchemeId());
		Map returnMap = Maps.newHashMap();
		returnMap.put("Scheme", rec);
		returnMap.put("SchemeDetail", recDetails);
		return Result.success("", returnMap);
	}

	/**
	 * 某个缴交方案的已选人员列表分页,通过缴交方案ID
	 *
	 * @param dto
	 *            方案ID
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2017/12/22 11:07
	 */
	@Override
	public Result getSelectedPersonPage(ComSocialInsSchemeDTO dto) {
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<Map> list = medicalSocialRecMapper.getSelectedPersonPage(dto.getPaySchemeId());
		return Result.success("", new PageInfoUtils(list));
	}

}
