package com.bcxin.oa.old.service.salary.web;

import com.bcxin.oa.old.entity.salary.PerSalaryGrant;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.salary.PerSalaryParamDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 人员薪资发放
 *
 * @author llc
 * @date 2019-01-01
 */
public interface PerSalaryGrantService {

    /**
     * 核算薪资
     * @param perSalaryGrant
     * @return
     * @author llc
     * @date 2019-01-02
     */
    Result calSalary(PerSalaryGrant perSalaryGrant) throws BusinessException;


    /**
     * 人员月度工资列表
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-02
     */
    Result getPerSalaryList(PerSalaryParamDTO dto) throws BusinessException;


    /**
     * 校验是否核算
     * @param paramDTO
     * @return
     * @throws BusinessException
     */
    Result checkIsAccount(PerSalaryParamDTO paramDTO)  throws BusinessException;


    /**
     * 个人工资单查询
     * @return
     * @author llc
     * @date 2019-01-01
     */
    Result getPerSalaryDetail(ParamDTO paramDTO) throws BusinessException;


    /**
     * 删除工资条
     * @return
     * @author lp
     * @date 2019-01-01
     */
    Result deleteSalaryGrant(ParamDTO paramDTO) throws BusinessException;


    /**
     * 个人工资条修改
     * @return
     * @author lp
     * @date 2019-01-01
     */
    Result updateSalaryDetail(Map<String,String> paramMap) throws BusinessException;

    /**
     * 批量核算工资条
     * @param paramDTO
     * @return
     * @throws BusinessException
     */
    Result batchAccountSalary(ParamDTO paramDTO)  throws BusinessException;


    /**
     * 人员月度工资导出
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-17
     */
    Result exportPerMonthSalary(PerSalaryParamDTO dto, HttpServletResponse response);

    Result exportSalaryTemplate();
    /**
     * 薪酬明细导入
     * @param file
     * @param paramDTO
     * @return
     */
    Result importSalaryReportInfo(MultipartFile file, ParamDTO paramDTO);

}