package com.bcxin.oa.old.service.salary.web;

import com.bcxin.oa.old.entity.salary.ComSalaryTemp;
import com.bcxin.oa.old.dto.salary.ComSalaryTempDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

import java.util.Map;

/**
 * 企业薪酬模板
 *
 * @author llc
 * @date 2018-12-28
 */
public interface ComSalaryTempService {

    /**
     * 获取薪酬项目配置
     * @author llc
     * @date 2018-12-28
     * @return
     */
    Result getConfigSalaryType() throws BusinessException;


    /**
     * 校验模板人员是否存在其他模板
     *
     * @param comSalaryTemp
     * @param perList
     * @return
     * @author llc
     * @date 2019-01-03
     */
    Result checkSalaryTempPer(ComSalaryTemp comSalaryTemp ,String perList) throws BusinessException;

    /**
     * 保存企业薪酬模板接口
     * @author llc
     * @date 2018-12-28
     * @return
     */
    Result saveComSalaryTemp(ComSalaryTemp comSalaryTemp,Map<String,String> requestMap) throws BusinessException;


    /**
     * 企业薪酬模板列表分页查询
     * @author llc
     * @date 2018-12-29
     * @param dto
     * @return
     */
    Result pageComSalaryTemp(ComSalaryTempDTO dto) throws BusinessException;


    /**
     * 查询企业薪酬模板详情
     * @author llc
     * @date 2018-12-29
     * @param comSalaryTemp
     * @return
     */
    Result getComSalaryTempInfo(ComSalaryTemp comSalaryTemp) throws BusinessException;


    /**
     * 删除企业薪酬模板
     * @author llc
     * @date 2018-12-29
     * @param comSalaryTemp
     * @return
     */
    Result delComSalaryTemp(ComSalaryTemp comSalaryTemp) throws BusinessException;


    /**
     * 复制企业薪酬模板
     * @author llc
     * @date 2018-12-29
     * @param comSalaryTemp
     * @return
     */
    Result copyComSalaryTemp(ComSalaryTemp comSalaryTemp) throws BusinessException;


}