package com.bcxin.oa.old.service.salary.app;

import cn.hutool.core.date.DateUtil;
import com.bcxin.oa.old.mapper.attend.CountPerAttendDateMapper;
import com.bcxin.oa.old.mapper.salary.PerSalaryGrantDetailMapper;
import com.bcxin.oa.old.mapper.salary.PerSalaryGrantMapper;
import com.bcxin.oa.old.mapper.task.CountPerTaskDateMapper;
import com.bcxin.oa.old.entity.salary.PerSalaryGrant;
import com.bcxin.oa.old.dto.ExportPerAttendMonthDTO;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.common.Result;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 企业薪酬模板
 *
 * @author lp
 * @date 2018-12-28
 */
@Service
@Transactional
public class HtmlPerSalaryGrantServiceImpl implements HtmlPerSalaryGrantService {

    private final static String PLUS_CHAR = "+";
    private final static String SUB_CHAR = "-";

    @Resource
    private PerSalaryGrantMapper perSalaryGrantMapper;

    @Resource
    private PerSalaryGrantDetailMapper perSalaryGrantDetailMapper;

    @Resource
    private CountPerAttendDateMapper countPerAttendDateMapper;

    @Resource
    private CountPerTaskDateMapper countPerTaskDateMapper;

    /**
     * 个人工资单列表
     *
     * @param paramDTO
     * @return
     * @author lp
     * @date 2019-01-03
     */
    @Override
    public Result perSalaryList(ParamDTO paramDTO) throws BusinessException {
        PageHelper.startPage(paramDTO.getPageNumber(), paramDTO.getPageSize());
        List<Map<String, Object>> list = perSalaryGrantMapper.pagePerSalaryList(paramDTO);
        PageInfoUtils pageInfo = new PageInfoUtils(list);
        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }

    /**
     * 个人工资单详情
     *
     * @param paramDTO
     * @return
     * @author lp
     * @date 2019-01-03
     */
    @Override
    public Result perSalaryDetail(ParamDTO paramDTO) throws BusinessException {
        if ( paramDTO.getId() == null ) {
            throw new BusinessException(Result.ERROR, "薪资id不能为空");
        }
        Map<String,Object> resultMap = Maps.newHashMap();
        /* 获得个人工资条 */
        PerSalaryGrant salaryGrant = perSalaryGrantMapper.getByPrimaryKey(Long.parseLong(paramDTO.getId()));
        /* 获得个人工资条动态的明细 */
        List<Map> detailMap = perSalaryGrantDetailMapper.getAllBySalaryId(salaryGrant.getPerSalaryGrantId());
        /* 获得收入项 */
        List<Map> incomeMap = Lists.newLinkedList();
        /* 获得扣款项 */
        List<Map> outMap = Lists.newLinkedList();
        for (Map map:detailMap) {
            if (PLUS_CHAR.equals(map.get("calRule"))) {
                incomeMap.add(map);
            }
            else if (SUB_CHAR.equals(map.get("calRule"))) {
                outMap.add(map);
            }
        }
        /* 获得考勤明细 */
        paramDTO.setPerId(salaryGrant.getPerId());
        Date startDate = DateUtil.parseDate(salaryGrant.getGrantYears()+"-01");
        paramDTO.setStartDate(salaryGrant.getGrantYears()+"-01");
        paramDTO.setEndDate(DateUtil.formatDate(DateUtil.endOfMonth(startDate)));
        ExportPerAttendMonthDTO attendDetail = countPerAttendDateMapper.getPerAttendMonthCount(paramDTO);
        ExportPerAttendMonthDTO taskAttendDetail = countPerTaskDateMapper.getPerTaskAttendMonthCount(paramDTO);
        resultMap.put("salaryGrant",salaryGrant);
        resultMap.put("incomeMap",incomeMap);
        resultMap.put("outMap",outMap);
        resultMap.put("attendDetail",attendDetail);
        resultMap.put("taskAttendDetail",taskAttendDetail);
        return Result.success(Result.SUCCESS_QUERY_MSG,resultMap);
    }


    /**
     * 确认个人工资单
     *
     * @param paramDTO
     * @return
     * @author lp
     * @date 2019-01-03
     */
    @Override
    public Result perSalaryConfirm(ParamDTO paramDTO) throws BusinessException {
        if ( paramDTO.getId() == null ) {
            throw new BusinessException(Result.ERROR, "薪资id不能为空");
        }
        perSalaryGrantMapper.confirmPerSalary(Long.parseLong(paramDTO.getId()));
        return Result.success(Result.SUCCESS_QUERY_MSG);
    }
}