package com.bcxin.oa.old.scheduling;

import com.bcxin.oa.old.service.web.CountPerTaskDateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 定时器生成昨天的外勤统计数据
 * 
 * @author llc
 * @date 2019-01-24
 */
@Component
@Slf4j
public class CreateTaskCountReportHandler {

	@Resource
	private CountPerTaskDateService countPerTaskDateService;

	/**
	 * 定时生成外勤统计报表（每天凌晨1时执行）
	 */
	@Scheduled(cron = "0 0 1 * * ?")
	public void execute() {
		log.info("定时器生成昨天的外勤统计数据CreateTaskCountReportHandler启动！");
		countPerTaskDateService.createTaskCountReport();
		log.info("CreateTaskCountReportHandler执行结束");
	}
}
