package com.bcxin.oa.old.mapper.app;

import com.bcxin.oa.old.common.CrudDao;
import com.bcxin.oa.old.entity.task.PerTaskCardRecord;
import com.bcxin.oa.old.dto.app.AppPerTaskCardRecordDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 任务考勤打卡记录
 *
 * @author wangjianchi
 * @since 2018-03-08 11:29:13
 */
public interface PerTaskCardRecordMapper extends CrudDao<PerTaskCardRecord> {
	/**
	 * 获取打卡记录
	 *
	 * @param perTaskCardRecordDTO
	 * @return
	 */
	PerTaskCardRecord get(AppPerTaskCardRecordDTO perTaskCardRecordDTO);

	/**
	 * 获取上下班是否存在打卡记录
	 * 
	 * @param appPerTaskCardRecordDTO
	 * @return
	 */
	List<PerTaskCardRecord> getExitPerTaskCardRecord(AppPerTaskCardRecordDTO appPerTaskCardRecordDTO);


	/**
	 * 批量清除人员当天之后的打卡记录（因为有请假需要考虑）
	 *
	 * @param comTaskId
	 * @param date
	 * @param perIdList
	 * @author llc
	 * @date 2019-12-02
	 * @return
	 */
	Integer deletePerTaskCardRecordByDateAndPerIdList(@Param("comTaskId") Long comTaskId,@Param("date") String date,@Param("list") List<String> perIdList);

	/**
	 * 删除某日之后的任务打卡记录（因为有请假需要考虑）
	 *
	 * @param comTaskId
	 * @param comId
	 * @param date
	 * @author llc
	 * @date 2020-04-10
	 * @return
	 */
	Integer deleteTaskCardRecordByDate(@Param("comTaskId") Long comTaskId,@Param("comId") Long comId,@Param("date") String date);
}