package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.system.PerSocialInsSchemeRela;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>陈堂君
 * <p>类描述: 人员医社保缴费方案关联
 * <p>
 * @apiNote  作者 陈堂君
 * @since 创建于 2017/12/22 13:11
 */
@Component
public interface PerSocialInsSchemeRelaMapper {
    int insert(PerSocialInsSchemeRela record);
    int update(PerSocialInsSchemeRela record);

    /**
     * 根据人员ID，查询该人员已经关联的医社保缴费方案数量
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 11:08
     * @param perId
     * @return
     */
    Map<String,Object> selectByPerId(@Param("perId") Long perId);

    /**
     * 删除某个医社保缴费方案和人员的关系数据
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 11:07
     * @param paySchemeId
     * @param perIds
     * @return
     */
    int deleteByIds(@Param("paySchemeId") Long paySchemeId,@Param("perIds") String[] perIds);
}