package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskSchedul;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 任务排班制明细
 *
 * @author zhangye
 * @since 2018-02-26 10:04:47
 */
public interface ComTaskSchedulMapper extends CrudDao<ComTaskSchedul> {

    void deleteByPerTask(@Param("date") String cdate, @Param("perId") Long perId, @Param("comTaskId") Long comTaskId);

    void deleteByPerTaskAndFromDate(@Param("date") String cdate, @Param("perId") Long perId, @Param("comTaskId") Long comTaskId);

    void deleteByPerTaskInRange(@Param("beginDate") String beginDate,@Param("endDate") String endDate, @Param("perId") Long perId, @Param("comTaskId") Long comTaskId);

    int deleteByPerListTaskAndFromDate(@Param("date") String cdate, @Param("perIdList") List<String> perIdList, @Param("comTaskId") Long comTaskId);

    void insertBatch(List<ComTaskSchedul> list);

    List<ComTaskSchedul> getByTaskId(@Param("comTaskId") Long comTaskId);


    /**
     * 获取某人某天某任务的排班班次
     *
     * @param comTaskSchedul
     * @return
     * @author llc
     * @date 2019-02-21
     */
    Map<String,String> getPerDateTaskShift(ComTaskSchedul comTaskSchedul);

    /**
     * 删除李四2019-02-22不在A任务的排班记录(休息的不处理) 或者在A任务的排班记录
     *
     * @param acceptPerIds
     * @param comId
     * @param schedulDate
     * @param comTaskId
     * @return
     * @author llc
     * @date 2019-02-22
     */
    int deleteSchedulByBehalf(@Param("list") List<String> acceptPerIds,@Param("comId") Long comId,@Param("schedulDate") String schedulDate,@Param("comTaskId") Long comTaskId);


    /**
     * 更新张三2019-02-22在A任务的排班记录为休息
     * @param perId
     * @param createBy
     * @param schedulDate
     * @param comTaskId
     * @return
     * @author llc
     * @date 2019-02-22
     */
    int updateSchedulByBehalf(@Param("perId") Long perId,@Param("createBy") Long createBy,@Param("schedulDate") String schedulDate,@Param("comTaskId") Long comTaskId);


    /**
     * 获取同步百保盾的排班记录
     *
     * @param
     * @return
     * @author llc
     * @date 2020-03-24
     */
    List<ComTaskSchedul> getSyncTaskSchedulList(@Param("comTaskId") Long comTaskId,
                                                @Param("startDate") String startDate,
                                                @Param("endDate") String endDate,
                                                @Param("perIdList") List<String> perIdList);

    /**
     * 删除某日之后的任务排班记录
     *
     * @param comTaskId
     * @param comId
     * @param date
     * @return
     * @author llc
     * @date 2020-04-10
     */
    int deleteTaskSchedulFromDate(@Param("comTaskId") Long comTaskId ,@Param("comId") Long comId ,@Param("date") String date);

    /**
     * 获取冲突排班列表
     *
     * @param comTaskId
     * @param comId
     * @param date
     * @param perIdList
     * @return
     * @author llc
     * @date 2020-04-15
     */
    List<Map<String,String>> getConflictSchedulList(@Param("comTaskId") Long comTaskId ,@Param("comId") Long comId ,@Param("date") String date,@Param("perIdList") List<String> perIdList);


    /**
     * 删除当日的排班记录
     *
     * @param comTaskId
     * @param comId
     * @param date
     * @param perIdList
     * @return
     * @author llc
     * @date 2020-04-15
     */
    int deleteByPerListAndDate(@Param("date") String date, @Param("perIdList") List<String> perIdList, @Param("comTaskId") Long comTaskId, @Param("comId") Long comId);
}