package com.bcxin.oa.old.mapper;


import com.bcxin.oa.old.entity.task.ComShift;
import com.bcxin.oa.old.dto.ComShiftDto;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业班次
 *
 * @author zhangye
 * @since 2018-02-26 13:42:27
 */
public interface ComShiftMapper extends CrudDao<ComShift> {
    /**
     * @Author: zhongjianhui
     * @Description:查询所有班次
     * @Date: 2017/12/29  11:18
     */
    List<Map<String,String>> pageForShift(ComShiftDto comShiftDto);


    /**
     * @Author: zhongjianhui
     * @Description:替换所有未开始的任务的班次
     * @Date: 2017/12/29  11:18
     */
   int updateShift(@Param("oldShiftId")Long oldShiftId,@Param("shiftId")Long shiftId,@Param("comId")Long comId);
    /**
     * @Author: zhongjianhui
     * @Description:查询是否有 任务在使用
     * @Date: 2017/12/29  11:18
     */
    List<String> countForShift(ComShiftDto comShiftDto);

    /**
     * @Author: zhongjianhui
     * @Description:查询除自己外是否有重复名称的
     * @Date: 2017/12/29  11:18
     */
    int  findShiftNameRepetition(ComShiftDto comShiftDto);

    /**
     * @Author: llc
     * @Description: 查询使用此班次的考勤组集合
     * @Date: 2018/4/9 11:18
     */
    List<String>  getAttendGroupListByShiftId(@Param("shiftId") Long shiftId ,@Param("comId") Long comId);

}