package com.bcxin.oa.old.entity.task.tempTask;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 临保任务排班制明细
 * 
 * @author llc
 * @date 2020-02-21
 */
@Data
@TableName("com_task_schedul")
public class ComTempTaskSchedul extends BaseEntity<ComTempTaskSchedul> {

	/** 临保任务排班制ID */
	@ApiModelProperty(value = "临保任务排班制ID")
	private Long tempTaskSchedulId;

	/** 排班日期 */
	@ApiModelProperty(value = "排班日期")
	private Date schedulDate;

	/** 是否休息 */
	@ApiModelProperty(value = "是否休息")
	private String isRest;

	/** 临保任务ID */
	@ApiModelProperty(value = "临保任务ID")
	private Long comTempTaskId;

	/** 排班人员ID */
	@ApiModelProperty(value = "排班人员ID")
	private Long perId;

	/** 班次ID */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getTempTaskSchedulId() {
		return tempTaskSchedulId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComTempTaskId() {
		return comTempTaskId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

}