package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 任务排班周期所选班次
 * 
 * @author zhangye
 * @since 2018-02-26 10:42:15
 */
@Data
@TableName("com_task_cycle_shift")
public class ComTaskCycleShift extends BaseEntity<ComTaskCycleShift> {
	private static final long serialVersionUID = 240335138L;

	/** 企业ID */
	@ApiModelProperty(value = "企业ID")
	private Long comId;

	/** 第几天 */
	@ApiModelProperty(value = "第几天")
	private int whatDay;

	/** 是否休息 */
	@ApiModelProperty(value = "是否休息")
	private String isRest;

	/** 任务排班周期ID */
	@ApiModelProperty(value = "任务排班周期ID")
	private Long taskSchedulCycleId;

	/** 班次ID */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;


	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskSchedulCycleId() {
		return taskSchedulCycleId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

}