package com.bcxin.oa.old.entity.system;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 人员组织关系
 *
 * @author zhangye
 * @since 2017-12-22 16:35:48
 */
@TableName("per_org_relation")
@Data
public class PerOrgRelation extends BaseEntity<PerOrgRelation> {
    private static final long serialVersionUID = 1999969228L;

    /**
     * V5的ID
     */
    @ApiModelProperty(value = "V5的ID")
    private String tlkId;

    /**
     * 人员组织关系ID
     */
    @ApiModelProperty(value = "人员组织关系ID")
    private Long perOrgRelationId;

    /**
     * 职位
     */
    @ApiModelProperty(value = "职位")
    private String position;

    /**
     * 工号
     */
    @ApiModelProperty(value = "工号")
    private String jobNo;

    /**
     * 入职日期
     */
    @ApiModelProperty(value = "入职日期")
    private Date entryDate;

    /**
     * 离职日期
     */
    @ApiModelProperty(value = "离职日期")
    private Date leaveDate;

    /**
     * 离职原因
     */
    @ApiModelProperty(value = "离职原因")
    private String leaveReason;

    /**
     * 所在组织类型
     */
    @ApiModelProperty(value = "所在组织类型")
    private String orgType;

    /**
     * 所在组织ID
     */
    @ApiModelProperty(value = "所在组织ID")
    private Long orgId;

    /**
     * 人员ID
     */
    @ApiModelProperty(value = "人员ID")
    private Long perId;


    @JsonSerialize(using = ToStringSerializer.class)
    public Long getPerOrgRelationId() {
        return perOrgRelationId;
    }


    @JsonSerialize(using = ToStringSerializer.class)
    public Long getOrgId() {
        return orgId;
    }


    @JsonSerialize(using = ToStringSerializer.class)
    public Long getPerId() {
        return perId;
    }


}