package com.bcxin.oa.old.dto.app;

import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 *
 * APP任务轨迹
 *
 * @author zhangye
 * @since 2018-03-15 16:24:22
 */
@Data
public class AppComTaskImplementDto extends BaseEntity<AppComTaskImplementDto> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 49195933494526696L;
	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long taskId;
	/** 任务执行情况ID */
	@ApiModelProperty(value = "任务执行情况ID")
	private Long taskImplementId;

	/** 任务地址经度 */
	@ApiModelProperty(value = "任务地址经度")
	private String addressLongitude;

	/** 任务地址纬度 */
	@ApiModelProperty(value = "任务地址纬度")
	private String addressLatitude;
	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	private Long perId;
	/**
	 * 当前选择年月日
	 */
	@ApiModelProperty(value = "当前选择日期")
	private String selectDate;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskId() {
		return taskId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskImplementId() {
		return taskImplementId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}
}
