package com.bcxin.oa.old.dto.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 *
 * APP任务保存时转成对象
 * 外勤信息
 * @author 罗鹏
 */
@Data
public class AppComTaskContentDTO {

	/**
	 * 任务id
	 */
	private Long comTaskId;

	/**  外勤名称 */
	private String taskName;

	/** 发布什么类型 */
	private String taskType;

	/** 去哪里执勤 */
	private String address;

	/** 去哪里执勤所在省份 */
	private Integer province;

	/** 去哪里执勤所在城市 */
	private Integer city;

	/** 去哪里执勤所在区县 */
	private Integer area;

	/** 去哪里执勤地址经度 */
	private String addressLongitude;

	/** 去哪里执勤地址纬度 */
	private String addressLatitude;

	/** 去哪里执勤有效范围（单位:米） */
	private Long execRange;

	/**
	 * 签到地址
	 */
	private List<AppComTaskAttendAddressDTO> attendAddressList;

	/** 外勤开始日期 */
	private String startDate;

	/** 外勤截止日期 */
	private String endDate;

	/** 外勤内容 */
	private String taskDetail;

	/**
	 * 排班制的子排班方式
	 * 规律周期排班和不规律手动排班
	 */
	private String attendSubType;

	/**
	 * 班次集合
	 */
	private String shiftIds;

	/* -----------------适用于周期排班的信息---------------- */
	/**
	 * 周期集合
	 */
	private List<AppComTaskScheduleDTO> scheduleList;

	/* -----------------适用于手动排班的信息---------------- */
	/**
	 * 执勤人集合
	 */
	private String perIds;

	/**
	 * 负责人
	 */
	private Long inChargePerId;

	/**
	 * 记录执行轨迹（1代表开，0代表关）
	 */
	private String locusReportSwitch;

	/** 服务对象*/
	private String  serviceObject;

	/** 服务对象类型*/
	private String  serviceObjectType;

	/** 服务对象涉外情况*/
	private String  serviceObjectSySituation;

	/** 是否治安保卫重点单位*/
	private String  isSecurityImportantUnit;

	/** 驻勤点类型*/
	private String  taskStationType;

	/**
	 * 所属市公安机构id
	 */
	@ApiModelProperty(value = "所属市公安机构id")
	private Long cityOrgId;

	/**
	 * 所属县（区）机构id
	 */
	@ApiModelProperty(value = "所属县（区）机构id")
	private Long districtOrgId;

	/**
	 * 所属派出所id
	 */
	@ApiModelProperty(value = "所属派出所id")
	private Long policeStationId;

	/**
	 * 百保盾ID
	 */
	@ApiModelProperty(value = "百保盾ID")
	private Long bbdId;

}
