package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.entity.task.ComTask;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Arrays;

/**
 * 企业任务组固定班制明细DTO
 *
 * @author zhangye
 * @version 1.0
 */

@Data
public class ComTaskTempDTO extends ComTask {
    /**
     *
     */
    private static final long serialVersionUID = -7117217812684937974L;
    /**
     * 传递任务出勤地点列表
     */
    @ApiModelProperty(value = "任务出勤地点列表")
    private String comTaskAttendAdresses;
    /**
     * 传递任务组固定班制列表
     */
    @ApiModelProperty(value = "任务固定班制列表")
    private String comTaskFixeds;
    /**
     * 任务排班周期Json
     * <p>
     * "comTaskSchedulCycleJson":[{"cycleName":"周期名称AAA","cycleDays":"4","shiftIdArrayUse":[1,2,3,-1]},{"cycleName":"周期名称BBB","cycleDays":"4","shiftIdArrayUse":[1,2,3,-1]}]
     */
    @ApiModelProperty(value = "任务排班周期Json")
    private String comTaskSchedulCycleJson;
    @ApiModelProperty(value = "班次Id的Json")
    private String shiftIdJson;
    /**
     * 任务组ID
     */
    @ApiModelProperty(value = "任务ID")
    private Long comTaskId;

    private Long comId;
    /**
     * 冗余班次ID查询用
     */
    private String shiftIds;

    /**
     * 固定排班选择的人员
     */
    private String[] perIdArray;

    /**
     * 考勤类型(1：固定班制，2：排班制，3：自由工时)
     */
    @ApiModelProperty(value = "考勤类型")
    private String attendType;
    //所有都不可以编辑
    public  static String ALL_CAN_NOT_EDIT = "0";
    //所有都可编辑
    public static String ALL_CAN_EDIT = "1";
    //一些可以编辑
    public static String SOME_CAN_EDIT = "2";
    /**
     * 是否休息---》是
     */
    public static String ISREST = "1";
    /**
     * 是否休息---》否
     */
    public static String ISNOTREST = "0";

    public String getComTaskFixeds() {
        return comTaskFixeds;
    }

    public void setComTaskFixeds(String comTaskFixeds) {
        this.comTaskFixeds = comTaskFixeds;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComTaskId() {
        return comTaskId;
    }

    public void setComTaskId(Long comTaskId) {
        this.comTaskId = comTaskId;
    }

    public String getAttendType() {
        return attendType;
    }

    public void setAttendType(String attendType) {
        this.attendType = attendType;
    }


    public String getComTaskAttendAdresses() {
        return comTaskAttendAdresses;
    }

    public void setComTaskAttendAdresses(String comTaskAttendAdresses) {
        this.comTaskAttendAdresses = comTaskAttendAdresses;
    }

    public String getComTaskSchedulCycleJson() {
        return comTaskSchedulCycleJson;
    }

    public void setComTaskSchedulCycleJson(String comTaskSchedulCycleJson) {
        this.comTaskSchedulCycleJson = comTaskSchedulCycleJson;
    }

    public String getShiftIdJson() {
        return shiftIdJson;
    }

    public void setShiftIdJson(String shiftIdJson) {
        this.shiftIdJson = shiftIdJson;
    }

    @Override
    public String toString() {
        return "ComTaskTempDTO{" +
                "comTaskAttendAdresses='" + comTaskAttendAdresses + '\'' +
                ", comTaskFixeds='" + comTaskFixeds + '\'' +
                ", comTaskSchedulCycleJson='" + comTaskSchedulCycleJson + '\'' +
                ", shiftIdJson='" + shiftIdJson + '\'' +
                ", comTaskId=" + comTaskId +
                ", comId=" + comId +
                ", shifIds='" + shiftIds + '\'' +
                ", perIdArray=" + Arrays.toString(perIdArray) +
                ", attendType='" + attendType + '\'' +
                '}';
    }
}
