package com.bcxin.oa.old.controller.system;

import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.PaymentSettingListDTO;
import com.bcxin.oa.old.service.system.MedicalSocialRecService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.log4j.Log4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 企业基础信息表 前端控制器
 * </p>
 *
 * @author ctj
 * @since 2017-12-11
 */
@RestController
@RequestMapping("/enterprise/ins/payment-setting-list")
@Api(tags = { "" }, description = "医社保-缴费比例设置列表") // tag中文会影响路径
public class PaymentSettingListController extends BaseController {

	@Autowired
	private MedicalSocialRecService medicalSocialRecService;

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保-缴费设置列表", title = "查询人员缴交情况分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-payment-setting-list-page")
	@ApiOperation(value = "查询人员缴交情况分页")
	public Result getPaymentSettingListPage(PaymentSettingListDTO dto) throws BusinessException {
		return medicalSocialRecService.getPaymentSettingPage(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保-缴费设置列表", title = "删除缴交方案", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/del-payment-setting")
	@ApiOperation(value = "删除缴交方案")
	public Result delPaymentSetting(PaymentSettingListDTO dto) throws BusinessException {
		return medicalSocialRecService.delPaymentSetting(dto).setBack(getRequest());
	}

}
