# ************************************************************
# Sequel Ace SQL dump
# 版本号： 20046
#
# https://sequel-ace.com/
# https://github.com/Sequel-Ace/Sequel-Ace
#
# 主机: 127.0.0.1 (MySQL 5.7.39-log)
# 数据库: java_mer_dev
# 生成时间: 2023-07-18 06:37:54 +0000
# 
# 
# 
# CRMEB Java 多商户 v1.2 版本sql
# 平台管理 admin / 123456
# 商户 18292417675 / 000000
# 用户 自己注册 建议使用小程序
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
SET NAMES utf8mb4;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE='NO_AUTO_VALUE_ON_ZERO', SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# 转储表 eb_activity_product
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_activity_product`;

CREATE TABLE `eb_activity_product` (
  `aid` int(11) NOT NULL COMMENT '活动id',
  `pro_id` int(11) NOT NULL COMMENT '商品id',
  `pro_image` varchar(256) NOT NULL DEFAULT '' COMMENT '活动商品图片',
  `sort` int(5) NOT NULL DEFAULT '999' COMMENT '排序',
  PRIMARY KEY (`aid`,`pro_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='活动商品关联表';



# 转储表 eb_activity_style
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_activity_style`;

CREATE TABLE `eb_activity_style` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) NOT NULL COMMENT '活动名称',
  `type` bit(1) NOT NULL COMMENT '活动类型0=活动边框，1=活动背景',
  `starttime` datetime NOT NULL COMMENT '开始时间',
  `endtime` datetime NOT NULL COMMENT '结束时间',
  `style` varchar(255) NOT NULL COMMENT '活动边框素材地址',
  `status` bit(1) NOT NULL COMMENT '状态 0=关闭1=开启',
  `method` int(11) DEFAULT NULL COMMENT '商品参与类型 0=全部商品参与，1=指定商品参与，2=指定品牌参与，3=指定商品分类参与,4=指定商户产品',
  `products` varchar(500) DEFAULT NULL COMMENT '参与活动商品',
  `createtime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updatetime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4;


# 转储表 eb_ali_pay_callback
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_ali_pay_callback`;

CREATE TABLE `eb_ali_pay_callback` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `notify_type` varchar(64) DEFAULT NULL COMMENT '通知的类型',
  `notify_id` varchar(128) DEFAULT NULL COMMENT '通知校验 ID',
  `app_id` varchar(32) DEFAULT NULL COMMENT '支付宝分配给开发者的应用 ID',
  `charset` varchar(10) DEFAULT NULL COMMENT '编码格式，如 utf-8、gbk、gb2312 等',
  `version` varchar(3) DEFAULT NULL COMMENT '调用的接口版本，固定为：1.0',
  `sign_type` varchar(10) DEFAULT NULL COMMENT '商户生成签名字符串所使用的签名算法类型，目前支持 RSA2 和 RSA，推荐使用 RSA2',
  `sign` varchar(500) DEFAULT NULL COMMENT '签名',
  `trade_no` varchar(64) DEFAULT NULL COMMENT '支付宝交易凭证号',
  `out_trade_no` varchar(64) DEFAULT NULL COMMENT '原支付请求的商户订单号',
  `trade_status` varchar(32) DEFAULT NULL COMMENT '交易目前所处的状态:WAIT_BUYER_PAY-交易创建，等待买家付款,TRADE_CLOSED-未付款交易超时关闭，或支付完成后全额退款,3-交易支付成功,4-交易结束，不可退款',
  `total_amount` decimal(9,2) DEFAULT NULL COMMENT '本次交易支付的订单金额，单位为人民币（元）',
  `receipt_amount` decimal(9,2) DEFAULT NULL COMMENT '商家在交易中实际收到的款项，单位为人民币（元）',
  `refund_fee` decimal(9,2) DEFAULT NULL COMMENT '退款通知中，返回总退款金额，单位为人民币（元），支持两位小数',
  `subject` varchar(256) DEFAULT NULL COMMENT '商品的标题/交易标题/订单标题/订单关键字等，是请求时对应的参数，原样通知回来',
  `body` varchar(400) DEFAULT NULL COMMENT '该订单的备注、描述、明细等。对应请求时的 body 参数，原样通知回来',
  `passback_params` varchar(512) DEFAULT NULL COMMENT '公共回传参数，如果请求时传递了该参数，则返回给商户时会在异步通知时将该参数原样返回。本参数必须进行UrlEncode之后才可以发送给支付宝。',
  `notify_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '通知的发送时间。格式为 yyyy-MM-dd HH:mm:ss',
  `add_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `out_trade_no` (`out_trade_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='支付宝回调表';



# 转储表 eb_ali_pay_info
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_ali_pay_info`;

CREATE TABLE `eb_ali_pay_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) DEFAULT NULL COMMENT '支付宝分配给开发者的应用ID',
  `timestamp` varchar(20) DEFAULT NULL COMMENT '发送请求的时间，格式yyyy-MM-dd HH:mm:ss',
  `body` varchar(128) DEFAULT NULL COMMENT '订单描述',
  `subject` varchar(256) DEFAULT NULL COMMENT '订单标题',
  `out_trade_no` varchar(64) DEFAULT NULL COMMENT '商户订单号',
  `timeout_express` varchar(6) DEFAULT NULL COMMENT '订单相对超时时间',
  `time_expire` varchar(32) DEFAULT NULL COMMENT '订单绝对超时时间',
  `total_amount` varchar(9) DEFAULT NULL COMMENT '订单总金额。单位为元，精确到小数点后两位',
  `passback_params` varchar(512) DEFAULT NULL COMMENT '公用回传参数,本参数必须进行UrlEncode之后才可以发送给支付宝',
  `code` varchar(32) DEFAULT NULL COMMENT '网关返回码',
  `msg` varchar(256) DEFAULT NULL COMMENT '网关返回码描述',
  `sub_code` varchar(50) DEFAULT NULL COMMENT '业务返回码',
  `sub_msg` varchar(100) DEFAULT NULL COMMENT '业务返回码描述',
  `sign` varchar(500) DEFAULT NULL COMMENT '签名',
  `trade_no` varchar(64) DEFAULT NULL COMMENT '该交易在支付宝系统中的交易流水号',
  `seller_id` varchar(20) DEFAULT NULL COMMENT '收款支付宝账号对应的支付宝唯一用户号',
  `notify_url` varchar(256) DEFAULT NULL COMMENT '支付宝服务器主动通知商户服务器里指定的页面http/https路径',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `out_trade_no` (`out_trade_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='支付宝订单表';



# 转储表 eb_article
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_article`;

CREATE TABLE `eb_article` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `cid` int(11) NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '文章标题',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `cover` varchar(255) NOT NULL DEFAULT '' COMMENT '文章封面',
  `synopsis` varchar(500) DEFAULT '' COMMENT '文章简介',
  `content` text NOT NULL COMMENT '文章内容',
  `visit` bigint(15) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门(小程序)',
  `is_banner` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否轮播图(小程序)',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态，0-关闭，1-开启',
  `sort` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品关联id',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除，0-未删除，1-删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cid` (`cid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章管理表';



# 转储表 eb_article_category
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_article_category`;

CREATE TABLE `eb_article_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章分类ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '分类名称',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '分类图标',
  `sort` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态，0-关闭，1-开启',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除，0-未删除，1-删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章分类表';



# 转储表 eb_bill
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_bill`;

CREATE TABLE `eb_bill` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '帐单id',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户uid',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户id',
  `link_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '关联id',
  `order_no` varchar(32) NOT NULL DEFAULT '' COMMENT '关联订单',
  `pm` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '0 = 支出 1 = 获得',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '金额',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '类型：pay_order-订单支付,refund_order-订单退款，recharge_user-用户充值，yue_pay-余额支付,merchant_collect-商户分账，brokerage-分佣,system-系统',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `pm` (`pm`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1158314 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='平台帐单表';



# 转储表 eb_browse_record
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_browse_record`;

CREATE TABLE `eb_browse_record` (
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品id',
  `date` varchar(12) NOT NULL DEFAULT '' COMMENT '日期：年-月-日',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`uid`,`product_id`) USING BTREE,
  KEY `date` (`date`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='浏览记录表';



# 转储表 eb_cart
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_cart`;

CREATE TABLE `eb_cart` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户ID',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户Id',
  `product_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `product_attr_unique` int(11) NOT NULL DEFAULT '0' COMMENT '商品规格属性ID',
  `cart_num` int(5) unsigned NOT NULL DEFAULT '0' COMMENT '商品数量',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '购物车状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`uid`) USING BTREE,
  KEY `search_id` (`id`,`uid`,`mer_id`,`status`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=591 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='购物车表';



# 转储表 eb_category
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_category`;

CREATE TABLE `eb_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `path` varchar(255) NOT NULL DEFAULT '/0/' COMMENT '路径',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `type` smallint(2) DEFAULT '1' COMMENT '类型，2 附件分类, 4 设置分类， 5 菜单分类，6 配置分类， 7 秒杀配置',
  `url` varchar(255) DEFAULT '' COMMENT '地址',
  `extra` text COMMENT '扩展字段 Jsos格式',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态, 1正常，0失效',
  `sort` int(6) NOT NULL DEFAULT '99999' COMMENT '排序',
  `owner` int(11) NOT NULL DEFAULT '-1' COMMENT '分类所属：-1 - 平台，其他-商户',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `status+pid` (`pid`,`status`) USING BTREE,
  KEY `id+status+url` (`path`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='分类表';

LOCK TABLES `eb_category` WRITE;
/*!40000 ALTER TABLE `eb_category` DISABLE KEYS */;

INSERT INTO `eb_category` (`id`, `pid`, `path`, `name`, `type`, `url`, `extra`, `status`, `sort`, `owner`, `create_time`, `update_time`)
VALUES
	(5,0,'/0/','应用配置',6,'应用配置',NULL,1,7,-1,'2022-08-01 10:05:45','2022-08-01 16:55:25'),
	(7,0,'/0/','文件上传配置',6,'文件上传配置',NULL,1,1,-1,'2022-08-01 10:06:10','2022-08-01 10:06:10'),
	(8,0,'','第三方配置',6,'第三方配置',NULL,1,1,-1,'2022-08-01 10:06:22','2022-11-09 10:03:15'),
	(9,0,'/0/','商户设置',6,'商户设置',NULL,1,9,-1,'2022-08-01 10:06:47','2022-08-01 16:55:10'),
	(10,0,'/0/','商城设置/移动端配置',6,'商城设置/移动端配置',NULL,1,8,-1,'2022-08-01 10:07:08','2022-08-01 16:55:19'),
	(11,0,'/0/','支付/充值',6,'支付/充值',NULL,1,6,-1,'2022-08-01 10:07:21','2022-08-01 16:55:31'),
	(12,5,'/0/5/','公众号配置',6,'公众号配置','公众号配置',1,1,-1,'2022-08-01 12:14:55','2023-03-04 14:57:07'),
	(13,5,'/0/5/','小程序配置',6,'小程序配置','小程序配置',1,1,-1,'2022-08-01 12:15:05','2023-03-04 14:57:07'),
	(14,7,'/0/7/','基础配置',6,'基础配置','文件上传-基础配置',1,1,-1,'2022-08-01 12:16:13','2023-03-04 14:57:07'),
	(15,7,'/0/7/','阿里云配置',6,'阿里云配置','阿里云配置',1,1,-1,'2022-08-01 12:16:21','2023-03-04 14:57:07'),
	(16,7,'/0/7/','七牛云配置',6,'七牛云配置','七牛云配置',1,1,-1,'2022-08-01 12:16:28','2023-03-04 14:57:07'),
	(17,7,'/0/7/','腾讯云配置',6,'腾讯云配置','腾讯云配置',1,1,-1,'2022-08-01 12:16:35','2023-03-04 14:57:07'),
	(18,8,'/0/8/',' 短信配置',6,' 短信配置','短信设置',1,1,-1,'2022-08-01 12:17:09','2023-03-04 14:57:07'),
	(19,8,'/0/8/',' 采集商品配置',6,' 采集商品配置','采集商品配置',1,1,-1,'2022-08-01 12:17:15','2023-03-04 14:57:07'),
	(20,8,'/0/8/','物流查询',6,'物流查询','物流查询',1,1,-1,'2022-08-01 12:17:31','2023-03-04 14:57:07'),
	(21,8,'8/',' 电子面单',6,' 电子面单','电子面单',0,1,-1,'2022-08-01 12:17:42','2023-03-04 14:57:07'),
	(22,8,'8/','小票打印(易联云)',6,'小票打印(易联云)','易联云打印设置',1,1,-1,'2022-08-01 12:17:59','2023-03-04 14:57:07'),
	(23,9,'/0/9/','商户登录页配置',6,'商户登录页配置','商户登录页配置',1,1,-1,'2022-08-01 12:18:41','2023-03-04 14:57:07'),
	(24,11,'/0/11/',' 公众号支付配置',6,' 公众号支付配置','公众号支付配置',1,1,-1,'2022-08-01 12:19:29','2023-03-04 14:57:07'),
	(25,11,'/0/11/','小程序支付配置',6,'小程序支付配置','小程序支付配置',1,1,-1,'2022-08-01 12:19:34','2023-03-04 14:57:07'),
	(26,11,'/0/11/',' 余额支付',6,' 余额支付','余额支付',1,1,-1,'2022-08-01 12:19:39','2023-03-04 14:57:07'),
	(27,11,'/0/11/','微信APP支付',6,'微信APP支付','app微信支付配置',1,1,-1,'2022-08-01 12:19:45','2023-03-04 14:57:07'),
	(28,11,'/0/11/','支付宝支付(h5/App)',6,'支付宝支付(h5/App)','支付宝支付',1,1,-1,'2022-08-01 12:19:58','2023-03-04 14:57:07'),
	(29,10,'/0/10/','H5',6,'H5','H5配置',1,1,-1,'2022-08-01 14:36:38','2023-03-04 14:57:07'),
	(30,11,'/0/11/','支付回调地址(域名)',6,'支付回调地址(域名)','支付回调地址(域名)',1,1,-1,'2022-08-01 15:10:15','2023-03-04 14:57:07'),
	(31,0,'','平台配置',6,'平台配置','53',1,10,-1,'2022-08-01 16:50:15','2023-03-31 14:45:10'),
	(32,31,'31/','登录页配置',6,'登录页配置','平台登录页配置',1,1,-1,'2022-08-01 16:51:24','2023-05-08 10:06:37'),
	(33,31,'/0/31/','订单配置',6,'订单配置','订单配置',1,1,-1,'2022-08-01 16:51:51','2023-03-04 14:57:07'),
	(35,31,'/0/31/','物流配置',6,'物流配置','物流配置',1,1,-1,'2022-08-01 16:52:49','2023-03-04 14:57:07'),
	(36,31,'/0/31/','客服配置',6,'客服配置','客服配置',1,1,-1,'2022-08-01 16:53:13','2023-03-04 14:57:07'),
	(37,0,'/0/','七夕素材',2,'url',NULL,0,1,-1,'2022-08-04 11:40:02','2022-08-04 11:40:02'),
	(38,0,'/0/','服装',1,'','crmebimage/public/maintain/2022/08/04/b908b2b0034343458ba3649c7d1084383u7xxcc3ji.png',1,0,-1,'2022-08-09 09:47:56','2022-08-09 09:47:56'),
	(39,11,'/0/11/','充值配置',6,'充值配置','充值配置',1,1,-1,'2022-08-31 09:48:20','2023-03-30 18:13:03'),
	(40,0,'','系统素材',2,'url',NULL,0,1,-1,'2022-09-15 12:19:30','2022-09-15 12:19:30'),
	(41,0,'','衣服',2,'url',NULL,0,1,1,'2022-10-10 14:46:12','2022-10-10 14:46:12'),
	(42,0,'','商品图',2,'url',NULL,0,1,2,'2022-10-10 18:05:19','2022-10-10 18:05:19'),
	(43,0,'','商品图',2,'url',NULL,0,1,-1,'2022-10-11 11:16:36','2022-10-11 11:16:36'),
	(44,0,'','商品图',2,'url',NULL,0,1,1,'2022-10-11 12:18:45','2022-10-11 12:18:45'),
	(45,0,'','店铺图1',2,'url',NULL,0,1,1,'2022-10-11 17:20:15','2022-11-08 11:11:33'),
	(46,0,'','店铺',2,'url',NULL,0,1,2,'2022-10-11 17:24:27','2022-10-11 17:24:27'),
	(47,0,'','banner',2,'url',NULL,0,1,-1,'2022-10-11 17:26:11','2022-10-11 17:26:11'),
	(48,0,'','店铺配置',2,'url',NULL,0,1,3,'2022-10-13 17:03:50','2022-10-13 17:03:50'),
	(49,0,'','数码',2,'url',NULL,0,1,-1,'2022-10-15 10:25:04','2022-10-15 10:25:04'),
	(50,0,'','3C',2,'url',NULL,0,1,3,'2022-10-15 10:34:47','2022-10-15 10:34:47'),
	(51,0,'','微信视频号类目审核资质',2,'url',NULL,0,1,-1,'2022-10-29 16:05:50','2022-10-29 16:05:50'),
	(54,0,'','测试分类',2,'url',NULL,0,1,-1,'2022-11-02 15:22:17','2022-11-02 15:22:17'),
	(57,0,'','cs',2,'url',NULL,0,1,7,'2022-11-02 16:12:45','2022-11-02 16:12:45'),
	(59,0,'','添加分类',2,'url',NULL,0,1,7,'2022-11-09 09:31:15','2022-11-09 09:31:15'),
	(61,0,'','图标素材',2,'url',NULL,0,9,-1,'2022-11-11 11:20:37','2022-11-11 11:20:37'),
	(62,61,'61/','金刚区',2,'url',NULL,0,1,-1,'2022-11-11 11:21:59','2022-11-11 11:21:59'),
	(63,61,'61/','服务中心',2,'url',NULL,0,1,-1,'2022-11-11 11:22:25','2022-11-11 11:22:25'),
	(64,5,'/0/5/','微信App配置',6,'微信App配置','微信app配置',1,1,-1,'2022-11-26 20:01:23','2023-03-04 14:57:07'),
	(65,0,'','活动边框',2,'url',NULL,0,1,-1,'2023-01-11 15:24:57','2023-01-11 15:24:57'),
	(66,0,'','氛围图',2,'url',NULL,0,1,-1,'2023-01-11 17:38:19','2023-01-11 17:38:19'),
	(67,61,'61/','底部tab',2,'url',NULL,0,1,-1,'2023-02-10 10:05:33','2023-02-10 10:05:33'),
	(68,0,'','tabBar',2,'url',NULL,0,1,-1,'2023-02-13 10:22:54','2023-02-13 10:22:54'),
	(69,0,'','会员等级',2,'url',NULL,0,1,-1,'2023-03-02 10:23:32','2023-03-02 10:23:32'),
	(70,7,'/0/7/','京东云配置',6,'京东云配置','jdCloudConfig',1,1,-1,'2023-04-01 11:26:32','2023-04-01 11:27:54'),
	(71,0,'','直播商品',2,'url',NULL,0,1,3,'2023-04-06 16:03:01','2023-04-06 16:03:01'),
	(72,0,'','小于300px',2,'url',NULL,0,1,3,'2023-04-10 15:23:39','2023-04-10 15:23:39'),
	(73,10,'/0/10/','App升级',6,'appUpgrond','APP自动升级',1,1,-1,'2023-05-27 16:09:10','2023-05-27 16:09:20'),
	(74,0,'','DIY素材',2,'url',NULL,0,1,-1,'2023-05-31 09:48:35','2023-05-31 09:48:35'),
	(75,0,'','分类素材',2,'url',NULL,0,1,-1,'2023-05-31 17:38:11','2023-05-31 17:38:11'),
	(76,0,'','首页Banner',2,'url',NULL,0,1,-1,'2023-06-07 15:19:48','2023-06-07 15:19:48'),
	(77,0,'','测试上传的图片',2,'url',NULL,0,1,-1,'2023-06-07 16:55:23','2023-06-07 16:55:23');

/*!40000 ALTER TABLE `eb_category` ENABLE KEYS */;
UNLOCK TABLES;


# 转储表 eb_city_region
# ------------------------------------------------------------

DROP TABLE IF EXISTS `eb_city_region`;

CREATE TABLE `eb_city_region` (
  `region_id` int(11) NOT NULL DEFAULT '0' COMMENT '区域id',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT '父区域id',
  `region_name` varchar(100) NOT NULL DEFAULT '' COMMENT '区域名称',
  `region_type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '区域类型，0-国家、1-省、2-市、3-区、4-街道',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`region_id`) USING BTREE,
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `region_type` (`region_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='城市区域表';

LOCK TABLES `eb_city_region` WRITE;
/*!40000 ALTER TABLE `eb_city_region` DISABLE KEYS */;

INSERT INTO `eb_city_region` (`region_id`, `parent_id`, `region_name`, `region_type`, `create_time`, `update_time`)
VALUES
	(110000,1,'北京市',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(110100,110000,'北京市',2,'2022-11-09 10:07:58','2022-11-17 11:48:49'),
	(110101,110100,'东城区',3,'2022-11-09 10:32:30','2022-11-09 11:06:18'),
	(110102,110100,'西城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110105,110100,'朝阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110106,110100,'丰台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110107,110100,'石景山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110108,110100,'海淀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110109,110100,'门头沟区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110111,110100,'房山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110112,110100,'通州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110113,110100,'顺义区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110114,110100,'昌平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110115,110100,'大兴区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110116,110100,'怀柔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110117,110100,'平谷区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110118,110100,'密云区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110119,110100,'延庆区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120000,1,'天津市',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(120100,120000,'天津市',2,'2022-11-09 10:07:58','2022-11-17 11:49:02'),
	(120101,120100,'和平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120102,120100,'河东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120103,120100,'河西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120104,120100,'南开区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120105,120100,'河北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120106,120100,'红桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120110,120100,'东丽区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120111,120100,'西青区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120112,120100,'津南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120113,120100,'北辰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120114,120100,'武清区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120115,120100,'宝坻区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120116,120100,'滨海新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120117,120100,'宁河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120118,120100,'静海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(120119,120100,'蓟州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130000,1,'河北省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(130100,130000,'石家庄市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130101,130100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130102,130100,'长安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130104,130100,'桥西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130105,130100,'新华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130107,130100,'井陉矿区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130108,130100,'裕华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130109,130100,'藁城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130110,130100,'鹿泉区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130111,130100,'栾城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130121,130100,'井陉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130123,130100,'正定县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130125,130100,'行唐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130126,130100,'灵寿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130127,130100,'高邑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130128,130100,'深泽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130129,130100,'赞皇县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130130,130100,'无极县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130131,130100,'平山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130132,130100,'元氏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130133,130100,'赵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130171,130100,'石家庄高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130172,130100,'石家庄循环化工园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130181,130100,'辛集市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130183,130100,'晋州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130184,130100,'新乐市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130200,130000,'唐山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130201,130200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130202,130200,'路南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130203,130200,'路北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130204,130200,'古冶区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130205,130200,'开平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130207,130200,'丰南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130208,130200,'丰润区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130209,130200,'曹妃甸区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130224,130200,'滦南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130225,130200,'乐亭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130227,130200,'迁西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130229,130200,'玉田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130271,130200,'河北唐山芦台经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130272,130200,'唐山市汉沽管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130273,130200,'唐山高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130274,130200,'河北唐山海港经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130281,130200,'遵化市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130283,130200,'迁安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130284,130200,'滦州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130300,130000,'秦皇岛市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130301,130300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130302,130300,'海港区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130303,130300,'山海关区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130304,130300,'北戴河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130306,130300,'抚宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130321,130300,'青龙满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130322,130300,'昌黎县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130324,130300,'卢龙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130371,130300,'秦皇岛市经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130372,130300,'北戴河新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130400,130000,'邯郸市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130401,130400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130402,130400,'邯山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130403,130400,'丛台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130404,130400,'复兴区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130406,130400,'峰峰矿区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130407,130400,'肥乡区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130408,130400,'永年区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130423,130400,'临漳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130424,130400,'成安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130425,130400,'大名县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130426,130400,'涉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130427,130400,'磁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130430,130400,'邱县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130431,130400,'鸡泽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130432,130400,'广平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130433,130400,'馆陶县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130434,130400,'魏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130435,130400,'曲周县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130471,130400,'邯郸经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130473,130400,'邯郸冀南新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130481,130400,'武安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130500,130000,'邢台市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130501,130500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130502,130500,'襄都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130503,130500,'信都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130505,130500,'任泽区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130506,130500,'南和区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130522,130500,'临城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130523,130500,'内丘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130524,130500,'柏乡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130525,130500,'隆尧县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130528,130500,'宁晋县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130529,130500,'巨鹿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130530,130500,'新河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130531,130500,'广宗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130532,130500,'平乡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130533,130500,'威县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130534,130500,'清河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130535,130500,'临西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130571,130500,'河北邢台经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130581,130500,'南宫市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130582,130500,'沙河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130600,130000,'保定市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130601,130600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130602,130600,'竞秀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130606,130600,'莲池区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130607,130600,'满城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130608,130600,'清苑区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130609,130600,'徐水区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130623,130600,'涞水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130624,130600,'阜平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130626,130600,'定兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130627,130600,'唐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130628,130600,'高阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130629,130600,'容城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130630,130600,'涞源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130631,130600,'望都县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130632,130600,'安新县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130633,130600,'易县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130634,130600,'曲阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130635,130600,'蠡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130636,130600,'顺平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130637,130600,'博野县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130638,130600,'雄县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130671,130600,'保定高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130672,130600,'保定白沟新城',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130681,130600,'涿州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130682,130600,'定州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130683,130600,'安国市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130684,130600,'高碑店市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130700,130000,'张家口市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130701,130700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130702,130700,'桥东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130703,130700,'桥西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130705,130700,'宣化区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130706,130700,'下花园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130708,130700,'万全区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130709,130700,'崇礼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130722,130700,'张北县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130723,130700,'康保县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130724,130700,'沽源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130725,130700,'尚义县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130726,130700,'蔚县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130727,130700,'阳原县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130728,130700,'怀安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130730,130700,'怀来县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130731,130700,'涿鹿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130732,130700,'赤城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130771,130700,'张家口经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130772,130700,'张家口市察北管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130773,130700,'张家口市塞北管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130800,130000,'承德市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130801,130800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130802,130800,'双桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130803,130800,'双滦区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130804,130800,'鹰手营子矿区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130821,130800,'承德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130822,130800,'兴隆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130824,130800,'滦平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130825,130800,'隆化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130826,130800,'丰宁满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130827,130800,'宽城满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130828,130800,'围场满族蒙古族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130871,130800,'承德高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130881,130800,'平泉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130900,130000,'沧州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(130901,130900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130902,130900,'新华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130903,130900,'运河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130921,130900,'沧县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130922,130900,'青县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130923,130900,'东光县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130924,130900,'海兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130925,130900,'盐山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130926,130900,'肃宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130927,130900,'南皮县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130928,130900,'吴桥县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130929,130900,'献县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130930,130900,'孟村回族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130971,130900,'河北沧州经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130972,130900,'沧州高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130973,130900,'沧州渤海新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130981,130900,'泊头市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130982,130900,'任丘市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130983,130900,'黄骅市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(130984,130900,'河间市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131000,130000,'廊坊市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(131001,131000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131002,131000,'安次区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131003,131000,'广阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131022,131000,'固安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131023,131000,'永清县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131024,131000,'香河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131025,131000,'大城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131026,131000,'文安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131028,131000,'大厂回族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131071,131000,'廊坊经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131081,131000,'霸州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131082,131000,'三河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131100,130000,'衡水市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(131101,131100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131102,131100,'桃城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131103,131100,'冀州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131121,131100,'枣强县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131122,131100,'武邑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131123,131100,'武强县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131124,131100,'饶阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131125,131100,'安平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131126,131100,'故城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131127,131100,'景县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131128,131100,'阜城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131171,131100,'河北衡水高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131172,131100,'衡水滨湖新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(131182,131100,'深州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140000,1,'山西省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(140100,140000,'太原市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140101,140100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140105,140100,'小店区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140106,140100,'迎泽区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140107,140100,'杏花岭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140108,140100,'尖草坪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140109,140100,'万柏林区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140110,140100,'晋源区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140121,140100,'清徐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140122,140100,'阳曲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140123,140100,'娄烦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140171,140100,'山西转型综合改革示范区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140181,140100,'古交市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140200,140000,'大同市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140201,140200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140212,140200,'新荣区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140213,140200,'平城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140214,140200,'云冈区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140215,140200,'云州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140221,140200,'阳高县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140222,140200,'天镇县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140223,140200,'广灵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140224,140200,'灵丘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140225,140200,'浑源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140226,140200,'左云县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140271,140200,'山西大同经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140300,140000,'阳泉市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140301,140300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140302,140300,'城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140303,140300,'矿区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140311,140300,'郊区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140321,140300,'平定县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140322,140300,'盂县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140400,140000,'长治市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140401,140400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140403,140400,'潞州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140404,140400,'上党区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140405,140400,'屯留区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140406,140400,'潞城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140423,140400,'襄垣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140425,140400,'平顺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140426,140400,'黎城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140427,140400,'壶关县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140428,140400,'长子县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140429,140400,'武乡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140430,140400,'沁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140431,140400,'沁源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140471,140400,'山西长治高新技术产业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140500,140000,'晋城市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140501,140500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140502,140500,'城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140521,140500,'沁水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140522,140500,'阳城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140524,140500,'陵川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140525,140500,'泽州县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140581,140500,'高平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140600,140000,'朔州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140601,140600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140602,140600,'朔城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140603,140600,'平鲁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140621,140600,'山阴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140622,140600,'应县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140623,140600,'右玉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140671,140600,'山西朔州经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140681,140600,'怀仁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140700,140000,'晋中市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140701,140700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140702,140700,'榆次区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140703,140700,'太谷区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140721,140700,'榆社县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140722,140700,'左权县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140723,140700,'和顺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140724,140700,'昔阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140725,140700,'寿阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140727,140700,'祁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140728,140700,'平遥县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140729,140700,'灵石县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140781,140700,'介休市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140800,140000,'运城市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140801,140800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140802,140800,'盐湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140821,140800,'临猗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140822,140800,'万荣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140823,140800,'闻喜县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140824,140800,'稷山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140825,140800,'新绛县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140826,140800,'绛县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140827,140800,'垣曲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140828,140800,'夏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140829,140800,'平陆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140830,140800,'芮城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140881,140800,'永济市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140882,140800,'河津市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140900,140000,'忻州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(140901,140900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140902,140900,'忻府区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140921,140900,'定襄县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140922,140900,'五台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140923,140900,'代县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140924,140900,'繁峙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140925,140900,'宁武县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140926,140900,'静乐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140927,140900,'神池县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140928,140900,'五寨县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140929,140900,'岢岚县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140930,140900,'河曲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140931,140900,'保德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140932,140900,'偏关县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140971,140900,'五台山风景名胜区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(140981,140900,'原平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141000,140000,'临汾市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(141001,141000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141002,141000,'尧都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141021,141000,'曲沃县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141022,141000,'翼城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141023,141000,'襄汾县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141024,141000,'洪洞县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141025,141000,'古县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141026,141000,'安泽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141027,141000,'浮山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141028,141000,'吉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141029,141000,'乡宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141030,141000,'大宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141031,141000,'隰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141032,141000,'永和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141033,141000,'蒲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141034,141000,'汾西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141081,141000,'侯马市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141082,141000,'霍州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141100,140000,'吕梁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(141101,141100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141102,141100,'离石区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141121,141100,'文水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141122,141100,'交城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141123,141100,'兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141124,141100,'临县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141125,141100,'柳林县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141126,141100,'石楼县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141127,141100,'岚县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141128,141100,'方山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141129,141100,'中阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141130,141100,'交口县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141181,141100,'孝义市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(141182,141100,'汾阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150000,1,'内蒙古自治区',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(150100,150000,'呼和浩特市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150101,150100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150102,150100,'新城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150103,150100,'回民区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150104,150100,'玉泉区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150105,150100,'赛罕区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150121,150100,'土默特左旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150122,150100,'托克托县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150123,150100,'和林格尔县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150124,150100,'清水河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150125,150100,'武川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150172,150100,'呼和浩特经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150200,150000,'包头市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150201,150200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150202,150200,'东河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150203,150200,'昆都仑区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150204,150200,'青山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150205,150200,'石拐区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150206,150200,'白云鄂博矿区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150207,150200,'九原区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150221,150200,'土默特右旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150222,150200,'固阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150223,150200,'达尔罕茂明安联合旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150271,150200,'包头稀土高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150300,150000,'乌海市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150301,150300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150302,150300,'海勃湾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150303,150300,'海南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150304,150300,'乌达区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150400,150000,'赤峰市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150401,150400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150402,150400,'红山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150403,150400,'元宝山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150404,150400,'松山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150421,150400,'阿鲁科尔沁旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150422,150400,'巴林左旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150423,150400,'巴林右旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150424,150400,'林西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150425,150400,'克什克腾旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150426,150400,'翁牛特旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150428,150400,'喀喇沁旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150429,150400,'宁城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150430,150400,'敖汉旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150500,150000,'通辽市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150501,150500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150502,150500,'科尔沁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150521,150500,'科尔沁左翼中旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150522,150500,'科尔沁左翼后旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150523,150500,'开鲁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150524,150500,'库伦旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150525,150500,'奈曼旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150526,150500,'扎鲁特旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150571,150500,'通辽经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150581,150500,'霍林郭勒市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150600,150000,'鄂尔多斯市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150601,150600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150602,150600,'东胜区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150603,150600,'康巴什区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150621,150600,'达拉特旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150622,150600,'准格尔旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150623,150600,'鄂托克前旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150624,150600,'鄂托克旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150625,150600,'杭锦旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150626,150600,'乌审旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150627,150600,'伊金霍洛旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150700,150000,'呼伦贝尔市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150701,150700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150702,150700,'海拉尔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150703,150700,'扎赉诺尔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150721,150700,'阿荣旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150722,150700,'莫力达瓦达斡尔族自治旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150723,150700,'鄂伦春自治旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150724,150700,'鄂温克族自治旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150725,150700,'陈巴尔虎旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150726,150700,'新巴尔虎左旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150727,150700,'新巴尔虎右旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150781,150700,'满洲里市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150782,150700,'牙克石市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150783,150700,'扎兰屯市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150784,150700,'额尔古纳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150785,150700,'根河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150800,150000,'巴彦淖尔市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150801,150800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150802,150800,'临河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150821,150800,'五原县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150822,150800,'磴口县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150823,150800,'乌拉特前旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150824,150800,'乌拉特中旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150825,150800,'乌拉特后旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150826,150800,'杭锦后旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150900,150000,'乌兰察布市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(150901,150900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150902,150900,'集宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150921,150900,'卓资县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150922,150900,'化德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150923,150900,'商都县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150924,150900,'兴和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150925,150900,'凉城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150926,150900,'察哈尔右翼前旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150927,150900,'察哈尔右翼中旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150928,150900,'察哈尔右翼后旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150929,150900,'四子王旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(150981,150900,'丰镇市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152200,150000,'兴安盟',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(152201,152200,'乌兰浩特市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152202,152200,'阿尔山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152221,152200,'科尔沁右翼前旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152222,152200,'科尔沁右翼中旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152223,152200,'扎赉特旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152224,152200,'突泉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152500,150000,'锡林郭勒盟',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(152501,152500,'二连浩特市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152502,152500,'锡林浩特市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152522,152500,'阿巴嘎旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152523,152500,'苏尼特左旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152524,152500,'苏尼特右旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152525,152500,'东乌珠穆沁旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152526,152500,'西乌珠穆沁旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152527,152500,'太仆寺旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152528,152500,'镶黄旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152529,152500,'正镶白旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152530,152500,'正蓝旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152531,152500,'多伦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152571,152500,'乌拉盖管委会',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152900,150000,'阿拉善盟',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(152921,152900,'阿拉善左旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152922,152900,'阿拉善右旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152923,152900,'额济纳旗',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(152971,152900,'内蒙古阿拉善高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210000,1,'辽宁省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(210100,210000,'沈阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210101,210100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210102,210100,'和平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210103,210100,'沈河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210104,210100,'大东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210105,210100,'皇姑区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210106,210100,'铁西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210111,210100,'苏家屯区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210112,210100,'浑南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210113,210100,'沈北新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210114,210100,'于洪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210115,210100,'辽中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210123,210100,'康平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210124,210100,'法库县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210181,210100,'新民市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210200,210000,'大连市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210201,210200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210202,210200,'中山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210203,210200,'西岗区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210204,210200,'沙河口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210211,210200,'甘井子区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210212,210200,'旅顺口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210213,210200,'金州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210214,210200,'普兰店区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210224,210200,'长海县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210281,210200,'瓦房店市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210283,210200,'庄河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210300,210000,'鞍山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210301,210300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210302,210300,'铁东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210303,210300,'铁西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210304,210300,'立山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210311,210300,'千山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210321,210300,'台安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210323,210300,'岫岩满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210381,210300,'海城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210400,210000,'抚顺市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210401,210400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210402,210400,'新抚区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210403,210400,'东洲区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210404,210400,'望花区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210411,210400,'顺城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210421,210400,'抚顺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210422,210400,'新宾满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210423,210400,'清原满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210500,210000,'本溪市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210501,210500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210502,210500,'平山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210503,210500,'溪湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210504,210500,'明山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210505,210500,'南芬区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210521,210500,'本溪满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210522,210500,'桓仁满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210600,210000,'丹东市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210601,210600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210602,210600,'元宝区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210603,210600,'振兴区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210604,210600,'振安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210624,210600,'宽甸满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210681,210600,'东港市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210682,210600,'凤城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210700,210000,'锦州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210701,210700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210702,210700,'古塔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210703,210700,'凌河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210711,210700,'太和区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210726,210700,'黑山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210727,210700,'义县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210781,210700,'凌海市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210782,210700,'北镇市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210800,210000,'营口市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210801,210800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210802,210800,'站前区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210803,210800,'西市区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210804,210800,'鲅鱼圈区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210811,210800,'老边区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210881,210800,'盖州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210882,210800,'大石桥市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210900,210000,'阜新市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(210901,210900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210902,210900,'海州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210903,210900,'新邱区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210904,210900,'太平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210905,210900,'清河门区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210911,210900,'细河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210921,210900,'阜新蒙古族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(210922,210900,'彰武县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211000,210000,'辽阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(211001,211000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211002,211000,'白塔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211003,211000,'文圣区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211004,211000,'宏伟区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211005,211000,'弓长岭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211011,211000,'太子河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211021,211000,'辽阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211081,211000,'灯塔市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211100,210000,'盘锦市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(211101,211100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211102,211100,'双台子区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211103,211100,'兴隆台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211104,211100,'大洼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211122,211100,'盘山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211200,210000,'铁岭市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(211201,211200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211202,211200,'银州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211204,211200,'清河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211221,211200,'铁岭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211223,211200,'西丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211224,211200,'昌图县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211281,211200,'调兵山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211282,211200,'开原市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211300,210000,'朝阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(211301,211300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211302,211300,'双塔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211303,211300,'龙城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211321,211300,'朝阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211322,211300,'建平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211324,211300,'喀喇沁左翼蒙古族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211381,211300,'北票市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211382,211300,'凌源市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211400,210000,'葫芦岛市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(211401,211400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211402,211400,'连山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211403,211400,'龙港区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211404,211400,'南票区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211421,211400,'绥中县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211422,211400,'建昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(211481,211400,'兴城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220000,1,'吉林省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(220100,220000,'长春市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(220101,220100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220102,220100,'南关区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220103,220100,'宽城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220104,220100,'朝阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220105,220100,'二道区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220106,220100,'绿园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220112,220100,'双阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220113,220100,'九台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220122,220100,'农安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220171,220100,'长春经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220172,220100,'长春净月高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220173,220100,'长春高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220174,220100,'长春汽车经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220182,220100,'榆树市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220183,220100,'德惠市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220184,220100,'公主岭市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220200,220000,'吉林市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(220201,220200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220202,220200,'昌邑区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220203,220200,'龙潭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220204,220200,'船营区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220211,220200,'丰满区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220221,220200,'永吉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220271,220200,'吉林经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220272,220200,'吉林高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220273,220200,'吉林中国新加坡食品区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220281,220200,'蛟河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220282,220200,'桦甸市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220283,220200,'舒兰市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220284,220200,'磐石市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220300,220000,'四平市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(220301,220300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220302,220300,'铁西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220303,220300,'铁东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220322,220300,'梨树县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220323,220300,'伊通满族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220382,220300,'双辽市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220400,220000,'辽源市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(220401,220400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220402,220400,'龙山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220403,220400,'西安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220421,220400,'东丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220422,220400,'东辽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220500,220000,'通化市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(220501,220500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220502,220500,'东昌区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220503,220500,'二道江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220521,220500,'通化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220523,220500,'辉南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220524,220500,'柳河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220581,220500,'梅河口市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220582,220500,'集安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220600,220000,'白山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(220601,220600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220602,220600,'浑江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220605,220600,'江源区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220621,220600,'抚松县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220622,220600,'靖宇县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220623,220600,'长白朝鲜族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220681,220600,'临江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220700,220000,'松原市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(220701,220700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220702,220700,'宁江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220721,220700,'前郭尔罗斯蒙古族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220722,220700,'长岭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220723,220700,'乾安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220771,220700,'吉林松原经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220781,220700,'扶余市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220800,220000,'白城市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(220801,220800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220802,220800,'洮北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220821,220800,'镇赉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220822,220800,'通榆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220871,220800,'吉林白城经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220881,220800,'洮南市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(220882,220800,'大安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(222400,220000,'延边朝鲜族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(222401,222400,'延吉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(222402,222400,'图们市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(222403,222400,'敦化市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(222404,222400,'珲春市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(222405,222400,'龙井市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(222406,222400,'和龙市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(222424,222400,'汪清县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(222426,222400,'安图县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230000,1,'黑龙江省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(230100,230000,'哈尔滨市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230101,230100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230102,230100,'道里区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230103,230100,'南岗区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230104,230100,'道外区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230108,230100,'平房区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230109,230100,'松北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230110,230100,'香坊区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230111,230100,'呼兰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230112,230100,'阿城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230113,230100,'双城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230123,230100,'依兰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230124,230100,'方正县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230125,230100,'宾县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230126,230100,'巴彦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230127,230100,'木兰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230128,230100,'通河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230129,230100,'延寿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230183,230100,'尚志市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230184,230100,'五常市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230200,230000,'齐齐哈尔市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230201,230200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230202,230200,'龙沙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230203,230200,'建华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230204,230200,'铁锋区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230205,230200,'昂昂溪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230206,230200,'富拉尔基区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230207,230200,'碾子山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230208,230200,'梅里斯达斡尔族区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230221,230200,'龙江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230223,230200,'依安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230224,230200,'泰来县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230225,230200,'甘南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230227,230200,'富裕县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230229,230200,'克山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230230,230200,'克东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230231,230200,'拜泉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230281,230200,'讷河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230300,230000,'鸡西市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230301,230300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230302,230300,'鸡冠区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230303,230300,'恒山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230304,230300,'滴道区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230305,230300,'梨树区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230306,230300,'城子河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230307,230300,'麻山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230321,230300,'鸡东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230381,230300,'虎林市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230382,230300,'密山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230400,230000,'鹤岗市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230401,230400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230402,230400,'向阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230403,230400,'工农区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230404,230400,'南山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230405,230400,'兴安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230406,230400,'东山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230407,230400,'兴山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230421,230400,'萝北县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230422,230400,'绥滨县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230500,230000,'双鸭山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230501,230500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230502,230500,'尖山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230503,230500,'岭东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230505,230500,'四方台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230506,230500,'宝山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230521,230500,'集贤县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230522,230500,'友谊县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230523,230500,'宝清县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230524,230500,'饶河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230600,230000,'大庆市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230601,230600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230602,230600,'萨尔图区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230603,230600,'龙凤区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230604,230600,'让胡路区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230605,230600,'红岗区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230606,230600,'大同区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230621,230600,'肇州县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230622,230600,'肇源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230623,230600,'林甸县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230624,230600,'杜尔伯特蒙古族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230671,230600,'大庆高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230700,230000,'伊春市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230701,230700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230717,230700,'伊美区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230718,230700,'乌翠区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230719,230700,'友好区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230722,230700,'嘉荫县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230723,230700,'汤旺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230724,230700,'丰林县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230725,230700,'大箐山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230726,230700,'南岔县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230751,230700,'金林区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230781,230700,'铁力市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230800,230000,'佳木斯市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230801,230800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230803,230800,'向阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230804,230800,'前进区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230805,230800,'东风区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230811,230800,'郊区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230822,230800,'桦南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230826,230800,'桦川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230828,230800,'汤原县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230881,230800,'同江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230882,230800,'富锦市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230883,230800,'抚远市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230900,230000,'七台河市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(230901,230900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230902,230900,'新兴区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230903,230900,'桃山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230904,230900,'茄子河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(230921,230900,'勃利县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231000,230000,'牡丹江市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(231001,231000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231002,231000,'东安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231003,231000,'阳明区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231004,231000,'爱民区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231005,231000,'西安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231025,231000,'林口县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231071,231000,'牡丹江经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231081,231000,'绥芬河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231083,231000,'海林市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231084,231000,'宁安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231085,231000,'穆棱市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231086,231000,'东宁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231100,230000,'黑河市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(231101,231100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231102,231100,'爱辉区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231123,231100,'逊克县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231124,231100,'孙吴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231181,231100,'北安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231182,231100,'五大连池市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231183,231100,'嫩江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231200,230000,'绥化市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(231201,231200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231202,231200,'北林区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231221,231200,'望奎县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231222,231200,'兰西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231223,231200,'青冈县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231224,231200,'庆安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231225,231200,'明水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231226,231200,'绥棱县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231281,231200,'安达市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231282,231200,'肇东市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(231283,231200,'海伦市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(232700,230000,'大兴安岭地区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(232701,232700,'漠河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(232721,232700,'呼玛县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(232722,232700,'塔河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(232761,232700,'加格达奇区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(232762,232700,'松岭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(232763,232700,'新林区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(232764,232700,'呼中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310000,1,'上海市',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(310100,310000,'市辖区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(310101,310100,'黄浦区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310104,310100,'徐汇区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310105,310100,'长宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310106,310100,'静安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310107,310100,'普陀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310109,310100,'虹口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310110,310100,'杨浦区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310112,310100,'闵行区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310113,310100,'宝山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310114,310100,'嘉定区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310115,310100,'浦东新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310116,310100,'金山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310117,310100,'松江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310118,310100,'青浦区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310120,310100,'奉贤区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(310151,310100,'崇明区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320000,1,'江苏省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(320100,320000,'南京市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320101,320100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320102,320100,'玄武区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320104,320100,'秦淮区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320105,320100,'建邺区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320106,320100,'鼓楼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320111,320100,'浦口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320113,320100,'栖霞区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320114,320100,'雨花台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320115,320100,'江宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320116,320100,'六合区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320117,320100,'溧水区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320118,320100,'高淳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320200,320000,'无锡市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320201,320200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320205,320200,'锡山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320206,320200,'惠山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320211,320200,'滨湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320213,320200,'梁溪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320214,320200,'新吴区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320281,320200,'江阴市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320282,320200,'宜兴市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320300,320000,'徐州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320301,320300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320302,320300,'鼓楼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320303,320300,'云龙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320305,320300,'贾汪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320311,320300,'泉山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320312,320300,'铜山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320321,320300,'丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320322,320300,'沛县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320324,320300,'睢宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320371,320300,'徐州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320381,320300,'新沂市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320382,320300,'邳州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320400,320000,'常州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320401,320400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320402,320400,'天宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320404,320400,'钟楼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320411,320400,'新北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320412,320400,'武进区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320413,320400,'金坛区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320481,320400,'溧阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320500,320000,'苏州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320501,320500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320505,320500,'虎丘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320506,320500,'吴中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320507,320500,'相城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320508,320500,'姑苏区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320509,320500,'吴江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320571,320500,'苏州工业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320581,320500,'常熟市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320582,320500,'张家港市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320583,320500,'昆山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320585,320500,'太仓市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320600,320000,'南通市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320601,320600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320612,320600,'通州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320613,320600,'崇川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320614,320600,'海门区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320623,320600,'如东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320671,320600,'南通经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320681,320600,'启东市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320682,320600,'如皋市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320685,320600,'海安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320700,320000,'连云港市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320701,320700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320703,320700,'连云区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320706,320700,'海州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320707,320700,'赣榆区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320722,320700,'东海县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320723,320700,'灌云县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320724,320700,'灌南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320771,320700,'连云港经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320772,320700,'连云港高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320800,320000,'淮安市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320801,320800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320803,320800,'淮安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320804,320800,'淮阴区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320812,320800,'清江浦区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320813,320800,'洪泽区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320826,320800,'涟水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320830,320800,'盱眙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320831,320800,'金湖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320871,320800,'淮安经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320900,320000,'盐城市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(320901,320900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320902,320900,'亭湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320903,320900,'盐都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320904,320900,'大丰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320921,320900,'响水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320922,320900,'滨海县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320923,320900,'阜宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320924,320900,'射阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320925,320900,'建湖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320971,320900,'盐城经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(320981,320900,'东台市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321000,320000,'扬州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(321001,321000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321002,321000,'广陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321003,321000,'邗江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321012,321000,'江都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321023,321000,'宝应县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321071,321000,'扬州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321081,321000,'仪征市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321084,321000,'高邮市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321100,320000,'镇江市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(321101,321100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321102,321100,'京口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321111,321100,'润州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321112,321100,'丹徒区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321171,321100,'镇江新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321181,321100,'丹阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321182,321100,'扬中市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321183,321100,'句容市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321200,320000,'泰州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(321201,321200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321202,321200,'海陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321203,321200,'高港区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321204,321200,'姜堰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321271,321200,'泰州医药高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321281,321200,'兴化市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321282,321200,'靖江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321283,321200,'泰兴市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321300,320000,'宿迁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(321301,321300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321302,321300,'宿城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321311,321300,'宿豫区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321322,321300,'沭阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321323,321300,'泗阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321324,321300,'泗洪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(321371,321300,'宿迁经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330000,1,'浙江省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(330100,330000,'杭州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330101,330100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330102,330100,'上城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330105,330100,'拱墅区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330106,330100,'西湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330108,330100,'滨江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330109,330100,'萧山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330110,330100,'余杭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330111,330100,'富阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330112,330100,'临安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330113,330100,'临平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330114,330100,'钱塘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330122,330100,'桐庐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330127,330100,'淳安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330182,330100,'建德市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330200,330000,'宁波市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330201,330200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330203,330200,'海曙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330205,330200,'江北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330206,330200,'北仑区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330211,330200,'镇海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330212,330200,'鄞州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330213,330200,'奉化区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330225,330200,'象山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330226,330200,'宁海县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330281,330200,'余姚市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330282,330200,'慈溪市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330300,330000,'温州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330301,330300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330302,330300,'鹿城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330303,330300,'龙湾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330304,330300,'瓯海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330305,330300,'洞头区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330324,330300,'永嘉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330326,330300,'平阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330327,330300,'苍南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330328,330300,'文成县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330329,330300,'泰顺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330371,330300,'温州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330381,330300,'瑞安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330382,330300,'乐清市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330383,330300,'龙港市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330400,330000,'嘉兴市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330401,330400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330402,330400,'南湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330411,330400,'秀洲区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330421,330400,'嘉善县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330424,330400,'海盐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330481,330400,'海宁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330482,330400,'平湖市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330483,330400,'桐乡市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330500,330000,'湖州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330501,330500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330502,330500,'吴兴区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330503,330500,'南浔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330521,330500,'德清县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330522,330500,'长兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330523,330500,'安吉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330600,330000,'绍兴市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330601,330600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330602,330600,'越城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330603,330600,'柯桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330604,330600,'上虞区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330624,330600,'新昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330681,330600,'诸暨市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330683,330600,'嵊州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330700,330000,'金华市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330701,330700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330702,330700,'婺城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330703,330700,'金东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330723,330700,'武义县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330726,330700,'浦江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330727,330700,'磐安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330781,330700,'兰溪市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330782,330700,'义乌市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330783,330700,'东阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330784,330700,'永康市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330800,330000,'衢州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330801,330800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330802,330800,'柯城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330803,330800,'衢江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330822,330800,'常山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330824,330800,'开化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330825,330800,'龙游县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330881,330800,'江山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330900,330000,'舟山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(330901,330900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330902,330900,'定海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330903,330900,'普陀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330921,330900,'岱山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(330922,330900,'嵊泗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331000,330000,'台州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(331001,331000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331002,331000,'椒江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331003,331000,'黄岩区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331004,331000,'路桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331022,331000,'三门县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331023,331000,'天台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331024,331000,'仙居县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331081,331000,'温岭市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331082,331000,'临海市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331083,331000,'玉环市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331100,330000,'丽水市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(331101,331100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331102,331100,'莲都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331121,331100,'青田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331122,331100,'缙云县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331123,331100,'遂昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331124,331100,'松阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331125,331100,'云和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331126,331100,'庆元县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331127,331100,'景宁畲族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(331181,331100,'龙泉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340000,1,'安徽省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(340100,340000,'合肥市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(340101,340100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340102,340100,'瑶海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340103,340100,'庐阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340104,340100,'蜀山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340111,340100,'包河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340121,340100,'长丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340122,340100,'肥东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340123,340100,'肥西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340124,340100,'庐江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340171,340100,'合肥高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340172,340100,'合肥经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340173,340100,'合肥新站高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340181,340100,'巢湖市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340200,340000,'芜湖市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(340201,340200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340202,340200,'镜湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340207,340200,'鸠江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340209,340200,'弋江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340210,340200,'湾沚区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340212,340200,'繁昌区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340223,340200,'南陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340271,340200,'芜湖经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340272,340200,'安徽芜湖三山经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340281,340200,'无为市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340300,340000,'蚌埠市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(340301,340300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340302,340300,'龙子湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340303,340300,'蚌山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340304,340300,'禹会区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340311,340300,'淮上区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340321,340300,'怀远县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340322,340300,'五河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340323,340300,'固镇县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340371,340300,'蚌埠市高新技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340372,340300,'蚌埠市经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340400,340000,'淮南市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(340401,340400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340402,340400,'大通区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340403,340400,'田家庵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340404,340400,'谢家集区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340405,340400,'八公山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340406,340400,'潘集区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340421,340400,'凤台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340422,340400,'寿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340500,340000,'马鞍山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(340501,340500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340503,340500,'花山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340504,340500,'雨山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340506,340500,'博望区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340521,340500,'当涂县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340522,340500,'含山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340523,340500,'和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340600,340000,'淮北市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(340601,340600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340602,340600,'杜集区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340603,340600,'相山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340604,340600,'烈山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340621,340600,'濉溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340700,340000,'铜陵市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(340701,340700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340705,340700,'铜官区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340706,340700,'义安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340711,340700,'郊区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340722,340700,'枞阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340800,340000,'安庆市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(340801,340800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340802,340800,'迎江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340803,340800,'大观区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340811,340800,'宜秀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340822,340800,'怀宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340825,340800,'太湖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340826,340800,'宿松县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340827,340800,'望江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340828,340800,'岳西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340871,340800,'安徽安庆经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340881,340800,'桐城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(340882,340800,'潜山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341000,340000,'黄山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(341001,341000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341002,341000,'屯溪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341003,341000,'黄山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341004,341000,'徽州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341021,341000,'歙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341022,341000,'休宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341023,341000,'黟县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341024,341000,'祁门县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341100,340000,'滁州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(341101,341100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341102,341100,'琅琊区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341103,341100,'南谯区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341122,341100,'来安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341124,341100,'全椒县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341125,341100,'定远县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341126,341100,'凤阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341171,341100,'中新苏滁高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341172,341100,'滁州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341181,341100,'天长市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341182,341100,'明光市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341200,340000,'阜阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(341201,341200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341202,341200,'颍州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341203,341200,'颍东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341204,341200,'颍泉区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341221,341200,'临泉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341222,341200,'太和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341225,341200,'阜南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341226,341200,'颍上县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341271,341200,'阜阳合肥现代产业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341272,341200,'阜阳经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341282,341200,'界首市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341300,340000,'宿州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(341301,341300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341302,341300,'埇桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341321,341300,'砀山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341322,341300,'萧县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341323,341300,'灵璧县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341324,341300,'泗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341371,341300,'宿州马鞍山现代产业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341372,341300,'宿州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341500,340000,'六安市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(341501,341500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341502,341500,'金安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341503,341500,'裕安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341504,341500,'叶集区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341522,341500,'霍邱县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341523,341500,'舒城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341524,341500,'金寨县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341525,341500,'霍山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341600,340000,'亳州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(341601,341600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341602,341600,'谯城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341621,341600,'涡阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341622,341600,'蒙城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341623,341600,'利辛县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341700,340000,'池州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(341701,341700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341702,341700,'贵池区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341721,341700,'东至县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341722,341700,'石台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341723,341700,'青阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341800,340000,'宣城市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(341801,341800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341802,341800,'宣州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341821,341800,'郎溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341823,341800,'泾县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341824,341800,'绩溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341825,341800,'旌德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341871,341800,'宣城市经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341881,341800,'宁国市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(341882,341800,'广德市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350000,1,'福建省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(350100,350000,'福州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350101,350100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350102,350100,'鼓楼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350103,350100,'台江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350104,350100,'仓山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350105,350100,'马尾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350111,350100,'晋安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350112,350100,'长乐区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350121,350100,'闽侯县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350122,350100,'连江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350123,350100,'罗源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350124,350100,'闽清县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350125,350100,'永泰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350128,350100,'平潭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350181,350100,'福清市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350200,350000,'厦门市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350201,350200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350203,350200,'思明区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350205,350200,'海沧区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350206,350200,'湖里区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350211,350200,'集美区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350212,350200,'同安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350213,350200,'翔安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350300,350000,'莆田市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350301,350300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350302,350300,'城厢区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350303,350300,'涵江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350304,350300,'荔城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350305,350300,'秀屿区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350322,350300,'仙游县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350400,350000,'三明市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350401,350400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350404,350400,'三元区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350405,350400,'沙县区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350421,350400,'明溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350423,350400,'清流县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350424,350400,'宁化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350425,350400,'大田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350426,350400,'尤溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350428,350400,'将乐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350429,350400,'泰宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350430,350400,'建宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350481,350400,'永安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350500,350000,'泉州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350501,350500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350502,350500,'鲤城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350503,350500,'丰泽区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350504,350500,'洛江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350505,350500,'泉港区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350521,350500,'惠安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350524,350500,'安溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350525,350500,'永春县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350526,350500,'德化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350527,350500,'金门县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350581,350500,'石狮市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350582,350500,'晋江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350583,350500,'南安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350600,350000,'漳州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350601,350600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350602,350600,'芗城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350603,350600,'龙文区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350604,350600,'龙海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350605,350600,'长泰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350622,350600,'云霄县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350623,350600,'漳浦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350624,350600,'诏安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350626,350600,'东山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350627,350600,'南靖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350628,350600,'平和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350629,350600,'华安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350700,350000,'南平市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350701,350700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350702,350700,'延平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350703,350700,'建阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350721,350700,'顺昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350722,350700,'浦城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350723,350700,'光泽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350724,350700,'松溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350725,350700,'政和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350781,350700,'邵武市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350782,350700,'武夷山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350783,350700,'建瓯市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350800,350000,'龙岩市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350801,350800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350802,350800,'新罗区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350803,350800,'永定区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350821,350800,'长汀县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350823,350800,'上杭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350824,350800,'武平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350825,350800,'连城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350881,350800,'漳平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350900,350000,'宁德市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(350901,350900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350902,350900,'蕉城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350921,350900,'霞浦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350922,350900,'古田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350923,350900,'屏南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350924,350900,'寿宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350925,350900,'周宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350926,350900,'柘荣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350981,350900,'福安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(350982,350900,'福鼎市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360000,1,'江西省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(360100,360000,'南昌市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360101,360100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360102,360100,'东湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360103,360100,'西湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360104,360100,'青云谱区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360111,360100,'青山湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360112,360100,'新建区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360113,360100,'红谷滩区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360121,360100,'南昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360123,360100,'安义县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360124,360100,'进贤县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360200,360000,'景德镇市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360201,360200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360202,360200,'昌江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360203,360200,'珠山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360222,360200,'浮梁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360281,360200,'乐平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360300,360000,'萍乡市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360301,360300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360302,360300,'安源区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360313,360300,'湘东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360321,360300,'莲花县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360322,360300,'上栗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360323,360300,'芦溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360400,360000,'九江市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360401,360400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360402,360400,'濂溪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360403,360400,'浔阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360404,360400,'柴桑区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360423,360400,'武宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360424,360400,'修水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360425,360400,'永修县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360426,360400,'德安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360428,360400,'都昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360429,360400,'湖口县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360430,360400,'彭泽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360481,360400,'瑞昌市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360482,360400,'共青城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360483,360400,'庐山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360500,360000,'新余市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360501,360500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360502,360500,'渝水区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360521,360500,'分宜县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360600,360000,'鹰潭市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360601,360600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360602,360600,'月湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360603,360600,'余江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360681,360600,'贵溪市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360700,360000,'赣州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360701,360700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360702,360700,'章贡区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360703,360700,'南康区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360704,360700,'赣县区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360722,360700,'信丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360723,360700,'大余县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360724,360700,'上犹县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360725,360700,'崇义县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360726,360700,'安远县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360728,360700,'定南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360729,360700,'全南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360730,360700,'宁都县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360731,360700,'于都县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360732,360700,'兴国县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360733,360700,'会昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360734,360700,'寻乌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360735,360700,'石城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360781,360700,'瑞金市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360783,360700,'龙南市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360800,360000,'吉安市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360801,360800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360802,360800,'吉州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360803,360800,'青原区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360821,360800,'吉安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360822,360800,'吉水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360823,360800,'峡江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360824,360800,'新干县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360825,360800,'永丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360826,360800,'泰和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360827,360800,'遂川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360828,360800,'万安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360829,360800,'安福县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360830,360800,'永新县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360881,360800,'井冈山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360900,360000,'宜春市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(360901,360900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360902,360900,'袁州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360921,360900,'奉新县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360922,360900,'万载县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360923,360900,'上高县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360924,360900,'宜丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360925,360900,'靖安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360926,360900,'铜鼓县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360981,360900,'丰城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360982,360900,'樟树市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(360983,360900,'高安市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361000,360000,'抚州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(361001,361000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361002,361000,'临川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361003,361000,'东乡区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361021,361000,'南城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361022,361000,'黎川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361023,361000,'南丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361024,361000,'崇仁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361025,361000,'乐安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361026,361000,'宜黄县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361027,361000,'金溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361028,361000,'资溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361030,361000,'广昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361100,360000,'上饶市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(361101,361100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361102,361100,'信州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361103,361100,'广丰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361104,361100,'广信区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361123,361100,'玉山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361124,361100,'铅山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361125,361100,'横峰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361126,361100,'弋阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361127,361100,'余干县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361128,361100,'鄱阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361129,361100,'万年县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361130,361100,'婺源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(361181,361100,'德兴市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370000,1,'山东省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(370100,370000,'济南市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370101,370100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370102,370100,'历下区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370103,370100,'市中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370104,370100,'槐荫区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370105,370100,'天桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370112,370100,'历城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370113,370100,'长清区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370114,370100,'章丘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370115,370100,'济阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370116,370100,'莱芜区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370117,370100,'钢城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370124,370100,'平阴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370126,370100,'商河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370171,370100,'济南高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370200,370000,'青岛市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370201,370200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370202,370200,'市南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370203,370200,'市北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370211,370200,'黄岛区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370212,370200,'崂山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370213,370200,'李沧区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370214,370200,'城阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370215,370200,'即墨区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370271,370200,'青岛高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370281,370200,'胶州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370283,370200,'平度市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370285,370200,'莱西市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370300,370000,'淄博市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370301,370300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370302,370300,'淄川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370303,370300,'张店区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370304,370300,'博山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370305,370300,'临淄区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370306,370300,'周村区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370321,370300,'桓台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370322,370300,'高青县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370323,370300,'沂源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370400,370000,'枣庄市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370401,370400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370402,370400,'市中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370403,370400,'薛城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370404,370400,'峄城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370405,370400,'台儿庄区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370406,370400,'山亭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370481,370400,'滕州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370500,370000,'东营市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370501,370500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370502,370500,'东营区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370503,370500,'河口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370505,370500,'垦利区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370522,370500,'利津县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370523,370500,'广饶县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370571,370500,'东营经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370572,370500,'东营港经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370600,370000,'烟台市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370601,370600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370602,370600,'芝罘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370611,370600,'福山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370612,370600,'牟平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370613,370600,'莱山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370614,370600,'蓬莱区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370671,370600,'烟台高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370672,370600,'烟台经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370681,370600,'龙口市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370682,370600,'莱阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370683,370600,'莱州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370685,370600,'招远市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370686,370600,'栖霞市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370687,370600,'海阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370700,370000,'潍坊市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370701,370700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370702,370700,'潍城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370703,370700,'寒亭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370704,370700,'坊子区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370705,370700,'奎文区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370724,370700,'临朐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370725,370700,'昌乐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370772,370700,'潍坊滨海经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370781,370700,'青州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370782,370700,'诸城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370783,370700,'寿光市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370784,370700,'安丘市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370785,370700,'高密市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370786,370700,'昌邑市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370800,370000,'济宁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370801,370800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370811,370800,'任城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370812,370800,'兖州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370826,370800,'微山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370827,370800,'鱼台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370828,370800,'金乡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370829,370800,'嘉祥县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370830,370800,'汶上县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370831,370800,'泗水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370832,370800,'梁山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370871,370800,'济宁高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370881,370800,'曲阜市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370883,370800,'邹城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370900,370000,'泰安市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(370901,370900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370902,370900,'泰山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370911,370900,'岱岳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370921,370900,'宁阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370923,370900,'东平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370982,370900,'新泰市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(370983,370900,'肥城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371000,370000,'威海市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(371001,371000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371002,371000,'环翠区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371003,371000,'文登区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371071,371000,'威海火炬高技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371072,371000,'威海经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371073,371000,'威海临港经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371082,371000,'荣成市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371083,371000,'乳山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371100,370000,'日照市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(371101,371100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371102,371100,'东港区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371103,371100,'岚山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371121,371100,'五莲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371122,371100,'莒县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371171,371100,'日照经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371300,370000,'临沂市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(371301,371300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371302,371300,'兰山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371311,371300,'罗庄区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371312,371300,'河东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371321,371300,'沂南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371322,371300,'郯城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371323,371300,'沂水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371324,371300,'兰陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371325,371300,'费县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371326,371300,'平邑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371327,371300,'莒南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371328,371300,'蒙阴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371329,371300,'临沭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371371,371300,'临沂高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371400,370000,'德州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(371401,371400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371402,371400,'德城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371403,371400,'陵城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371422,371400,'宁津县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371423,371400,'庆云县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371424,371400,'临邑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371425,371400,'齐河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371426,371400,'平原县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371427,371400,'夏津县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371428,371400,'武城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371471,371400,'德州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371472,371400,'德州运河经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371481,371400,'乐陵市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371482,371400,'禹城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371500,370000,'聊城市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(371501,371500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371502,371500,'东昌府区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371503,371500,'茌平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371521,371500,'阳谷县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371522,371500,'莘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371524,371500,'东阿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371525,371500,'冠县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371526,371500,'高唐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371581,371500,'临清市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371600,370000,'滨州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(371601,371600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371602,371600,'滨城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371603,371600,'沾化区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371621,371600,'惠民县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371622,371600,'阳信县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371623,371600,'无棣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371625,371600,'博兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371681,371600,'邹平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371700,370000,'菏泽市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(371701,371700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371702,371700,'牡丹区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371703,371700,'定陶区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371721,371700,'曹县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371722,371700,'单县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371723,371700,'成武县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371724,371700,'巨野县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371725,371700,'郓城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371726,371700,'鄄城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371728,371700,'东明县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371771,371700,'菏泽经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(371772,371700,'菏泽高新技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410000,1,'河南省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(410100,410000,'郑州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410101,410100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410102,410100,'中原区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410103,410100,'二七区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410104,410100,'管城回族区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410105,410100,'金水区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410106,410100,'上街区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410108,410100,'惠济区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410122,410100,'中牟县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410171,410100,'郑州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410172,410100,'郑州高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410173,410100,'郑州航空港经济综合实验区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410181,410100,'巩义市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410182,410100,'荥阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410183,410100,'新密市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410184,410100,'新郑市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410185,410100,'登封市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410200,410000,'开封市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410201,410200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410202,410200,'龙亭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410203,410200,'顺河回族区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410204,410200,'鼓楼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410205,410200,'禹王台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410212,410200,'祥符区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410221,410200,'杞县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410222,410200,'通许县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410223,410200,'尉氏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410225,410200,'兰考县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410300,410000,'洛阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410301,410300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410302,410300,'老城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410303,410300,'西工区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410304,410300,'瀍河回族区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410305,410300,'涧西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410307,410300,'偃师区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410308,410300,'孟津区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410311,410300,'洛龙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410323,410300,'新安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410324,410300,'栾川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410325,410300,'嵩县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410326,410300,'汝阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410327,410300,'宜阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410328,410300,'洛宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410329,410300,'伊川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410371,410300,'洛阳高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410400,410000,'平顶山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410401,410400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410402,410400,'新华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410403,410400,'卫东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410404,410400,'石龙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410411,410400,'湛河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410421,410400,'宝丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410422,410400,'叶县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410423,410400,'鲁山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410425,410400,'郏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410471,410400,'平顶山高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410472,410400,'平顶山市城乡一体化示范区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410481,410400,'舞钢市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410482,410400,'汝州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410500,410000,'安阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410501,410500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410502,410500,'文峰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410503,410500,'北关区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410505,410500,'殷都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410506,410500,'龙安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410522,410500,'安阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410523,410500,'汤阴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410526,410500,'滑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410527,410500,'内黄县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410571,410500,'安阳高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410581,410500,'林州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410600,410000,'鹤壁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410601,410600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410602,410600,'鹤山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410603,410600,'山城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410611,410600,'淇滨区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410621,410600,'浚县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410622,410600,'淇县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410671,410600,'鹤壁经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410700,410000,'新乡市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410701,410700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410702,410700,'红旗区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410703,410700,'卫滨区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410704,410700,'凤泉区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410711,410700,'牧野区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410721,410700,'新乡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410724,410700,'获嘉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410725,410700,'原阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410726,410700,'延津县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410727,410700,'封丘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410771,410700,'新乡高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410772,410700,'新乡经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410773,410700,'新乡市平原城乡一体化示范区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410781,410700,'卫辉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410782,410700,'辉县市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410783,410700,'长垣市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410800,410000,'焦作市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410801,410800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410802,410800,'解放区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410803,410800,'中站区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410804,410800,'马村区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410811,410800,'山阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410821,410800,'修武县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410822,410800,'博爱县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410823,410800,'武陟县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410825,410800,'温县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410871,410800,'焦作城乡一体化示范区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410882,410800,'沁阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410883,410800,'孟州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410900,410000,'濮阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(410901,410900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410902,410900,'华龙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410922,410900,'清丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410923,410900,'南乐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410926,410900,'范县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410927,410900,'台前县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410928,410900,'濮阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410971,410900,'河南濮阳工业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(410972,410900,'濮阳经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411000,410000,'许昌市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(411001,411000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411002,411000,'魏都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411003,411000,'建安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411024,411000,'鄢陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411025,411000,'襄城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411071,411000,'许昌经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411081,411000,'禹州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411082,411000,'长葛市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411100,410000,'漯河市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(411101,411100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411102,411100,'源汇区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411103,411100,'郾城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411104,411100,'召陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411121,411100,'舞阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411122,411100,'临颍县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411171,411100,'漯河经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411200,410000,'三门峡市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(411201,411200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411202,411200,'湖滨区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411203,411200,'陕州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411221,411200,'渑池县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411224,411200,'卢氏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411271,411200,'河南三门峡经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411281,411200,'义马市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411282,411200,'灵宝市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411300,410000,'南阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(411301,411300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411302,411300,'宛城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411303,411300,'卧龙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411321,411300,'南召县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411322,411300,'方城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411323,411300,'西峡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411324,411300,'镇平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411325,411300,'内乡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411326,411300,'淅川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411327,411300,'社旗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411328,411300,'唐河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411329,411300,'新野县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411330,411300,'桐柏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411371,411300,'南阳高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411372,411300,'南阳市城乡一体化示范区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411381,411300,'邓州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411400,410000,'商丘市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(411401,411400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411402,411400,'梁园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411403,411400,'睢阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411421,411400,'民权县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411422,411400,'睢县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411423,411400,'宁陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411424,411400,'柘城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411425,411400,'虞城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411426,411400,'夏邑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411471,411400,'豫东综合物流产业聚集区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411472,411400,'河南商丘经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411481,411400,'永城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411500,410000,'信阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(411501,411500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411502,411500,'浉河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411503,411500,'平桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411521,411500,'罗山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411522,411500,'光山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411523,411500,'新县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411524,411500,'商城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411525,411500,'固始县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411526,411500,'潢川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411527,411500,'淮滨县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411528,411500,'息县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411571,411500,'信阳高新技术产业开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411600,410000,'周口市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(411601,411600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411602,411600,'川汇区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411603,411600,'淮阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411621,411600,'扶沟县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411622,411600,'西华县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411623,411600,'商水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411624,411600,'沈丘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411625,411600,'郸城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411627,411600,'太康县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411628,411600,'鹿邑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411671,411600,'河南周口经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411681,411600,'项城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411700,410000,'驻马店市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(411701,411700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411702,411700,'驿城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411721,411700,'西平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411722,411700,'上蔡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411723,411700,'平舆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411724,411700,'正阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411725,411700,'确山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411726,411700,'泌阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411727,411700,'汝南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411728,411700,'遂平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411729,411700,'新蔡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(411771,411700,'河南驻马店经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(419000,410000,'省直辖县级行政区划',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(419001,419000,'济源市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420000,1,'湖北省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(420100,420000,'武汉市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(420101,420100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420102,420100,'江岸区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420103,420100,'江汉区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420104,420100,'硚口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420105,420100,'汉阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420106,420100,'武昌区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420107,420100,'青山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420111,420100,'洪山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420112,420100,'东西湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420113,420100,'汉南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420114,420100,'蔡甸区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420115,420100,'江夏区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420116,420100,'黄陂区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420117,420100,'新洲区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420200,420000,'黄石市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(420201,420200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420202,420200,'黄石港区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420203,420200,'西塞山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420204,420200,'下陆区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420205,420200,'铁山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420222,420200,'阳新县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420281,420200,'大冶市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420300,420000,'十堰市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(420301,420300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420302,420300,'茅箭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420303,420300,'张湾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420304,420300,'郧阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420322,420300,'郧西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420323,420300,'竹山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420324,420300,'竹溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420325,420300,'房县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420381,420300,'丹江口市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420500,420000,'宜昌市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(420501,420500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420502,420500,'西陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420503,420500,'伍家岗区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420504,420500,'点军区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420505,420500,'猇亭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420506,420500,'夷陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420525,420500,'远安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420526,420500,'兴山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420527,420500,'秭归县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420528,420500,'长阳土家族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420529,420500,'五峰土家族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420581,420500,'宜都市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420582,420500,'当阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420583,420500,'枝江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420600,420000,'襄阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(420601,420600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420602,420600,'襄城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420606,420600,'樊城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420607,420600,'襄州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420624,420600,'南漳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420625,420600,'谷城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420626,420600,'保康县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420682,420600,'老河口市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420683,420600,'枣阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420684,420600,'宜城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420700,420000,'鄂州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(420701,420700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420702,420700,'梁子湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420703,420700,'华容区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420704,420700,'鄂城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420800,420000,'荆门市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(420801,420800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420802,420800,'东宝区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420804,420800,'掇刀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420822,420800,'沙洋县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420881,420800,'钟祥市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420882,420800,'京山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420900,420000,'孝感市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(420901,420900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420902,420900,'孝南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420921,420900,'孝昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420922,420900,'大悟县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420923,420900,'云梦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420981,420900,'应城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420982,420900,'安陆市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(420984,420900,'汉川市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421000,420000,'荆州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(421001,421000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421002,421000,'沙市区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421003,421000,'荆州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421022,421000,'公安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421024,421000,'江陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421071,421000,'荆州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421081,421000,'石首市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421083,421000,'洪湖市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421087,421000,'松滋市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421088,421000,'监利市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421100,420000,'黄冈市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(421101,421100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421102,421100,'黄州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421121,421100,'团风县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421122,421100,'红安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421123,421100,'罗田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421124,421100,'英山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421125,421100,'浠水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421126,421100,'蕲春县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421127,421100,'黄梅县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421171,421100,'龙感湖管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421181,421100,'麻城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421182,421100,'武穴市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421200,420000,'咸宁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(421201,421200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421202,421200,'咸安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421221,421200,'嘉鱼县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421222,421200,'通城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421223,421200,'崇阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421224,421200,'通山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421281,421200,'赤壁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421300,420000,'随州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(421301,421300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421303,421300,'曾都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421321,421300,'随县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(421381,421300,'广水市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(422800,420000,'恩施土家族苗族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(422801,422800,'恩施市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(422802,422800,'利川市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(422822,422800,'建始县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(422823,422800,'巴东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(422825,422800,'宣恩县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(422826,422800,'咸丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(422827,422800,'来凤县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(422828,422800,'鹤峰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(429000,420000,'省直辖县级行政区划',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(429004,429000,'仙桃市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(429005,429000,'潜江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(429006,429000,'天门市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(429021,429000,'神农架林区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430000,1,'湖南省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(430100,430000,'长沙市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430101,430100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430102,430100,'芙蓉区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430103,430100,'天心区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430104,430100,'岳麓区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430105,430100,'开福区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430111,430100,'雨花区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430112,430100,'望城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430121,430100,'长沙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430181,430100,'浏阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430182,430100,'宁乡市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430200,430000,'株洲市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430201,430200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430202,430200,'荷塘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430203,430200,'芦淞区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430204,430200,'石峰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430211,430200,'天元区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430212,430200,'渌口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430223,430200,'攸县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430224,430200,'茶陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430225,430200,'炎陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430271,430200,'云龙示范区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430281,430200,'醴陵市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430300,430000,'湘潭市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430301,430300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430302,430300,'雨湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430304,430300,'岳塘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430321,430300,'湘潭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430371,430300,'湖南湘潭高新技术产业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430372,430300,'湘潭昭山示范区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430373,430300,'湘潭九华示范区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430381,430300,'湘乡市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430382,430300,'韶山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430400,430000,'衡阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430401,430400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430405,430400,'珠晖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430406,430400,'雁峰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430407,430400,'石鼓区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430408,430400,'蒸湘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430412,430400,'南岳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430421,430400,'衡阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430422,430400,'衡南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430423,430400,'衡山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430424,430400,'衡东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430426,430400,'祁东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430471,430400,'衡阳综合保税区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430472,430400,'湖南衡阳高新技术产业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430473,430400,'湖南衡阳松木经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430481,430400,'耒阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430482,430400,'常宁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430500,430000,'邵阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430501,430500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430502,430500,'双清区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430503,430500,'大祥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430511,430500,'北塔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430522,430500,'新邵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430523,430500,'邵阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430524,430500,'隆回县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430525,430500,'洞口县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430527,430500,'绥宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430528,430500,'新宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430529,430500,'城步苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430581,430500,'武冈市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430582,430500,'邵东市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430600,430000,'岳阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430601,430600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430602,430600,'岳阳楼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430603,430600,'云溪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430611,430600,'君山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430621,430600,'岳阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430623,430600,'华容县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430624,430600,'湘阴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430626,430600,'平江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430671,430600,'岳阳市屈原管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430681,430600,'汨罗市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430682,430600,'临湘市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430700,430000,'常德市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430701,430700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430702,430700,'武陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430703,430700,'鼎城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430721,430700,'安乡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430722,430700,'汉寿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430723,430700,'澧县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430724,430700,'临澧县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430725,430700,'桃源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430726,430700,'石门县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430771,430700,'常德市西洞庭管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430781,430700,'津市市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430800,430000,'张家界市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430801,430800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430802,430800,'永定区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430811,430800,'武陵源区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430821,430800,'慈利县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430822,430800,'桑植县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430900,430000,'益阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(430901,430900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430902,430900,'资阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430903,430900,'赫山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430921,430900,'南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430922,430900,'桃江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430923,430900,'安化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430971,430900,'益阳市大通湖管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430972,430900,'湖南益阳高新技术产业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(430981,430900,'沅江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431000,430000,'郴州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(431001,431000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431002,431000,'北湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431003,431000,'苏仙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431021,431000,'桂阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431022,431000,'宜章县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431023,431000,'永兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431024,431000,'嘉禾县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431025,431000,'临武县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431026,431000,'汝城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431027,431000,'桂东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431028,431000,'安仁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431081,431000,'资兴市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431100,430000,'永州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(431101,431100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431102,431100,'零陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431103,431100,'冷水滩区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431122,431100,'东安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431123,431100,'双牌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431124,431100,'道县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431125,431100,'江永县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431126,431100,'宁远县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431127,431100,'蓝山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431128,431100,'新田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431129,431100,'江华瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431171,431100,'永州经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431173,431100,'永州市回龙圩管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431181,431100,'祁阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431200,430000,'怀化市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(431201,431200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431202,431200,'鹤城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431221,431200,'中方县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431222,431200,'沅陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431223,431200,'辰溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431224,431200,'溆浦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431225,431200,'会同县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431226,431200,'麻阳苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431227,431200,'新晃侗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431228,431200,'芷江侗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431229,431200,'靖州苗族侗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431230,431200,'通道侗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431271,431200,'怀化市洪江管理区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431281,431200,'洪江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431300,430000,'娄底市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(431301,431300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431302,431300,'娄星区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431321,431300,'双峰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431322,431300,'新化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431381,431300,'冷水江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(431382,431300,'涟源市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(433100,430000,'湘西土家族苗族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(433101,433100,'吉首市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(433122,433100,'泸溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(433123,433100,'凤凰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(433124,433100,'花垣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(433125,433100,'保靖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(433126,433100,'古丈县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(433127,433100,'永顺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(433130,433100,'龙山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440000,1,'广东省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(440100,440000,'广州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440101,440100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440103,440100,'荔湾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440104,440100,'越秀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440105,440100,'海珠区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440106,440100,'天河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440111,440100,'白云区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440112,440100,'黄埔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440113,440100,'番禺区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440114,440100,'花都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440115,440100,'南沙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440117,440100,'从化区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440118,440100,'增城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440200,440000,'韶关市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440201,440200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440203,440200,'武江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440204,440200,'浈江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440205,440200,'曲江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440222,440200,'始兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440224,440200,'仁化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440229,440200,'翁源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440232,440200,'乳源瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440233,440200,'新丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440281,440200,'乐昌市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440282,440200,'南雄市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440300,440000,'深圳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440301,440300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440303,440300,'罗湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440304,440300,'福田区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440305,440300,'南山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440306,440300,'宝安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440307,440300,'龙岗区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440308,440300,'盐田区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440309,440300,'龙华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440310,440300,'坪山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440311,440300,'光明区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440400,440000,'珠海市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440401,440400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440402,440400,'香洲区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440403,440400,'斗门区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440404,440400,'金湾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440500,440000,'汕头市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440501,440500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440507,440500,'龙湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440511,440500,'金平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440512,440500,'濠江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440513,440500,'潮阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440514,440500,'潮南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440515,440500,'澄海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440523,440500,'南澳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440600,440000,'佛山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440601,440600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440604,440600,'禅城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440605,440600,'南海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440606,440600,'顺德区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440607,440600,'三水区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440608,440600,'高明区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440700,440000,'江门市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440701,440700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440703,440700,'蓬江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440704,440700,'江海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440705,440700,'新会区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440781,440700,'台山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440783,440700,'开平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440784,440700,'鹤山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440785,440700,'恩平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440800,440000,'湛江市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440801,440800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440802,440800,'赤坎区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440803,440800,'霞山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440804,440800,'坡头区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440811,440800,'麻章区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440823,440800,'遂溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440825,440800,'徐闻县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440881,440800,'廉江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440882,440800,'雷州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440883,440800,'吴川市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440900,440000,'茂名市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(440901,440900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440902,440900,'茂南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440904,440900,'电白区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440981,440900,'高州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440982,440900,'化州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(440983,440900,'信宜市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441200,440000,'肇庆市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(441201,441200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441202,441200,'端州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441203,441200,'鼎湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441204,441200,'高要区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441223,441200,'广宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441224,441200,'怀集县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441225,441200,'封开县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441226,441200,'德庆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441284,441200,'四会市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441300,440000,'惠州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(441301,441300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441302,441300,'惠城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441303,441300,'惠阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441322,441300,'博罗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441323,441300,'惠东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441324,441300,'龙门县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441400,440000,'梅州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(441401,441400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441402,441400,'梅江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441403,441400,'梅县区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441422,441400,'大埔县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441423,441400,'丰顺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441424,441400,'五华县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441426,441400,'平远县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441427,441400,'蕉岭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441481,441400,'兴宁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441500,440000,'汕尾市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(441501,441500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441502,441500,'城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441521,441500,'海丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441523,441500,'陆河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441581,441500,'陆丰市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441600,440000,'河源市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(441601,441600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441602,441600,'源城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441621,441600,'紫金县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441622,441600,'龙川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441623,441600,'连平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441624,441600,'和平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441625,441600,'东源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441700,440000,'阳江市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(441701,441700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441702,441700,'江城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441704,441700,'阳东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441721,441700,'阳西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441781,441700,'阳春市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441800,440000,'清远市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(441801,441800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441802,441800,'清城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441803,441800,'清新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441821,441800,'佛冈县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441823,441800,'阳山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441825,441800,'连山壮族瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441826,441800,'连南瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441881,441800,'英德市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441882,441800,'连州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(441900,440000,'东莞市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(442000,440000,'中山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(445100,440000,'潮州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(445101,445100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445102,445100,'湘桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445103,445100,'潮安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445122,445100,'饶平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445200,440000,'揭阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(445201,445200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445202,445200,'榕城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445203,445200,'揭东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445222,445200,'揭西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445224,445200,'惠来县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445281,445200,'普宁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445300,440000,'云浮市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(445301,445300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445302,445300,'云城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445303,445300,'云安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445321,445300,'新兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445322,445300,'郁南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(445381,445300,'罗定市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450000,1,'广西壮族自治区',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(450100,450000,'南宁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450101,450100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450102,450100,'兴宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450103,450100,'青秀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450105,450100,'江南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450107,450100,'西乡塘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450108,450100,'良庆区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450109,450100,'邕宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450110,450100,'武鸣区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450123,450100,'隆安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450124,450100,'马山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450125,450100,'上林县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450126,450100,'宾阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450181,450100,'横州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450200,450000,'柳州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450201,450200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450202,450200,'城中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450203,450200,'鱼峰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450204,450200,'柳南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450205,450200,'柳北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450206,450200,'柳江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450222,450200,'柳城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450223,450200,'鹿寨县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450224,450200,'融安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450225,450200,'融水苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450226,450200,'三江侗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450300,450000,'桂林市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450301,450300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450302,450300,'秀峰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450303,450300,'叠彩区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450304,450300,'象山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450305,450300,'七星区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450311,450300,'雁山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450312,450300,'临桂区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450321,450300,'阳朔县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450323,450300,'灵川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450324,450300,'全州县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450325,450300,'兴安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450326,450300,'永福县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450327,450300,'灌阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450328,450300,'龙胜各族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450329,450300,'资源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450330,450300,'平乐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450332,450300,'恭城瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450381,450300,'荔浦市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450400,450000,'梧州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450401,450400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450403,450400,'万秀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450405,450400,'长洲区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450406,450400,'龙圩区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450421,450400,'苍梧县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450422,450400,'藤县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450423,450400,'蒙山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450481,450400,'岑溪市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450500,450000,'北海市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450501,450500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450502,450500,'海城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450503,450500,'银海区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450512,450500,'铁山港区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450521,450500,'合浦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450600,450000,'防城港市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450601,450600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450602,450600,'港口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450603,450600,'防城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450621,450600,'上思县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450681,450600,'东兴市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450700,450000,'钦州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450701,450700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450702,450700,'钦南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450703,450700,'钦北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450721,450700,'灵山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450722,450700,'浦北县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450800,450000,'贵港市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450801,450800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450802,450800,'港北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450803,450800,'港南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450804,450800,'覃塘区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450821,450800,'平南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450881,450800,'桂平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450900,450000,'玉林市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(450901,450900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450902,450900,'玉州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450903,450900,'福绵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450921,450900,'容县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450922,450900,'陆川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450923,450900,'博白县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450924,450900,'兴业县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(450981,450900,'北流市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451000,450000,'百色市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(451001,451000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451002,451000,'右江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451003,451000,'田阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451022,451000,'田东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451024,451000,'德保县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451026,451000,'那坡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451027,451000,'凌云县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451028,451000,'乐业县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451029,451000,'田林县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451030,451000,'西林县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451031,451000,'隆林各族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451081,451000,'靖西市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451082,451000,'平果市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451100,450000,'贺州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(451101,451100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451102,451100,'八步区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451103,451100,'平桂区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451121,451100,'昭平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451122,451100,'钟山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451123,451100,'富川瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451200,450000,'河池市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(451201,451200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451202,451200,'金城江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451203,451200,'宜州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451221,451200,'南丹县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451222,451200,'天峨县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451223,451200,'凤山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451224,451200,'东兰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451225,451200,'罗城仫佬族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451226,451200,'环江毛南族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451227,451200,'巴马瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451228,451200,'都安瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451229,451200,'大化瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451300,450000,'来宾市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(451301,451300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451302,451300,'兴宾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451321,451300,'忻城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451322,451300,'象州县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451323,451300,'武宣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451324,451300,'金秀瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451381,451300,'合山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451400,450000,'崇左市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(451401,451400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451402,451400,'江州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451421,451400,'扶绥县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451422,451400,'宁明县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451423,451400,'龙州县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451424,451400,'大新县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451425,451400,'天等县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(451481,451400,'凭祥市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460000,1,'海南省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(460100,460000,'海口市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(460101,460100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460105,460100,'秀英区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460106,460100,'龙华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460107,460100,'琼山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460108,460100,'美兰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460200,460000,'三亚市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(460201,460200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460202,460200,'海棠区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460203,460200,'吉阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460204,460200,'天涯区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460205,460200,'崖州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460300,460000,'三沙市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(460321,460300,'西沙群岛',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460322,460300,'南沙群岛',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460323,460300,'中沙群岛的岛礁及其海域',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(460400,460000,'儋州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(469000,460000,'省直辖县级行政区划',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(469001,469000,'五指山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469002,469000,'琼海市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469005,469000,'文昌市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469006,469000,'万宁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469007,469000,'东方市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469021,469000,'定安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469022,469000,'屯昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469023,469000,'澄迈县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469024,469000,'临高县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469025,469000,'白沙黎族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469026,469000,'昌江黎族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469027,469000,'乐东黎族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469028,469000,'陵水黎族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469029,469000,'保亭黎族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(469030,469000,'琼中黎族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500000,1,'重庆市',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(500100,500000,'市辖区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(500101,500100,'万州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500102,500100,'涪陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500103,500100,'渝中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500104,500100,'大渡口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500105,500100,'江北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500106,500100,'沙坪坝区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500107,500100,'九龙坡区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500108,500100,'南岸区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500109,500100,'北碚区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500110,500100,'綦江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500111,500100,'大足区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500112,500100,'渝北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500113,500100,'巴南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500114,500100,'黔江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500115,500100,'长寿区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500116,500100,'江津区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500117,500100,'合川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500118,500100,'永川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500119,500100,'南川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500120,500100,'璧山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500151,500100,'铜梁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500152,500100,'潼南区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500153,500100,'荣昌区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500154,500100,'开州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500155,500100,'梁平区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500156,500100,'武隆区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500200,500000,'县',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(500229,500200,'城口县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500230,500200,'丰都县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500231,500200,'垫江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500233,500200,'忠县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500235,500200,'云阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500236,500200,'奉节县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500237,500200,'巫山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500238,500200,'巫溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500240,500200,'石柱土家族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500241,500200,'秀山土家族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500242,500200,'酉阳土家族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(500243,500200,'彭水苗族土家族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510000,1,'四川省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(510100,510000,'成都市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(510101,510100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510104,510100,'锦江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510105,510100,'青羊区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510106,510100,'金牛区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510107,510100,'武侯区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510108,510100,'成华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510112,510100,'龙泉驿区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510113,510100,'青白江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510114,510100,'新都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510115,510100,'温江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510116,510100,'双流区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510117,510100,'郫都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510118,510100,'新津区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510121,510100,'金堂县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510129,510100,'大邑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510131,510100,'蒲江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510181,510100,'都江堰市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510182,510100,'彭州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510183,510100,'邛崃市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510184,510100,'崇州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510185,510100,'简阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510300,510000,'自贡市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(510301,510300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510302,510300,'自流井区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510303,510300,'贡井区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510304,510300,'大安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510311,510300,'沿滩区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510321,510300,'荣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510322,510300,'富顺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510400,510000,'攀枝花市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(510401,510400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510402,510400,'东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510403,510400,'西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510411,510400,'仁和区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510421,510400,'米易县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510422,510400,'盐边县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510500,510000,'泸州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(510501,510500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510502,510500,'江阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510503,510500,'纳溪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510504,510500,'龙马潭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510521,510500,'泸县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510522,510500,'合江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510524,510500,'叙永县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510525,510500,'古蔺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510600,510000,'德阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(510601,510600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510603,510600,'旌阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510604,510600,'罗江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510623,510600,'中江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510681,510600,'广汉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510682,510600,'什邡市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510683,510600,'绵竹市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510700,510000,'绵阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(510701,510700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510703,510700,'涪城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510704,510700,'游仙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510705,510700,'安州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510722,510700,'三台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510723,510700,'盐亭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510725,510700,'梓潼县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510726,510700,'北川羌族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510727,510700,'平武县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510781,510700,'江油市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510800,510000,'广元市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(510801,510800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510802,510800,'利州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510811,510800,'昭化区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510812,510800,'朝天区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510821,510800,'旺苍县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510822,510800,'青川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510823,510800,'剑阁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510824,510800,'苍溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510900,510000,'遂宁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(510901,510900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510903,510900,'船山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510904,510900,'安居区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510921,510900,'蓬溪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510923,510900,'大英县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(510981,510900,'射洪市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511000,510000,'内江市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511001,511000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511002,511000,'市中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511011,511000,'东兴区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511024,511000,'威远县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511025,511000,'资中县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511071,511000,'内江经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511083,511000,'隆昌市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511100,510000,'乐山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511101,511100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511102,511100,'市中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511111,511100,'沙湾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511112,511100,'五通桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511113,511100,'金口河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511123,511100,'犍为县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511124,511100,'井研县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511126,511100,'夹江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511129,511100,'沐川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511132,511100,'峨边彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511133,511100,'马边彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511181,511100,'峨眉山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511300,510000,'南充市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511301,511300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511302,511300,'顺庆区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511303,511300,'高坪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511304,511300,'嘉陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511321,511300,'南部县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511322,511300,'营山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511323,511300,'蓬安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511324,511300,'仪陇县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511325,511300,'西充县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511381,511300,'阆中市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511400,510000,'眉山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511401,511400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511402,511400,'东坡区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511403,511400,'彭山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511421,511400,'仁寿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511423,511400,'洪雅县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511424,511400,'丹棱县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511425,511400,'青神县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511500,510000,'宜宾市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511501,511500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511502,511500,'翠屏区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511503,511500,'南溪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511504,511500,'叙州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511523,511500,'江安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511524,511500,'长宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511525,511500,'高县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511526,511500,'珙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511527,511500,'筠连县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511528,511500,'兴文县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511529,511500,'屏山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511600,510000,'广安市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511601,511600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511602,511600,'广安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511603,511600,'前锋区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511621,511600,'岳池县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511622,511600,'武胜县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511623,511600,'邻水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511681,511600,'华蓥市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511700,510000,'达州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511701,511700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511702,511700,'通川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511703,511700,'达川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511722,511700,'宣汉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511723,511700,'开江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511724,511700,'大竹县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511725,511700,'渠县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511771,511700,'达州经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511781,511700,'万源市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511800,510000,'雅安市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511801,511800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511802,511800,'雨城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511803,511800,'名山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511822,511800,'荥经县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511823,511800,'汉源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511824,511800,'石棉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511825,511800,'天全县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511826,511800,'芦山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511827,511800,'宝兴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511900,510000,'巴中市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(511901,511900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511902,511900,'巴州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511903,511900,'恩阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511921,511900,'通江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511922,511900,'南江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511923,511900,'平昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(511971,511900,'巴中经济开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(512000,510000,'资阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(512001,512000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(512002,512000,'雁江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(512021,512000,'安岳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(512022,512000,'乐至县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513200,510000,'阿坝藏族羌族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(513201,513200,'马尔康市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513221,513200,'汶川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513222,513200,'理县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513223,513200,'茂县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513224,513200,'松潘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513225,513200,'九寨沟县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513226,513200,'金川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513227,513200,'小金县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513228,513200,'黑水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513230,513200,'壤塘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513231,513200,'阿坝县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513232,513200,'若尔盖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513233,513200,'红原县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513300,510000,'甘孜藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(513301,513300,'康定市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513322,513300,'泸定县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513323,513300,'丹巴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513324,513300,'九龙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513325,513300,'雅江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513326,513300,'道孚县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513327,513300,'炉霍县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513328,513300,'甘孜县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513329,513300,'新龙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513330,513300,'德格县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513331,513300,'白玉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513332,513300,'石渠县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513333,513300,'色达县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513334,513300,'理塘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513335,513300,'巴塘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513336,513300,'乡城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513337,513300,'稻城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513338,513300,'得荣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513400,510000,'凉山彝族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(513401,513400,'西昌市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513402,513400,'会理市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513422,513400,'木里藏族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513423,513400,'盐源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513424,513400,'德昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513426,513400,'会东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513427,513400,'宁南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513428,513400,'普格县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513429,513400,'布拖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513430,513400,'金阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513431,513400,'昭觉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513432,513400,'喜德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513433,513400,'冕宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513434,513400,'越西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513435,513400,'甘洛县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513436,513400,'美姑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(513437,513400,'雷波县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520000,1,'贵州省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(520100,520000,'贵阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(520101,520100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520102,520100,'南明区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520103,520100,'云岩区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520111,520100,'花溪区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520112,520100,'乌当区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520113,520100,'白云区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520115,520100,'观山湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520121,520100,'开阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520122,520100,'息烽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520123,520100,'修文县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520181,520100,'清镇市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520200,520000,'六盘水市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(520201,520200,'钟山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520203,520200,'六枝特区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520204,520200,'水城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520281,520200,'盘州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520300,520000,'遵义市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(520301,520300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520302,520300,'红花岗区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520303,520300,'汇川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520304,520300,'播州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520322,520300,'桐梓县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520323,520300,'绥阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520324,520300,'正安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520325,520300,'道真仡佬族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520326,520300,'务川仡佬族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520327,520300,'凤冈县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520328,520300,'湄潭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520329,520300,'余庆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520330,520300,'习水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520381,520300,'赤水市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520382,520300,'仁怀市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520400,520000,'安顺市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(520401,520400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520402,520400,'西秀区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520403,520400,'平坝区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520422,520400,'普定县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520423,520400,'镇宁布依族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520424,520400,'关岭布依族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520425,520400,'紫云苗族布依族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520500,520000,'毕节市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(520501,520500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520502,520500,'七星关区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520521,520500,'大方县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520523,520500,'金沙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520524,520500,'织金县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520525,520500,'纳雍县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520526,520500,'威宁彝族回族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520527,520500,'赫章县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520581,520500,'黔西市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520600,520000,'铜仁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(520601,520600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520602,520600,'碧江区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520603,520600,'万山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520621,520600,'江口县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520622,520600,'玉屏侗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520623,520600,'石阡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520624,520600,'思南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520625,520600,'印江土家族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520626,520600,'德江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520627,520600,'沿河土家族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(520628,520600,'松桃苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522300,520000,'黔西南布依族苗族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(522301,522300,'兴义市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522302,522300,'兴仁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522323,522300,'普安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522324,522300,'晴隆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522325,522300,'贞丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522326,522300,'望谟县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522327,522300,'册亨县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522328,522300,'安龙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522600,520000,'黔东南苗族侗族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(522601,522600,'凯里市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522622,522600,'黄平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522623,522600,'施秉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522624,522600,'三穗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522625,522600,'镇远县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522626,522600,'岑巩县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522627,522600,'天柱县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522628,522600,'锦屏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522629,522600,'剑河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522630,522600,'台江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522631,522600,'黎平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522632,522600,'榕江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522633,522600,'从江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522634,522600,'雷山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522635,522600,'麻江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522636,522600,'丹寨县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522700,520000,'黔南布依族苗族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(522701,522700,'都匀市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522702,522700,'福泉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522722,522700,'荔波县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522723,522700,'贵定县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522725,522700,'瓮安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522726,522700,'独山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522727,522700,'平塘县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522728,522700,'罗甸县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522729,522700,'长顺县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522730,522700,'龙里县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522731,522700,'惠水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(522732,522700,'三都水族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530000,1,'云南省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(530100,530000,'昆明市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(530101,530100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530102,530100,'五华区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530103,530100,'盘龙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530111,530100,'官渡区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530112,530100,'西山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530113,530100,'东川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530114,530100,'呈贡区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530115,530100,'晋宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530124,530100,'富民县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530125,530100,'宜良县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530126,530100,'石林彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530127,530100,'嵩明县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530128,530100,'禄劝彝族苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530129,530100,'寻甸回族彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530181,530100,'安宁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530300,530000,'曲靖市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(530301,530300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530302,530300,'麒麟区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530303,530300,'沾益区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530304,530300,'马龙区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530322,530300,'陆良县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530323,530300,'师宗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530324,530300,'罗平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530325,530300,'富源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530326,530300,'会泽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530381,530300,'宣威市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530400,530000,'玉溪市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(530401,530400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530402,530400,'红塔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530403,530400,'江川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530423,530400,'通海县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530424,530400,'华宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530425,530400,'易门县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530426,530400,'峨山彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530427,530400,'新平彝族傣族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530428,530400,'元江哈尼族彝族傣族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530481,530400,'澄江市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530500,530000,'保山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(530501,530500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530502,530500,'隆阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530521,530500,'施甸县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530523,530500,'龙陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530524,530500,'昌宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530581,530500,'腾冲市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530600,530000,'昭通市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(530601,530600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530602,530600,'昭阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530621,530600,'鲁甸县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530622,530600,'巧家县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530623,530600,'盐津县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530624,530600,'大关县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530625,530600,'永善县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530626,530600,'绥江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530627,530600,'镇雄县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530628,530600,'彝良县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530629,530600,'威信县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530681,530600,'水富市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530700,530000,'丽江市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(530701,530700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530702,530700,'古城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530721,530700,'玉龙纳西族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530722,530700,'永胜县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530723,530700,'华坪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530724,530700,'宁蒗彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530800,530000,'普洱市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(530801,530800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530802,530800,'思茅区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530821,530800,'宁洱哈尼族彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530822,530800,'墨江哈尼族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530823,530800,'景东彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530824,530800,'景谷傣族彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530825,530800,'镇沅彝族哈尼族拉祜族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530826,530800,'江城哈尼族彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530827,530800,'孟连傣族拉祜族佤族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530828,530800,'澜沧拉祜族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530829,530800,'西盟佤族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530900,530000,'临沧市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(530901,530900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530902,530900,'临翔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530921,530900,'凤庆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530922,530900,'云县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530923,530900,'永德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530924,530900,'镇康县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530925,530900,'双江拉祜族佤族布朗族傣族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530926,530900,'耿马傣族佤族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(530927,530900,'沧源佤族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532300,530000,'楚雄彝族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(532301,532300,'楚雄市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532302,532300,'禄丰市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532322,532300,'双柏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532323,532300,'牟定县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532324,532300,'南华县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532325,532300,'姚安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532326,532300,'大姚县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532327,532300,'永仁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532328,532300,'元谋县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532329,532300,'武定县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532500,530000,'红河哈尼族彝族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(532501,532500,'个旧市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532502,532500,'开远市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532503,532500,'蒙自市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532504,532500,'弥勒市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532523,532500,'屏边苗族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532524,532500,'建水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532525,532500,'石屏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532527,532500,'泸西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532528,532500,'元阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532529,532500,'红河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532530,532500,'金平苗族瑶族傣族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532531,532500,'绿春县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532532,532500,'河口瑶族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532600,530000,'文山壮族苗族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(532601,532600,'文山市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532622,532600,'砚山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532623,532600,'西畴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532624,532600,'麻栗坡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532625,532600,'马关县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532626,532600,'丘北县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532627,532600,'广南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532628,532600,'富宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532800,530000,'西双版纳傣族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(532801,532800,'景洪市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532822,532800,'勐海县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532823,532800,'勐腊县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532900,530000,'大理白族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(532901,532900,'大理市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532922,532900,'漾濞彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532923,532900,'祥云县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532924,532900,'宾川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532925,532900,'弥渡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532926,532900,'南涧彝族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532927,532900,'巍山彝族回族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532928,532900,'永平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532929,532900,'云龙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532930,532900,'洱源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532931,532900,'剑川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(532932,532900,'鹤庆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533100,530000,'德宏傣族景颇族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(533102,533100,'瑞丽市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533103,533100,'芒市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533122,533100,'梁河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533123,533100,'盈江县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533124,533100,'陇川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533300,530000,'怒江傈僳族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(533301,533300,'泸水市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533323,533300,'福贡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533324,533300,'贡山独龙族怒族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533325,533300,'兰坪白族普米族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533400,530000,'迪庆藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(533401,533400,'香格里拉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533422,533400,'德钦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(533423,533400,'维西傈僳族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540000,1,'西藏自治区',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(540100,540000,'拉萨市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(540101,540100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540102,540100,'城关区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540103,540100,'堆龙德庆区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540104,540100,'达孜区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540121,540100,'林周县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540122,540100,'当雄县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540123,540100,'尼木县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540124,540100,'曲水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540127,540100,'墨竹工卡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540171,540100,'格尔木藏青工业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540172,540100,'拉萨经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540173,540100,'西藏文化旅游创意园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540174,540100,'达孜工业园区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540200,540000,'日喀则市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(540202,540200,'桑珠孜区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540221,540200,'南木林县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540222,540200,'江孜县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540223,540200,'定日县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540224,540200,'萨迦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540225,540200,'拉孜县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540226,540200,'昂仁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540227,540200,'谢通门县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540228,540200,'白朗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540229,540200,'仁布县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540230,540200,'康马县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540231,540200,'定结县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540232,540200,'仲巴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540233,540200,'亚东县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540234,540200,'吉隆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540235,540200,'聂拉木县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540236,540200,'萨嘎县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540237,540200,'岗巴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540300,540000,'昌都市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(540302,540300,'卡若区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540321,540300,'江达县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540322,540300,'贡觉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540323,540300,'类乌齐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540324,540300,'丁青县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540325,540300,'察雅县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540326,540300,'八宿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540327,540300,'左贡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540328,540300,'芒康县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540329,540300,'洛隆县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540330,540300,'边坝县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540400,540000,'林芝市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(540402,540400,'巴宜区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540421,540400,'工布江达县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540422,540400,'米林县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540423,540400,'墨脱县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540424,540400,'波密县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540425,540400,'察隅县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540426,540400,'朗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540500,540000,'山南市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(540501,540500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540502,540500,'乃东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540521,540500,'扎囊县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540522,540500,'贡嘎县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540523,540500,'桑日县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540524,540500,'琼结县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540525,540500,'曲松县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540526,540500,'措美县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540527,540500,'洛扎县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540528,540500,'加查县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540529,540500,'隆子县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540530,540500,'错那县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540531,540500,'浪卡子县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540600,540000,'那曲市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(540602,540600,'色尼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540621,540600,'嘉黎县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540622,540600,'比如县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540623,540600,'聂荣县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540624,540600,'安多县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540625,540600,'申扎县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540626,540600,'索县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540627,540600,'班戈县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540628,540600,'巴青县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540629,540600,'尼玛县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(540630,540600,'双湖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(542500,540000,'阿里地区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(542521,542500,'普兰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(542522,542500,'札达县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(542523,542500,'噶尔县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(542524,542500,'日土县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(542525,542500,'革吉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(542526,542500,'改则县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(542527,542500,'措勤县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610000,1,'陕西省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(610100,610000,'西安市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610101,610100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610102,610100,'新城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610103,610100,'碑林区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610104,610100,'莲湖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610111,610100,'灞桥区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610112,610100,'未央区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610113,610100,'雁塔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610114,610100,'阎良区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610115,610100,'临潼区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610116,610100,'长安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610117,610100,'高陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610118,610100,'鄠邑区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610122,610100,'蓝田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610124,610100,'周至县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610200,610000,'铜川市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610201,610200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610202,610200,'王益区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610203,610200,'印台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610204,610200,'耀州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610222,610200,'宜君县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610300,610000,'宝鸡市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610301,610300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610302,610300,'渭滨区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610303,610300,'金台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610304,610300,'陈仓区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610305,610300,'凤翔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610323,610300,'岐山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610324,610300,'扶风县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610326,610300,'眉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610327,610300,'陇县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610328,610300,'千阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610329,610300,'麟游县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610330,610300,'凤县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610331,610300,'太白县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610400,610000,'咸阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610401,610400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610402,610400,'秦都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610403,610400,'杨陵区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610404,610400,'渭城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610422,610400,'三原县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610423,610400,'泾阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610424,610400,'乾县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610425,610400,'礼泉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610426,610400,'永寿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610428,610400,'长武县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610429,610400,'旬邑县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610430,610400,'淳化县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610431,610400,'武功县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610481,610400,'兴平市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610482,610400,'彬州市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610500,610000,'渭南市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610501,610500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610502,610500,'临渭区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610503,610500,'华州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610522,610500,'潼关县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610523,610500,'大荔县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610524,610500,'合阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610525,610500,'澄城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610526,610500,'蒲城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610527,610500,'白水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610528,610500,'富平县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610581,610500,'韩城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610582,610500,'华阴市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610600,610000,'延安市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610601,610600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610602,610600,'宝塔区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610603,610600,'安塞区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610621,610600,'延长县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610622,610600,'延川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610625,610600,'志丹县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610626,610600,'吴起县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610627,610600,'甘泉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610628,610600,'富县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610629,610600,'洛川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610630,610600,'宜川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610631,610600,'黄龙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610632,610600,'黄陵县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610681,610600,'子长市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610700,610000,'汉中市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610701,610700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610702,610700,'汉台区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610703,610700,'南郑区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610722,610700,'城固县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610723,610700,'洋县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610724,610700,'西乡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610725,610700,'勉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610726,610700,'宁强县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610727,610700,'略阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610728,610700,'镇巴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610729,610700,'留坝县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610730,610700,'佛坪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610800,610000,'榆林市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610801,610800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610802,610800,'榆阳区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610803,610800,'横山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610822,610800,'府谷县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610824,610800,'靖边县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610825,610800,'定边县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610826,610800,'绥德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610827,610800,'米脂县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610828,610800,'佳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610829,610800,'吴堡县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610830,610800,'清涧县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610831,610800,'子洲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610881,610800,'神木市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610900,610000,'安康市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(610901,610900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610902,610900,'汉滨区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610921,610900,'汉阴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610922,610900,'石泉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610923,610900,'宁陕县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610924,610900,'紫阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610925,610900,'岚皋县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610926,610900,'平利县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610927,610900,'镇坪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610929,610900,'白河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(610981,610900,'旬阳市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(611000,610000,'商洛市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(611001,611000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(611002,611000,'商州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(611021,611000,'洛南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(611022,611000,'丹凤县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(611023,611000,'商南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(611024,611000,'山阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(611025,611000,'镇安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(611026,611000,'柞水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620000,1,'甘肃省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(620100,620000,'兰州市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620101,620100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620102,620100,'城关区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620103,620100,'七里河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620104,620100,'西固区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620105,620100,'安宁区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620111,620100,'红古区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620121,620100,'永登县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620122,620100,'皋兰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620123,620100,'榆中县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620171,620100,'兰州新区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620200,620000,'嘉峪关市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620201,620200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620300,620000,'金昌市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620301,620300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620302,620300,'金川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620321,620300,'永昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620400,620000,'白银市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620401,620400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620402,620400,'白银区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620403,620400,'平川区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620421,620400,'靖远县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620422,620400,'会宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620423,620400,'景泰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620500,620000,'天水市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620501,620500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620502,620500,'秦州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620503,620500,'麦积区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620521,620500,'清水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620522,620500,'秦安县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620523,620500,'甘谷县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620524,620500,'武山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620525,620500,'张家川回族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620600,620000,'武威市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620601,620600,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620602,620600,'凉州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620621,620600,'民勤县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620622,620600,'古浪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620623,620600,'天祝藏族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620700,620000,'张掖市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620701,620700,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620702,620700,'甘州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620721,620700,'肃南裕固族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620722,620700,'民乐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620723,620700,'临泽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620724,620700,'高台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620725,620700,'山丹县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620800,620000,'平凉市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620801,620800,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620802,620800,'崆峒区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620821,620800,'泾川县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620822,620800,'灵台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620823,620800,'崇信县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620825,620800,'庄浪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620826,620800,'静宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620881,620800,'华亭市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620900,620000,'酒泉市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(620901,620900,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620902,620900,'肃州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620921,620900,'金塔县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620922,620900,'瓜州县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620923,620900,'肃北蒙古族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620924,620900,'阿克塞哈萨克族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620981,620900,'玉门市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(620982,620900,'敦煌市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621000,620000,'庆阳市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(621001,621000,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621002,621000,'西峰区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621021,621000,'庆城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621022,621000,'环县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621023,621000,'华池县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621024,621000,'合水县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621025,621000,'正宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621026,621000,'宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621027,621000,'镇原县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621100,620000,'定西市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(621101,621100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621102,621100,'安定区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621121,621100,'通渭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621122,621100,'陇西县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621123,621100,'渭源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621124,621100,'临洮县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621125,621100,'漳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621126,621100,'岷县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621200,620000,'陇南市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(621201,621200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621202,621200,'武都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621221,621200,'成县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621222,621200,'文县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621223,621200,'宕昌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621224,621200,'康县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621225,621200,'西和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621226,621200,'礼县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621227,621200,'徽县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(621228,621200,'两当县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(622900,620000,'临夏回族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(622901,622900,'临夏市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(622921,622900,'临夏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(622922,622900,'康乐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(622923,622900,'永靖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(622924,622900,'广河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(622925,622900,'和政县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(622926,622900,'东乡族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(622927,622900,'积石山保安族东乡族撒拉族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(623000,620000,'甘南藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(623001,623000,'合作市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(623021,623000,'临潭县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(623022,623000,'卓尼县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(623023,623000,'舟曲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(623024,623000,'迭部县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(623025,623000,'玛曲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(623026,623000,'碌曲县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(623027,623000,'夏河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630000,1,'青海省',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(630100,630000,'西宁市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(630101,630100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630102,630100,'城东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630103,630100,'城中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630104,630100,'城西区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630105,630100,'城北区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630106,630100,'湟中区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630121,630100,'大通回族土族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630123,630100,'湟源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630200,630000,'海东市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(630202,630200,'乐都区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630203,630200,'平安区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630222,630200,'民和回族土族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630223,630200,'互助土族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630224,630200,'化隆回族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(630225,630200,'循化撒拉族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632200,630000,'海北藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(632221,632200,'门源回族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632222,632200,'祁连县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632223,632200,'海晏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632224,632200,'刚察县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632300,630000,'黄南藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(632301,632300,'同仁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632322,632300,'尖扎县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632323,632300,'泽库县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632324,632300,'河南蒙古族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632500,630000,'海南藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(632521,632500,'共和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632522,632500,'同德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632523,632500,'贵德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632524,632500,'兴海县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632525,632500,'贵南县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632600,630000,'果洛藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(632621,632600,'玛沁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632622,632600,'班玛县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632623,632600,'甘德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632624,632600,'达日县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632625,632600,'久治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632626,632600,'玛多县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632700,630000,'玉树藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(632701,632700,'玉树市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632722,632700,'杂多县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632723,632700,'称多县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632724,632700,'治多县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632725,632700,'囊谦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632726,632700,'曲麻莱县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632800,630000,'海西蒙古族藏族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(632801,632800,'格尔木市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632802,632800,'德令哈市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632803,632800,'茫崖市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632821,632800,'乌兰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632822,632800,'都兰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632823,632800,'天峻县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(632857,632800,'大柴旦行政委员会',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640000,1,'宁夏回族自治区',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(640100,640000,'银川市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(640101,640100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640104,640100,'兴庆区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640105,640100,'西夏区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640106,640100,'金凤区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640121,640100,'永宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640122,640100,'贺兰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640181,640100,'灵武市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640200,640000,'石嘴山市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(640201,640200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640202,640200,'大武口区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640205,640200,'惠农区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640221,640200,'平罗县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640300,640000,'吴忠市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(640301,640300,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640302,640300,'利通区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640303,640300,'红寺堡区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640323,640300,'盐池县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640324,640300,'同心县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640381,640300,'青铜峡市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640400,640000,'固原市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(640401,640400,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640402,640400,'原州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640422,640400,'西吉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640423,640400,'隆德县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640424,640400,'泾源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640425,640400,'彭阳县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640500,640000,'中卫市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(640501,640500,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640502,640500,'沙坡头区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640521,640500,'中宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(640522,640500,'海原县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650000,1,'新疆维吾尔自治区',1,'2022-11-09 10:07:58','2022-11-09 10:07:58'),
	(650100,650000,'乌鲁木齐市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(650101,650100,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650102,650100,'天山区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650103,650100,'沙依巴克区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650104,650100,'新市区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650105,650100,'水磨沟区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650106,650100,'头屯河区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650107,650100,'达坂城区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650109,650100,'米东区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650121,650100,'乌鲁木齐县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650200,650000,'克拉玛依市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(650201,650200,'市辖区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650202,650200,'独山子区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650203,650200,'克拉玛依区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650204,650200,'白碱滩区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650205,650200,'乌尔禾区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650400,650000,'吐鲁番市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(650402,650400,'高昌区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650421,650400,'鄯善县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650422,650400,'托克逊县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650500,650000,'哈密市',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(650502,650500,'伊州区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650521,650500,'巴里坤哈萨克自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(650522,650500,'伊吾县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652300,650000,'昌吉回族自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(652301,652300,'昌吉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652302,652300,'阜康市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652323,652300,'呼图壁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652324,652300,'玛纳斯县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652325,652300,'奇台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652327,652300,'吉木萨尔县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652328,652300,'木垒哈萨克自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652700,650000,'博尔塔拉蒙古自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(652701,652700,'博乐市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652702,652700,'阿拉山口市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652722,652700,'精河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652723,652700,'温泉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652800,650000,'巴音郭楞蒙古自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(652801,652800,'库尔勒市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652822,652800,'轮台县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652823,652800,'尉犁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652824,652800,'若羌县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652825,652800,'且末县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652826,652800,'焉耆回族自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652827,652800,'和静县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652828,652800,'和硕县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652829,652800,'博湖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652871,652800,'库尔勒经济技术开发区',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652900,650000,'阿克苏地区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(652901,652900,'阿克苏市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652902,652900,'库车市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652922,652900,'温宿县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652924,652900,'沙雅县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652925,652900,'新和县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652926,652900,'拜城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652927,652900,'乌什县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652928,652900,'阿瓦提县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(652929,652900,'柯坪县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653000,650000,'克孜勒苏柯尔克孜自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(653001,653000,'阿图什市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653022,653000,'阿克陶县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653023,653000,'阿合奇县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653024,653000,'乌恰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653100,650000,'喀什地区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(653101,653100,'喀什市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653121,653100,'疏附县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653122,653100,'疏勒县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653123,653100,'英吉沙县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653124,653100,'泽普县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653125,653100,'莎车县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653126,653100,'叶城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653127,653100,'麦盖提县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653128,653100,'岳普湖县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653129,653100,'伽师县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653130,653100,'巴楚县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653131,653100,'塔什库尔干塔吉克自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653200,650000,'和田地区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(653201,653200,'和田市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653221,653200,'和田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653222,653200,'墨玉县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653223,653200,'皮山县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653224,653200,'洛浦县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653225,653200,'策勒县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653226,653200,'于田县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(653227,653200,'民丰县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654000,650000,'伊犁哈萨克自治州',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(654002,654000,'伊宁市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654003,654000,'奎屯市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654004,654000,'霍尔果斯市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654021,654000,'伊宁县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654022,654000,'察布查尔锡伯自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654023,654000,'霍城县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654024,654000,'巩留县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654025,654000,'新源县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654026,654000,'昭苏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654027,654000,'特克斯县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654028,654000,'尼勒克县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654200,650000,'塔城地区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(654201,654200,'塔城市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654202,654200,'乌苏市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654203,654200,'沙湾市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654221,654200,'额敏县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654224,654200,'托里县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654225,654200,'裕民县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654226,654200,'和布克赛尔蒙古自治县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654300,650000,'阿勒泰地区',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(654301,654300,'阿勒泰市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654321,654300,'布尔津县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654322,654300,'富蕴县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654323,654300,'福海县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654324,654300,'哈巴河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654325,654300,'青河县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(654326,654300,'吉木乃县',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659000,650000,'自治区直辖县级行政区划',2,'2022-11-09 10:07:58','2022-11-09 10:19:44'),
	(659001,659000,'石河子市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659002,659000,'阿拉尔市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18');

INSERT INTO `eb_city_region` (`region_id`, `parent_id`, `region_name`, `region_type`, `create_time`, `update_time`)
VALUES
	(659003,659000,'图木舒克市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659004,659000,'五家渠市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659005,659000,'北屯市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659006,659000,'铁门关市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659007,659000,'双河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659008,659000,'可克达拉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659009,659000,'昆玉市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659010,659000,'胡杨河市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(659011,659000,'新星市',3,'2022-11-09 10:32:31','2022-11-09 11:06:18'),
	(110101001,110101,'东华门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101002,110101,'景山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101003,110101,'交道口街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101004,110101,'安定门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101005,110101,'北新桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101006,110101,'东四街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101007,110101,'朝阳门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101008,110101,'建国门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101009,110101,'东直门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101010,110101,'和平里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101011,110101,'前门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101012,110101,'崇文门外街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101013,110101,'东花市街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101014,110101,'龙潭街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101015,110101,'体育馆路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101016,110101,'天坛街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110101017,110101,'永定门外街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102001,110102,'西长安街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102003,110102,'新街口街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102007,110102,'月坛街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102009,110102,'展览路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102010,110102,'德胜街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102011,110102,'金融街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102012,110102,'什刹海街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102013,110102,'大栅栏街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102014,110102,'天桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102015,110102,'椿树街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102016,110102,'陶然亭街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102017,110102,'广安门内街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102018,110102,'牛街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102019,110102,'白纸坊街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110102020,110102,'广安门外街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105001,110105,'建外街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105002,110105,'朝外街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105003,110105,'呼家楼街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105004,110105,'三里屯街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105005,110105,'左家庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105006,110105,'香河园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105007,110105,'和平街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105008,110105,'安贞街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105009,110105,'亚运村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105010,110105,'小关街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105011,110105,'酒仙桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105012,110105,'麦子店街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105013,110105,'团结湖街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105014,110105,'六里屯街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105015,110105,'八里庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105016,110105,'双井街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105017,110105,'劲松街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105018,110105,'潘家园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105019,110105,'垡头街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105021,110105,'南磨房地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105022,110105,'高碑店地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105023,110105,'将台地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105024,110105,'太阳宫地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105025,110105,'大屯街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105026,110105,'望京街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105027,110105,'小红门地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105028,110105,'十八里店地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105029,110105,'平房地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105030,110105,'东风地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105031,110105,'奥运村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105032,110105,'来广营地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105033,110105,'常营地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105034,110105,'三间房地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105035,110105,'管庄地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105036,110105,'金盏地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105037,110105,'孙河地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105038,110105,'崔各庄地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105039,110105,'东坝地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105040,110105,'黑庄户地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105041,110105,'豆各庄地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105042,110105,'王四营地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105043,110105,'东湖街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110105400,110105,'首都机场街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106001,110106,'右安门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106002,110106,'太平桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106003,110106,'西罗园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106004,110106,'大红门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106005,110106,'南苑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106006,110106,'东高地街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106007,110106,'东铁匠营街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106008,110106,'六里桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106009,110106,'丰台街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106010,110106,'新村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106011,110106,'长辛店街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106012,110106,'云岗街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106013,110106,'方庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106014,110106,'宛平街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106015,110106,'马家堡街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106016,110106,'和义街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106017,110106,'卢沟桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106018,110106,'花乡街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106020,110106,'成寿寺街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106021,110106,'石榴庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106022,110106,'玉泉营街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106023,110106,'看丹街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106024,110106,'五里店街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106025,110106,'青塔街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106100,110106,'北宫镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110106101,110106,'王佐镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107001,110107,'八宝山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107002,110107,'老山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107003,110107,'八角街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107004,110107,'古城街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107005,110107,'苹果园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107006,110107,'金顶街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107009,110107,'广宁街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107010,110107,'五里坨街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110107011,110107,'鲁谷街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108001,110108,'万寿路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108002,110108,'永定路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108003,110108,'羊坊店街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108004,110108,'甘家口街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108005,110108,'八里庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108006,110108,'紫竹院街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108007,110108,'北下关街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108008,110108,'北太平庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108010,110108,'学院路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108011,110108,'中关村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108012,110108,'海淀街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108013,110108,'青龙桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108014,110108,'清华园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108015,110108,'燕园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108016,110108,'香山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108017,110108,'清河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108018,110108,'花园路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108019,110108,'西三旗街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108020,110108,'马连洼街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108021,110108,'田村路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108022,110108,'上地街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108023,110108,'万柳地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108024,110108,'东升地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108025,110108,'曙光街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108026,110108,'温泉地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108027,110108,'四季青地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108028,110108,'西北旺地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108029,110108,'苏家坨地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110108030,110108,'上庄地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109001,110109,'大峪街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109002,110109,'城子街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109003,110109,'东辛房街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109004,110109,'大台街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109005,110109,'王平地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109006,110109,'永定地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109007,110109,'龙泉地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109101,110109,'潭柘寺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109104,110109,'军庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109105,110109,'雁翅镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109106,110109,'斋堂镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109107,110109,'清水镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110109108,110109,'妙峰山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111001,110111,'城关街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111002,110111,'新镇街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111004,110111,'向阳街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111005,110111,'东风街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111006,110111,'迎风街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111007,110111,'星城街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111008,110111,'良乡地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111009,110111,'周口店地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111010,110111,'琉璃河地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111011,110111,'拱辰街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111012,110111,'西潞街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111101,110111,'阎村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111103,110111,'窦店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111104,110111,'石楼镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111105,110111,'长阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111107,110111,'河北镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111108,110111,'长沟镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111109,110111,'大石窝镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111110,110111,'张坊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111111,110111,'十渡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111112,110111,'青龙湖镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111115,110111,'韩村河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111208,110111,'霞云岭乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111209,110111,'南窖乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111210,110111,'佛子庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111211,110111,'大安山乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111212,110111,'史家营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110111213,110111,'蒲洼乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112001,110112,'中仓街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112002,110112,'新华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112003,110112,'北苑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112004,110112,'玉桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112007,110112,'潞源街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112008,110112,'通运街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112009,110112,'文景街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112010,110112,'九棵树街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112011,110112,'临河里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112012,110112,'杨庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112013,110112,'潞邑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112104,110112,'宋庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112105,110112,'张家湾镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112106,110112,'漷县镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112109,110112,'马驹桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112110,110112,'西集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112114,110112,'台湖镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112117,110112,'永乐店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112119,110112,'潞城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112120,110112,'永顺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112121,110112,'梨园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110112209,110112,'于家务回族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113001,110113,'胜利街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113002,110113,'光明街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113003,110113,'仁和地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113004,110113,'后沙峪地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113005,110113,'天竺地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113006,110113,'杨镇地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113007,110113,'牛栏山地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113008,110113,'南法信地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113009,110113,'马坡地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113010,110113,'石园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113011,110113,'空港街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113012,110113,'双丰街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113013,110113,'旺泉街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113101,110113,'高丽营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113104,110113,'李桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113105,110113,'李遂镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113106,110113,'南彩镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113108,110113,'北务镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113109,110113,'大孙各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113110,110113,'张镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113111,110113,'龙湾屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113112,110113,'木林镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113113,110113,'北小营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113115,110113,'北石槽镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110113116,110113,'赵全营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114001,110114,'城北街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114002,110114,'南口地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114003,110114,'马池口地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114004,110114,'沙河地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114005,110114,'城南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114007,110114,'东小口地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114008,110114,'天通苑北街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114009,110114,'天通苑南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114010,110114,'霍营街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114011,110114,'回龙观街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114012,110114,'龙泽园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114013,110114,'史各庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114104,110114,'阳坊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114110,110114,'小汤山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114111,110114,'南邵镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114112,110114,'崔村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114113,110114,'百善镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114115,110114,'北七家镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114116,110114,'兴寿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114118,110114,'流村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114119,110114,'十三陵镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110114120,110114,'延寿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115001,110115,'兴丰街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115002,110115,'林校路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115003,110115,'清源街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115004,110115,'亦庄地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115005,110115,'黄村地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115006,110115,'旧宫地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115007,110115,'西红门地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115008,110115,'瀛海地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115009,110115,'观音寺街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115010,110115,'天宫院街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115011,110115,'高米店街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115012,110115,'荣华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115013,110115,'博兴街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115103,110115,'青云店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115104,110115,'采育镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115105,110115,'安定镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115106,110115,'礼贤镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115107,110115,'榆垡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115108,110115,'庞各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115109,110115,'北臧村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115110,110115,'魏善庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115111,110115,'长子营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115403,110115,'北京经济技术开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115404,110115,'中关村国家自主创新示范区大兴生物医药产业基地',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115405,110115,'国家新媒体产业基地',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110115406,110115,'大兴国际机场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116001,110116,'泉河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116002,110116,'龙山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116003,110116,'怀柔地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116004,110116,'雁栖地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116005,110116,'庙城地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116102,110116,'北房镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116103,110116,'杨宋镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116105,110116,'桥梓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116106,110116,'怀北镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116107,110116,'汤河口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116108,110116,'渤海镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116109,110116,'九渡河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116110,110116,'琉璃庙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116111,110116,'宝山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116211,110116,'长哨营满族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116213,110116,'喇叭沟门满族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110116400,110116,'北京雁栖经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117001,110117,'滨河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117002,110117,'兴谷街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117003,110117,'渔阳地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117004,110117,'峪口地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117005,110117,'马坊地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117006,110117,'金海湖地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117101,110117,'东高村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117102,110117,'山东庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117104,110117,'南独乐河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117105,110117,'大华山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117106,110117,'夏各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117108,110117,'马昌营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117110,110117,'王辛庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117111,110117,'大兴庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117112,110117,'刘家店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117114,110117,'镇罗营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117213,110117,'黄松峪乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110117214,110117,'熊儿寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118001,110118,'鼓楼街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118002,110118,'果园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118003,110118,'檀营地区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118100,110118,'密云镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118101,110118,'溪翁庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118102,110118,'西田各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118103,110118,'十里堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118104,110118,'河南寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118105,110118,'巨各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118106,110118,'穆家峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118107,110118,'太师屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118108,110118,'高岭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118109,110118,'不老屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118110,110118,'冯家峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118111,110118,'古北口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118112,110118,'大城子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118113,110118,'东邵渠镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118114,110118,'北庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118115,110118,'新城子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118116,110118,'石城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110118400,110118,'中关村科技园区密云园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119001,110119,'百泉街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119002,110119,'香水园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119003,110119,'儒林街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119100,110119,'延庆镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119101,110119,'康庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119102,110119,'八达岭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119103,110119,'永宁镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119104,110119,'旧县镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119105,110119,'张山营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119106,110119,'四海镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119107,110119,'千家店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119108,110119,'沈家营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119109,110119,'大榆树镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119110,110119,'井庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119200,110119,'大庄科乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119201,110119,'刘斌堡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119202,110119,'香营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(110119203,110119,'珍珠泉乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120101001,120101,'劝业场街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120101002,120101,'小白楼街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120101003,120101,'五大道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120101004,120101,'新兴街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120101005,120101,'南营门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120101006,120101,'南市街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102001,120102,'大王庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102002,120102,'大直沽街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102003,120102,'中山门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102004,120102,'富民路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102005,120102,'二号桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102006,120102,'春华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102007,120102,'唐家口街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102008,120102,'向阳楼街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102009,120102,'常州道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102010,120102,'上杭路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102011,120102,'东新街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102012,120102,'鲁山道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120102013,120102,'天津铁厂街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103001,120103,'大营门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103002,120103,'下瓦房街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103003,120103,'桃园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103004,120103,'挂甲寺街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103005,120103,'马场街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103006,120103,'越秀路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103007,120103,'友谊路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103008,120103,'天塔街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103009,120103,'尖山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103010,120103,'陈塘庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103011,120103,'柳林街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103012,120103,'东海街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103013,120103,'梅江街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120103014,120103,'太湖路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104001,120104,'长虹街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104002,120104,'鼓楼街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104003,120104,'兴南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104004,120104,'广开街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104005,120104,'万兴街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104006,120104,'学府街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104007,120104,'向阳路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104008,120104,'嘉陵道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104009,120104,'王顶堤街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104010,120104,'水上公园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104011,120104,'体育中心街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120104012,120104,'华苑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105001,120105,'光复道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105002,120105,'望海楼街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105003,120105,'鸿顺里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105004,120105,'新开河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105005,120105,'铁东路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105006,120105,'建昌道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105007,120105,'宁园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105008,120105,'王串场街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105009,120105,'江都路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120105010,120105,'月牙河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106001,120106,'西于庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106003,120106,'咸阳北路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106004,120106,'丁字沽街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106005,120106,'西沽街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106006,120106,'三条石街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106008,120106,'邵公庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106009,120106,'芥园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106010,120106,'铃铛阁街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120106012,120106,'和苑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110001,120110,'张贵庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110002,120110,'丰年村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110003,120110,'万新街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110004,120110,'无瑕街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110005,120110,'新立街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110006,120110,'华明街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110007,120110,'金钟街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110008,120110,'军粮城街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110009,120110,'金桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110010,120110,'华新街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110011,120110,'东丽湖街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110400,120110,'天津经济技术开发区西区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110401,120110,'天津航空物流区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110402,120110,'天津空港经济区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110403,120110,'东丽区经济技术开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110405,120110,'综合保税区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110406,120110,'航空新城',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120110407,120110,'服务滨海新区建设管理委员会',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111001,120111,'西营门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111002,120111,'李七庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111003,120111,'赤龙南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111005,120111,'津门湖街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111100,120111,'中北镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111101,120111,'杨柳青镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111102,120111,'辛口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111103,120111,'张家窝镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111104,120111,'精武镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111105,120111,'大寺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111106,120111,'王稳庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111400,120111,'天津经济技术开发区微电子小区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111401,120111,'新技术产业园区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120111450,120111,'西青区开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112001,120112,'双新街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112002,120112,'双林街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112003,120112,'海棠街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112100,120112,'咸水沽镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112101,120112,'葛沽镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112102,120112,'小站镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112103,120112,'双港镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112104,120112,'辛庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112106,120112,'双桥河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112107,120112,'八里台镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112108,120112,'北闸口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112403,120112,'长青办事处',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112404,120112,'津南开发区东区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112405,120112,'津南开发区西区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120112501,120112,'津南国家农业园区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113001,120113,'果园新村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113002,120113,'集贤里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113003,120113,'普东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113004,120113,'瑞景街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113005,120113,'佳荣里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113006,120113,'青源街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113007,120113,'广源街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113008,120113,'双环邨街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113100,120113,'天穆镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113101,120113,'北仓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113102,120113,'双街镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113103,120113,'双口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113104,120113,'青光镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113106,120113,'宜兴埠镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113107,120113,'小淀镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113108,120113,'大张庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113111,120113,'西堤头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113400,120113,'科技园区北区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113401,120113,'科技园区南区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113402,120113,'天津医药医疗器械工业园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113403,120113,'天津陆路港物流装备产业园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113404,120113,'天津风电产业园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113500,120113,'红旗农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120113501,120113,'曙光农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114001,120114,'杨村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114002,120114,'下朱庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114003,120114,'东蒲洼街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114004,120114,'黄庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114005,120114,'徐官屯街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114006,120114,'运河西街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114101,120114,'梅厂镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114102,120114,'大碱厂镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114103,120114,'崔黄口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114104,120114,'大良镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114105,120114,'下伍旗镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114106,120114,'南蔡村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114107,120114,'大孟庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114108,120114,'泗村店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114109,120114,'河西务镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114110,120114,'城关镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114111,120114,'东马圈镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114112,120114,'黄花店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114113,120114,'石各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114114,120114,'王庆坨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114115,120114,'汊沽港镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114116,120114,'河北屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114117,120114,'上马台镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114118,120114,'大王古庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114119,120114,'陈咀镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114120,120114,'豆张庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114121,120114,'曹子里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114122,120114,'大黄堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114123,120114,'高村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114124,120114,'白古屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114400,120114,'天津经济技术开发区逸仙科学工业园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114401,120114,'武清经济技术开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114403,120114,'天津京滨工业园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114404,120114,'天津京津电子商务产业园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114405,120114,'天津武清汽车产业园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114406,120114,'天津京津科技谷',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120114407,120114,'京津高村科技创新园',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115001,120115,'海滨街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115002,120115,'宝平街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115003,120115,'钰华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115006,120115,'周良街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115007,120115,'潮阳街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115008,120115,'朝霞街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115101,120115,'大口屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115103,120115,'王卜庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115104,120115,'方家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115105,120115,'林亭口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115106,120115,'八门城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115107,120115,'大钟庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115108,120115,'新安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115111,120115,'霍各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115113,120115,'新开口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115115,120115,'大唐庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115119,120115,'牛道口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115120,120115,'史各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115121,120115,'郝各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115123,120115,'牛家牌镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115124,120115,'尔王庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115125,120115,'黄庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115126,120115,'口东镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115127,120115,'大白庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115456,120115,'宝坻经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120115457,120115,'京津中关村科技城',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116001,120116,'塘沽街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116005,120116,'杭州道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116006,120116,'新河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116007,120116,'大沽街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116008,120116,'新北街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116009,120116,'北塘街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116011,120116,'胡家园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116012,120116,'新港街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116013,120116,'新村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116014,120116,'天津经济技术开发区东区泰达街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116031,120116,'汉沽街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116032,120116,'寨上街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116033,120116,'茶淀街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116051,120116,'大港街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116053,120116,'古林街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116054,120116,'海滨街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116100,120116,'新城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116135,120116,'杨家泊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116156,120116,'太平镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116157,120116,'小王庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116158,120116,'中塘镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116400,120116,'天津经济技术开发区（其他片区）',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116401,120116,'天津港保税区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116402,120116,'天津滨海新区高新技术产业开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116403,120116,'东疆保税港区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120116406,120116,'中新天津生态城',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117001,120117,'芦台街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117002,120117,'桥北街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117102,120117,'宁河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117103,120117,'苗庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117104,120117,'丰台镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117105,120117,'岳龙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117106,120117,'板桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117107,120117,'潘庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117109,120117,'造甲城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117110,120117,'七里海镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117111,120117,'大北涧沽镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117112,120117,'东棘坨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117113,120117,'北淮淀镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117114,120117,'俵口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117115,120117,'廉庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117400,120117,'宁河区贸易开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117401,120117,'宁河区经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117402,120117,'天津未来科技城天津经济技术开发区片区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117403,120117,'天津未来科技城滨海高新区片区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117451,120117,'天津未来科技城宁河片区现代产业区组团',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117452,120117,'天津未来科技城宁河片区潘庄工业区组团',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120117453,120117,'天津未来科技城宁河片区北淮淀组团',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118001,120118,'华康街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118002,120118,'朝阳街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118100,120118,'静海镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118101,120118,'唐官屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118102,120118,'独流镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118103,120118,'王口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118104,120118,'台头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118105,120118,'子牙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118106,120118,'陈官屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118107,120118,'中旺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118108,120118,'大邱庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118109,120118,'蔡公庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118110,120118,'梁头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118111,120118,'团泊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118112,120118,'双塘镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118113,120118,'大丰堆镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118114,120118,'沿庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118115,120118,'西翟庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118200,120118,'良王庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118201,120118,'杨成庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118400,120118,'天津静海经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118402,120118,'天津子牙循环经济产业区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120118403,120118,'团泊新城',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119001,120119,'文昌街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119100,120119,'渔阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119101,120119,'洇溜镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119102,120119,'官庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119103,120119,'马伸桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119104,120119,'下营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119105,120119,'邦均镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119106,120119,'别山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119108,120119,'尤古庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119109,120119,'上仓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119111,120119,'下仓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119112,120119,'罗庄子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119113,120119,'白涧镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119115,120119,'侯家营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119116,120119,'桑梓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119117,120119,'东施古镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119118,120119,'下窝头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119119,120119,'杨津庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119120,120119,'出头岭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119121,120119,'西龙虎峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119122,120119,'穿芳峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119123,120119,'东二营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119124,120119,'许家台镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119125,120119,'礼明庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119126,120119,'东赵各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119127,120119,'州河湾镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119203,120119,'孙各庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(120119401,120119,'天津市蓟州区京津州河科技产业园管理委员会',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102001,130102,'建北街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102002,130102,'青园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102003,130102,'广安街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102004,130102,'育才街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102005,130102,'跃进街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102007,130102,'河东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102010,130102,'长丰街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102011,130102,'谈固街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102012,130102,'中山东路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102013,130102,'阜康街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102014,130102,'建安街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102015,130102,'胜利北街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102100,130102,'西兆通镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102101,130102,'南村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102102,130102,'高营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130102103,130102,'桃园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104001,130104,'东里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104002,130104,'中山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104004,130104,'南长街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104005,130104,'维明街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104007,130104,'友谊街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104008,130104,'红旗街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104009,130104,'新石街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104010,130104,'苑东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104011,130104,'西里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104012,130104,'振头街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104013,130104,'留营街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104014,130104,'长兴街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104015,130104,'彭后街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104016,130104,'东风街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104017,130104,'东华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104018,130104,'休门街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130104019,130104,'汇通街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105001,130105,'革新街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105003,130105,'新华路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105004,130105,'宁安街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105005,130105,'东焦街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105006,130105,'西苑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105007,130105,'合作路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105008,130105,'联盟街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105009,130105,'石岗街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105011,130105,'天苑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105012,130105,'北苑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105013,130105,'赵陵铺路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105014,130105,'西三庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105015,130105,'大郭街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105016,130105,'杜北街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130105017,130105,'赵佗路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130107001,130107,'矿市街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130107002,130107,'四微街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130107100,130107,'贾庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130107101,130107,'凤山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130107200,130107,'横涧乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108001,130108,'裕兴街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108002,130108,'裕强街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108003,130108,'东苑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108004,130108,'建通街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108005,130108,'槐底街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108006,130108,'裕华路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108007,130108,'裕东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108008,130108,'裕翔街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108009,130108,'建华南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130108101,130108,'方村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109100,130109,'廉州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109101,130109,'兴安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109102,130109,'贾市庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109103,130109,'南营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109104,130109,'梅花镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109105,130109,'岗上镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109107,130109,'南董镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109108,130109,'张家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109109,130109,'南孟镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109110,130109,'增村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109111,130109,'常安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109112,130109,'西关镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109200,130109,'九门回族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130109500,130109,'石家庄经济技术开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110100,130110,'获鹿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110101,130110,'铜冶镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110102,130110,'寺家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110103,130110,'上庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110104,130110,'李村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110105,130110,'宜安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110106,130110,'黄壁庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110107,130110,'大河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110108,130110,'山尹村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110200,130110,'石井乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110201,130110,'白鹿泉乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110202,130110,'上寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130110500,130110,'河北鹿泉经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130111100,130111,'栾城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130111103,130111,'冶河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130111104,130111,'窦妪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130111105,130111,'楼底镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130111200,130111,'南高乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130111201,130111,'柳林屯乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130111202,130111,'西营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121100,130121,'微水镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121101,130121,'上安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121102,130121,'天长镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121103,130121,'秀林镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121104,130121,'南峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121105,130121,'威州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121106,130121,'小作镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121107,130121,'南障城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121108,130121,'苍岩山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121109,130121,'测鱼镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121200,130121,'吴家窑乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121201,130121,'北正乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121202,130121,'于家乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121203,130121,'孙庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121204,130121,'南陉乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121205,130121,'辛庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130121206,130121,'南王庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123001,130123,'诸福屯街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123002,130123,'三里屯街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123100,130123,'正定镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123102,130123,'新城铺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123103,130123,'新安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123104,130123,'南岗镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123105,130123,'曲阳桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123200,130123,'南牛乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123201,130123,'南楼乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130123202,130123,'西平乐乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125100,130125,'龙州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125101,130125,'南桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125102,130125,'上碑镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125103,130125,'口头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125200,130125,'独羊岗乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125201,130125,'安香乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125202,130125,'只里乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125203,130125,'市同乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125204,130125,'翟营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125205,130125,'城寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125206,130125,'上方乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125207,130125,'玉亭乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125208,130125,'北河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125209,130125,'上闫庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125210,130125,'九口子乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130125400,130125,'开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126100,130126,'灵寿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126101,130126,'青同镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126102,130126,'塔上镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126103,130126,'陈庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126104,130126,'慈峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126105,130126,'岔头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126200,130126,'三圣院乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126201,130126,'北洼乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126202,130126,'牛城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126203,130126,'狗台乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126204,130126,'南寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126205,130126,'南燕川乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126206,130126,'北谭庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126207,130126,'寨头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130126208,130126,'南营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130127100,130127,'高邑镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130127101,130127,'大营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130127102,130127,'富村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130127103,130127,'万城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130127104,130127,'中韩镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130128100,130128,'深泽镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130128101,130128,'铁杆镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130128102,130128,'赵八镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130128103,130128,'大桥头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130128200,130128,'白庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130128201,130128,'留村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129100,130129,'赞皇镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129101,130129,'院头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129102,130129,'南邢郭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129103,130129,'嶂石岩镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129200,130129,'西龙门乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129202,130129,'南清河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129203,130129,'西阳泽乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129204,130129,'土门乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129205,130129,'黄北坪乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129207,130129,'许亭乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130129208,130129,'张楞乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130100,130130,'无极镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130101,130130,'七汲镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130102,130130,'张段固镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130103,130130,'北苏镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130104,130130,'郭庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130105,130130,'大陈镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130200,130130,'高头回族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130201,130130,'郝庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130202,130130,'东侯坊乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130203,130130,'里城道乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130130204,130130,'南流乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131100,130131,'平山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131101,130131,'东回舍镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131102,130131,'温塘镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131103,130131,'南甸镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131104,130131,'岗南镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131105,130131,'古月镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131106,130131,'下槐镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131107,130131,'孟家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131108,130131,'小觉镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131109,130131,'蛟潭庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131110,130131,'西柏坡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131111,130131,'下口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131200,130131,'西大吾乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131201,130131,'上三汲乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131202,130131,'两河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131203,130131,'东王坡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131204,130131,'苏家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131205,130131,'宅北乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131207,130131,'北冶乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131209,130131,'上观音堂乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131210,130131,'杨家桥乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131211,130131,'营里乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130131212,130131,'合河口乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132001,130132,'城区街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132100,130132,'槐阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132101,130132,'殷村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132102,130132,'南佐镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132103,130132,'宋曹镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132104,130132,'南因镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132105,130132,'姬村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132106,130132,'北褚镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132107,130132,'马村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132201,130132,'东张乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132202,130132,'赵同乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132204,130132,'苏村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132205,130132,'苏阳乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132206,130132,'北正乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132207,130132,'前仙乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130132208,130132,'黑水河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133100,130133,'赵州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133101,130133,'范庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133102,130133,'北王里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133103,130133,'新寨店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133104,130133,'韩村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133105,130133,'南柏舍镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133106,130133,'沙河店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133107,130133,'王西章镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133200,130133,'前大章乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133201,130133,'谢庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130133202,130133,'高村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130171010,130171,'长江街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130171011,130171,'太行街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130171100,130171,'宋营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130171101,130171,'郄马镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130172100,130172,'丘头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181100,130181,'辛集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181101,130181,'旧城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181102,130181,'张古庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181103,130181,'位伯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181104,130181,'新垒头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181105,130181,'新城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181106,130181,'南智邱镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181107,130181,'王口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181200,130181,'天宫营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181201,130181,'前营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181202,130181,'马庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181203,130181,'和睦井乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181204,130181,'田家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181205,130181,'中里厢乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181206,130181,'小辛庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130181500,130181,'辛集经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183100,130183,'晋州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183101,130183,'总十庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183102,130183,'营里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183103,130183,'桃园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183104,130183,'东卓宿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183105,130183,'马于镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183106,130183,'小樵镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183107,130183,'槐树镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183108,130183,'东里庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130183201,130183,'周家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184001,130184,'长寿街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184101,130184,'化皮镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184102,130184,'承安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184103,130184,'正莫镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184104,130184,'南大岳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184105,130184,'杜固镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184106,130184,'邯邰镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184107,130184,'东王镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184108,130184,'马头铺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184200,130184,'协神乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184201,130184,'木村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130184202,130184,'彭家庄回族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202001,130202,'学院南路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202002,130202,'友谊街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202003,130202,'广场街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202004,130202,'永红桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202005,130202,'小山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202006,130202,'文化北后街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202007,130202,'钱家营矿区街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202008,130202,'惠民道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202009,130202,'梁家屯路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202102,130202,'稻地镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130202200,130202,'女织寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203001,130203,'乔屯街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203002,130203,'文化路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203003,130203,'钓鱼台街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203004,130203,'东新村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203005,130203,'缸窑街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203006,130203,'机场路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203007,130203,'河北路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203008,130203,'龙东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203009,130203,'大里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203010,130203,'光明街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203011,130203,'翔云道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203100,130203,'韩城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130203101,130203,'果园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204001,130204,'林西街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204002,130204,'唐家庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204003,130204,'古冶街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204004,130204,'赵各庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204007,130204,'京华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204100,130204,'范各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204101,130204,'卑家店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204201,130204,'王辇庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204202,130204,'习家套乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130204203,130204,'大庄坨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205001,130205,'马家沟街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205002,130205,'开平街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205003,130205,'税务庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205005,130205,'陡电街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205006,130205,'荆各庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205100,130205,'开平镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205101,130205,'栗园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205102,130205,'郑庄子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205103,130205,'双桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205104,130205,'洼里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130205105,130205,'越河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207103,130207,'小集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207104,130207,'黄各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207105,130207,'西葛镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207106,130207,'大新庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207107,130207,'钱营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207108,130207,'唐坊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207109,130207,'王兰庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207110,130207,'柳树瞿阝镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207111,130207,'黑沿子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207113,130207,'胥各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207114,130207,'大齐各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207115,130207,'岔河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207201,130207,'南孙庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207202,130207,'东田庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130207203,130207,'尖字沽乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208001,130208,'太平路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208002,130208,'燕山路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208003,130208,'浭阳街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208100,130208,'丰润镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208102,130208,'任各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208103,130208,'左家坞镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208104,130208,'泉河头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208105,130208,'王官营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208106,130208,'火石营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208109,130208,'新军屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208110,130208,'小张各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208111,130208,'丰登坞镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208112,130208,'李钊庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208113,130208,'白官屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208114,130208,'石各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208115,130208,'沙流河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208116,130208,'七树庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208117,130208,'杨官林镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208118,130208,'银城铺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208119,130208,'常庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208202,130208,'姜家营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208205,130208,'欢喜庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130208208,130208,'刘家营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209100,130209,'唐海镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209112,130209,'滨海镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209113,130209,'柳赞镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209401,130209,'一农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209403,130209,'三农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209404,130209,'四农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209405,130209,'五农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209406,130209,'六农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209407,130209,'七农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209408,130209,'八农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209409,130209,'九农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209410,130209,'十农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209411,130209,'十一农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209412,130209,'八里滩养殖场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209413,130209,'十里海养殖场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209450,130209,'南堡经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209451,130209,'曹妃甸工业区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130209452,130209,'曹妃甸新城',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224001,130224,'友谊路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224100,130224,'倴城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224101,130224,'宋道口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224102,130224,'长凝镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224103,130224,'胡各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224104,130224,'坨里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224105,130224,'姚王庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224106,130224,'司各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224107,130224,'安各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224108,130224,'扒齿港镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224109,130224,'程庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224110,130224,'青坨营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224111,130224,'柏各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224114,130224,'南堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224115,130224,'方各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224116,130224,'东黄坨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130224117,130224,'马城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225001,130225,'乐安街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225100,130225,'乐亭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225101,130225,'汤家河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225102,130225,'胡家坨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225104,130225,'闫各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225105,130225,'马头营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225106,130225,'新寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225107,130225,'汀流河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225108,130225,'姜各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225109,130225,'毛庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225110,130225,'中堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225111,130225,'大相各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225201,130225,'庞各庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225203,130225,'古河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225453,130225,'河北乐亭经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130225454,130225,'乐亭县城区工业聚集区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227001,130227,'栗乡街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227100,130227,'兴城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227101,130227,'金厂峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227102,130227,'洒河桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227103,130227,'太平寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227104,130227,'罗家屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227105,130227,'东荒峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227106,130227,'新集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227107,130227,'三屯营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227108,130227,'滦阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227109,130227,'汉儿庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227110,130227,'新庄子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227111,130227,'东莲花院镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227200,130227,'白庙子乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227201,130227,'上营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227203,130227,'渔户寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227204,130227,'旧城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227205,130227,'尹庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130227450,130227,'栗乡工业产业聚集区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229001,130229,'无终街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229100,130229,'玉田镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229101,130229,'亮甲店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229102,130229,'鸦鸿桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229103,130229,'窝洛沽镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229104,130229,'石臼窝镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229105,130229,'虹桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229106,130229,'散水头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229107,130229,'林南仓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229108,130229,'林西镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229109,130229,'杨家板桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229110,130229,'彩亭桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229111,130229,'孤树镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229112,130229,'大安镇镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229113,130229,'唐自头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229114,130229,'郭家屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229115,130229,'杨家套镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229116,130229,'陈家铺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229201,130229,'林头屯乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229203,130229,'潮洛窝乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229205,130229,'郭家桥乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229400,130229,'河北玉田经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130229401,130229,'河北唐山国家农业科技园区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130271100,130271,'海北镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130271450,130271,'新华路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130272101,130272,'汉丰镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130272451,130272,'兴农街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130272452,130272,'振兴街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130273001,130273,'街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130273101,130273,'老庄子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130273401,130273,'庆北办事处',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130273402,130273,'三女河办事处',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130274103,130274,'王滩镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130274451,130274,'社区管理服务中心',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130274452,130274,'唐山湾国际旅游岛',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130274455,130274,'大清河',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281001,130281,'华明路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281002,130281,'文化路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281100,130281,'遵化镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281101,130281,'堡子店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281102,130281,'马兰峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281103,130281,'平安城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281104,130281,'东新庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281105,130281,'新店子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281106,130281,'党峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281107,130281,'地北头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281108,130281,'东旧寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281109,130281,'铁厂镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281110,130281,'苏家洼镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281111,130281,'建明镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281112,130281,'石门镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281113,130281,'崔家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281200,130281,'西留村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281202,130281,'兴旺寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281203,130281,'西下营满族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281204,130281,'汤泉满族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281205,130281,'东陵满族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281206,130281,'刘备寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281207,130281,'团瓢庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281208,130281,'娘娘庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281209,130281,'西三里乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281210,130281,'侯家寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130281211,130281,'小厂乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283001,130283,'永顺街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283002,130283,'兴安街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283003,130283,'滨河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283004,130283,'杨店子街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283101,130283,'夏官营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283102,130283,'杨各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283103,130283,'建昌营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283104,130283,'赵店子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283105,130283,'野鸡坨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283106,130283,'大崔庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283108,130283,'蔡园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283109,130283,'马兰庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283110,130283,'沙河驿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283111,130283,'木厂口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283112,130283,'上射雁庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283113,130283,'太平庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283114,130283,'扣庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283115,130283,'大五里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283116,130283,'五重安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283117,130283,'彭店子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130283118,130283,'阎家店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284001,130284,'滦河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284002,130284,'古城街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284003,130284,'滦城路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284004,130284,'响嘡街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284102,130284,'东安各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284103,130284,'雷庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284104,130284,'茨榆坨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284105,130284,'榛子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284106,130284,'杨柳庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284107,130284,'油榨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284108,130284,'古马镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284109,130284,'小马庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284110,130284,'九百户镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130284111,130284,'王店子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302001,130302,'文化路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302002,130302,'海滨路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302003,130302,'北环路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302004,130302,'建设大街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302005,130302,'河东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302006,130302,'西港路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302007,130302,'燕山大街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302008,130302,'港城大街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302009,130302,'东环路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302010,130302,'白塔岭街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302100,130302,'东港镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302101,130302,'海港镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302102,130302,'西港镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302103,130302,'海阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302104,130302,'北港镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302105,130302,'杜庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302106,130302,'石门寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302107,130302,'驻操营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302403,130302,'临港物流园区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130302404,130302,'海港经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130303001,130303,'南关街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130303002,130303,'古城街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130303003,130303,'西关街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130303004,130303,'路南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130303100,130303,'第一关镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130303101,130303,'石河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130303102,130303,'孟姜镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130304001,130304,'西山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130304002,130304,'东山街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130304100,130304,'海滨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130304101,130304,'戴河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130304103,130304,'牛头崖镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130306001,130306,'骊城街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130306100,130306,'抚宁镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130306101,130306,'留守营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130306102,130306,'榆关镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130306105,130306,'台营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130306106,130306,'大新寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130306109,130306,'坟坨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130306200,130306,'茶棚乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321001,130321,'都阳路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321100,130321,'青龙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321101,130321,'祖山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321102,130321,'木头凳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321103,130321,'双山子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321104,130321,'马圈子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321105,130321,'肖营子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321106,130321,'大巫岚镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321107,130321,'土门子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321108,130321,'八道河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321109,130321,'隔河头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321110,130321,'娄杖子镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321200,130321,'凤凰山乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321201,130321,'龙王庙乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321202,130321,'三星口乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321203,130321,'干沟乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321206,130321,'大石岭乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321208,130321,'官场乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321209,130321,'茨榆山乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321210,130321,'平方子乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321211,130321,'安子岭乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321212,130321,'朱杖子乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321213,130321,'草碾乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321217,130321,'三拨子乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130321218,130321,'凉水河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322100,130322,'昌黎镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322101,130322,'靖安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322102,130322,'安山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322103,130322,'龙家店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322104,130322,'泥井镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322105,130322,'大蒲河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322106,130322,'新集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322107,130322,'刘台庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322108,130322,'茹荷镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322109,130322,'朱各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322110,130322,'荒佃庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322201,130322,'团林乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322202,130322,'葛条港乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322203,130322,'马坨店乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322206,130322,'两山乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130322207,130322,'十里铺乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324100,130324,'卢龙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324101,130324,'潘庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324102,130324,'燕河营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324103,130324,'双望镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324104,130324,'刘田各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324105,130324,'石门镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324106,130324,'木井镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324107,130324,'陈官屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324108,130324,'蛤泊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324200,130324,'下寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324201,130324,'刘家营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130324203,130324,'印庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130371005,130371,'船厂路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130371011,130371,'珠江道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130371012,130371,'黄河道街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130371013,130371,'腾飞路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130371200,130371,'渤海乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130372001,130372,'南戴河街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130372400,130372,'大蒲河管理处',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130372401,130372,'团林管理处',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130372402,130372,'留守营管理处',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402001,130402,'火磨街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402002,130402,'陵园路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402003,130402,'光明路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402004,130402,'滏东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402005,130402,'罗城头街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402006,130402,'渚河路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402007,130402,'浴新南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402008,130402,'农林路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402009,130402,'贸东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402010,130402,'贸西街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402011,130402,'盛和路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402101,130402,'北张庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402102,130402,'河沙镇镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402200,130402,'马庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402201,130402,'南堡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130402202,130402,'代召乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403001,130403,'丛台西街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403002,130403,'联纺西街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403003,130403,'联纺东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403004,130403,'光明桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403005,130403,'丛台东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403006,130403,'四季青街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403007,130403,'和平街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403008,130403,'中华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403009,130403,'人民路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403010,130403,'柳林桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403101,130403,'黄粱梦镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403200,130403,'苏曹乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403205,130403,'三陵乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403206,130403,'南吕固乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130403207,130403,'兼庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404001,130404,'胜利桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404002,130404,'百家村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404003,130404,'铁路大院街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404004,130404,'化林路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404005,130404,'庞村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404006,130404,'二六七二街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404007,130404,'石化街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404100,130404,'户村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404200,130404,'彭家寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130404201,130404,'康庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406001,130406,'滏阳东路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406100,130406,'临水镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406101,130406,'峰峰镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406102,130406,'新坡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406103,130406,'大社镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406104,130406,'和村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406105,130406,'义井镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406106,130406,'彭城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406107,130406,'界城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406108,130406,'大峪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130406200,130406,'西固义乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407100,130407,'肥乡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407101,130407,'天台山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407102,130407,'辛安镇镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407103,130407,'大寺上镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407104,130407,'东漳堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407105,130407,'毛演堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407106,130407,'西吕营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407203,130407,'元固乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130407206,130407,'旧店乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408100,130408,'临洺关镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408101,130408,'大北汪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408102,130408,'张西堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408103,130408,'广府镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408105,130408,'永合会镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408106,130408,'刘营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408107,130408,'西苏镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408108,130408,'讲武镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408109,130408,'东杨庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408201,130408,'界河店乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408203,130408,'刘汉乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408204,130408,'正西乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408206,130408,'曲陌乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408207,130408,'辛庄堡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408208,130408,'小龙马乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408211,130408,'西河庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130408213,130408,'西阳城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423100,130423,'临漳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423101,130423,'南东坊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423102,130423,'孙陶集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423103,130423,'柳园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423104,130423,'称勾集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423105,130423,'邺城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423106,130423,'章里集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423200,130423,'狄邱乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423201,130423,'张村集乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423202,130423,'西羊羔乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423204,130423,'杜村集乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423206,130423,'习文乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423207,130423,'砖寨营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130423208,130423,'柏鹤集乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424100,130424,'成安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424101,130424,'商城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424102,130424,'漳河店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424103,130424,'李家疃镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424104,130424,'北乡义镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424105,130424,'道东堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424200,130424,'辛义乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424201,130424,'柏寺营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130424204,130424,'长巷乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425100,130425,'大名镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425101,130425,'杨桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425102,130425,'万堤镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425103,130425,'龙王庙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425104,130425,'束馆镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425105,130425,'金滩镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425106,130425,'沙圪塔镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425107,130425,'大街镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425108,130425,'铺上镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425109,130425,'孙甘店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425201,130425,'王村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425203,130425,'黄金堤乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425205,130425,'旧治乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425206,130425,'西未庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425208,130425,'西付集乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425209,130425,'埝头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425210,130425,'北峰乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425211,130425,'张铁集乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425212,130425,'红庙乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130425213,130425,'营镇回族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426001,130426,'平安街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426101,130426,'河南店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426102,130426,'索堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426103,130426,'西戌镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426104,130426,'井店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426105,130426,'更乐镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426106,130426,'固新镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426107,130426,'西达镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426108,130426,'偏城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426200,130426,'神头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426201,130426,'辽城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426202,130426,'偏店乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426203,130426,'龙虎乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426204,130426,'木井乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426205,130426,'关防乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426206,130426,'合漳乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426207,130426,'鹿头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130426400,130426,'涉城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427100,130427,'磁州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427103,130427,'讲武城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427104,130427,'岳城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427105,130427,'观台镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427107,130427,'白土镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427108,130427,'黄沙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427200,130427,'路村营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427204,130427,'时村营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427207,130427,'陶泉乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427208,130427,'都党乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130427209,130427,'北贾壁乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130430100,130430,'新马头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130430101,130430,'邱城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130430102,130430,'梁二庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130430103,130430,'香城固镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130430104,130430,'古城营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130430201,130430,'南辛店乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130430204,130430,'陈村回族乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130431100,130431,'鸡泽镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130431101,130431,'小寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130431102,130431,'双塔镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130431103,130431,'曹庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130431104,130431,'浮图店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130431105,130431,'吴官营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130431202,130431,'风正乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130432100,130432,'广平镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130432101,130432,'平固店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130432102,130432,'胜营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130432103,130432,'南阳堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130432104,130432,'十里铺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130432105,130432,'南韩镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130432106,130432,'东张孟镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130433100,130433,'馆陶镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130433101,130433,'房寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130433102,130433,'柴堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130433103,130433,'魏僧寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130433200,130433,'寿山寺乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130433201,130433,'王桥乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130433202,130433,'南徐村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130433203,130433,'路桥乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434100,130434,'魏城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434101,130434,'德政镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434102,130434,'北皋镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434103,130434,'双井镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434104,130434,'牙里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434105,130434,'车往镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434106,130434,'回隆镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434107,130434,'张二庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434108,130434,'东代固镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434109,130434,'院堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434110,130434,'棘针寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434111,130434,'南双庙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434112,130434,'边马镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434113,130434,'泊口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434114,130434,'仕望集镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434202,130434,'沙口集乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434203,130434,'野胡拐乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434205,130434,'前大磨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434208,130434,'大辛庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434209,130434,'大马村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130434212,130434,'北台头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435100,130435,'曲周镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435101,130435,'安寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435102,130435,'侯村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435103,130435,'河南疃镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435104,130435,'第四疃镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435105,130435,'白寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435200,130435,'槐桥乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435201,130435,'南里岳乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435203,130435,'大河道乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130435204,130435,'依庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130471001,130471,'开发区街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130471100,130471,'尚璧镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130471101,130471,'南沿村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130471200,130471,'小西堡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130471201,130471,'姚寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473001,130473,'城南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473100,130473,'高臾镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473101,130473,'西光禄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473102,130473,'林坛镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473103,130473,'马头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473200,130473,'辛庄营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473201,130473,'花官营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473202,130473,'台城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130473203,130473,'南城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481100,130481,'武安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481101,130481,'康二城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481102,130481,'午汲镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481103,130481,'磁山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481104,130481,'伯延镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481105,130481,'淑村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481106,130481,'大同镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481107,130481,'邑城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481108,130481,'矿山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481109,130481,'贺进镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481110,130481,'阳邑镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481111,130481,'徘徊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481112,130481,'冶陶镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481200,130481,'上团城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481201,130481,'北安庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481202,130481,'北安乐乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481203,130481,'西土山乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481204,130481,'西寺庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481205,130481,'活水乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481206,130481,'石洞乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481207,130481,'管陶乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481208,130481,'马家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130481400,130481,'河北武安工业园区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502001,130502,'南长街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502002,130502,'北大街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502003,130502,'西大街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502004,130502,'西门里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502005,130502,'泉东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502006,130502,'豫让桥街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502100,130502,'东郭村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502101,130502,'祝村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502103,130502,'晏家屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130502200,130502,'大梁庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503001,130503,'钢铁路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503002,130503,'中兴路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503003,130503,'达活泉街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503004,130503,'张宽街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503005,130503,'章村街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503006,130503,'中华大街街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503007,130503,'团结路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503008,130503,'泉西街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503100,130503,'南大郭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503101,130503,'李村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503102,130503,'南石门镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503103,130503,'羊范镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503104,130503,'皇寺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503105,130503,'会宁镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503106,130503,'西黄村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503107,130503,'路罗镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503108,130503,'将军墓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503109,130503,'浆水镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503110,130503,'宋家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503202,130503,'太子井乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503203,130503,'龙泉寺乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503204,130503,'北小庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503205,130503,'城计头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503206,130503,'白岸乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130503207,130503,'冀家村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130505100,130505,'任城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130505101,130505,'邢家湾镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130505102,130505,'辛店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130505103,130505,'天口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130505200,130505,'西固城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130505201,130505,'永福庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130505202,130505,'大屯乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130505203,130505,'骆庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130506100,130506,'和阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130506101,130506,'贾宋镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130506102,130506,'郝桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130506103,130506,'三思镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130506104,130506,'河郭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130506200,130506,'东三召乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130506201,130506,'阎里乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130506203,130506,'史召乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130522100,130522,'临城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130522101,130522,'东镇镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130522102,130522,'西竖镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130522103,130522,'郝庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130522104,130522,'黑城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130522201,130522,'鸭鸽营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130522203,130522,'石城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130522205,130522,'赵庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523100,130523,'内丘镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523101,130523,'大孟村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523102,130523,'金店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523103,130523,'官庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523104,130523,'柳林镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523200,130523,'五郭店乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523203,130523,'南赛乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523204,130523,'獐獏乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130523205,130523,'侯家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130524100,130524,'柏乡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130524101,130524,'固城店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130524102,130524,'西汪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130524103,130524,'龙华镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130524200,130524,'王家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130524203,130524,'内步乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525100,130525,'隆尧镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525101,130525,'魏家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525102,130525,'尹村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525103,130525,'山口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525104,130525,'莲子镇镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525105,130525,'固城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525106,130525,'东良镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525200,130525,'北楼乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525202,130525,'双碑乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525203,130525,'牛家桥乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525204,130525,'千户营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525205,130525,'大张家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130525400,130525,'柳行农场',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528001,130528,'宁北街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528100,130528,'凤凰镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528101,130528,'河渠镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528102,130528,'北河庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528103,130528,'耿庄桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528104,130528,'东汪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528105,130528,'贾家口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528106,130528,'四芝兰镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528107,130528,'大陆村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528108,130528,'苏家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528109,130528,'换马店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528110,130528,'唐邱镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528111,130528,'大曹庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528112,130528,'侯口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528202,130528,'纪昌庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528205,130528,'北鱼乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528208,130528,'徐家河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130528401,130528,'大曹庄管理区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529100,130529,'巨鹿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529101,130529,'王虎寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529102,130529,'西郭城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529103,130529,'官亭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529104,130529,'阎疃镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529105,130529,'小吕寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529106,130529,'苏家营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529107,130529,'观寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529200,130529,'堤村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130529201,130529,'张王疃乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130530100,130530,'新河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130530101,130530,'寻寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130530200,130530,'白神首乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130530201,130530,'荆家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130530202,130530,'西流乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130530203,130530,'仁让里乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130531100,130531,'广宗镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130531101,130531,'冯家寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130531102,130531,'北塘疃镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130531103,130531,'核桃园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130531200,130531,'葫芦乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130531201,130531,'大平台乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130531202,130531,'件只乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130531204,130531,'东召乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130532001,130532,'中华路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130532101,130532,'平乡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130532102,130532,'河古庙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130532200,130532,'节固乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130532201,130532,'油召乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130532202,130532,'田付村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130532203,130532,'寻召乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533100,130533,'洺州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533101,130533,'梨园屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533102,130533,'章台镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533103,130533,'侯贯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533104,130533,'七级镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533105,130533,'贺营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533106,130533,'方家营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533107,130533,'常庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533108,130533,'第什营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533109,130533,'贺钊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533110,130533,'赵村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533111,130533,'固献镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533202,130533,'枣园乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533206,130533,'张家营乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533207,130533,'常屯乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130533209,130533,'高公庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130534100,130534,'葛仙庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130534101,130534,'连庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130534102,130534,'油坊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130534103,130534,'谢炉镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130534104,130534,'王官庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130534105,130534,'坝营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535100,130535,'临西镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535101,130535,'河西镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535102,130535,'下堡寺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535103,130535,'尖塚镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535104,130535,'老官寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535105,130535,'吕寨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535106,130535,'大刘庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535200,130535,'东枣园乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535203,130535,'摇鞍镇乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130535400,130535,'轴承工业园区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130571100,130571,'东汪镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130571101,130571,'王快镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130571103,130571,'沙河城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130571104,130571,'留村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130571400,130571,'市高新技术开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581001,130581,'凤岗街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581002,130581,'南杜街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581003,130581,'北胡街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581004,130581,'西丁街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581100,130581,'苏村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581101,130581,'大高村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581102,130581,'垂杨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581103,130581,'明化镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581104,130581,'段芦头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581105,130581,'紫冢镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581200,130581,'大村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581201,130581,'南便村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581202,130581,'大屯乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581203,130581,'王道寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130581204,130581,'薛吴村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582001,130582,'褡裢街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582002,130582,'桥东街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582003,130582,'桥西街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582004,130582,'赞善街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582005,130582,'周庄街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582101,130582,'新城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582102,130582,'白塔镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582103,130582,'十里亭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582104,130582,'綦村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582201,130582,'册井乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582202,130582,'刘石岗乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582203,130582,'柴关乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130582204,130582,'蝉房乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602001,130602,'先锋街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602002,130602,'新市场街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602003,130602,'东风路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602004,130602,'建南街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602005,130602,'韩村北路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602100,130602,'大激店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602200,130602,'颉庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602201,130602,'富昌乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602202,130602,'韩村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130602203,130602,'南奇乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606001,130606,'和平里街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606002,130606,'五四路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606003,130606,'西关街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606004,130606,'中华路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606005,130606,'东关街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606006,130606,'联盟街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606007,130606,'红星街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606008,130606,'裕华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606009,130606,'永华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606010,130606,'南关街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606100,130606,'百楼镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606200,130606,'韩庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606201,130606,'东金庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606203,130606,'杨庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606204,130606,'南大园乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606205,130606,'焦庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130606206,130606,'五尧乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607001,130607,'惠阳街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607100,130607,'满城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607101,130607,'大册营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607102,130607,'神星镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607103,130607,'南韩村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607104,130607,'方顺桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607105,130607,'于家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607203,130607,'要庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607204,130607,'白龙乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607205,130607,'石井乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607206,130607,'坨南乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607207,130607,'刘家台乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130607400,130607,'河北满城经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608100,130608,'清苑镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608101,130608,'冉庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608102,130608,'阳城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608103,130608,'魏村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608104,130608,'温仁镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608105,130608,'张登镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608106,130608,'大庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608107,130608,'臧村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608108,130608,'望亭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608109,130608,'东闾镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608200,130608,'白团乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608201,130608,'北店乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608202,130608,'石桥乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608203,130608,'李庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608204,130608,'北王力乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608206,130608,'何桥乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608207,130608,'孙村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608208,130608,'阎庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130608400,130608,'河北清苑经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609100,130609,'安肃镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609101,130609,'崔庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609102,130609,'大因镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609103,130609,'遂城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609104,130609,'高林村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609105,130609,'大王店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609106,130609,'漕河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609107,130609,'东史端镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609108,130609,'留村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609109,130609,'正村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609203,130609,'户木乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609204,130609,'瀑河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609205,130609,'东釜山乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130609206,130609,'义联庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623100,130623,'涞水镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623101,130623,'永阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623102,130623,'义安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623103,130623,'石亭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623104,130623,'赵各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623105,130623,'九龙镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623106,130623,'三坡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623107,130623,'一渡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623108,130623,'明义镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623109,130623,'王村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623110,130623,'娄村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623111,130623,'东文山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623205,130623,'其中口乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623206,130623,'龙门乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623207,130623,'胡家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130623401,130623,'涞水县城区社区管理办公室',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624100,130624,'阜平镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624101,130624,'龙泉关镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624102,130624,'平阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624103,130624,'城南庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624104,130624,'天生桥镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624105,130624,'王林口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624106,130624,'砂窝镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624107,130624,'北果园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624202,130624,'台峪乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624203,130624,'大台乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624204,130624,'史家寨乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624206,130624,'吴王口乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624207,130624,'夏庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130624400,130624,'河北阜平经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626100,130626,'定兴镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626101,130626,'固城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626102,130626,'贤寓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626103,130626,'北河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626104,130626,'天宫寺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626105,130626,'小朱庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626106,130626,'姚村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626107,130626,'杨村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626200,130626,'东落堡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626201,130626,'高里乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626202,130626,'张家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626204,130626,'肖村乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626205,130626,'柳卓乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626207,130626,'北田乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626208,130626,'北南蔡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130626209,130626,'李郁庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627100,130627,'仁厚镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627101,130627,'王京镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627102,130627,'高昌镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627103,130627,'北罗镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627104,130627,'白合镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627105,130627,'军城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627106,130627,'川里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627107,130627,'长古城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627108,130627,'罗庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627109,130627,'北店头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627201,130627,'都亭乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627202,130627,'南店头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627205,130627,'雹水乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627206,130627,'大洋乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627207,130627,'迷城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627208,130627,'齐家佐乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627209,130627,'羊角乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627210,130627,'石门乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627211,130627,'黄石口乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130627212,130627,'倒马关乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628001,130628,'高阳县锦华街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628101,130628,'庞口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628102,130628,'西演镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628103,130628,'邢家南镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628104,130628,'晋庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628105,130628,'小王果庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628106,130628,'蒲口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628107,130628,'庞家佐镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130628400,130628,'高阳县经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130629100,130629,'容城镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130629101,130629,'小里镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130629102,130629,'南张镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130629103,130629,'大河镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130629104,130629,'晾马台镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130629200,130629,'八于乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130629201,130629,'贾光乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130629203,130629,'平王乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630100,130630,'涞源镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630101,130630,'银坊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630102,130630,'走马驿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630103,130630,'水堡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630104,130630,'王安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630105,130630,'杨家庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630106,130630,'白石山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630107,130630,'南屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630108,130630,'泉坊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630109,130630,'北石佛镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630201,130630,'南马庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630203,130630,'金家井乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630204,130630,'留家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630205,130630,'上庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630206,130630,'东团堡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630207,130630,'塔崖驿乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130630208,130630,'乌龙沟乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631100,130631,'望都镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631101,130631,'固店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631102,130631,'贾村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631103,130631,'中韩庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631104,130631,'寺庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631105,130631,'赵庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631106,130631,'高岭镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631202,130631,'黑堡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130631400,130631,'望都经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632100,130632,'安新镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632101,130632,'大王镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632102,130632,'三台镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632103,130632,'端村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632104,130632,'赵北口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632105,130632,'同口镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632106,130632,'刘李庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632107,130632,'安州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632108,130632,'老河头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632200,130632,'圈头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632201,130632,'寨里乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632202,130632,'芦庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130632203,130632,'龙化乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633100,130633,'易州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633101,130633,'梁格庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633102,130633,'西陵镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633103,130633,'裴山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633104,130633,'塘湖镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633105,130633,'狼牙山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633106,130633,'良岗镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633107,130633,'紫荆关镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633108,130633,'高村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633200,130633,'桥头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633201,130633,'白马乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633202,130633,'流井乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633204,130633,'高陌乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633205,130633,'大龙华乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633206,130633,'安格庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633207,130633,'凌云册乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633208,130633,'西山北乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633209,130633,'尉都乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633210,130633,'独乐乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633211,130633,'七峪乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633212,130633,'富岗乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633213,130633,'坡仓乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633214,130633,'牛岗乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633215,130633,'桥家河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633216,130633,'甘河净乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633217,130633,'蔡家峪乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633218,130633,'南城司乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130633400,130633,'恋乡太行水镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634100,130634,'恒州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634101,130634,'灵山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634102,130634,'燕赵镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634103,130634,'羊平镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634104,130634,'文德镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634105,130634,'晓林镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634106,130634,'邸村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634107,130634,'齐村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634108,130634,'孝墓镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634109,130634,'产德镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634200,130634,'路庄子乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634201,130634,'下河乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634202,130634,'庄窠乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634205,130634,'东旺乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634210,130634,'党城乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634211,130634,'郎家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634212,130634,'范家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130634213,130634,'北台乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635100,130635,'蠡吾镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635101,130635,'留史镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635102,130635,'大百尺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635103,130635,'辛兴镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635104,130635,'北郭丹镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635105,130635,'万安镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635106,130635,'桑园镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635107,130635,'南庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635108,130635,'大曲堤镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635109,130635,'鲍墟镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635110,130635,'小陈镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635201,130635,'林堡乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130635202,130635,'北埝头乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636100,130636,'蒲阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636101,130636,'高于铺镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636102,130636,'腰山镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636103,130636,'蒲上镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636104,130636,'神南镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636105,130636,'安阳镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636201,130636,'白云乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636202,130636,'河口乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636204,130636,'台鱼乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130636205,130636,'大悲乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130637100,130637,'博野镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130637101,130637,'小店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130637102,130637,'程委镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130637103,130637,'东墟镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130637104,130637,'北杨镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130637105,130637,'城东镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130637106,130637,'南小王镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638100,130638,'雄州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638101,130638,'昝岗镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638102,130638,'大营镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638103,130638,'龙湾镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638104,130638,'朱各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638105,130638,'米家务镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638106,130638,'鄚州镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638107,130638,'苟各庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638200,130638,'北沙口乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638203,130638,'双堂乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638204,130638,'张岗乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130638205,130638,'七间房乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130671202,130671,'贤台乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130671205,130671,'大马坊乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130671400,130671,'保定国家高新区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130672103,130672,'白沟镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681001,130681,'双塔街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681002,130681,'桃园街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681003,130681,'清凉寺街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681100,130681,'松林店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681101,130681,'码头镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681102,130681,'东城坊镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681103,130681,'高官庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681104,130681,'东仙坡镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681105,130681,'百尺竿镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681106,130681,'义和庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681107,130681,'刁窝镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681108,130681,'林家屯镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681109,130681,'豆庄镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681204,130681,'孙家庄乡',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681400,130681,'高新技术产业开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681401,130681,'京南经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130681402,130681,'松林店经济开发区',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682001,130682,'南城区街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682002,130682,'北城区街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682003,130682,'西城区街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682004,130682,'长安路街道',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682100,130682,'留早镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682101,130682,'清风店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682102,130682,'庞村镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682103,130682,'砖路镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682104,130682,'明月店镇',4,'2022-11-09 10:39:24','2022-11-09 11:10:46'),
	(130682105,130682,'叮咛店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682106,130682,'东亭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682107,130682,'大辛庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682108,130682,'东旺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682109,130682,'高蓬镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682110,130682,'邢邑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682111,130682,'李亲顾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682112,130682,'子位镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682113,130682,'开元镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682115,130682,'周村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682116,130682,'息冢镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682203,130682,'东留春乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682204,130682,'号头庄回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682205,130682,'杨家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682206,130682,'大鹿庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130682208,130682,'西城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683001,130683,'药都街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683002,130683,'祁州路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683101,130683,'伍仁桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683102,130683,'石佛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683103,130683,'郑章镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683104,130683,'大五女镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683105,130683,'西佛落镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683106,130683,'西城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683200,130683,'明官店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683201,130683,'南娄底乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683204,130683,'北段村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130683400,130683,'现代中药工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684001,130684,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684002,130684,'军城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684003,130684,'东盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684004,130684,'北城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684005,130684,'兴华路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684100,130684,'方官镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684101,130684,'新城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684102,130684,'泗庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684104,130684,'辛立庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684105,130684,'东马营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684106,130684,'辛桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684107,130684,'肖官营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684108,130684,'张六庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130684109,130684,'梁家营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130702001,130702,'红旗楼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130702002,130702,'胜利北路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130702003,130702,'五一路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130702004,130702,'花园街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130702005,130702,'工业路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130702101,130702,'姚家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130702102,130702,'大仓盖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130702202,130702,'东望山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130703001,130703,'新华街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130703002,130703,'大境门街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130703003,130703,'明德北街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130703004,130703,'明德南街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130703005,130703,'堡子里街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130703006,130703,'南营坊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130703007,130703,'工人新村街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130703100,130703,'东窑子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705001,130705,'天泰寺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705002,130705,'皇城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705003,130705,'南关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705004,130705,'南大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705005,130705,'大北街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705006,130705,'工业街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705007,130705,'建国街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705100,130705,'庞家堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705101,130705,'深井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705102,130705,'崞村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705104,130705,'洋河南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705106,130705,'贾家营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705107,130705,'顾家营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705108,130705,'赵川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705109,130705,'江家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705200,130705,'河子西乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705201,130705,'春光乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705202,130705,'侯家庙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705204,130705,'李家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705205,130705,'王家湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130705206,130705,'塔儿村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130706001,130706,'城镇街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130706002,130706,'煤矿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130706200,130706,'花园乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130706201,130706,'辛庄子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130706202,130706,'定方水乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130706203,130706,'段家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708100,130708,'孔家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708101,130708,'万全镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708102,130708,'洗马林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708103,130708,'郭磊庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708200,130708,'膳房堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708201,130708,'北新屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708202,130708,'宣平堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708203,130708,'高庙堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708204,130708,'旧堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708205,130708,'安家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708206,130708,'北沙城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708400,130708,'孔家庄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130708401,130708,'宣平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709001,130709,'西湾子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709100,130709,'西湾子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709101,130709,'高家营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709200,130709,'四台嘴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709201,130709,'红旗营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709202,130709,'石窑子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709203,130709,'驿马图乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709204,130709,'石嘴子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709205,130709,'狮子沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709206,130709,'清三营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130709207,130709,'白旗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722100,130722,'张北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722101,130722,'公会镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722102,130722,'二台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722103,130722,'大囫囵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722104,130722,'小二台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722106,130722,'油篓沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722107,130722,'大河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722200,130722,'台路沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722202,130722,'馒头营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722203,130722,'二泉井乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722204,130722,'单晶河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722206,130722,'海流图乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722207,130722,'两面井乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722208,130722,'大西湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722209,130722,'郝家营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722210,130722,'白庙滩乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722212,130722,'战海乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130722213,130722,'三号乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723100,130723,'康保镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723101,130723,'张纪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723102,130723,'土城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723103,130723,'邓油坊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723104,130723,'李家地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723105,130723,'照阳河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723106,130723,'屯垦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723200,130723,'闫油坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723201,130723,'丹清河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723202,130723,'哈咇嘎乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723203,130723,'二号卜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723204,130723,'芦家营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723205,130723,'忠义乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723206,130723,'处长地乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723207,130723,'满德堂乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723500,130723,'康保牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130723501,130723,'屯垦林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724100,130724,'平定堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724101,130724,'小厂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724102,130724,'黄盖淖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724103,130724,'九连城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724200,130724,'高山堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724201,130724,'小河子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724202,130724,'二道渠乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724203,130724,'大二号回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724204,130724,'闪电河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724205,130724,'长梁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724206,130724,'丰源店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724207,130724,'西辛营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724208,130724,'莲花滩乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130724209,130724,'白土窑乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725100,130725,'南壕堑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725101,130725,'大青沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725102,130725,'八道沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725103,130725,'红土梁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725104,130725,'小蒜沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725105,130725,'三工地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725106,130725,'满井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725200,130725,'大营盘乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725201,130725,'大苏计乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725202,130725,'石井乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725205,130725,'七甲乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725206,130725,'套里庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725207,130725,'甲石河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130725208,130725,'下马圈乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726100,130726,'蔚州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726101,130726,'代王城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726102,130726,'西合营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726103,130726,'吉家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726104,130726,'白乐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726105,130726,'暖泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726106,130726,'南留庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726107,130726,'北水泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726108,130726,'桃花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726109,130726,'阳眷镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726110,130726,'宋家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726200,130726,'下宫村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726202,130726,'南杨庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726203,130726,'柏树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726204,130726,'常宁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726205,130726,'涌泉庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726206,130726,'杨庄窠乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726207,130726,'南岭庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726208,130726,'陈家洼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726209,130726,'黄梅乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726210,130726,'白草村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130726211,130726,'草沟堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727100,130727,'西城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727101,130727,'东城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727102,130727,'化稍营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727103,130727,'揣骨疃镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727104,130727,'东井集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727200,130727,'要家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727201,130727,'东坊城堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727202,130727,'井儿沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727203,130727,'三马坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727204,130727,'高墙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727205,130727,'大田洼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727206,130727,'辛堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727207,130727,'马圈堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130727208,130727,'浮图讲乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728100,130728,'柴沟堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728101,130728,'左卫镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728102,130728,'头百户镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728103,130728,'怀安城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728200,130728,'渡口堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728201,130728,'第六屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728202,130728,'西湾堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728203,130728,'西沙城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728204,130728,'太平庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728205,130728,'王虎屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130728206,130728,'第三堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730100,130730,'沙城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730101,130730,'北辛堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730102,130730,'新保安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730103,130730,'东花园镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730104,130730,'官厅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730105,130730,'桑园镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730106,130730,'存瑞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730107,130730,'土木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730108,130730,'大黄庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730109,130730,'西八里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730110,130730,'小南辛堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730200,130730,'狼山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730203,130730,'鸡鸣驿乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730205,130730,'东八里乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730207,130730,'瑞云观乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730208,130730,'孙庄子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130730210,130730,'王家楼回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731100,130731,'涿鹿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731101,130731,'张家堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731102,130731,'武家沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731103,130731,'五堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731104,130731,'保岱镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731105,130731,'矾山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731106,130731,'大堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731107,130731,'河东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731108,130731,'东小庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731109,130731,'辉耀镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731110,130731,'大河南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731111,130731,'温泉屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731112,130731,'蟒石口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731201,130731,'栾庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731204,130731,'黑山寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731205,130731,'卧佛寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130731206,130731,'谢家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732100,130732,'赤城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732101,130732,'田家窑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732102,130732,'龙关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732103,130732,'雕鹗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732104,130732,'独石口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732105,130732,'白草镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732106,130732,'龙门所镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732107,130732,'后城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732108,130732,'东卯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732200,130732,'炮梁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732201,130732,'大海陀乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732202,130732,'镇宁堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732203,130732,'马营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732204,130732,'云州乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732205,130732,'三道川乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732206,130732,'东万口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732207,130732,'茨营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130732208,130732,'样田乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130771001,130771,'南站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130771002,130771,'马路东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130771100,130771,'老鸦庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130771101,130771,'沈家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130771102,130771,'姚家房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130771103,130771,'沙岭子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130772105,130772,'沙沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130772215,130772,'宇宙营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130772401,130772,'黄山管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130772402,130772,'石门管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130772403,130772,'乌兰管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130772404,130772,'金沙管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130772405,130772,'白塔管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130773501,130773,'榆树沟管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130773502,130773,'沙梁子管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130773503,130773,'小城子管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130773504,130773,'东大门管理处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802001,130802,'西大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802002,130802,'头道牌楼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802003,130802,'潘家沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802004,130802,'中华路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802005,130802,'新华路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802006,130802,'石洞子沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802007,130802,'桥东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802100,130802,'水泉沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802101,130802,'狮子沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802102,130802,'牛圈子沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802103,130802,'大石庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130802105,130802,'双峰寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803001,130803,'元宝山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803002,130803,'钢城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803003,130803,'秀水街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803100,130803,'双塔山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803101,130803,'滦河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803102,130803,'大庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803103,130803,'偏桥子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803104,130803,'西地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130803105,130803,'陈栅子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130804001,130804,'铁北路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130804100,130804,'鹰手营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130804101,130804,'北马圈子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130804102,130804,'寿王坟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130804103,130804,'汪家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821100,130821,'下板城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821102,130821,'甲山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821103,130821,'六沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821104,130821,'三沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821105,130821,'头沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821106,130821,'高寺台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821107,130821,'鞍匠镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821108,130821,'三家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821109,130821,'磴上镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821110,130821,'上谷镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821111,130821,'新杖子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821112,130821,'石灰窑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821200,130821,'东小白旗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821202,130821,'刘杖子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821204,130821,'孟家院乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821205,130821,'大营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821206,130821,'八家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821208,130821,'满杖子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821210,130821,'五道河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821211,130821,'岔沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821212,130821,'岗子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821214,130821,'两家满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130821216,130821,'仓子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822100,130822,'兴隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822101,130822,'半壁山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822102,130822,'挂兰峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822103,130822,'青松岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822104,130822,'六道河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822105,130822,'平安堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822106,130822,'北营房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822107,130822,'孤山子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822108,130822,'蓝旗营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822109,130822,'雾灵山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822110,130822,'李家营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822111,130822,'大杖子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822112,130822,'三道河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822113,130822,'蘑菇峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822114,130822,'大水泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822200,130822,'南天门满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822202,130822,'八卦岭满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822203,130822,'陡子峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822204,130822,'上石洞乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130822211,130822,'安子岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824001,130824,'中兴路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824100,130824,'滦平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824101,130824,'长山峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824102,130824,'红旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824103,130824,'金沟屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824104,130824,'虎什哈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824105,130824,'巴克什营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824106,130824,'张百湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824107,130824,'付营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824108,130824,'大屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824109,130824,'火斗山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824110,130824,'两间房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824111,130824,'小营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824200,130824,'平坊满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824201,130824,'安纯沟门满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824206,130824,'西沟满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824207,130824,'邓厂满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824208,130824,'五道营子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824209,130824,'马营子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130824210,130824,'付家店满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825001,130825,'安州街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825100,130825,'苔山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825101,130825,'韩麻营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825102,130825,'中关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825103,130825,'七家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825104,130825,'汤头沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825105,130825,'张三营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825106,130825,'唐三营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825107,130825,'蓝旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825108,130825,'步古沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825109,130825,'郭家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825110,130825,'茅荆坝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825200,130825,'荒地乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825201,130825,'章吉营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825203,130825,'尹家营满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825204,130825,'庙子沟蒙古族满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825205,130825,'偏坡营满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825206,130825,'山湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825207,130825,'八达营蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825208,130825,'太平庄满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825209,130825,'旧屯满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825210,130825,'西阿超满族蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825212,130825,'碱房乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825213,130825,'韩家店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130825214,130825,'湾沟门乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826001,130826,'新丰路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826100,130826,'大阁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826101,130826,'大滩镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826102,130826,'鱼儿山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826103,130826,'土城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826104,130826,'黄旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826105,130826,'凤山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826106,130826,'波罗诺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826107,130826,'黑山咀镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826108,130826,'天桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826109,130826,'胡麻营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826110,130826,'将军营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826200,130826,'万胜永乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826201,130826,'四岔口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826202,130826,'苏家店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826203,130826,'外沟门乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826204,130826,'草原乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826205,130826,'窟窿山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826206,130826,'小坝子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826207,130826,'五道营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826209,130826,'选将营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826210,130826,'西官营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826211,130826,'王营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826212,130826,'北头营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826214,130826,'石人沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826215,130826,'汤河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130826216,130826,'杨木栅子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827100,130827,'宽城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827101,130827,'龙须门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827102,130827,'峪耳崖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827103,130827,'板城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827104,130827,'汤道河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827105,130827,'桲罗台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827106,130827,'碾子峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827107,130827,'亮甲台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827108,130827,'化皮溜子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827109,130827,'松岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827201,130827,'塌山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827203,130827,'孟子岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827204,130827,'独石沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827207,130827,'铧尖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827208,130827,'东黄花川乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827210,130827,'苇子沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827211,130827,'大字沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130827212,130827,'大石柱子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828100,130828,'围场镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828101,130828,'四合永镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828102,130828,'克勒沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828103,130828,'棋盘山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828104,130828,'半截塔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828105,130828,'朝阳地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828106,130828,'朝阳湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828107,130828,'腰站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828108,130828,'龙头山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828109,130828,'新拨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828110,130828,'御道口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828111,130828,'城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828200,130828,'道坝子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828203,130828,'黄土坎乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828204,130828,'四道沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828205,130828,'兰旗卡伦乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828206,130828,'银窝沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828207,130828,'新地乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828208,130828,'广发永乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828209,130828,'育太和乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828210,130828,'郭家湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828211,130828,'杨家湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828212,130828,'大唤起乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828213,130828,'哈里哈乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828215,130828,'张家湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828216,130828,'宝元栈乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828217,130828,'山湾子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828218,130828,'三义永乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828219,130828,'姜家店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828220,130828,'下伙房乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828221,130828,'燕格柏乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828222,130828,'牌楼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828224,130828,'老窝铺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828226,130828,'石桌子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828227,130828,'大头山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828228,130828,'南山嘴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828229,130828,'西龙头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828450,130828,'塞罕坝机械林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130828500,130828,'国营御道口牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130871104,130871,'冯营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130871106,130871,'上板城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881100,130881,'平泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881101,130881,'黄土梁子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881102,130881,'榆树林子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881103,130881,'杨树岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881104,130881,'七沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881105,130881,'小寺沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881106,130881,'党坝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881107,130881,'卧龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881108,130881,'南五十家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881109,130881,'北五十家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881110,130881,'桲椤树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881111,130881,'柳溪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881112,130881,'平北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881113,130881,'青河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881114,130881,'台头山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881200,130881,'王土房乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881203,130881,'七家岱满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881206,130881,'茅兰沟满族蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130881210,130881,'道虎沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130902001,130902,'建设北街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130902002,130902,'车站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130902003,130902,'南大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130902004,130902,'东环街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130902005,130902,'道东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130902200,130902,'小赵庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130903001,130903,'水月寺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130903002,130903,'南环中路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130903003,130903,'南湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130903004,130903,'市场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130903005,130903,'西环中街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130903006,130903,'公园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130903100,130903,'小王庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130903101,130903,'南陈屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921100,130921,'旧州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921101,130921,'兴济镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921102,130921,'杜生镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921103,130921,'崔尔庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921104,130921,'李天木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921105,130921,'纸房头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921106,130921,'姚官屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921200,130921,'薛官屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921201,130921,'捷地回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921202,130921,'张官屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921204,130921,'风化店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921206,130921,'杜林回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921207,130921,'汪家铺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921208,130921,'刘家庙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921209,130921,'仵龙堂乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921210,130921,'大官厅乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921211,130921,'高川乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921212,130921,'黄递铺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130921213,130921,'大褚村回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922100,130922,'清州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922101,130922,'金牛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922102,130922,'新兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922103,130922,'流河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922104,130922,'木门店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922105,130922,'马厂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922106,130922,'盘古镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922107,130922,'曹寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922200,130922,'上伍乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922203,130922,'陈嘴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130922400,130922,'青县农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923100,130923,'东光镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923101,130923,'连镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923102,130923,'找王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923103,130923,'秦村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923104,130923,'灯明寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923105,130923,'南霞口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923106,130923,'大单镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923107,130923,'龙王李镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130923201,130923,'于桥乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924100,130924,'苏基镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924101,130924,'辛集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924102,130924,'高湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924103,130924,'赵毛陶镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924201,130924,'香坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924202,130924,'小山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924203,130924,'张会亭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924400,130924,'海兴县农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924401,130924,'青先农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130924402,130924,'青锋农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925100,130925,'盐山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925101,130925,'望树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925102,130925,'庆云镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925103,130925,'韩集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925104,130925,'千童镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925105,130925,'圣佛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925106,130925,'边务镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925107,130925,'小庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925108,130925,'杨集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925201,130925,'小营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925203,130925,'孟店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130925204,130925,'常庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926100,130926,'肃宁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926101,130926,'梁家村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926102,130926,'窝北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926103,130926,'尚村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926104,130926,'万里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926105,130926,'师素镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926106,130926,'河北留善寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926107,130926,'付家佐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130926205,130926,'邵庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927100,130927,'南皮镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927101,130927,'冯家口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927102,130927,'寨子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927103,130927,'鲍官屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927104,130927,'王寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927105,130927,'乌马营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927106,130927,'潞灌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927200,130927,'大浪淀乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130927201,130927,'刘八里乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928100,130928,'桑园镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928101,130928,'铁城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928102,130928,'于集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928103,130928,'梁集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928104,130928,'安陵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928200,130928,'曹家洼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928201,130928,'东宋门乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928202,130928,'杨家寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928203,130928,'沟店铺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928204,130928,'何庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130928400,130928,'吴桥经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929100,130929,'乐寿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929101,130929,'淮镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929102,130929,'郭庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929103,130929,'河城街镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929104,130929,'韩村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929105,130929,'陌南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929106,130929,'陈庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929107,130929,'段村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929108,130929,'高官镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929109,130929,'十五级镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929206,130929,'商林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929209,130929,'张村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929210,130929,'临河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929211,130929,'小平王乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929213,130929,'垒头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929214,130929,'南河头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929215,130929,'西城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929216,130929,'本斋回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929400,130929,'梅庄洼农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130929401,130929,'献县经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130930100,130930,'孟村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130930101,130930,'新县镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130930102,130930,'辛店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130930103,130930,'高寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130930200,130930,'宋庄子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130930201,130930,'牛进庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130971400,130971,'开发区乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130972400,130972,'高新乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130973206,130973,'新村回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130973400,130973,'南大港管理区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130973401,130973,'国营中捷农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130973402,130973,'港城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130973403,130973,'临港化工园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981001,130981,'解放街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981002,130981,'河东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981003,130981,'鼓楼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981100,130981,'泊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981101,130981,'交河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981102,130981,'齐桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981103,130981,'寺门村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981104,130981,'郝村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981105,130981,'富镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981106,130981,'文庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981107,130981,'洼里王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981108,130981,'四营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981201,130981,'王武庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981202,130981,'营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981204,130981,'西辛店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130981400,130981,'河北泊头经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982001,130982,'新华路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982002,130982,'西环路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982003,130982,'永丰路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982004,130982,'中华路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982005,130982,'渤海路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982006,130982,'油建路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982007,130982,'会战道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982100,130982,'出岸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982101,130982,'石门桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982102,130982,'吕公堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982103,130982,'长丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982106,130982,'梁召镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982107,130982,'辛中驿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982108,130982,'麻家坞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982109,130982,'北辛庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982110,130982,'议论堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982204,130982,'青塔乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982207,130982,'北汉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982208,130982,'于村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982400,130982,'华北石油管理局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130982500,130982,'河北任丘经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983001,130983,'骅东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983002,130983,'骅中街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983003,130983,'骅西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983100,130983,'黄骅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983101,130983,'南排河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983102,130983,'吕桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983103,130983,'旧城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983104,130983,'齐家务镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983105,130983,'滕庄子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983106,130983,'常郭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983107,130983,'羊二庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983204,130983,'官庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130983207,130983,'羊三木回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984001,130984,'瀛州路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984002,130984,'城垣西路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984101,130984,'米各庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984102,130984,'景和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984103,130984,'卧佛堂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984104,130984,'束城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984105,130984,'留古寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984106,130984,'沙河桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984107,130984,'诗经村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984108,130984,'尊祖庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984109,130984,'兴村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984110,130984,'行别营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984111,130984,'故仙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984201,130984,'黎民居乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984203,130984,'沙洼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984204,130984,'西九吉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984205,130984,'北石槽乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984209,130984,'时村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984212,130984,'龙华店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984213,130984,'果子洼回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(130984403,130984,'河北河间经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002001,131002,'银河南路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002002,131002,'光明西道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002003,131002,'永华道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002100,131002,'落垡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002101,131002,'码头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002102,131002,'葛渔城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002103,131002,'东沽港镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002104,131002,'调河头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002105,131002,'北史家务镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002106,131002,'杨税务镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002201,131002,'仇庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002400,131002,'廊坊龙河高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002401,131002,'河北廊坊高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002402,131002,'河北廊坊龙港经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131002403,131002,'河北安次经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003001,131003,'银河北路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003002,131003,'爱民东道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003003,131003,'解放道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003004,131003,'新开路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003005,131003,'新源道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003100,131003,'南尖塔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003101,131003,'万庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003102,131003,'九州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003103,131003,'北旺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131003500,131003,'新世纪步行街服务中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022100,131022,'固安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022101,131022,'宫村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022102,131022,'柳泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022103,131022,'牛驼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022104,131022,'马庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022200,131022,'东湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022201,131022,'彭村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022202,131022,'渠沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022203,131022,'礼让店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131022400,131022,'固安温泉休闲商务产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023001,131023,'城区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023100,131023,'永清镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023101,131023,'韩村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023102,131023,'后奕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023103,131023,'别古庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023104,131023,'里澜城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023200,131023,'管家务回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023201,131023,'曹家务乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023202,131023,'龙虎庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023203,131023,'刘街乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023204,131023,'三圣口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023400,131023,'河北永清经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131023401,131023,'北京亦庄永清高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024100,131024,'淑阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024101,131024,'蒋辛屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024102,131024,'渠口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024103,131024,'安头屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024104,131024,'安平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024105,131024,'刘宋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024106,131024,'五百户镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024107,131024,'钱旺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024108,131024,'钳屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024500,131024,'河北香河经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131024501,131024,'香河新兴产业示范区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025100,131025,'平舒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025101,131025,'旺村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025102,131025,'大尚屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025103,131025,'南赵扶镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025104,131025,'留各庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025105,131025,'权村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025106,131025,'里坦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025107,131025,'广安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025108,131025,'北魏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025109,131025,'臧屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131025400,131025,'河北大城经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026100,131026,'文安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026101,131026,'新镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026102,131026,'苏桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026103,131026,'大柳河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026104,131026,'左各庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026105,131026,'滩里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026106,131026,'史各庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026107,131026,'赵各庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026108,131026,'兴隆宫镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026109,131026,'大留镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026110,131026,'孙氏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026111,131026,'德归镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131026200,131026,'大围河回族满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131028001,131028,'北辰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131028100,131028,'大厂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131028101,131028,'夏垫镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131028102,131028,'祁各庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131028103,131028,'邵府镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131028104,131028,'陈府镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131028400,131028,'河北大厂高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131071450,131071,'耀华道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131071451,131071,'云鹏道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081001,131081,'裕华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081100,131081,'霸州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081101,131081,'南孟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081102,131081,'信安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081103,131081,'堂二里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081104,131081,'煎茶铺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081105,131081,'胜芳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081106,131081,'杨芬港镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081107,131081,'康仙庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081108,131081,'王庄子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081200,131081,'岔河集乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081202,131081,'东杨庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131081204,131081,'东段乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082001,131082,'鼎盛东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082002,131082,'泃阳西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082003,131082,'行宫东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082004,131082,'迎宾北路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082005,131082,'燕顺路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082006,131082,'康城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082100,131082,'泃阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082101,131082,'李旗庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082102,131082,'杨庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082103,131082,'皇庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082104,131082,'新集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082105,131082,'段甲岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082106,131082,'黄土庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082107,131082,'高楼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082108,131082,'齐心庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082109,131082,'燕郊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082450,131082,'燕郊高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131082451,131082,'河北三河国家农业科技园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131102001,131102,'河西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131102002,131102,'河东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131102003,131102,'路北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131102004,131102,'中华大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131102100,131102,'郑家河沿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131102101,131102,'赵家圈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131102102,131102,'邓庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131102200,131102,'何家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103100,131103,'冀州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103102,131103,'官道李镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103103,131103,'南午村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103104,131103,'周村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103105,131103,'码头李镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103106,131103,'西王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103200,131103,'门家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103201,131103,'徐家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103202,131103,'北漳淮乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103203,131103,'小寨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131103400,131103,'社区建设办公室',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121100,131121,'枣强镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121101,131121,'恩察镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121102,131121,'大营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121103,131121,'嘉会镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121104,131121,'马屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121105,131121,'肖张镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121106,131121,'张秀屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121107,131121,'新屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121108,131121,'唐林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121202,131121,'王均乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131121204,131121,'王常乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122100,131122,'武邑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122101,131122,'清凉店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122102,131122,'审坡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122103,131122,'赵桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122104,131122,'韩庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122105,131122,'肖桥头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122106,131122,'龙店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122201,131122,'圈头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131122203,131122,'大紫塔乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131123100,131123,'武强镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131123101,131123,'街关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131123102,131123,'周窝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131123103,131123,'东孙庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131123104,131123,'豆村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131123201,131123,'北代乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131124100,131124,'饶阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131124101,131124,'大尹村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131124102,131124,'五公镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131124103,131124,'大官亭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131124104,131124,'王同岳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131124105,131124,'东里满镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131124106,131124,'留楚镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125100,131125,'安平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125101,131125,'马店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125102,131125,'南王庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125103,131125,'大子文镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125104,131125,'东黄城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125200,131125,'大何庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125201,131125,'程油子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125202,131125,'西两洼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125400,131125,'高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131125401,131125,'社区建设办公室',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126100,131126,'郑口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126101,131126,'夏庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126102,131126,'青罕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126103,131126,'故城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126104,131126,'武官寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126105,131126,'饶阳店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126106,131126,'军屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126107,131126,'建国镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126108,131126,'西半屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126109,131126,'房庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126110,131126,'三朗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126200,131126,'辛庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131126201,131126,'里老乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127100,131127,'景州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127101,131127,'龙华镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127102,131127,'广川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127103,131127,'王瞳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127104,131127,'洚河流镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127105,131127,'安陵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127106,131127,'杜桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127107,131127,'王谦寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127108,131127,'北留智镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127109,131127,'留智庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127110,131127,'梁集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127200,131127,'刘集乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127201,131127,'连镇乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127203,131127,'温城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127204,131127,'后留名府乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131127205,131127,'青兰乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128100,131128,'阜城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128101,131128,'古城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128102,131128,'码头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128103,131128,'霞口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128104,131128,'崔家庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128105,131128,'漫河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128201,131128,'建桥乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128202,131128,'蒋坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128203,131128,'大白乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131128204,131128,'王集乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131171201,131171,'大麻森乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131171400,131171,'高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131171401,131171,'新型功能材料产业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131171402,131171,'苏正办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131172101,131172,'魏家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131172203,131172,'彭杜村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131172401,131172,'滨湖新区教育园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182100,131182,'唐奉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182101,131182,'深州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182102,131182,'辰时镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182103,131182,'榆科镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182104,131182,'魏家桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182105,131182,'大堤镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182106,131182,'前磨头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182107,131182,'王家井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182108,131182,'护驾迟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182109,131182,'大屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182110,131182,'高古庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182111,131182,'北溪村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182112,131182,'大冯营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182200,131182,'兵曹乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182201,131182,'穆村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182202,131182,'东安庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182206,131182,'乔屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182400,131182,'深州监狱',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182401,131182,'城市新区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(131182403,131182,'经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105001,140105,'坞城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105002,140105,'营盘街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105003,140105,'北营街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105004,140105,'平阳路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105005,140105,'黄陵街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105006,140105,'小店街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105007,140105,'龙城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105100,140105,'北格镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105200,140105,'西温庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140105201,140105,'刘家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140106001,140106,'柳巷街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140106002,140106,'文庙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140106003,140106,'庙前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140106004,140106,'迎泽街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140106005,140106,'桥东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140106006,140106,'老军营街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140106100,140106,'郝庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107001,140107,'巨轮街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107002,140107,'三桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107003,140107,'鼓楼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107004,140107,'杏花岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107005,140107,'坝陵桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107006,140107,'大东关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107007,140107,'职工新街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107008,140107,'敦化坊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107009,140107,'涧河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107010,140107,'杨家峪街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107011,140107,'享堂街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140107100,140107,'中涧河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108001,140108,'尖草坪街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108002,140108,'光社街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108003,140108,'上兰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108004,140108,'南寨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108005,140108,'迎新街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108006,140108,'古城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108007,140108,'汇丰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108008,140108,'柴村街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108009,140108,'新城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108100,140108,'向阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108101,140108,'阳曲镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108201,140108,'柏板乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108202,140108,'西墕乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140108400,140108,'太原中北高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109001,140109,'千峰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109002,140109,'下元街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109003,140109,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109004,140109,'兴华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109005,140109,'万柏林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109006,140109,'杜儿坪街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109007,140109,'白家庄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109008,140109,'南寒街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109009,140109,'东社街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109011,140109,'小井峪街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109012,140109,'西铭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109013,140109,'长风西街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109014,140109,'神堂沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140109015,140109,'王化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140110001,140110,'义井街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140110002,140110,'罗城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140110003,140110,'晋源街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140110100,140110,'金胜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140110101,140110,'晋祠镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140110102,140110,'姚村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121100,140121,'清源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121101,140121,'徐沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121102,140121,'东于镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121103,140121,'孟封镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121200,140121,'马峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121201,140121,'柳杜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121202,140121,'西谷乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121203,140121,'王答乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140121204,140121,'集义乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122100,140122,'黄寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122101,140122,'大盂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122102,140122,'东黄水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122103,140122,'泥屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122200,140122,'高村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122201,140122,'侯村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122202,140122,'凌井店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122203,140122,'西凌井乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122205,140122,'杨兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140122400,140122,'中心镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140123100,140123,'娄烦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140123101,140123,'静游镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140123102,140123,'杜交曲镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140123201,140123,'马家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140123202,140123,'盖家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140123203,140123,'米峪镇乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140123204,140123,'天池店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140171401,140171,'唐槐园区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140171402,140171,'学府园区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140171403,140171,'阳曲产业园区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140171404,140171,'潇河园区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140171405,140171,'科创城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181001,140181,'东曲街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181002,140181,'西曲街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181003,140181,'桃园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181004,140181,'屯兰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181100,140181,'河口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181101,140181,'镇城底镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181102,140181,'马兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181201,140181,'嘉乐泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181202,140181,'梭峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181203,140181,'岔口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181204,140181,'常安乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181205,140181,'原相乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140181206,140181,'邢家社乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140212100,140212,'新荣镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140212101,140212,'古店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140212102,140212,'花园屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140212200,140212,'破鲁堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140212202,140212,'郭家窑乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140212206,140212,'西村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140212209,140212,'堡子湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213050,140213,'永泰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213051,140213,'古城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213052,140213,'新旺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213053,140213,'迎宾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213054,140213,'振华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213055,140213,'清远街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213056,140213,'武定街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213057,140213,'御河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213058,140213,'开源街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213059,140213,'大庆路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213060,140213,'马军营街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213061,140213,'卧虎湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213062,140213,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213063,140213,'鹿苑街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213064,140213,'白登山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213065,140213,'文瀛湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213066,140213,'水泊寺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140213067,140213,'小南头街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214001,140214,'新胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214002,140214,'新平旺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214016,140214,'新泉路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214017,140214,'民胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214018,140214,'口泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214023,140214,'平泉路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214025,140214,'和顺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214026,140214,'和瑞街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214027,140214,'平盛路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214028,140214,'清泉街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214029,140214,'西花园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214030,140214,'老平旺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214031,140214,'新文街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214032,140214,'和旺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214033,140214,'玉龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214034,140214,'云武街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214035,140214,'云燕街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214036,140214,'玉泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214037,140214,'平德街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214038,140214,'平喜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214039,140214,'平源街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214101,140214,'高山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214102,140214,'云冈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214200,140214,'口泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214206,140214,'西韩岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214207,140214,'平旺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140214210,140214,'鸦儿崖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215100,140215,'西坪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215101,140215,'倍加造镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215102,140215,'周士庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215201,140215,'吉家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215202,140215,'峰峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215204,140215,'杜庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215205,140215,'党留庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215209,140215,'聚乐乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140215211,140215,'许堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221100,140221,'龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221101,140221,'罗文皂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221102,140221,'大白登镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221103,140221,'王官屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221104,140221,'古城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221105,140221,'东小村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221106,140221,'友宰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221201,140221,'长城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221204,140221,'狮子屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221209,140221,'下深井乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140221212,140221,'鳌石乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222100,140222,'玉泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222101,140222,'谷前堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222102,140222,'米薪关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222103,140222,'逯家湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222104,140222,'新平堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222200,140222,'卅里铺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222204,140222,'贾家屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222206,140222,'赵家沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222208,140222,'南高崖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222209,140222,'张西河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140222210,140222,'马家皂乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140223100,140223,'壶泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140223101,140223,'南村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140223102,140223,'加斗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140223103,140223,'作疃镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140223104,140223,'梁庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140223200,140223,'一斗泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140223202,140223,'蕉山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140223206,140223,'宜兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224100,140224,'武灵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224101,140224,'东河南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224102,140224,'上寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224200,140224,'落水河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224205,140224,'赵北乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224206,140224,'石家田乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224207,140224,'柳科乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224208,140224,'白崖台乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224210,140224,'红石塄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224212,140224,'下关乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140224213,140224,'独峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225100,140225,'永安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225101,140225,'西坊城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225102,140225,'蔡村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225103,140225,'沙圪坨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225104,140225,'王庄堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225106,140225,'青磁窑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225201,140225,'东坊城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225203,140225,'裴村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225204,140225,'驼峰乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225205,140225,'西留村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225206,140225,'下韩村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225208,140225,'南榆林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225210,140225,'吴城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225213,140225,'大仁庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225215,140225,'千佛岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140225218,140225,'官儿乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140226100,140226,'云兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140226101,140226,'鹊儿山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140226102,140226,'店湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140226200,140226,'管家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140226201,140226,'张家场乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140226205,140226,'三屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140226206,140226,'马道头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140226207,140226,'小京庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140271400,140271,'经济技术开发区乡级单位',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140302001,140302,'上站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140302002,140302,'下站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140302003,140302,'北大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140302004,140302,'南山路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140302005,140302,'义井街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140302100,140302,'义井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140303001,140303,'平潭街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140303003,140303,'蔡洼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140303004,140303,'赛鱼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140303005,140303,'沙坪街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140303006,140303,'贵石沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140303007,140303,'桥头街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140311100,140311,'荫营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140311101,140311,'河底镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140311103,140311,'平坦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140311200,140311,'西南舁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140311201,140311,'杨家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140311202,140311,'李家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140311203,140311,'旧街乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140311400,140311,'开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321100,140321,'冠山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321101,140321,'冶西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321102,140321,'锁簧镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321103,140321,'张庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321104,140321,'东回镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321105,140321,'柏井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321106,140321,'娘子关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321107,140321,'巨城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321200,140321,'石门口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140321201,140321,'岔口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322100,140322,'秀水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322101,140322,'孙家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322102,140322,'路家村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322103,140322,'南娄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322104,140322,'牛村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322105,140322,'苌池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322106,140322,'上社镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322107,140322,'西烟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322200,140322,'仙人乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322201,140322,'北下庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322203,140322,'梁家寨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322204,140322,'西潘乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140322205,140322,'东梁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403001,140403,'东街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403002,140403,'西街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403003,140403,'英雄南路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403004,140403,'英雄中路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403005,140403,'紫金街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403006,140403,'太行东街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403007,140403,'太行西街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403008,140403,'延安南路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403009,140403,'常青街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403010,140403,'五马街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403013,140403,'堠北庄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403014,140403,'老顶山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403015,140403,'大辛庄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403103,140403,'马厂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403104,140403,'黄碾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403105,140403,'西白兔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403400,140403,'长治市漳泽工业转型试验区管理委员会社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403401,140403,'长治市老顶山旅游开发管理中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140403403,140403,'长治经济技术开发区潞州区部分',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404001,140404,'韩店街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404101,140404,'苏店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404102,140404,'荫城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404103,140404,'西火镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404104,140404,'八义镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404106,140404,'郝家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404107,140404,'南宋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404201,140404,'西池乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404202,140404,'北呈乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404203,140404,'东和乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404400,140404,'振兴乡村生态文化旅游区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404401,140404,'上党经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140404406,140404,'长治市经济技术开发区上党区部分',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405001,140405,'麟绛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405101,140405,'上村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405102,140405,'渔泽镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405103,140405,'余吾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405104,140405,'吾元镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405105,140405,'张店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405106,140405,'丰宜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405200,140405,'李高乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405201,140405,'路村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405202,140405,'河神庙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405400,140405,'西流寨开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405401,140405,'康庄工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405402,140405,'上莲开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140405403,140405,'屯留经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406001,140406,'潞华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406002,140406,'成家川街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406003,140406,'翟店街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406100,140406,'店上镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406101,140406,'微子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406102,140406,'辛安泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406104,140406,'史回镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406201,140406,'黄牛蹄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140406400,140406,'潞城经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423100,140423,'古韩镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423101,140423,'王桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423102,140423,'侯堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423103,140423,'夏店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423104,140423,'虒亭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423105,140423,'西营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423106,140423,'王村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423107,140423,'下良镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423108,140423,'善福镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140423402,140423,'襄垣经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425100,140425,'青羊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425101,140425,'龙溪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425102,140425,'石城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425103,140425,'苗庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425104,140425,'玉峡关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425200,140425,'西沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425201,140425,'东寺头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425202,140425,'虹梯关乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425203,140425,'阳高乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425204,140425,'北耽车乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425206,140425,'北社乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140425400,140425,'平顺经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426101,140426,'东阳关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426102,140426,'上遥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426103,140426,'西井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426104,140426,'黄崖洞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426105,140426,'黎侯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426106,140426,'洪井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426107,140426,'西仵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426108,140426,'程家山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140426400,140426,'黎城县经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427100,140427,'龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427101,140427,'百尺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427102,140427,'店上镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427103,140427,'晋庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427104,140427,'树掌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427105,140427,'大峡谷镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427106,140427,'集店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427201,140427,'黄山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427202,140427,'东井岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427203,140427,'石坡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140427401,140427,'壶关县经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428100,140428,'丹朱镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428101,140428,'鲍店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428102,140428,'石哲镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428103,140428,'大堡头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428104,140428,'慈林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428105,140428,'色头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428106,140428,'南漳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428107,140428,'宋村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428108,140428,'南陈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428201,140428,'碾张乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428202,140428,'常张乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140428400,140428,'长子经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429100,140429,'丰州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429101,140429,'洪水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429102,140429,'蟠龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429103,140429,'监漳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429104,140429,'故城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429105,140429,'韩北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429202,140429,'大有乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429203,140429,'贾豁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429205,140429,'上司乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429206,140429,'石北乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429207,140429,'涌泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429208,140429,'分水岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429400,140429,'武乡经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140429401,140429,'武乡县现代农业产业示范区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430100,140430,'定昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430101,140430,'郭村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430102,140430,'故县镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430103,140430,'新店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430104,140430,'漳源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430105,140430,'册村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430106,140430,'沁州黄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430107,140430,'南里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430108,140430,'松村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430203,140430,'牛寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430206,140430,'杨安乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140430400,140430,'沁县现代农业产业示范区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431100,140431,'沁河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431101,140431,'郭道镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431102,140431,'灵空山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431103,140431,'王和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431105,140431,'王陶镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431107,140431,'景凤镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431200,140431,'中峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431201,140431,'法中乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431202,140431,'交口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431203,140431,'聪子峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431204,140431,'韩洪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431207,140431,'赤石桥乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140431400,140431,'沁源经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140471400,140471,'长治高新技术开发区城北街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140502001,140502,'东街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140502002,140502,'西街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140502003,140502,'南街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140502004,140502,'北街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140502006,140502,'钟家庄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140502007,140502,'西上庄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140502009,140502,'开发区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140502100,140502,'北石店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521100,140521,'龙港镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521101,140521,'中村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521102,140521,'郑庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521103,140521,'端氏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521104,140521,'嘉峰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521105,140521,'郑村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521106,140521,'柿庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521201,140521,'土沃乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46');

INSERT INTO `eb_city_region` (`region_id`, `parent_id`, `region_name`, `region_type`, `create_time`, `update_time`)
VALUES
	(140521202,140521,'张村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521204,140521,'胡底乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521205,140521,'固县乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140521206,140521,'十里乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522100,140522,'凤城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522101,140522,'北留镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522102,140522,'润城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522103,140522,'町店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522104,140522,'芹池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522105,140522,'次营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522106,140522,'横河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522107,140522,'河北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522108,140522,'蟒河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522109,140522,'东冶镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522110,140522,'演礼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522111,140522,'白桑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522201,140522,'寺头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522202,140522,'西河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140522205,140522,'董封乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524100,140524,'崇文镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524101,140524,'礼义镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524102,140524,'附城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524103,140524,'西河底镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524104,140524,'平城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524105,140524,'杨村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524106,140524,'潞城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524204,140524,'夺火乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524206,140524,'马圪当乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524207,140524,'古郊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140524209,140524,'六泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525100,140525,'南村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525101,140525,'下村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525102,140525,'大东沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525103,140525,'周村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525104,140525,'犁川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525105,140525,'晋庙铺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525106,140525,'金村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525107,140525,'高都镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525108,140525,'巴公镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525109,140525,'大阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525110,140525,'山河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525111,140525,'大箕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525112,140525,'柳树口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525113,140525,'北义城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525114,140525,'川底镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140525115,140525,'南岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581001,140581,'北城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581002,140581,'东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581003,140581,'南城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581101,140581,'米山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581102,140581,'三甲镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581103,140581,'神农镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581104,140581,'陈区镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581105,140581,'北诗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581106,140581,'河西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581107,140581,'马村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581108,140581,'野川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581109,140581,'寺庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581201,140581,'建宁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581202,140581,'石末乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140581203,140581,'原村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602001,140602,'北城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602002,140602,'南城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602003,140602,'神头街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602004,140602,'北旺庄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602100,140602,'神头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602101,140602,'利民镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602200,140602,'下团堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602201,140602,'小平易乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602202,140602,'滋润乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602204,140602,'南榆林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602205,140602,'贾庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602206,140602,'沙塄河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602207,140602,'窑子头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140602208,140602,'张蔡庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603100,140603,'井坪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603101,140603,'凤凰城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603200,140603,'白堂乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603201,140603,'陶村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603202,140603,'下水头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603203,140603,'双碾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603204,140603,'阻虎乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603205,140603,'高石庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603206,140603,'西水界乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603207,140603,'下面高乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603209,140603,'向阳堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140603210,140603,'榆岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621100,140621,'玉井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621101,140621,'北周庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621102,140621,'古城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621103,140621,'岱岳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621104,140621,'广武镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621200,140621,'吴马营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621201,140621,'马营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621202,140621,'下喇叭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621203,140621,'合盛堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621205,140621,'安荣乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621206,140621,'薛圐圙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140621209,140621,'马营庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622100,140622,'金城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622101,140622,'南河种镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622102,140622,'下社镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622200,140622,'镇子梁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622201,140622,'义井乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622202,140622,'臧寨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622203,140622,'大黄巍乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622204,140622,'杏寨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622205,140622,'下马峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622206,140622,'南泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622207,140622,'大临河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140622208,140622,'白马石乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140623100,140623,'新城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140623101,140623,'右卫镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140623102,140623,'威远镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140623103,140623,'元堡子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140623200,140623,'牛心堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140623202,140623,'高家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140623204,140623,'杨千河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140623205,140623,'李达窑乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140671400,140671,'山西朔州经济开发区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681001,140681,'云东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681002,140681,'云中街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681003,140681,'云西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681101,140681,'吴家窑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681102,140681,'金沙滩镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681103,140681,'毛家皂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681200,140681,'何家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681201,140681,'新家园乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681202,140681,'亲和乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681203,140681,'海北头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681205,140681,'河头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681500,140681,'金沙滩农牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140681501,140681,'金沙滩林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702001,140702,'北关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702002,140702,'锦纶街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702003,140702,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702004,140702,'西南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702005,140702,'路西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702006,140702,'经纬街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702007,140702,'安宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702008,140702,'新建街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702009,140702,'晋华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702100,140702,'乌金山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702101,140702,'东阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702103,140702,'长凝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702104,140702,'北田镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702105,140702,'修文镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702200,140702,'郭家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702201,140702,'张庆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702202,140702,'庄子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702203,140702,'东赵乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702401,140702,'山西转型综合改革示范区晋中开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140702402,140702,'榆次区使赵乡社会事务管理中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703101,140703,'胡村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703102,140703,'范村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703103,140703,'水秀镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703200,140703,'侯城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703201,140703,'北汪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703203,140703,'阳邑乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703204,140703,'小白乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703205,140703,'任村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703401,140703,'白塔区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703402,140703,'北城区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140703403,140703,'南城区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140721100,140721,'箕城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140721101,140721,'云簇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140721102,140721,'郝北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140721103,140721,'社城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140721200,140721,'河峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140721201,140721,'北寨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140721202,140721,'西马乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140721400,140721,'城区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722100,140722,'辽阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722101,140722,'桐峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722102,140722,'麻田镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722103,140722,'芹泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722104,140722,'拐儿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722200,140722,'寒王乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722201,140722,'石匣乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722204,140722,'羊角乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140722400,140722,'城区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723100,140723,'义兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723101,140723,'李阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723102,140723,'松烟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723103,140723,'青城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723104,140723,'横岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723200,140723,'喂马乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723201,140723,'平松乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723203,140723,'马坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140723400,140723,'城区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724100,140724,'乐平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724101,140724,'皋落镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724102,140724,'冶头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724103,140724,'沾尚镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724104,140724,'大寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724200,140724,'李家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724201,140724,'界都乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724202,140724,'三都乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724203,140724,'赵壁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724204,140724,'孔氏乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140724400,140724,'城区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725100,140725,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725101,140725,'南燕竹镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725102,140725,'宗艾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725103,140725,'平头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725104,140725,'松塔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725105,140725,'西洛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725106,140725,'尹灵芝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725200,140725,'平舒乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725201,140725,'解愁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725202,140725,'温家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725203,140725,'景尚乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140725205,140725,'羊头崖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727100,140727,'昭馀镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727101,140727,'东观镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727102,140727,'古县镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727103,140727,'贾令镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727104,140727,'城赵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727105,140727,'来远镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727201,140727,'峪口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727400,140727,'祁县经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140727404,140727,'城区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728001,140728,'古城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728002,140728,'城东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728003,140728,'城西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728100,140728,'古陶镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728101,140728,'段村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728102,140728,'东泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728103,140728,'洪善镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728104,140728,'宁固镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728200,140728,'南政乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728201,140728,'中都乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728202,140728,'岳壁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728203,140728,'卜宜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728205,140728,'朱坑乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728206,140728,'襄垣乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728207,140728,'杜家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140728208,140728,'香乐乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729100,140729,'翠峰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729101,140729,'静升镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729102,140729,'两渡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729103,140729,'夏门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729104,140729,'南关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729105,140729,'段纯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729202,140729,'王禹乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729203,140729,'坛镇乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729204,140729,'梁家焉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729205,140729,'交口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140729403,140729,'灵石县城区社会事务服务中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781001,140781,'北关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781002,140781,'西关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781003,140781,'东南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781004,140781,'西南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781005,140781,'北坛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781100,140781,'义安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781101,140781,'张兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781102,140781,'连福镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781103,140781,'洪山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781104,140781,'龙凤镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781105,140781,'绵山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781106,140781,'义棠镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781200,140781,'城关乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140781201,140781,'宋古乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802001,140802,'中城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802002,140802,'东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802003,140802,'西城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802004,140802,'南城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802005,140802,'北城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802006,140802,'安邑街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802007,140802,'大渠街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802008,140802,'姚孟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802100,140802,'解州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802101,140802,'龙居镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802102,140802,'北相镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802103,140802,'泓芝驿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802104,140802,'三路里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802105,140802,'陶村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802106,140802,'东郭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802200,140802,'席张乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802201,140802,'金井乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802202,140802,'王范乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802203,140802,'冯村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802204,140802,'上郭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802205,140802,'上王乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140802404,140802,'运城经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821100,140821,'猗氏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821101,140821,'嵋阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821102,140821,'临晋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821103,140821,'七级镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821104,140821,'东张镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821105,140821,'孙吉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821106,140821,'三管镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821107,140821,'牛杜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821108,140821,'耽子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821109,140821,'角杯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821200,140821,'楚侯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821201,140821,'庙上乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821203,140821,'北辛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821204,140821,'北景乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140821402,140821,'临猗县城市社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822100,140822,'解店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822101,140822,'通化镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822102,140822,'汉薛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822103,140822,'荣河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822104,140822,'裴庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822105,140822,'高村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822200,140822,'万泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822201,140822,'里望乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822202,140822,'西村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822203,140822,'南张乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822205,140822,'皇甫乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822206,140822,'贾村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822207,140822,'王显乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140822208,140822,'光华乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823100,140823,'桐城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823101,140823,'郭家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823102,140823,'畖底镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823103,140823,'薛店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823104,140823,'东镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823105,140823,'礼元镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823106,140823,'河底镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823107,140823,'阳隅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823108,140823,'侯村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823109,140823,'裴社镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823204,140823,'后宫乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823205,140823,'石门乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140823400,140823,'闻喜县社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824100,140824,'稷峰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824101,140824,'西社镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824102,140824,'化峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824103,140824,'翟店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824104,140824,'清河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824200,140824,'蔡村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824201,140824,'太阳乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824400,140824,'稷山县社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140824401,140824,'稷山县经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825100,140825,'龙兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825101,140825,'三泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825102,140825,'泽掌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825103,140825,'北张镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825104,140825,'古交镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825105,140825,'万安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825106,140825,'阳王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825107,140825,'泉掌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825108,140825,'横桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825400,140825,'新绛县社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140825498,140825,'新绛县经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826100,140826,'古绛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826101,140826,'横水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826102,140826,'陈村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826103,140826,'卫庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826104,140826,'磨里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826105,140826,'南樊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826106,140826,'安峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826107,140826,'大交镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826200,140826,'郝庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826201,140826,'冷口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826400,140826,'绛县社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140826402,140826,'山西绛县经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827100,140827,'新城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827101,140827,'历山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827102,140827,'古城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827103,140827,'王茅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827104,140827,'毛家湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827105,140827,'英言镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827200,140827,'蒲掌乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827202,140827,'解峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827203,140827,'华峰乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827204,140827,'长直乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827205,140827,'皋落乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140827400,140827,'垣曲县城市社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828100,140828,'瑶峰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828101,140828,'庙前镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828102,140828,'裴介镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828103,140828,'水头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828104,140828,'埝掌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828105,140828,'泗交镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828106,140828,'禹王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828200,140828,'尉郭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828202,140828,'胡张乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828203,140828,'南大里乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140828204,140828,'祁家河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829100,140829,'圣人涧镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829101,140829,'常乐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829102,140829,'张店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829103,140829,'张村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829104,140829,'曹川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829105,140829,'三门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829106,140829,'部官镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829107,140829,'洪池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829201,140829,'杜马乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140829400,140829,'平陆县社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830100,140830,'古魏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830101,140830,'风陵渡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830102,140830,'陌南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830103,140830,'西陌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830104,140830,'永乐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830105,140830,'大王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830106,140830,'阳城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830107,140830,'南磑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830200,140830,'东垆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830202,140830,'学张乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830401,140830,'芮城县社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140830402,140830,'山西风陵渡经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881001,140881,'城西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881002,140881,'城北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881003,140881,'城东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881100,140881,'虞乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881101,140881,'卿头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881102,140881,'开张镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881103,140881,'栲栳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881104,140881,'蒲州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881105,140881,'韩阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881106,140881,'张营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881400,140881,'永济监狱',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881401,140881,'山西省永济虞乡强制隔离戒毒所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140881402,140881,'山西省永济董村强制隔离戒毒所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882001,140882,'城区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882002,140882,'清涧街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882003,140882,'赵家庄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882004,140882,'阳村街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882100,140882,'樊村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882101,140882,'僧楼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882102,140882,'柴家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882200,140882,'小梁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882203,140882,'下化乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140882450,140882,'山西铝厂',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902001,140902,'秀容街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902002,140902,'长征街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902003,140902,'新建路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902004,140902,'云中路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902005,140902,'九原街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902006,140902,'旭来街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902007,140902,'桥西街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902101,140902,'奇村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902102,140902,'三交镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902103,140902,'庄磨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902104,140902,'豆罗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902105,140902,'董村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902106,140902,'西张镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902107,140902,'忻口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902108,140902,'合索镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902206,140902,'兰村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902209,140902,'东楼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140902210,140902,'北义井乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921100,140921,'晋昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921101,140921,'河边镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921102,140921,'宏道镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921103,140921,'季庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921104,140921,'蒋村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921201,140921,'南王乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921203,140921,'神山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921205,140921,'受禄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140921400,140921,'定襄县居民办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922100,140922,'台城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922102,140922,'耿镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922103,140922,'豆村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922104,140922,'白家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922105,140922,'东冶镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922107,140922,'建安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922200,140922,'沟南乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922201,140922,'东雷乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922202,140922,'高洪口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922203,140922,'门限石乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922204,140922,'陈家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922207,140922,'蒋坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922209,140922,'阳白乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140922210,140922,'茹村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923100,140923,'上馆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923101,140923,'阳明堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923102,140923,'峨口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923103,140923,'聂营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923104,140923,'枣林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923106,140923,'雁门关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923107,140923,'峪口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923200,140923,'新高乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923202,140923,'上磨坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140923400,140923,'代县居民事务中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924100,140924,'繁城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924101,140924,'砂河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924102,140924,'大营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924103,140924,'平型关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924200,140924,'下茹越乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924202,140924,'光裕堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924203,140924,'集义庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924204,140924,'东山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924205,140924,'金山铺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924208,140924,'神堂堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140924209,140924,'岩头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925100,140925,'凤凰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925101,140925,'阳方口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925102,140925,'东寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925103,140925,'石家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925104,140925,'宁化镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925200,140925,'薛家洼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925201,140925,'余庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925202,140925,'涔山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925204,140925,'西马坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925206,140925,'迭台寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925208,140925,'怀道乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925209,140925,'东马坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925400,140925,'阳方口煤矿',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140925401,140925,'宁武县居民办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926100,140926,'鹅城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926101,140926,'杜家村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926102,140926,'康家会镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926103,140926,'丰润镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926104,140926,'双路镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926105,140926,'王村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926204,140926,'段家寨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926205,140926,'辛村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926207,140926,'神峪沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926208,140926,'娘子神乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926209,140926,'娑婆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926210,140926,'赤泥窊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140926400,140926,'静乐县居民办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927100,140927,'龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927101,140927,'义井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927102,140927,'八角镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927200,140927,'东湖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927203,140927,'贺职乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927204,140927,'长畛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927205,140927,'烈堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927206,140927,'大严备乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140927400,140927,'神池县城镇街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928100,140928,'砚城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928101,140928,'小河头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928102,140928,'三岔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928200,140928,'前所乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928201,140928,'李家坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928202,140928,'孙家坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928204,140928,'胡会乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928206,140928,'韩家楼乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928207,140928,'东秀庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928208,140928,'杏岭子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140928400,140928,'五寨县居民办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929100,140929,'岚漪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929101,140929,'三井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929102,140929,'宋家沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929201,140929,'高家会乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929202,140929,'李家沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929203,140929,'水峪贯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929204,140929,'西豹峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929205,140929,'温泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929206,140929,'阳坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929207,140929,'大涧乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140929400,140929,'岢岚县居民办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930100,140930,'西口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930101,140930,'楼子营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930102,140930,'刘家塔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930103,140930,'巡镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930104,140930,'旧县镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930105,140930,'沙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930200,140930,'鹿固乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930202,140930,'单寨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930203,140930,'土沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930205,140930,'沙坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140930206,140930,'社梁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931100,140931,'东关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931101,140931,'义门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931102,140931,'桥头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931103,140931,'杨家湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931104,140931,'孙家沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931200,140931,'腰庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931201,140931,'韩家川乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931202,140931,'林遮峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931203,140931,'冯家川乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931204,140931,'土崖塔乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931208,140931,'南河沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140931400,140931,'保德县居民事务中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140932100,140932,'新关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140932102,140932,'老营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140932103,140932,'万家寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140932104,140932,'水泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140932105,140932,'老牛湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140932106,140932,'尚峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140932200,140932,'窑头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140932201,140932,'楼沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140971100,140971,'台怀镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140971101,140971,'石咀镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140971200,140971,'金岗库乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981001,140981,'北城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981002,140981,'南城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981004,140981,'新原街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981005,140981,'吉祥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981101,140981,'苏龙口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981102,140981,'崞阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981103,140981,'大牛店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981104,140981,'闫庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981106,140981,'轩岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981107,140981,'云水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981108,140981,'同川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981202,140981,'子干乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981203,140981,'中阳乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981204,140981,'沿沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981205,140981,'大林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981206,140981,'西镇乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981208,140981,'王家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981210,140981,'段家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981400,140981,'山西鲁能晋北铝业工矿区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981401,140981,'原平市石豹沟煤矿工矿区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981403,140981,'原平农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(140981404,140981,'原平经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002001,141002,'解放路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002002,141002,'鼓楼西街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002003,141002,'水塔街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002004,141002,'南街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002005,141002,'乡贤街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002006,141002,'辛寺街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002007,141002,'铁路东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002008,141002,'车站街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002009,141002,'汾河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002010,141002,'滨河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002100,141002,'屯里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002101,141002,'乔李镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002102,141002,'大阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002103,141002,'县底镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002104,141002,'刘村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002105,141002,'金殿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002106,141002,'吴村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002107,141002,'土门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002108,141002,'魏村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002109,141002,'尧庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002200,141002,'段店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002201,141002,'贾得乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002203,141002,'一平垣乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002204,141002,'枕头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141002401,141002,'临汾经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141021100,141021,'乐昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141021101,141021,'史村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141021102,141021,'曲村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141021103,141021,'高显镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141021104,141021,'里村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141021200,141021,'北董乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141021201,141021,'杨谈乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022100,141022,'唐兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022101,141022,'南梁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022102,141022,'里砦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022103,141022,'隆化镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022104,141022,'桥上镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022105,141022,'西阎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022106,141022,'王庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022200,141022,'中卫乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141022201,141022,'南唐乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023100,141023,'新城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023101,141023,'赵康镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023102,141023,'汾城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023103,141023,'南贾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023104,141023,'古城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023105,141023,'襄陵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023106,141023,'邓庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023200,141023,'陶寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023201,141023,'永固乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023202,141023,'景毛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023203,141023,'西贾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023204,141023,'南辛店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141023205,141023,'大邓乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024100,141024,'大槐树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024101,141024,'甘亭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024102,141024,'曲亭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024103,141024,'苏堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024104,141024,'广胜寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024105,141024,'明姜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024106,141024,'赵城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024107,141024,'万安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024108,141024,'刘家垣镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024109,141024,'辛村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024200,141024,'淹底乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024201,141024,'兴唐寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024202,141024,'堤村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024204,141024,'龙马乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141024207,141024,'山目乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141025100,141025,'岳阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141025101,141025,'北平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141025102,141025,'古阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141025103,141025,'旧县镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141025104,141025,'三合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141025202,141025,'南垣乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141026100,141026,'府城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141026101,141026,'和川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141026102,141026,'唐城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141026103,141026,'冀氏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141026104,141026,'良马镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141026105,141026,'马壁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141027100,141027,'天坛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141027101,141027,'响水河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141027102,141027,'张庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141027103,141027,'北王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141027201,141027,'东张乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141027202,141027,'槐埝乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141027206,141027,'寨圪塔乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141028100,141028,'吉昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141028101,141028,'屯里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141028102,141028,'壶口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141028200,141028,'车城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141028201,141028,'文城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141028203,141028,'柏山寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141028204,141028,'中垛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029100,141029,'昌宁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029101,141029,'光华镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029102,141029,'台头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029103,141029,'管头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029104,141029,'西坡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029200,141029,'双鹤乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029201,141029,'关王庙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029202,141029,'尉庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029203,141029,'西交口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141029204,141029,'枣岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141030100,141030,'昕水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141030101,141030,'曲峨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141030102,141030,'太古镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141030200,141030,'三多乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141030201,141030,'太德乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141031100,141031,'龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141031101,141031,'午城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141031102,141031,'黄土镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141031200,141031,'阳头升乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141031201,141031,'寨子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141031203,141031,'下李乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141031204,141031,'城南乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141032100,141032,'芝河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141032101,141032,'桑壁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141032203,141032,'坡头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141032205,141032,'乾坤湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141032206,141032,'望海寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141032207,141032,'楼山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141033100,141033,'蒲城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141033101,141033,'薛关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141033102,141033,'黑龙关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141033103,141033,'克城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141033104,141033,'乔家湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141033200,141033,'山中乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141033201,141033,'古县乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141033204,141033,'太林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141034100,141034,'永安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141034101,141034,'对竹镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141034102,141034,'勍香镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141034103,141034,'和平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141034104,141034,'僧念镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141034200,141034,'佃坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141034201,141034,'团柏乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141034400,141034,'社区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141081001,141081,'路东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141081002,141081,'路西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141081003,141081,'浍滨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141081004,141081,'上马街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141081005,141081,'张村街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141081200,141081,'新田乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141081201,141081,'高村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141081202,141081,'凤城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082001,141082,'鼓楼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082002,141082,'北环路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082003,141082,'南环路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082004,141082,'开元街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082005,141082,'退沙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082100,141082,'白龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082101,141082,'辛置镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082102,141082,'大张镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082103,141082,'李曹镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082200,141082,'陶唐峪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082201,141082,'三教乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141082202,141082,'师庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102001,141102,'滨河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102002,141102,'凤山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102003,141102,'莲花池街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102004,141102,'城北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102005,141102,'田家会街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102006,141102,'交口街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102007,141102,'西属巴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102100,141102,'吴城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102101,141102,'信义镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102201,141102,'枣林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141102202,141102,'坪头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121100,141121,'凤城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121101,141121,'开栅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121102,141121,'南庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121103,141121,'南安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121104,141121,'刘胡兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121105,141121,'下曲镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121106,141121,'孝义镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121200,141121,'南武乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121201,141121,'西城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121202,141121,'北张乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121203,141121,'马西乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141121204,141121,'西槽头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122100,141122,'天宁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122101,141122,'夏家营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122102,141122,'西营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122103,141122,'水峪贯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122104,141122,'西社镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122105,141122,'庞泉沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122106,141122,'洪相镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122202,141122,'东坡底乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141122400,141122,'夏家营生态工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123100,141123,'蔚汾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123101,141123,'魏家滩镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123102,141123,'瓦塘镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123103,141123,'康宁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123104,141123,'高家村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123105,141123,'罗峪口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123106,141123,'蔡家会镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123200,141123,'交楼申乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123202,141123,'东会乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123203,141123,'固贤乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123204,141123,'奥家湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123205,141123,'蔡家崖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123207,141123,'孟家坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123208,141123,'赵家坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123209,141123,'圪垯上乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141123400,141123,'兴县经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124100,141124,'临泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124101,141124,'白文镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124102,141124,'城庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124103,141124,'兔坂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124104,141124,'克虎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124105,141124,'三交镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124106,141124,'湍水头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124107,141124,'林家坪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124108,141124,'招贤镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124109,141124,'碛口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124110,141124,'刘家会镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124111,141124,'丛罗峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124112,141124,'曲峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124200,141124,'木瓜坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124201,141124,'安业乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124202,141124,'玉坪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124203,141124,'青凉寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124204,141124,'石白头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124205,141124,'雷家碛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124206,141124,'八堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124207,141124,'大禹乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124208,141124,'车赶乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141124209,141124,'安家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125100,141125,'柳林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125101,141125,'穆村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125102,141125,'薛村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125103,141125,'庄上镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125104,141125,'留誉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125105,141125,'三交镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125106,141125,'成家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125107,141125,'孟门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125108,141125,'陈家湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125109,141125,'金家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125200,141125,'李家湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125201,141125,'贾家垣乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125204,141125,'高家沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125205,141125,'石西乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141125206,141125,'王家沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126100,141126,'灵泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126101,141126,'罗村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126102,141126,'义牒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126103,141126,'小蒜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126104,141126,'辛关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126200,141126,'龙交乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126201,141126,'和合乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126203,141126,'曹家垣乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141126204,141126,'裴沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127100,141127,'东村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127101,141127,'岚城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127102,141127,'普明镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127103,141127,'界河口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127201,141127,'上明乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127202,141127,'王狮乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127203,141127,'梁家庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127204,141127,'顺会乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127206,141127,'社科乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141127400,141127,'岚县普明工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141128100,141128,'圪洞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141128101,141128,'马坊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141128102,141128,'峪口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141128103,141128,'大武镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141128104,141128,'北武当镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141128105,141128,'积翠镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141129100,141129,'宁乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141129101,141129,'金罗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141129102,141129,'枝柯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141129103,141129,'武家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141129104,141129,'暖泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141129201,141129,'下枣林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141130100,141130,'水头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141130101,141130,'康城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141130102,141130,'双池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141130103,141130,'桃红坡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141130104,141130,'石口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141130105,141130,'回龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141130202,141130,'温泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181001,141181,'新义街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181002,141181,'中阳楼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181003,141181,'振兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181004,141181,'胜溪湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181005,141181,'崇文街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181100,141181,'兑镇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181101,141181,'阳泉曲镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181102,141181,'下堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181103,141181,'西辛庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181104,141181,'高阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181105,141181,'梧桐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181106,141181,'柱濮镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181107,141181,'大孝堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181201,141181,'下栅乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181202,141181,'驿马乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141181204,141181,'杜村乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182001,141182,'文峰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182002,141182,'太和桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182003,141182,'西河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182100,141182,'贾家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182101,141182,'杏花村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182102,141182,'冀村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182103,141182,'肖家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182104,141182,'演武镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182105,141182,'三泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182106,141182,'石庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182107,141182,'杨家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182108,141182,'峪道河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182109,141182,'阳城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(141182110,141182,'栗家庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102001,150102,'海拉尔东路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102002,150102,'锡林北路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102003,150102,'中山东路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102004,150102,'东街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102005,150102,'西街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102006,150102,'东风路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102007,150102,'迎新路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102008,150102,'成吉思汗大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102101,150102,'保合少镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150102400,150102,'新城区鸿盛高科技园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150103001,150103,'新华西路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150103002,150103,'中山西路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150103003,150103,'光明路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150103004,150103,'海拉尔西路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150103005,150103,'环河街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150103006,150103,'通道街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150103007,150103,'钢铁路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150103100,150103,'攸攸板镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104001,150104,'小召前街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104002,150104,'兴隆巷街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104003,150104,'长和廊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104004,150104,'石东路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104005,150104,'大南街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104006,150104,'鄂尔多斯路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104007,150104,'西菜园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104008,150104,'昭君路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104100,150104,'小黑河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150104400,150104,'裕隆工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105001,150105,'人民路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105002,150105,'大学西路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105003,150105,'乌兰察布东路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105004,150105,'大学东路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105005,150105,'中专路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105006,150105,'昭乌达路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105007,150105,'巴彦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105008,150105,'敕勒川路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105101,150105,'榆林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105103,150105,'黄合少镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105104,150105,'金河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150105400,150105,'金桥经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121100,150121,'察素齐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121101,150121,'毕克齐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121102,150121,'善岱镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121103,150121,'台阁牧镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121104,150121,'白庙子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121105,150121,'沙尔沁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121106,150121,'敕勒川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121207,150121,'北什轴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121208,150121,'塔布赛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150121401,150121,'呼和浩特金山经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150122100,150122,'双河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150122101,150122,'新营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150122102,150122,'五申镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150122103,150122,'伍什家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150122104,150122,'古城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150122400,150122,'托县工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123100,150123,'城关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123101,150123,'盛乐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123102,150123,'新店子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123103,150123,'巧什营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123203,150123,'舍必崖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123205,150123,'大红城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123206,150123,'羊群沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123207,150123,'黑老夭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123400,150123,'盛乐经济工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150123401,150123,'内蒙古和林格尔新区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124100,150124,'城关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124101,150124,'宏河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124102,150124,'喇嘛湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124103,150124,'老牛湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124200,150124,'窑沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124201,150124,'北堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124202,150124,'韭菜庄乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124203,150124,'五良太乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150124401,150124,'内蒙古清水河工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125100,150125,'可可以力更镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125101,150125,'哈乐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125102,150125,'西乌兰不浪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125200,150125,'大青山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125205,150125,'上秃亥乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125207,150125,'得胜沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125211,150125,'二份子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125213,150125,'哈拉合少乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125214,150125,'耗赖山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125402,150125,'内蒙古武川经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150125403,150125,'武川金三角经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150172401,150172,'如意工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150172402,150172,'金川工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150172403,150172,'呼和浩特综合保税区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150172404,150172,'呼和浩特留学人员创业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150172405,150172,'沙尔沁工业区（如意南区）',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150172406,150172,'呼和浩特白塔空港物流园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202001,150202,'和平路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202002,150202,'财神庙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202003,150202,'西脑包街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202004,150202,'南门外街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202005,150202,'南圪洞街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202006,150202,'东站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202007,150202,'回民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202008,150202,'天骄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202009,150202,'河东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202010,150202,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202011,150202,'东兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202012,150202,'杨圪塄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202100,150202,'河东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202101,150202,'沙尔沁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150202400,150202,'铝业工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203001,150203,'少先路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203003,150203,'沼潭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203004,150203,'林荫路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203005,150203,'友谊大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203006,150203,'阿尔丁大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203007,150203,'团结大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203008,150203,'鞍山道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203009,150203,'前进道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203010,150203,'市府东路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203011,150203,'白云路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203012,150203,'黄河西路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203013,150203,'昆工路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203014,150203,'昆北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203100,150203,'昆河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203102,150203,'卜尔汉图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150203400,150203,'包钢厂区办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204001,150204,'先锋道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204002,150204,'幸福路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204003,150204,'万青路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204004,150204,'富强路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204005,150204,'科学路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204006,150204,'青山路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204007,150204,'自由路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204008,150204,'乌素图街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204100,150204,'青福镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204101,150204,'兴胜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150204401,150204,'包头市装备制造产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205001,150205,'石拐街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205002,150205,'大发街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205003,150205,'大磁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205004,150205,'五当沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205005,150205,'白狐沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205006,150205,'大德恒街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205101,150205,'五当召镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205202,150205,'吉忽伦图苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150205400,150205,'工业园区管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150206001,150206,'矿山路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150206002,150206,'通阳道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150207001,150207,'沙河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150207002,150207,'赛汗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150207003,150207,'萨如拉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150207004,150207,'白音席勒街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150207103,150207,'麻池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150207105,150207,'哈林格尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150207110,150207,'哈业胡同镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150207202,150207,'阿嘎如泰苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221104,150221,'萨拉齐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221105,150221,'双龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221106,150221,'美岱召镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221107,150221,'沟门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221108,150221,'将军尧镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221213,150221,'海子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221214,150221,'明沙淖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221215,150221,'苏波盖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150221500,150221,'九峰山生态管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150222102,150222,'金山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150222103,150222,'西斗铺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150222104,150222,'下湿壕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150222105,150222,'银号镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150222106,150222,'怀朔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150222107,150222,'兴顺西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223102,150223,'满都拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223103,150223,'希拉穆仁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223104,150223,'百灵庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223105,150223,'石宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223106,150223,'乌克忽洞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223107,150223,'明安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223108,150223,'巴音花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223213,150223,'达尔汗苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223214,150223,'查干哈达苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223215,150223,'巴音敖包苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223216,150223,'西河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150223217,150223,'小文公乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150271010,150271,'稀土路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150271020,150271,'民馨路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150271102,150271,'万水泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150302001,150302,'凤凰岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150302002,150302,'海北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150302003,150302,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150302004,150302,'新华西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150302007,150302,'滨河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150302008,150302,'林荫街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150302101,150302,'千里山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150302400,150302,'乌海市海勃湾千里山工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150303001,150303,'拉僧仲街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150303002,150303,'西卓子山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150303102,150303,'公乌素镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150303103,150303,'拉僧庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150303104,150303,'巴音陶亥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304002,150304,'三道坎街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304003,150304,'五虎山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304008,150304,'新达街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304009,150304,'巴音赛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304010,150304,'梁家沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304011,150304,'苏海图街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304012,150304,'滨海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304101,150304,'乌兰淖尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150304400,150304,'乌达经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402001,150402,'西屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402002,150402,'三中街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402003,150402,'永巨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402004,150402,'东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402005,150402,'南新街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402006,150402,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402007,150402,'铁南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402008,150402,'长青街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402009,150402,'哈达街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402010,150402,'西城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402011,150402,'桥北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402100,150402,'红庙子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402102,150402,'文钟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402400,150402,'赤峰红山高新技术产业开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402401,150402,'内蒙古红山物流园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150402402,150402,'红山绿色食品产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403001,150403,'西露天街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403002,150403,'平庄城区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403003,150403,'平庄东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403004,150403,'平庄西城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403005,150403,'马林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403006,150403,'云杉路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403100,150403,'风水沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403101,150403,'元宝山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403102,150403,'美丽河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403103,150403,'平庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403104,150403,'五家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150403200,150403,'小五家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404001,150404,'振兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404002,150404,'向阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404003,150404,'松州街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404004,150404,'铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404100,150404,'穆家营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404101,150404,'初头朗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404102,150404,'大庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404103,150404,'王府镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404104,150404,'老府镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404105,150404,'哈拉道口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404106,150404,'上官地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404107,150404,'安庆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404108,150404,'太平地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404200,150404,'当铺地满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404201,150404,'夏家店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404202,150404,'城子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404203,150404,'大夫营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404204,150404,'岗子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404400,150404,'玉龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404401,150404,'全宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404407,150404,'兴安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150404408,150404,'松城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421100,150421,'天山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421101,150421,'天山口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421102,150421,'双胜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421103,150421,'坤都镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421104,150421,'巴彦花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421105,150421,'绍根镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421106,150421,'扎嘎斯台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421200,150421,'新民乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421201,150421,'先锋乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421202,150421,'罕苏木苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421203,150421,'赛罕塔拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421204,150421,'巴拉奇如德苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421205,150421,'乌兰哈达乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421206,150421,'巴彦温都尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421400,150421,'轻工食品产业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421401,150421,'新能源产业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421402,150421,'绍根煤碳及煤化工产业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421403,150421,'罕乌拉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150421404,150421,'欧沐沦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422100,150422,'林东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422101,150422,'隆昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422102,150422,'十三敖包镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422103,150422,'碧流台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422104,150422,'富河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422105,150422,'白音勿拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422106,150422,'哈拉哈达镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422200,150422,'查干哈达苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422201,150422,'乌兰达坝苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422202,150422,'三山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422203,150422,'花加拉嘎乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422403,150422,'林东西城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422404,150422,'林东东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150422405,150422,'林东产业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423100,150423,'大板镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423101,150423,'索博日嘎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423102,150423,'宝日勿苏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423103,150423,'查干诺尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423105,150423,'巴彦琥硕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423200,150423,'西拉沐沦苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423201,150423,'巴彦塔拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423202,150423,'幸福之路苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423203,150423,'查干沐沦苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423400,150423,'大板煤电化基地',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423401,150423,'赛罕街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150423402,150423,'达尔罕街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424100,150424,'林西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424101,150424,'新城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424102,150424,'新林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424103,150424,'五十家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424104,150424,'官地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424105,150424,'大井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424106,150424,'统部镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424200,150424,'大营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424201,150424,'十二吐乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424400,150424,'城北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424401,150424,'城南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150424402,150424,'内蒙古林西工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425100,150425,'经棚镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425101,150425,'宇宙地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425102,150425,'土城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425103,150425,'同兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425104,150425,'万合永镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425105,150425,'芝瑞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425106,150425,'达来诺日镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425200,150425,'新开地乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425201,150425,'红山子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425202,150425,'达日罕乌拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425203,150425,'巴彦查干苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425204,150425,'浩来呼热苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425205,150425,'乌兰布统苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425400,150425,'应昌街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425401,150425,'热水塘街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150425403,150425,'西拉沐沦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426100,150426,'乌丹镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426101,150426,'乌敦套海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426102,150426,'五分地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426103,150426,'桥头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426104,150426,'广德公镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426105,150426,'梧桐花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426106,150426,'海拉苏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426107,150426,'亿合公镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426200,150426,'解放营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426201,150426,'阿什罕苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426202,150426,'新苏莫苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426203,150426,'白音套海苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426204,150426,'毛山东乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426205,150426,'格日僧苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426400,150426,'玉龙工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426402,150426,'紫城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150426403,150426,'全宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428100,150428,'锦山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428101,150428,'美林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428102,150428,'王爷府镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428103,150428,'小牛群镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428104,150428,'牛家营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428105,150428,'乃林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428106,150428,'西桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428200,150428,'十家满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428201,150428,'南台子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428400,150428,'乃林果树农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428401,150428,'马鞍山羊场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428402,150428,'喀喇沁经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428403,150428,'锦山工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428404,150428,'河北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150428405,150428,'河南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429100,150429,'天义镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429101,150429,'小城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429102,150429,'大城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429103,150429,'八里罕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429104,150429,'黑里河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429105,150429,'右北平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429106,150429,'大双庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429107,150429,'汐子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429108,150429,'大明镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429109,150429,'忙农镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429110,150429,'五化镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429111,150429,'三座店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429112,150429,'必斯营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429202,150429,'一肯中乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429203,150429,'存金沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429400,150429,'中京工业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429401,150429,'塞飞亚食品工业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429402,150429,'八里罕酒业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429403,150429,'再生资源产业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429404,150429,'生物科技产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429405,150429,'汐子工业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429406,150429,'农机产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429407,150429,'宁城县铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429408,150429,'宁城县铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150429409,150429,'宁城县温泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430100,150430,'新惠镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430101,150430,'四家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430102,150430,'长胜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430103,150430,'贝子府镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430104,150430,'四道湾子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430105,150430,'下洼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430106,150430,'金厂沟梁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430107,150430,'兴隆洼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430108,150430,'黄羊洼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430109,150430,'古鲁板蒿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430110,150430,'牛古吐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430202,150430,'木头营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430204,150430,'丰收乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430205,150430,'玛尼罕乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430206,150430,'萨力巴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430207,150430,'敖润苏莫苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430401,150430,'敖汉旗工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430404,150430,'敖汉旗人民政府新州街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150430405,150430,'敖汉旗惠州街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502001,150502,'科尔沁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502002,150502,'西门街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502003,150502,'永清街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502004,150502,'明仁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502005,150502,'施介街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502006,150502,'团结街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502007,150502,'东郊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502008,150502,'铁路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502009,150502,'红星街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502010,150502,'霍林河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502011,150502,'建国街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502100,150502,'大林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502101,150502,'钱家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502102,150502,'余粮堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502103,150502,'木里图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502104,150502,'丰田镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502105,150502,'清河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502106,150502,'育新镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502107,150502,'庆和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502108,150502,'敖力布皋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502200,150502,'莫力庙苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502400,150502,'国有哲南农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502401,150502,'三义堂农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502402,150502,'通辽市高林屯种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502403,150502,'胡力海原种繁殖场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502404,150502,'莫力庙种羊场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150502405,150502,'半截店牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521100,150521,'保康镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521101,150521,'宝龙山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521102,150521,'舍伯吐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521103,150521,'巴彦塔拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521104,150521,'门达镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521105,150521,'架玛吐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521106,150521,'腰林毛都镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521107,150521,'希伯花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521108,150521,'花吐古拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521109,150521,'代力吉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521110,150521,'努日木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521200,150521,'花胡硕苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521201,150521,'协代苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521202,150521,'白兴吐苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521203,150521,'图布信苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521204,150521,'敖包苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521205,150521,'胜利乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521400,150521,'白音塔拉农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521401,150521,'珠日河牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521402,150521,'丰库牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150521403,150521,'保康街道办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522100,150522,'甘旗卡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522101,150522,'吉尔嘎朗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522102,150522,'金宝屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522103,150522,'常胜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522104,150522,'查日苏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522105,150522,'双胜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522106,150522,'阿古拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522107,150522,'朝鲁吐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522108,150522,'努古斯台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522109,150522,'海鲁吐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522200,150522,'阿都沁苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522201,150522,'茂道吐苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522202,150522,'巴胡塔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522203,150522,'散都苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522204,150522,'巴彦毛都苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522400,150522,'胜利农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522401,150522,'孟根达坝牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522402,150522,'查金台牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522403,150522,'原种繁育中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522404,150522,'大青沟管理局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522405,150522,'哈日乌苏种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522406,150522,'乌兰敖道渔场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522407,150522,'金宝屯林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522408,150522,'朝鲁吐林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522409,150522,'茂道吐林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522410,150522,'伊胡塔林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150522411,150522,'乌旦塔拉林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523100,150523,'开鲁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523101,150523,'大榆树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523102,150523,'黑龙坝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523103,150523,'麦新镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523104,150523,'义和塔拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523105,150523,'建华镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523106,150523,'小街基镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523107,150523,'东风镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523108,150523,'吉日嘎郎吐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523109,150523,'东来镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523400,150523,'清河牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523401,150523,'辽河农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150523402,150523,'保安农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524100,150524,'库伦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524101,150524,'扣河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524102,150524,'白音花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524103,150524,'六家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524104,150524,'额勒顺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524200,150524,'茫汗苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524201,150524,'先进苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524202,150524,'水泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150524400,150524,'库伦街道办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525100,150525,'大沁他拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525101,150525,'八仙筒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525102,150525,'青龙山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525103,150525,'新镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525104,150525,'治安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525105,150525,'东明镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525106,150525,'沙日浩来镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525107,150525,'义隆永镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525200,150525,'固日班花苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525201,150525,'白音他拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525202,150525,'明仁苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525203,150525,'黄花塔拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525204,150525,'土城子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525205,150525,'苇莲苏乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525400,150525,'国有六号农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150525401,150525,'大沁他拉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526100,150526,'鲁北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526101,150526,'黄花山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526102,150526,'嘎亥图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526103,150526,'巨日合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526104,150526,'巴雅尔吐胡硕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526105,150526,'香山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526106,150526,'阿日昆都楞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526200,150526,'巴彦塔拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526201,150526,'乌力吉木仁苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526202,150526,'道老杜苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526203,150526,'格日朝鲁苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526204,150526,'前德门苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526205,150526,'乌兰哈达苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526206,150526,'查布嘎图苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526207,150526,'乌额格其苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526400,150526,'乌额格其牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526401,150526,'香山农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526402,150526,'乌日根塔拉农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150526403,150526,'通辽市嘎达苏种畜繁育中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150571001,150571,'河西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150571002,150571,'电厂街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150571003,150571,'新城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150571004,150571,'滨河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150571100,150571,'辽河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150581001,150581,'珠斯花街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150581002,150581,'莫斯台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150581003,150581,'宝日呼吉尔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150581004,150581,'沙尔呼热街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150581200,150581,'达来胡硕苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150581400,150581,'霍林郭勒市军马场生态保护区管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602001,150602,'交通街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602002,150602,'公园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602003,150602,'林荫街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602004,150602,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602005,150602,'富兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602006,150602,'天骄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602007,150602,'诃额伦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602008,150602,'巴音门克街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602010,150602,'幸福街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602011,150602,'纺织街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602012,150602,'兴胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602013,150602,'民族街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602100,150602,'泊尔江海子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602101,150602,'罕台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602102,150602,'铜川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602400,150602,'鄂尔多斯市装备制造基地',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602401,150602,'东胜区轻纺工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150602404,150602,'铜川汽车博览园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150603001,150603,'哈巴格希街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150603002,150603,'青春山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150603003,150603,'滨河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150603008,150603,'康新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150603400,150603,'鄂尔多斯市高新技术产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621001,150621,'工业街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621002,150621,'昭君街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621003,150621,'锡尼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621004,150621,'白塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621005,150621,'西园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621006,150621,'平原街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621100,150621,'树林召镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621101,150621,'吉格斯太镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621102,150621,'白泥井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621103,150621,'王爱召镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621104,150621,'昭君镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621105,150621,'恩格贝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621106,150621,'中和西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621107,150621,'风水梁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621200,150621,'展旦召苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621400,150621,'达拉特经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150621401,150621,'鄂尔多斯市生态示范区管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622001,150622,'兴隆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622002,150622,'迎泽街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622003,150622,'蓝天街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622004,150622,'友谊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622100,150622,'薛家湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622101,150622,'沙圪堵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622102,150622,'大路镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622103,150622,'纳日松镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622104,150622,'龙口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622105,150622,'准格尔召镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622106,150622,'魏家峁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622200,150622,'暖水乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622201,150622,'十二连城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622202,150622,'布尔陶亥苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622400,150622,'准格尔经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150622401,150622,'大路煤化工基地',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150623100,150623,'敖勒召其镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150623101,150623,'上海庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150623102,150623,'城川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150623103,150623,'昂素镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150623400,150623,'上海庙经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150624100,150624,'乌兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150624101,150624,'棋盘井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150624102,150624,'蒙西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150624103,150624,'木凯淖尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150624200,150624,'苏米图苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150624201,150624,'阿尔巴斯苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150624404,150624,'内蒙古鄂托克经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150625100,150625,'锡尼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150625101,150625,'巴拉贡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150625102,150625,'吉日嘎朗图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150625103,150625,'独贵塔拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150625104,150625,'呼和木独镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150625200,150625,'伊和乌素苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150625400,150625,'内蒙古鄂尔多斯杭锦经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150626100,150626,'嘎鲁图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150626101,150626,'乌审召镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150626102,150626,'图克镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150626103,150626,'乌兰陶勒盖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150626104,150626,'无定河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150626200,150626,'苏力德苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150626410,150626,'苏里格经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627100,150627,'阿勒腾席热镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627101,150627,'札萨克镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627102,150627,'乌兰木伦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627103,150627,'纳林陶亥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627104,150627,'苏布尔嘎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627105,150627,'红庆河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627106,150627,'伊金霍洛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627400,150627,'鄂尔多斯蒙苏经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150627407,150627,'鄂尔多斯空港物流园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702001,150702,'正阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702002,150702,'健康街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702003,150702,'靠山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702004,150702,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702005,150702,'呼伦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702007,150702,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702008,150702,'东山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702100,150702,'哈克镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150702101,150702,'奋斗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150703001,150703,'第三街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150703002,150703,'第一街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150703003,150703,'第二街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150703004,150703,'第四街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150703005,150703,'第五街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150703100,150703,'灵泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721100,150721,'那吉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721101,150721,'六合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721102,150721,'亚东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721103,150721,'霍尔奇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721104,150721,'向阳峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721105,150721,'三岔河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721106,150721,'复兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721108,150721,'兴安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721200,150721,'得力其尔鄂温克民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721201,150721,'查巴奇鄂温克民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721202,150721,'音河达斡尔鄂温克民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721203,150721,'新发朝鲜民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150721402,150721,'阿荣旗林业和草原局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722100,150722,'尼尔基镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722102,150722,'宝山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722103,150722,'哈达阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722104,150722,'阿尔拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722105,150722,'汉古尔河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722106,150722,'西瓦尔图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722108,150722,'腾克镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722109,150722,'奎勒河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722110,150722,'塔温敖宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722111,150722,'登特科镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722112,150722,'红彦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722201,150722,'库如奇乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722202,150722,'额尔和乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722203,150722,'杜拉尔鄂温克民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150722205,150722,'巴彦鄂温克民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723100,150723,'阿里河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723101,150723,'大杨树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723102,150723,'甘河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723103,150723,'吉文镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723104,150723,'诺敏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723105,150723,'乌鲁布铁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723106,150723,'宜里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723107,150723,'克一河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723200,150723,'古里乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150723201,150723,'托扎敏乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724100,150724,'巴彦托海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724110,150724,'大雁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724111,150724,'伊敏河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724112,150724,'红花尔基镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724210,150724,'巴彦嵯岗苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724211,150724,'锡尼河西苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724212,150724,'锡尼河东苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724213,150724,'巴彦塔拉达斡尔民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724214,150724,'伊敏苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724215,150724,'辉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150724400,150724,'巴彦托海经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725100,150725,'巴彦库仁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725101,150725,'宝日希勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725102,150725,'呼和诺尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725200,150725,'西乌珠尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725201,150725,'鄂温克民族苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725202,150725,'东乌珠尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725203,150725,'巴彦哈达苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725501,150725,'陈巴尔虎旗哈达图国营农牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725502,150725,'内蒙古自治区国有浩特陶海牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150725503,150725,'陈巴尔虎旗特泥河农牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150726101,150726,'嵯岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150726102,150726,'阿木古郎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150726202,150726,'新宝力格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150726203,150726,'乌布尔宝力格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150726204,150726,'罕达盖苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150726205,150726,'吉布胡郎图苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150726206,150726,'甘珠尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150727100,150727,'阿拉坦额莫勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150727101,150727,'阿日哈沙特镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150727102,150727,'呼伦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150727200,150727,'贝尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150727201,150727,'克尔伦苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150727202,150727,'达赉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150727203,150727,'宝格德乌拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781001,150781,'东山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781002,150781,'道南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781003,150781,'道北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781004,150781,'兴华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781012,150781,'敖尔金街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781100,150781,'新开河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781400,150781,'满洲里市互市贸易区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781401,150781,'满洲里市经济合作区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781402,150781,'满洲里市东湖区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781406,150781,'满洲里国际物流产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150781407,150781,'扎赉诺尔矿区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782001,150782,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782002,150782,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782003,150782,'新工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782004,150782,'永兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782005,150782,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782006,150782,'暖泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782100,150782,'免渡河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782101,150782,'博克图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782102,150782,'绰河源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782103,150782,'乌尔其汉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782104,150782,'库都尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782105,150782,'图里河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782106,150782,'乌奴耳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782107,150782,'塔尔气镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782108,150782,'伊图里河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782109,150782,'牧原镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782400,150782,'莫拐农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782401,150782,'牙克石农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150782402,150782,'免渡河农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783001,150783,'兴华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783002,150783,'正阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783003,150783,'繁荣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783004,150783,'向阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783005,150783,'高台子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783006,150783,'铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783007,150783,'河西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783100,150783,'蘑菇气镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783102,150783,'卧牛河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783103,150783,'成吉思汗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783104,150783,'大河湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783105,150783,'浩饶山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783106,150783,'柴河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783107,150783,'中和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783108,150783,'哈多河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783200,150783,'达斡尔民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783201,150783,'鄂伦春民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783202,150783,'萨马街鄂温克民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783203,150783,'洼堤乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783403,150783,'成吉思汗牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783404,150783,'公安部后勤供应处农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150783406,150783,'柴河林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784001,150784,'拉布大林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784002,150784,'上库力街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784101,150784,'黑山头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784103,150784,'莫尔道嘎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784104,150784,'恩和哈达镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784200,150784,'三河回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784210,150784,'恩和俄罗斯族民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784211,150784,'蒙兀室韦苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784212,150784,'奇乾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784400,150784,'内蒙古拉布大林农牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784401,150784,'内蒙古三河种马场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784402,150784,'内蒙古上库力农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150784403,150784,'内蒙古苏沁农牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785001,150785,'河东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785002,150785,'河西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785003,150785,'森工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785004,150785,'好里堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785101,150785,'金河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785102,150785,'阿龙山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785103,150785,'满归镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785104,150785,'得耳布尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150785200,150785,'敖鲁古雅鄂温克民族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802001,150802,'团结街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802002,150802,'车站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802003,150802,'先锋街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802004,150802,'解放街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802005,150802,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802006,150802,'东环街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802007,150802,'铁南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802008,150802,'西环街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802009,150802,'北环街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802013,150802,'金川街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802014,150802,'汇丰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802100,150802,'狼山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802101,150802,'新华镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802102,150802,'干召庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802103,150802,'乌兰图克镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802104,150802,'双河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802105,150802,'城关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802106,150802,'白脑包镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802200,150802,'曙光乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802201,150802,'八一乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802400,150802,'狼山农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150802401,150802,'临河农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821100,150821,'隆兴昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821101,150821,'塔尔湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821102,150821,'巴彦套海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821103,150821,'新公中镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821104,150821,'天吉泰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821105,150821,'胜丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821106,150821,'银定图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821107,150821,'复兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821200,150821,'和胜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150821400,150821,'巴彦淖尔市建丰农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822100,150822,'巴彦高勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822101,150822,'隆盛合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822102,150822,'渡口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822103,150822,'补隆淖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822200,150822,'沙金套海苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822400,150822,'磴口县农垦乌兰布和农场有限责任公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822401,150822,'磴口县农垦巴彦套海农场有限责任公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822402,150822,'磴口县农垦哈腾套海农场有限责任公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822403,150822,'磴口县农垦包尔盖农场有限责任公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822404,150822,'磴口县农垦纳林套海农场有限责任公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150822405,150822,'沙漠林业实验中心农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823100,150823,'乌拉山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823101,150823,'白彦花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823102,150823,'先锋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823103,150823,'新安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823104,150823,'西小召镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823105,150823,'大佘太镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823106,150823,'明安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823107,150823,'小佘太镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823108,150823,'苏独仑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823200,150823,'额尔登布拉格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823201,150823,'沙德格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823400,150823,'巴彦淖尔市中滩农场有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823401,150823,'巴彦淖尔市西山嘴农场有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823402,150823,'巴彦淖尔市新安农场有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823403,150823,'巴彦淖尔市苏独隆农场有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823404,150823,'巴彦淖尔市大佘太牧场有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150823405,150823,'巴彦淖尔市乌梁素海渔场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824100,150824,'海流图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824101,150824,'乌加河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824102,150824,'德岭山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824103,150824,'石哈河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824104,150824,'甘其毛都镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824105,150824,'温更镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824200,150824,'呼勒斯太苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824201,150824,'川井苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824202,150824,'巴音乌兰苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824203,150824,'新忽热苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824400,150824,'巴彦淖尔市牧洋海牧场有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150824401,150824,'巴彦淖尔市同和太种畜繁育中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150825100,150825,'巴音宝力格镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150825101,150825,'呼和温都尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150825102,150825,'潮格温都尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150825200,150825,'获各琦苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150825201,150825,'巴音前达门苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150825202,150825,'乌盖苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826100,150826,'陕坝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826101,150826,'头道桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826102,150826,'二道桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826103,150826,'三道桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826104,150826,'蛮会镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826105,150826,'团结镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826106,150826,'双庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826107,150826,'沙海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826108,150826,'蒙海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150826500,150826,'太阳庙农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902001,150902,'新体路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902002,150902,'桥东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902003,150902,'前进路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902004,150902,'常青街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902005,150902,'虎山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902006,150902,'桥西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902007,150902,'新华街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902008,150902,'泉山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902105,150902,'白海子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150902205,150902,'马莲渠乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150921106,150921,'卓资山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150921107,150921,'旗下营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150921108,150921,'十八台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150921109,150921,'巴音锡勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150921110,150921,'梨花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150921210,150921,'大榆树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150921211,150921,'红召乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150921212,150921,'复兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150922103,150922,'长顺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150922104,150922,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150922105,150922,'七号镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150922200,150922,'德包图乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150922201,150922,'公腊胡洞乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150922218,150922,'白音特拉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150922401,150922,'化德县长顺工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923101,150923,'七台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923102,150923,'十八顷镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923103,150923,'大黑沙土镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923104,150923,'西井子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923105,150923,'屯垦队镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923106,150923,'小海子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923200,150923,'大库伦乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923201,150923,'卯都乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923202,150923,'玻璃忽镜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150923203,150923,'三大顷乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924106,150924,'城关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924107,150924,'张皋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924108,150924,'赛乌素镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924109,150924,'鄂尔栋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924110,150924,'店子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924209,150924,'大库联乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924210,150924,'民族团结乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924211,150924,'大同夭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150924212,150924,'五股泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150925103,150925,'鸿茅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150925104,150925,'六苏木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150925105,150925,'麦胡图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150925106,150925,'永兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150925107,150925,'蛮汉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150925108,150925,'岱海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150925218,150925,'天成乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150925220,150925,'曹碾满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926105,150926,'土贵乌拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926106,150926,'平地泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926107,150926,'玫瑰营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926108,150926,'巴音塔拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926109,150926,'黄旗海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926209,150926,'乌拉哈乌拉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926210,150926,'黄茂营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926211,150926,'三岔口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926212,150926,'老圈沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926400,150926,'察右前旗天皮山冶金化工工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150926401,150926,'乌兰察布市京蒙合作产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927103,150927,'科布尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927104,150927,'铁沙盖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927105,150927,'黄羊城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927106,150927,'广益隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927107,150927,'乌素图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927216,150927,'大滩乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927217,150927,'宏盘乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927218,150927,'巴音乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927219,150927,'库伦苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927220,150927,'乌兰哈页苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927221,150927,'土城子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150927400,150927,'辉腾锡勒园区管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150928105,150928,'白音察干镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150928106,150928,'土牧尔台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150928107,150928,'红格尔图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150928108,150928,'贲红镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150928109,150928,'大六号镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150928209,150928,'当郎忽洞苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150928210,150928,'乌兰哈达苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150928211,150928,'锡勒乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929100,150929,'乌兰花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929101,150929,'吉生太镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929102,150929,'库伦图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929103,150929,'供济堂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929104,150929,'白音朝克图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929200,150929,'红格尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929201,150929,'江岸苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929202,150929,'查干补力格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929203,150929,'脑木更苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929204,150929,'东八号乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929205,150929,'忽鸡图乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929206,150929,'大黑河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929207,150929,'巴音敖包苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150929400,150929,'乌兰牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981005,150981,'新城区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981006,150981,'旧城区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981007,150981,'北城区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981008,150981,'工业区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981009,150981,'南城区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981107,150981,'隆盛庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981108,150981,'黑土台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981109,150981,'红砂坝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981110,150981,'巨宝庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981111,150981,'三义泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981207,150981,'浑源窑乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981208,150981,'元山子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981209,150981,'官屯堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(150981400,150981,'丰镇高科技氟化学工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201001,152201,'爱国街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201002,152201,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201003,152201,'兴安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201004,152201,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201005,152201,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201006,152201,'都林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201007,152201,'五一街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201008,152201,'城郊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201009,152201,'新城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201100,152201,'乌兰哈达镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201101,152201,'葛根庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201102,152201,'太本站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201103,152201,'义勒力特镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201401,152201,'呼和马场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201402,152201,'乌兰浩特绿色产业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152201403,152201,'兴安盟经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152202001,152202,'林海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152202002,152202,'新城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152202003,152202,'温泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152202004,152202,'伊尔施街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152202100,152202,'天池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152202101,152202,'白狼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152202102,152202,'五岔沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152202103,152202,'明水河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221100,152221,'科尔沁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221101,152221,'索伦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221102,152221,'德伯斯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221103,152221,'大石寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221104,152221,'归流河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221105,152221,'居力很镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221106,152221,'察尔森镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221107,152221,'额尔格图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221108,152221,'俄体镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221200,152221,'满族屯满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221201,152221,'乌兰毛都苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221202,152221,'阿力得尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221203,152221,'巴日嘎斯台乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221204,152221,'桃合木苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221400,152221,'跃进马场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221401,152221,'索伦牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221403,152221,'阿力得尔牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221404,152221,'公主陵牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221405,152221,'绿水种畜繁育中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221407,152221,'科右前旗工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152221408,152221,'科右前旗现代农牧业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222100,152222,'巴彦呼舒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222101,152222,'巴仁哲里木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222102,152222,'吐列毛杜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222103,152222,'杜尔基镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222104,152222,'高力板镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222105,152222,'好腰苏木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222200,152222,'代钦塔拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222201,152222,'新佳木苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222202,152222,'哈日诺尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222203,152222,'额木庭高勒苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222204,152222,'巴彦茫哈苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222205,152222,'巴彦淖尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222400,152222,'布敦化牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222401,152222,'吐列毛杜农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222402,152222,'孟恩套力盖矿区工作部',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152222403,152222,'布敦化矿区工作部',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223100,152223,'音德尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223101,152223,'新林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223102,152223,'巴彦高勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223103,152223,'胡尔勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223104,152223,'阿尔本格勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223105,152223,'巴达尔胡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223106,152223,'图牧吉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223107,152223,'好力保镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223201,152223,'巴彦乌兰苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223202,152223,'宝力根花苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223203,152223,'阿拉达尔吐苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223204,152223,'巴彦扎拉嘎乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223205,152223,'努文木仁乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223400,152223,'内蒙古自治区图牧吉强制隔离戒毒所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223401,152223,'内蒙古自治区监狱管理局东部分局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223404,152223,'种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223405,152223,'八一牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152223406,152223,'巴达尔胡农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224100,152224,'突泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224101,152224,'六户镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224102,152224,'东杜尔基镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224103,152224,'永安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224104,152224,'水泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224105,152224,'宝石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224200,152224,'学田乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224201,152224,'九龙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224202,152224,'太平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152224400,152224,'内蒙古自治区国营杜尔基农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152501200,152501,'格日勒敖都苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152501400,152501,'二连浩特市社区建设管理局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152501401,152501,'二连边境经济技术合作区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502001,152502,'希日塔拉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502002,152502,'宝力根街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502003,152502,'杭盖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502004,152502,'楚古兰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502005,152502,'额尔敦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502006,152502,'南郊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502007,152502,'巴彦查干街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502008,152502,'巴彦锡勒街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502100,152502,'阿尔善宝拉格镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502200,152502,'宝力根苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502201,152502,'朝克乌拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502203,152502,'巴彦宝拉格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502400,152502,'锡林郭勒盟经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502500,152502,'白银库伦牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502501,152502,'贝力克牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152502502,152502,'毛登牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152522100,152522,'别力古台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152522101,152522,'洪格尔高勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152522102,152522,'查干淖尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152522200,152522,'那仁宝拉格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152522201,152522,'伊和高勒苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152522202,152522,'吉尔嘎郎图苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152522203,152522,'巴彦图嘎苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152522400,152522,'玛尼图煤矿',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523100,152523,'满都拉图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523101,152523,'查干敖包镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523102,152523,'巴彦淖尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523200,152523,'巴彦乌拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523201,152523,'赛罕高毕苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523202,152523,'洪格尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523203,152523,'达来苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523400,152523,'苏尼特左旗芒来循环经济产业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152523500,152523,'恩格尔河灌区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152524100,152524,'赛汉塔拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152524101,152524,'朱日和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152524102,152524,'乌日根塔拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152524200,152524,'桑宝拉格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152524201,152524,'额仁淖尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152524202,152524,'赛罕乌力吉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152524203,152524,'阿其图乌拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152524400,152524,'苏尼特右旗朱日和工业园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525100,152525,'乌里雅斯太镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525101,152525,'道特淖尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525102,152525,'嘎达布其镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525103,152525,'满都胡宝拉格镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525104,152525,'额吉淖尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525200,152525,'呼热图淖尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525201,152525,'萨麦苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525202,152525,'嘎海乐苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525203,152525,'阿拉坦合力苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525400,152525,'乌里雅斯太工业区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152525503,152525,'宝格达乌拉总场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526100,152526,'巴拉嘎尔高勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526101,152526,'巴彦花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526102,152526,'吉仁高勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526103,152526,'浩勒图高勒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526104,152526,'高日罕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526200,152526,'巴彦胡舒苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526201,152526,'乌兰哈拉嘎苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526400,152526,'西乌旗白音华能源化工园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152526500,152526,'林业总场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152527100,152527,'宝昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152527101,152527,'千斤沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152527102,152527,'红旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152527103,152527,'骆驼山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152527104,152527,'永丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152527200,152527,'幸福乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152527201,152527,'贡宝拉格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152527500,152527,'万寿滩良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152528100,152528,'新宝拉格镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152528101,152528,'巴彦塔拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152528200,152528,'翁贡乌拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152528201,152528,'宝格达音髙勒苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152529100,152529,'明安图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152529101,152529,'星耀镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152529200,152529,'伊和淖尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152529201,152529,'乌兰查布苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152529202,152529,'宝拉根陶海苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152529500,152529,'额里图种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152529502,152529,'哲日根图林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530100,152530,'上都镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530101,152530,'桑根达来镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530102,152530,'哈毕日嘎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530200,152530,'宝绍代苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530201,152530,'那日图苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530202,152530,'赛音呼都嘎苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530203,152530,'扎格斯台苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530500,152530,'内蒙古自治区五一种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152530501,152530,'黑城子示范区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152531100,152531,'大北沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152531101,152531,'多伦诺尔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152531102,152531,'滦源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152531201,152531,'蔡木山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152531202,152531,'西干沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152531400,152531,'多伦新型工业化化工区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152571101,152571,'巴彦胡硕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152571500,152571,'哈拉盖图农牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152571501,152571,'贺斯格乌拉牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152571502,152571,'乌拉盖牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921102,152921,'温都尔勒图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921105,152921,'巴润别立镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921110,152921,'巴彦浩特镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921111,152921,'嘉尔嘎勒赛汉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921112,152921,'吉兰泰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921113,152921,'宗别立镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921114,152921,'敖伦布拉格镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921115,152921,'腾格里额里斯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921203,152921,'巴彦木仁苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921213,152921,'乌力吉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921214,152921,'巴彦诺日公苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921215,152921,'额尔克哈什哈苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921216,152921,'银根苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921217,152921,'超格图呼热苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921401,152921,'腾格里经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921402,152921,'巴彦浩特额鲁特街道办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921403,152921,'巴彦浩特南环路街道办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921404,152921,'巴彦浩特新华街道办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152921405,152921,'巴彦浩特王府街道办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152922103,152922,'巴丹吉林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152922104,152922,'雅布赖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152922105,152922,'阿拉腾敖包镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152922211,152922,'曼德拉苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152922212,152922,'阿拉腾朝格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152922213,152922,'巴彦高勒苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152922214,152922,'塔木素布拉格苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923001,152923,'航空街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923002,152923,'东风街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923100,152923,'达来呼布镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923101,152923,'东风镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923102,152923,'哈日布日格德音乌拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923200,152923,'赛汉陶来苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923201,152923,'马鬃山苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923202,152923,'苏泊淖尔苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923203,152923,'巴彦陶来苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923204,152923,'温图高勒苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152923205,152923,'巴音陶海苏木',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(152971100,152971,'乌斯太镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102001,210102,'浑河湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102002,210102,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102016,210102,'马路湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102019,210102,'南湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102021,210102,'长白街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102022,210102,'太原街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102023,210102,'北市场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102025,210102,'南市场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102027,210102,'沈水湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210102028,210102,'浑河站西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103005,210103,'滨河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103006,210103,'万莲街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103013,210103,'朱剪炉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103014,210103,'北站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103015,210103,'风雨坛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103017,210103,'皇城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103018,210103,'五里河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103019,210103,'南塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103020,210103,'泉园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103022,210103,'马官桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210103023,210103,'东陵街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104002,210104,'大北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104003,210104,'万泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104006,210104,'文官街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104007,210104,'二台子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104008,210104,'津桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104009,210104,'东站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104012,210104,'长安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104015,210104,'东塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104017,210104,'上园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210104018,210104,'前进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105001,210105,'三台子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105008,210105,'黄河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105013,210105,'华山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105017,210105,'明廉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105019,210105,'新乐街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105020,210105,'舍利塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105021,210105,'北塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105022,210105,'陵东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105023,210105,'鸭绿江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210105024,210105,'四台子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106001,210106,'昆明湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106003,210106,'工人村街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106007,210106,'启工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106013,210106,'笃工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106015,210106,'兴华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106019,210106,'霁虹街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106020,210106,'凌空街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106021,210106,'重工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106024,210106,'兴顺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106026,210106,'大青中朝友谊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106027,210106,'翟家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106029,210106,'大潘街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106030,210106,'彰驿站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106031,210106,'高花街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210106401,210106,'沈阳市经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111001,210111,'解放街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111003,210111,'民主街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111005,210111,'中兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111009,210111,'林盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111010,210111,'沙河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111011,210111,'十里河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111012,210111,'陈相街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111015,210111,'永乐街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111018,210111,'佟沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111019,210111,'八一红菱街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111020,210111,'沈水街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210111021,210111,'白清姚千街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112009,210112,'东湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112010,210112,'五三街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112012,210112,'浑河站东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112014,210112,'高坎街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112015,210112,'满堂街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112016,210112,'深井子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112017,210112,'祝家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112018,210112,'白塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112019,210112,'桃仙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112020,210112,'李相街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112022,210112,'汪家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210112023,210112,'王滨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113001,210113,'新城子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113002,210113,'清水台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113003,210113,'辉山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113004,210113,'道义街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113006,210113,'虎石台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113007,210113,'财落街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113010,210113,'马刚街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113012,210113,'黄家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113014,210113,'兴隆台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113016,210113,'正良街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113401,210113,'青年农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113402,210113,'前进农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113403,210113,'育新农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113404,210113,'沈北新区马刚林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113405,210113,'沈北新区示范农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210113406,210113,'沈北新区种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114001,210114,'迎宾路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114003,210114,'陵西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114007,210114,'北陵街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114009,210114,'沙岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114010,210114,'南阳湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114011,210114,'城东湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114012,210114,'平罗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114013,210114,'马三家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114014,210114,'造化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114016,210114,'光辉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114401,210114,'马三家强制隔离戒毒所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114402,210114,'光辉农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210114404,210114,'监狱城',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115001,210115,'蒲西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115002,210115,'蒲东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115003,210115,'茨榆坨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115004,210115,'城郊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115101,210115,'于家房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115102,210115,'朱家房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115103,210115,'冷子堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115104,210115,'刘二堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115106,210115,'新民屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115107,210115,'满都户镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115108,210115,'杨士岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115109,210115,'肖寨门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115110,210115,'长滩镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115111,210115,'四方台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115113,210115,'六间房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115114,210115,'养士堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115115,210115,'潘家堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115117,210115,'老大房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115118,210115,'大黑岗子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115119,210115,'牛心坨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210115401,210115,'四方台农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123001,210123,'北三家子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123002,210123,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123003,210123,'东关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123101,210123,'小城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123102,210123,'张强镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123103,210123,'方家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123105,210123,'郝官屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123106,210123,'二牛所口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123203,210123,'北四家子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123204,210123,'两家子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123206,210123,'海洲窝堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123208,210123,'沙金台蒙古族满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123209,210123,'柳树屯蒙古族满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123210,210123,'西关屯蒙古族满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210123211,210123,'东升满族蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124001,210124,'吉祥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124002,210124,'龙山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124101,210124,'大孤家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124102,210124,'三面船镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124103,210124,'秀水河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124104,210124,'叶茂台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124105,210124,'登仕堡子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124106,210124,'柏家沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124107,210124,'丁家房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124108,210124,'孟家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124109,210124,'十间房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124110,210124,'冯贝堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124111,210124,'依牛堡子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124113,210124,'包家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124201,210124,'慈恩寺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124203,210124,'和平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124208,210124,'四家子蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124209,210124,'双台子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210124210,210124,'卧牛石乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181001,210181,'东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181002,210181,'辽滨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181003,210181,'西城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181004,210181,'新柳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181101,210181,'大红旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181102,210181,'梁山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181103,210181,'公主屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181104,210181,'兴隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181105,210181,'前当堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181106,210181,'大民屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181107,210181,'大柳屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181108,210181,'兴隆堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181109,210181,'胡台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181110,210181,'法哈牛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181111,210181,'柳河沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181112,210181,'高台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181113,210181,'张家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181114,210181,'罗家房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181115,210181,'三道岗子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181116,210181,'东蛇山子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181117,210181,'陶家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181118,210181,'周坨子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181119,210181,'金五台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181120,210181,'新农村镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181205,210181,'红旗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181206,210181,'卢家屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181207,210181,'姚堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210181209,210181,'于家窝堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210202001,210202,'海军广场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210202005,210202,'人民路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210202008,210202,'青泥洼桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210202010,210202,'葵英街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210202011,210202,'桃源街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210202012,210202,'老虎滩街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210203001,210203,'香炉礁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210203004,210203,'日新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210203010,210203,'八一路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210203011,210203,'人民广场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210203013,210203,'白云街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210204006,210204,'春柳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210204008,210204,'马栏街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210204009,210204,'南沙河口街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210204010,210204,'黑石礁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210204011,210204,'李家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210204017,210204,'星海湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210204018,210204,'西安路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211001,210211,'周水子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211002,210211,'椒金山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211004,210211,'甘井子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211006,210211,'南关岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211007,210211,'泡崖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211008,210211,'中华路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211010,210211,'机场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211014,210211,'辛寨子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211015,210211,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211016,210211,'凌水街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211017,210211,'大连湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211018,210211,'泉水街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211019,210211,'革镇堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211020,210211,'营城子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211021,210211,'七贤岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210211400,210211,'大连华侨果树农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212001,210212,'登峰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212003,210212,'得胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212005,210212,'水师营街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212006,210212,'龙王塘街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212007,210212,'铁山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212009,210212,'双岛湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212010,210212,'三涧堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212011,210212,'长城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212012,210212,'龙头街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212400,210212,'旅顺经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212401,210212,'大连奶牛场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210212402,210212,'龙头分园',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213001,210213,'拥政街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213002,210213,'友谊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213004,210213,'马桥子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213005,210213,'海青岛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213006,210213,'大孤山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213008,210213,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213009,210213,'先进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213011,210213,'董家沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213012,210213,'金石滩街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213013,210213,'湾里街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213014,210213,'二十里堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213016,210213,'亮甲店街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213017,210213,'登沙河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213019,210213,'大魏家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213020,210213,'杏树街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213021,210213,'七顶山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213022,210213,'华家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213023,210213,'向应街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213024,210213,'大李家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213025,210213,'得胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213027,210213,'炮台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213028,210213,'复州湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213029,210213,'三十里堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213030,210213,'石河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210213031,210213,'光中街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214001,210214,'丰荣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214002,210214,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214003,210214,'太平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214005,210214,'皮口街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214006,210214,'城子坦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214007,210214,'大刘家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214008,210214,'杨树房街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214009,210214,'大谭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214010,210214,'唐家房街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214011,210214,'莲山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214012,210214,'安波街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214013,210214,'沙包街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214014,210214,'星台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214015,210214,'墨盘街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214016,210214,'同益街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214017,210214,'乐甲街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214018,210214,'双塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210214019,210214,'四平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210224100,210224,'大长山岛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210224101,210224,'獐子岛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210224102,210224,'广鹿岛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210224103,210224,'小长山岛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210224104,210224,'海洋岛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281001,210281,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281002,210281,'文兰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281003,210281,'岭东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281004,210281,'共济街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281005,210281,'铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281006,210281,'祝华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281007,210281,'岗店街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281008,210281,'太阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281009,210281,'长兴岛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281010,210281,'九龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281011,210281,'交流岛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281101,210281,'复州城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281103,210281,'松树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281105,210281,'得利寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281106,210281,'万家岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281107,210281,'许屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281108,210281,'永宁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281109,210281,'谢屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281112,210281,'老虎屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281113,210281,'红沿河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281115,210281,'李官镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281116,210281,'仙浴湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281117,210281,'元台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281118,210281,'瓦窝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281201,210281,'赵屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281203,210281,'土城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281204,210281,'阎店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281205,210281,'西杨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281206,210281,'驼山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281208,210281,'三台满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281210,210281,'泡崖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210281212,210281,'杨家满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283001,210283,'城关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283002,210283,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283003,210283,'兴达街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283004,210283,'昌盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283005,210283,'明阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283101,210283,'青堆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283102,210283,'徐岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283104,210283,'黑岛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283105,210283,'栗子房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283107,210283,'大营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283108,210283,'塔岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283109,210283,'仙人洞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283110,210283,'蓉花山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283111,210283,'长岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283112,210283,'荷花山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283113,210283,'城山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283114,210283,'光明山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283115,210283,'大郑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283118,210283,'吴炉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283120,210283,'王家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283204,210283,'鞍子山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283208,210283,'太平岭满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283209,210283,'步云山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283211,210283,'桂云花满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283214,210283,'兰店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210283216,210283,'石城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302002,210302,'解放街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302003,210302,'山南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302004,210302,'园林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302006,210302,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302008,210302,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302011,210302,'湖南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302013,210302,'新兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302014,210302,'旧堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302015,210302,'大孤山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302017,210302,'长甸街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210302400,210302,'玉佛山风景区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303002,210303,'繁荣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303003,210303,'八家子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303005,210303,'共和街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303006,210303,'永乐街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303008,210303,'南华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303009,210303,'大陆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303012,210303,'永发街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303013,210303,'宁远街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210303014,210303,'达道湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304001,210304,'友好街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304004,210304,'双山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304006,210304,'立山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304008,210304,'曙光街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304009,210304,'灵山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304014,210304,'深沟寺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304015,210304,'沙河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304017,210304,'千山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210304019,210304,'齐大山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210311006,210311,'汤岗子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210311007,210311,'东鞍山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210311102,210311,'唐家房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210311103,210311,'大屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210311104,210311,'甘泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321001,210321,'八角台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321002,210321,'台东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321101,210321,'西佛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321102,210321,'新开河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321103,210321,'黄沙坨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321104,210321,'高力房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321105,210321,'桑林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321106,210321,'富家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321107,210321,'达牛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321109,210321,'韭菜台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321110,210321,'新台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321111,210321,'桓洞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321400,210321,'新华农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210321401,210321,'洪家农牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323001,210323,'阜昌街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323003,210323,'兴隆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323004,210323,'雅河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323101,210323,'三家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323102,210323,'石庙子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323103,210323,'黄花甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323104,210323,'大营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323105,210323,'苏子沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323106,210323,'偏岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323107,210323,'哈达碑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323108,210323,'新甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323109,210323,'洋河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323111,210323,'杨家堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323112,210323,'清凉山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323113,210323,'石灰窑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323114,210323,'前营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323115,210323,'龙潭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323116,210323,'牧牛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323117,210323,'药山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323118,210323,'大房身镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323119,210323,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323206,210323,'红旗营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323211,210323,'岭沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210323212,210323,'哨子河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381001,210381,'海州街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381002,210381,'兴海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381003,210381,'响堂街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381004,210381,'东四街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381006,210381,'温泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381101,210381,'孤山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381102,210381,'岔沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381103,210381,'接文镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381104,210381,'析木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381105,210381,'马风镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381107,210381,'牌楼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381108,210381,'八里镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381109,210381,'毛祁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381110,210381,'英落镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381111,210381,'感王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381112,210381,'西柳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381113,210381,'中小镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381114,210381,'王石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381115,210381,'南台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381118,210381,'腾鳌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381121,210381,'耿庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381123,210381,'牛庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381124,210381,'西四镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381125,210381,'望台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381126,210381,'温香镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210381127,210381,'高坨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210402001,210402,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210402005,210402,'福民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210402007,210402,'新抚街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210402009,210402,'榆林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210402011,210402,'永安台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210402019,210402,'刘山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210402201,210402,'千金乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403002,210403,'东洲街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403004,210403,'搭连街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403005,210403,'龙凤街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403006,210403,'新屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403007,210403,'万新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403008,210403,'老虎台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403012,210403,'章党街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403103,210403,'章党镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403104,210403,'哈达镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403202,210403,'碾盘乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210403215,210403,'兰山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404002,210404,'工农街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404003,210404,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404004,210404,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404005,210404,'光明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404006,210404,'朴屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404007,210404,'演武街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404011,210404,'李石街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404101,210404,'塔峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210404201,210404,'拉古满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210411002,210411,'长春街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210411003,210411,'葛布街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210411004,210411,'将军堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210411005,210411,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210411007,210411,'抚顺城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210411102,210411,'前甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210411201,210411,'河北乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210411205,210411,'会元乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210421101,210421,'石文镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210421102,210421,'后安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210421105,210421,'上马镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210421106,210421,'救兵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210421204,210421,'马圈子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210421209,210421,'峡河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210421211,210421,'海浪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210421216,210421,'汤图满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422100,210422,'新宾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422101,210422,'旺清门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422102,210422,'永陵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422103,210422,'平顶山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422104,210422,'大四平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422105,210422,'苇子峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422106,210422,'木奇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422108,210422,'上夹河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422109,210422,'南杂木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422202,210422,'红升乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422203,210422,'响水河子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422204,210422,'红庙子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422205,210422,'北四平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422207,210422,'榆树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210422208,210422,'下夹河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423100,210423,'清原镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423101,210423,'红透山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423103,210423,'草市镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423104,210423,'英额门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423105,210423,'南口前镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423106,210423,'南山城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423107,210423,'湾甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423108,210423,'大孤家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423109,210423,'夏家堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423110,210423,'北三家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423203,210423,'土口子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423206,210423,'敖家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423207,210423,'大苏河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210423208,210423,'枸乃甸乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210502001,210502,'南地街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210502003,210502,'平山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210502004,210502,'东明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210502005,210502,'崔东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210502007,210502,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210502008,210502,'千金街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210502012,210502,'桥北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210503001,210503,'河东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210503003,210503,'河西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210503005,210503,'彩屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210503009,210503,'东风街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210503010,210503,'石桥子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210503011,210503,'日月岛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210503013,210503,'火连寨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210504002,210504,'北地街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210504004,210504,'高峪街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210504005,210504,'明山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210504008,210504,'新明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210504009,210504,'牛心台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210504010,210504,'卧龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210504011,210504,'高台子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210505001,210505,'南芬街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210505004,210505,'思山岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210505005,210505,'下马塘街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521001,210521,'观音阁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521100,210521,'小市镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521101,210521,'草河掌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521102,210521,'草河城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521103,210521,'草河口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521104,210521,'连山关镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521106,210521,'清河城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521109,210521,'田师傅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521110,210521,'南甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521111,210521,'碱厂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521112,210521,'高官镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210521202,210521,'东营坊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522001,210522,'八卦城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522100,210522,'桓仁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522101,210522,'普乐堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522102,210522,'二棚甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522103,210522,'沙尖子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522104,210522,'五里甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522108,210522,'八里甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522110,210522,'华来镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522111,210522,'古城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522201,210522,'雅河朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522202,210522,'向阳乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522206,210522,'黑沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210522208,210522,'北甸子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210602002,210602,'七道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210602003,210602,'广济街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210602004,210602,'九道街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210602006,210602,'兴东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210602101,210602,'金山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603002,210603,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603003,210603,'临江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603005,210603,'帽盔山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603006,210603,'纤维街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603007,210603,'永昌街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603008,210603,'花园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603009,210603,'江海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603101,210603,'浪头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603102,210603,'安民镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210603103,210603,'汤池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604001,210604,'鸭绿江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604003,210604,'金矿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604004,210604,'珍珠街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604005,210604,'太平湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604102,210604,'同兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604104,210604,'五龙背镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604105,210604,'楼房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604106,210604,'九连城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210604107,210604,'汤山城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624100,210624,'宽甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624101,210624,'灌水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624102,210624,'硼海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624103,210624,'红石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624104,210624,'毛甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624105,210624,'长甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624106,210624,'永甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624108,210624,'太平哨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624109,210624,'青山沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624110,210624,'牛毛坞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624111,210624,'大川头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624112,210624,'青椅山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624113,210624,'杨木川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624114,210624,'虎山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624115,210624,'振江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624116,210624,'步达远镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624117,210624,'大西岔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624118,210624,'八河川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624119,210624,'双山子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624201,210624,'石湖沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624206,210624,'古楼子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210624212,210624,'下露河朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681001,210681,'大东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681002,210681,'新兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681003,210681,'新城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681101,210681,'孤山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681104,210681,'前阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681105,210681,'长安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681106,210681,'十字街镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681107,210681,'长山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681108,210681,'北井子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681109,210681,'椅圈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681110,210681,'黄土坎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681113,210681,'马家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681114,210681,'龙王庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681115,210681,'小甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681117,210681,'菩萨庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681118,210681,'黑沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681119,210681,'新农镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681206,210681,'合隆满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681401,210681,'示范农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681402,210681,'黄土坎农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681403,210681,'海洋红农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681404,210681,'兴隆农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210681405,210681,'五四农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682001,210682,'凤凰城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682002,210682,'凤山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682003,210682,'草河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682101,210682,'宝山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682102,210682,'白旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682103,210682,'沙里寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682104,210682,'红旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682105,210682,'蓝旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682107,210682,'边门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682110,210682,'东汤镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682111,210682,'石城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682112,210682,'大兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682113,210682,'爱阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682114,210682,'赛马镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682115,210682,'弟兄山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682116,210682,'鸡冠山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682117,210682,'刘家河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682118,210682,'通远堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682119,210682,'四门子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682120,210682,'青城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210682200,210682,'大堡蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210702002,210702,'石油街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210702003,210702,'古城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210702004,210702,'敬业街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210702005,210702,'保安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210702009,210702,'士英街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210703002,210703,'石桥子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210703003,210703,'龙江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210703004,210703,'榴花街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210703008,210703,'康宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210703009,210703,'锦铁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210703011,210703,'紫荆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210703403,210703,'锦州北山农工商总公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711004,210711,'太和街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711008,210711,'大薛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711011,210711,'新民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711012,210711,'营盘街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711013,210711,'女儿河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711071,210711,'天桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711072,210711,'杏山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711073,210711,'娘娘宫街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711080,210711,'凌南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711081,210711,'松山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210711480,210711,'锦州市果树农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726001,210726,'黑山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726002,210726,'大虎山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726101,210726,'芳山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726102,210726,'白厂门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726103,210726,'常兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726104,210726,'姜屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726105,210726,'励家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726106,210726,'绕阳河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726107,210726,'半拉门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726108,210726,'无梁殿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726109,210726,'胡家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726110,210726,'新立屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726111,210726,'八道壕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726113,210726,'四家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726114,210726,'新兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726116,210726,'太和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726117,210726,'镇安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726201,210726,'英城子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726209,210726,'段家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726210,210726,'大兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726212,210726,'薛屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210726400,210726,'辽宁省锦州市小东种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727001,210727,'义州街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727002,210727,'城关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727101,210727,'刘龙台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727102,210727,'七里河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727103,210727,'大榆树堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727104,210727,'稍户营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727105,210727,'九道岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727106,210727,'高台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727108,210727,'瓦子峪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727109,210727,'头台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727110,210727,'前杨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727111,210727,'张家堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727112,210727,'头道河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727113,210727,'留龙沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727114,210727,'聚粮屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727203,210727,'地藏寺满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727205,210727,'大定堡满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210727207,210727,'白庙子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781001,210781,'大凌河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781002,210781,'金城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781003,210781,'八千街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781101,210781,'石山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781102,210781,'余积镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781103,210781,'双羊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781104,210781,'班吉塔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781105,210781,'沈家台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781106,210781,'三台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781107,210781,'右卫镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781108,210781,'阎家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781109,210781,'新庄子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781112,210781,'翠岩镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781113,210781,'安屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781114,210781,'大业镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781116,210781,'建业镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781117,210781,'温滴楼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781118,210781,'白台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781212,210781,'板石沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781217,210781,'谢屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210781401,210781,'辽宁省金城原种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782004,210782,'北镇街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782006,210782,'富屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782007,210782,'广宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782008,210782,'沟帮子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782101,210782,'大市镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782102,210782,'罗罗堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782103,210782,'常兴店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782104,210782,'正安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782105,210782,'闾阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782106,210782,'中安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782107,210782,'廖屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782109,210782,'赵屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782110,210782,'青堆子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782111,210782,'高山子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782113,210782,'吴家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782203,210782,'鲍家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782206,210782,'大屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782209,210782,'柳家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782402,210782,'辽宁省北镇市高山子监狱',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210782403,210782,'新立农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210802001,210802,'八田地街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210802002,210802,'建丰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210802003,210802,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210802004,210802,'跃进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210802007,210802,'新建街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210802008,210802,'东兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210803002,210803,'清华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210803003,210803,'滨海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210803004,210803,'得胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210803005,210803,'五台子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210803006,210803,'渔市街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210803400,210803,'辽宁自贸区营口片区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210803401,210803,'辽宁（营口）沿海产业基地',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210804001,210804,'红海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210804002,210804,'海星街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210804003,210804,'望海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210804100,210804,'熊岳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210804101,210804,'芦屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210804102,210804,'红旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210811001,210811,'老边街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210811101,210811,'路南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210811102,210811,'柳树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210811103,210811,'边城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210811400,210811,'营口辽河经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881001,210881,'鼓楼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881002,210881,'西城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881003,210881,'东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881004,210881,'太阳升街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881005,210881,'团山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881006,210881,'西海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881007,210881,'九垄地街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881008,210881,'归州街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881102,210881,'高屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881105,210881,'沙岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881109,210881,'九寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881110,210881,'万福镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881111,210881,'卧龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881112,210881,'青石岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881113,210881,'暖泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881116,210881,'榜式堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881117,210881,'团甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881118,210881,'双台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881119,210881,'杨运镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881120,210881,'徐屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881121,210881,'什字街镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881122,210881,'矿洞沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881123,210881,'陈屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881124,210881,'梁屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881216,210881,'小石棚乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881217,210881,'果园乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210881218,210881,'二台乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882003,210882,'金桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882004,210882,'钢都街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882005,210882,'百寨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882006,210882,'镁都街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882101,210882,'水源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882102,210882,'沟沿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882103,210882,'石佛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882104,210882,'高坎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882105,210882,'旗口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882106,210882,'虎庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882107,210882,'官屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882112,210882,'博洛铺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882113,210882,'永安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882114,210882,'汤池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882115,210882,'建一镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882116,210882,'黄土岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882117,210882,'周家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882400,210882,'大石桥市水稻良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210882401,210882,'大石桥市示范场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210902003,210902,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210902004,210902,'西山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210902005,210902,'河北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210902006,210902,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210902008,210902,'五龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210902009,210902,'平安西部街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210902101,210902,'韩家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210903005,210903,'街基街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210903006,210903,'新发屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210903101,210903,'长营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210904001,210904,'红树街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210904003,210904,'高德街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210904004,210904,'孙家湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210904101,210904,'水泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210905001,210905,'清河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210905004,210905,'新北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210905101,210905,'河西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210905102,210905,'乌龙坝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210911001,210911,'玉新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210911007,210911,'玉龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210911008,210911,'玉丰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210911102,210911,'四合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210911401,210911,'六家子管委会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921001,210921,'城区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921100,210921,'阜新镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921102,210921,'东梁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921103,210921,'佛寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921104,210921,'伊吗图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921105,210921,'旧庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921106,210921,'务欢池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921107,210921,'建设镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921108,210921,'大巴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921109,210921,'泡子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921110,210921,'十家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921111,210921,'王府镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921112,210921,'于寺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921113,210921,'富荣镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921114,210921,'新民镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921115,210921,'福兴地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921116,210921,'平安地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921117,210921,'沙拉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921118,210921,'大固本镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921119,210921,'大五家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921120,210921,'大板镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921121,210921,'招束沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921122,210921,'八家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921123,210921,'蜘蛛山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921124,210921,'塔营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921125,210921,'扎兰营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921126,210921,'七家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921127,210921,'红帽子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921128,210921,'紫都台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921129,210921,'化石戈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921130,210921,'哈达户稍镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921131,210921,'老河土镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921132,210921,'太平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921203,210921,'卧凤沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921211,210921,'苍土乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921222,210921,'国华乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210921401,210921,'田家管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922100,210922,'彰武镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922101,210922,'哈尔套镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922102,210922,'章古台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922103,210922,'五峰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922104,210922,'冯家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922105,210922,'后新秋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922106,210922,'东六家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922107,210922,'阿尔乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922108,210922,'前福兴地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922109,210922,'双庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922110,210922,'大四家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922111,210922,'苇子沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922112,210922,'兴隆山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922113,210922,'满堂红镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922114,210922,'四合城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922115,210922,'大冷镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922116,210922,'两家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922117,210922,'平安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922118,210922,'四堡子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922119,210922,'西六家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922120,210922,'大德镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922121,210922,'兴隆堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922202,210922,'二道河子蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(210922209,210922,'丰田乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211002016,211002,'文圣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211002017,211002,'武圣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211002018,211002,'南门街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211002019,211002,'襄平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211003004,211003,'庆阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211003008,211003,'东京陵街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211003101,211003,'小屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211003102,211003,'罗大台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211004001,211004,'工农街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211004004,211004,'长征街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211004101,211004,'曙光镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211004102,211004,'兰家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211005001,211005,'苏家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211005003,211005,'安平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211005101,211005,'汤河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211005201,211005,'安平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211011003,211011,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211011101,211011,'祁家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211011102,211011,'沙岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211011103,211011,'王家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211011204,211011,'东宁卫乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021100,211021,'首山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021101,211021,'刘二堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021103,211021,'小北河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021104,211021,'黄泥洼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021106,211021,'唐马寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021107,211021,'穆家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021108,211021,'柳壕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021110,211021,'河栏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021111,211021,'隆昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021112,211021,'八会镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021113,211021,'寒岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021114,211021,'兴隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021201,211021,'下达河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021202,211021,'吉洞峪满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211021206,211021,'甜水满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081001,211081,'烟台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081002,211081,'万宝桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081003,211081,'古城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081101,211081,'佟二堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081102,211081,'铧子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081103,211081,'张台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081104,211081,'西大窑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081105,211081,'沈旦堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081106,211081,'西马峰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081107,211081,'柳条寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081108,211081,'柳河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081111,211081,'大河南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081114,211081,'五星镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211081205,211081,'鸡冠山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211102002,211102,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211102003,211102,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211102004,211102,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211102005,211102,'辽河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211102008,211102,'铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211102009,211102,'双盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211102100,211102,'统一镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211102101,211102,'陆家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103001,211103,'振兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103002,211103,'兴隆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103003,211103,'渤海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103004,211103,'新工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103007,211103,'曙光街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103008,211103,'欢喜岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103013,211103,'沈采街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103016,211103,'创新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103017,211103,'兴盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103018,211103,'兴海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211103019,211103,'惠宾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104002,211104,'二界沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104004,211104,'大洼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104005,211104,'田家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104006,211104,'榆树街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104007,211104,'王家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104009,211104,'于楼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104101,211104,'田庄台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104103,211104,'东风镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104104,211104,'新开镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104106,211104,'清水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104107,211104,'新兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104108,211104,'西安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104109,211104,'新立镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104112,211104,'唐家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104113,211104,'平安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211104114,211104,'赵圈河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122001,211122,'太平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122002,211122,'高升街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122003,211122,'得胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122004,211122,'东郭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122101,211122,'沙岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122103,211122,'胡家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122104,211122,'石新镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122106,211122,'羊圈子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122107,211122,'古城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122108,211122,'坝墙子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122110,211122,'陈家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122111,211122,'甜水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122112,211122,'吴家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211122400,211122,'盘山县林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202001,211202,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202002,211202,'工人街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202003,211202,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202004,211202,'铜钟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202005,211202,'柴河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202006,211202,'岭东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202007,211202,'辽海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202201,211202,'龙山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211202401,211202,'铁岭经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211204001,211204,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211204002,211204,'向阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211204101,211204,'张相镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211204102,211204,'杨木林子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211204203,211204,'聂家满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221101,211221,'新台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221102,211221,'阿吉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221103,211221,'平顶堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221104,211221,'大甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221105,211221,'凡河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221106,211221,'腰堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221107,211221,'镇西堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221108,211221,'蔡牛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221109,211221,'李千户镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221110,211221,'熊官屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221111,211221,'横道河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221112,211221,'双井子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221208,211221,'鸡冠山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211221209,211221,'白旗寨满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223100,211223,'西丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223101,211223,'平岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223102,211223,'郜家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223103,211223,'凉泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223104,211223,'振兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223105,211223,'安民镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223106,211223,'天德镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223107,211223,'房木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223108,211223,'柏榆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223109,211223,'陶然镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223110,211223,'钓鱼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223111,211223,'更刻镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223204,211223,'德兴满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223206,211223,'明德满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223209,211223,'成平满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223211,211223,'和隆满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223212,211223,'营厂满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211223213,211223,'金星满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224100,211224,'昌图镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224101,211224,'老城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224102,211224,'八面城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224103,211224,'三江口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224104,211224,'金家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224105,211224,'宝力镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224106,211224,'泉头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224107,211224,'双庙子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224108,211224,'亮中桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224109,211224,'马仲河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224110,211224,'毛家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224111,211224,'老四平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224112,211224,'大洼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224113,211224,'头道镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224114,211224,'鴜鷺树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224115,211224,'傅家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224117,211224,'四合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224118,211224,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224119,211224,'古榆树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224120,211224,'七家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224121,211224,'东嘎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224122,211224,'四面城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224123,211224,'前双井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224124,211224,'通江口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224125,211224,'大四家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224126,211224,'曲家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224127,211224,'十八家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224128,211224,'太平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224129,211224,'下二台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224130,211224,'平安堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224131,211224,'大兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224132,211224,'后窑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211224133,211224,'长发镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211281001,211281,'兀术街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211281002,211281,'调兵山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211281102,211281,'晓明镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211281103,211281,'大明镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211281105,211281,'晓南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282001,211282,'新城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282002,211282,'老城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282003,211282,'开原街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282102,211282,'威远堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282103,211282,'庆云堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282104,211282,'中固镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282105,211282,'八棵树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282106,211282,'金沟子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282107,211282,'八宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282108,211282,'业民镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282109,211282,'莲花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282110,211282,'靠山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282111,211282,'马家寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282112,211282,'下肥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282113,211282,'松山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282114,211282,'城东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282115,211282,'李家台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282116,211282,'上肥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282117,211282,'黄旗寨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211282217,211282,'林丰满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302001,211302,'双塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302003,211302,'前进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302004,211302,'凌河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302005,211302,'光明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302006,211302,'凌凤街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302007,211302,'龙山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302008,211302,'站南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302009,211302,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302010,211302,'燕北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302100,211302,'桃花吐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302101,211302,'他拉皋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302102,211302,'孙家湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211302205,211302,'长宝营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303004,211303,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303005,211303,'海龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303070,211303,'龙泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303101,211303,'七道泉子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303102,211303,'西大营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303103,211303,'召都巴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303105,211303,'大平房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303106,211303,'联合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211303107,211303,'边杖子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321001,211321,'柳城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321102,211321,'波罗赤镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321103,211321,'木头城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321104,211321,'二十家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321105,211321,'羊山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321106,211321,'六家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321107,211321,'瓦房子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321108,211321,'大庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321110,211321,'古山子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321111,211321,'南双庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321112,211321,'台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321113,211321,'清风岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321114,211321,'胜利镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321115,211321,'七道岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321116,211321,'杨树湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321211,211321,'西五家子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321212,211321,'北沟门子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321214,211321,'东大道乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321215,211321,'乌兰河硕蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321220,211321,'东大屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321221,211321,'松岭门蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321222,211321,'根德营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321224,211321,'西营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321228,211321,'北四家子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321230,211321,'王营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321231,211321,'黑牛营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321232,211321,'尚志乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211321400,211321,'国营朝阳县贾家店农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322001,211322,'叶柏寿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322002,211322,'红山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322003,211322,'铁南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322004,211322,'万寿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322101,211322,'朱碌科镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322102,211322,'建平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322103,211322,'黑水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322104,211322,'喀喇沁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322105,211322,'北二十家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322106,211322,'沙海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322108,211322,'哈拉道口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322109,211322,'榆树林子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322110,211322,'老官地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322111,211322,'深井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322112,211322,'奎德素镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322113,211322,'小塘镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322114,211322,'马场镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322115,211322,'昌隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322117,211322,'张家营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322118,211322,'青峰山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322119,211322,'太平庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322205,211322,'青松岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322206,211322,'杨树岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322209,211322,'罗福沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322211,211322,'烧锅营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322214,211322,'白山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322218,211322,'三家蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322220,211322,'义成功乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322400,211322,'八家国营农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211322401,211322,'热水国营畜牧农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324001,211324,'大城子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324002,211324,'利州街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324101,211324,'南公营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324102,211324,'山嘴子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324104,211324,'公营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324105,211324,'白塔子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324106,211324,'中三家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324107,211324,'老爷庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324108,211324,'六官营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324109,211324,'平房子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324110,211324,'十二德堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324111,211324,'羊角沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324112,211324,'兴隆庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324113,211324,'甘招镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324114,211324,'东哨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324115,211324,'水泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324204,211324,'尤杖子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324207,211324,'草场乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324210,211324,'坤都营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324211,211324,'大营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324214,211324,'卧虎沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211324400,211324,'国营官大海农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381001,211381,'城关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381002,211381,'南山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381003,211381,'冠山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381006,211381,'台吉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381101,211381,'西官营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381102,211381,'大板镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381103,211381,'上园镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381104,211381,'宝国老镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381105,211381,'黑城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381107,211381,'五间房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381108,211381,'台吉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381109,211381,'东官营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381110,211381,'龙潭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381111,211381,'北塔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381112,211381,'蒙古营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381113,211381,'大三家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381201,211381,'长皋乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381202,211381,'常河营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381203,211381,'小塔子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381204,211381,'马友营蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381206,211381,'泉巨永乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381212,211381,'哈尔脑乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381213,211381,'南八家子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381214,211381,'章吉营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381215,211381,'三宝营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381216,211381,'巴图营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381218,211381,'台吉营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381220,211381,'娄家店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381221,211381,'北四家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381223,211381,'凉水河蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381228,211381,'三宝乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381400,211381,'国营兴顺德畜牧农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381470,211381,'下府经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211381471,211381,'大黑山特别管理区管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382001,211382,'东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382002,211382,'北街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382003,211382,'南街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382008,211382,'红山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382009,211382,'城关街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382101,211382,'万元店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382102,211382,'宋杖子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382103,211382,'三十家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382104,211382,'杨杖子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382105,211382,'刀尔登镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382106,211382,'松岭子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382107,211382,'四官营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382108,211382,'沟门子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382110,211382,'小城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382111,211382,'四合当镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382113,211382,'乌兰白镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382114,211382,'瓦房店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382115,211382,'大河北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382116,211382,'牛营子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382117,211382,'三道河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382118,211382,'刘杖子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382204,211382,'大王杖子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382206,211382,'前进乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382210,211382,'北炉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382217,211382,'三家子蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382219,211382,'佛爷洞乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211382220,211382,'河坎子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402001,211402,'连山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402002,211402,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402003,211402,'渤海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402004,211402,'兴工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402005,211402,'石油街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402006,211402,'化工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402011,211402,'锦郊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402104,211402,'钢屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402105,211402,'寺儿堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402106,211402,'新台门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402201,211402,'沙河营乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402202,211402,'孤竹营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402203,211402,'白马石乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402205,211402,'山神庙子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402206,211402,'塔山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402210,211402,'杨郊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402400,211402,'杨家杖子经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211402401,211402,'连山飞地经济区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403001,211403,'葫芦岛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403003,211403,'马仗房街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403005,211403,'龙湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403006,211403,'滨海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403007,211403,'双龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403008,211403,'玉皇街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46');

INSERT INTO `eb_city_region` (`region_id`, `parent_id`, `region_name`, `region_type`, `create_time`, `update_time`)
VALUES
	(211403009,211403,'连湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403010,211403,'北港街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403201,211403,'双树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403400,211403,'葫芦岛经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403401,211403,'葫芦岛市专利技术园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211403402,211403,'龙港飞地经济区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404002,211404,'沙锅屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404008,211404,'九龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404010,211404,'龙腾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404101,211404,'缸窑岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404102,211404,'暖池塘镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404103,211404,'高桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404104,211404,'虹螺岘镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404105,211404,'金星镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404106,211404,'台集屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404201,211404,'沙锅屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404203,211404,'黄土坎乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404204,211404,'大兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404205,211404,'张相公屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404400,211404,'乌金塘水库',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211404401,211404,'南票飞地经济区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421100,211421,'绥中镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421101,211421,'西甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421102,211421,'宽邦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421103,211421,'大王庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421104,211421,'万家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421105,211421,'前所镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421106,211421,'高岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421107,211421,'前卫镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421108,211421,'荒地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421109,211421,'塔山屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421113,211421,'高台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421114,211421,'王宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421115,211421,'沙河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421116,211421,'小庄子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421201,211421,'西平坡满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421202,211421,'葛家满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421204,211421,'高甸子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421206,211421,'范家满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421207,211421,'明水满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421208,211421,'秋子沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421210,211421,'加碑岩乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421211,211421,'永安堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421212,211421,'李家堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421214,211421,'网户满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421217,211421,'城郊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421400,211421,'大台山果树农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421401,211421,'前所果树农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211421402,211421,'绥中飞地经济区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422100,211422,'建昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422101,211422,'八家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422102,211422,'喇嘛洞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422103,211422,'药王庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422104,211422,'汤神庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422105,211422,'玲珑塔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422106,211422,'大屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422201,211422,'牤牛营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422203,211422,'素珠营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422204,211422,'石佛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422206,211422,'王宝营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422207,211422,'老大杖子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422208,211422,'要路沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422209,211422,'魏家岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422210,211422,'西碱厂乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422211,211422,'头道营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422212,211422,'新开岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422213,211422,'贺杖子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422214,211422,'养马甸子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422215,211422,'和尚房子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422218,211422,'杨树湾子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422219,211422,'黑山科乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422220,211422,'雷家店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422222,211422,'小德营子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422223,211422,'二道湾子蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422224,211422,'巴什罕乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422225,211422,'娘娘庙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422226,211422,'谷杖子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211422401,211422,'建昌飞地经济区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481001,211481,'古城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481002,211481,'宁远街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481004,211481,'温泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481007,211481,'四家屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481008,211481,'菊花街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481101,211481,'曹庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481103,211481,'沙后所满族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481104,211481,'东辛庄满族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481105,211481,'郭家满族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481106,211481,'红崖子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481107,211481,'徐大堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481108,211481,'高家岭满族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481201,211481,'羊安满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481203,211481,'元台子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481204,211481,'白塔满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481206,211481,'望海满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481207,211481,'刘台子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481208,211481,'大寨满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481209,211481,'南大满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481210,211481,'围屏满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481212,211481,'碱厂满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481213,211481,'三道沟满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481215,211481,'旧门满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481216,211481,'药王满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(211481400,211481,'兴城飞地经济区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102001,220102,'南岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102002,220102,'自强街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102003,220102,'民康街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102004,220102,'新春街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102005,220102,'长通街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102006,220102,'全安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102007,220102,'曙光街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102008,220102,'永吉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102009,220102,'桃源街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102010,220102,'鸿城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102011,220102,'明珠街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102012,220102,'富裕街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220102200,220102,'幸福乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103001,220103,'新发街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103002,220103,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103003,220103,'南广街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103004,220103,'东广街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103005,220103,'群英街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103006,220103,'兴业街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103007,220103,'凯旋街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103008,220103,'团山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103009,220103,'柳影街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103010,220103,'欣园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103011,220103,'长德街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103100,220103,'兰家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103101,220103,'米沙子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103102,220103,'万宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220103171,220103,'合隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104001,220104,'前进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104002,220104,'桂林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104003,220104,'南湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104004,220104,'永昌街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104005,220104,'重庆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104006,220104,'清和街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104007,220104,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104008,220104,'湖西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104009,220104,'富锋街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104100,220104,'乐山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220104101,220104,'永春镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105001,220105,'东盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105002,220105,'吉林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105003,220105,'荣光街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105004,220105,'东站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105005,220105,'远达街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105006,220105,'八里堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105007,220105,'长青街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105100,220105,'英俊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105173,220105,'劝农山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105174,220105,'泉眼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220105270,220105,'四家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106001,220106,'正阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106003,220106,'春城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106005,220106,'青年路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106006,220106,'普阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106007,220106,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106010,220106,'林园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106011,220106,'同心街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106100,220106,'合心镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106101,220106,'西新镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106102,220106,'城西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220106400,220106,'绿园经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220112001,220112,'云山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220112002,220112,'平湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220112003,220112,'奢岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220112004,220112,'山河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220112102,220112,'鹿乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220112104,220112,'齐家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220112105,220112,'太平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220112203,220112,'双营子回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113001,220113,'九台街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113002,220113,'营城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113003,220113,'九郊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113004,220113,'西营城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113005,220113,'土们岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113006,220113,'苇子沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113007,220113,'兴隆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113008,220113,'纪家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113009,220113,'波泥河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113010,220113,'卡伦湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113011,220113,'东湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113012,220113,'龙嘉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113013,220113,'兴港街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113014,220113,'沐石河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113015,220113,'城子街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113102,220113,'其塔木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113103,220113,'上河湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113200,220113,'胡家回族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220113201,220113,'莽卡满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122001,220122,'兴农街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122002,220122,'宝塔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122003,220122,'和谐街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122004,220122,'黄龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122100,220122,'农安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122101,220122,'伏龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122102,220122,'哈拉海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122103,220122,'靠山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122104,220122,'开安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122105,220122,'烧锅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122106,220122,'高家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122107,220122,'华家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122108,220122,'三盛玉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122109,220122,'巴吉垒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122110,220122,'三岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122200,220122,'前岗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122201,220122,'龙王乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122203,220122,'万顺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122204,220122,'杨树林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122205,220122,'永安乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122206,220122,'青山口乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122207,220122,'黄鱼圈乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122208,220122,'新农乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122209,220122,'万金塔乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122210,220122,'小城子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220122400,220122,'洼中高农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220171001,220171,'临河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220171002,220171,'东方广场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220171003,220171,'会展街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220171004,220171,'世纪街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220171100,220171,'兴隆山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172001,220172,'永兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172002,220172,'净月街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172003,220172,'福祉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172004,220172,'德正街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172005,220172,'彩织街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172006,220172,'德容街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172007,220172,'博硕街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172100,220172,'新立城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172101,220172,'新湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220172102,220172,'玉潭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220173001,220173,'硅谷街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220173002,220173,'北湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220173003,220173,'超越街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220173004,220173,'飞跃街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220173005,220173,'双德街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220173200,220173,'奋进乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220174001,220174,'锦程街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220174002,220174,'东风街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220174003,220174,'富民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220174004,220174,'前程街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182001,220182,'华昌街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182002,220182,'正阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182003,220182,'培英街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182004,220182,'城郊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182100,220182,'五棵树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182101,220182,'弓棚镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182102,220182,'闵家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182103,220182,'大坡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182104,220182,'黑林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182105,220182,'土桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182106,220182,'新立镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182107,220182,'大岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182108,220182,'于家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182109,220182,'泗河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182110,220182,'八号镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182111,220182,'刘家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182112,220182,'秀水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182113,220182,'保寿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182114,220182,'新庄镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182200,220182,'育民乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182201,220182,'红星乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182202,220182,'太安乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182203,220182,'先峰乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182204,220182,'青山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182205,220182,'延和朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182206,220182,'恩育乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182207,220182,'城发乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220182208,220182,'环城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183001,220183,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183002,220183,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183003,220183,'惠发街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183004,220183,'夏家店街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183100,220183,'大青嘴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183101,220183,'郭家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183102,220183,'松花江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183103,220183,'达家沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183104,220183,'大房身镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183105,220183,'岔路口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183106,220183,'朱城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183107,220183,'布海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183108,220183,'天台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183109,220183,'菜园子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183200,220183,'同太乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183201,220183,'边岗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183202,220183,'五台乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220183203,220183,'朝阳乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184001,220184,'河南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184002,220184,'河北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184003,220184,'东三街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184004,220184,'岭东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184005,220184,'铁北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184006,220184,'岭西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184007,220184,'刘房子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184008,220184,'南崴子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184009,220184,'环岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184010,220184,'苇子沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184100,220184,'二十家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184101,220184,'黑林子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184102,220184,'陶家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184103,220184,'范家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184104,220184,'响水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184105,220184,'大岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184106,220184,'怀德镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184107,220184,'双城堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184108,220184,'双龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184109,220184,'杨大城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184110,220184,'毛城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184111,220184,'玻璃城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184112,220184,'朝阳坡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184113,220184,'大榆树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184114,220184,'秦家屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184115,220184,'八屋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184116,220184,'十屋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184117,220184,'桑树台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184200,220184,'龙山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184201,220184,'永发乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184400,220184,'省原种繁殖场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184401,220184,'四平农科院',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184402,220184,'公主岭市种猪场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184404,220184,'十屋种牛场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184405,220184,'创业农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220184407,220184,'范家屯经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202001,220202,'兴华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202002,220202,'文庙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202003,220202,'东局子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202004,220202,'新地号街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202005,220202,'延安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202006,220202,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202007,220202,'民主街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202008,220202,'莲花街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202009,220202,'通江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202010,220202,'哈达湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202011,220202,'新建街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202012,220202,'延江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202071,220202,'吉林东市商贸示范区特殊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202100,220202,'孤店子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202101,220202,'桦皮厂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202102,220202,'左家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202200,220202,'两家子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202201,220202,'土城子满族朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202401,220202,'幸福开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220202402,220202,'哈达湾经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203001,220203,'龙华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203002,220203,'湘潭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203003,220203,'铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203004,220203,'泡子沿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203005,220203,'龙潭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203006,220203,'新吉林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203007,220203,'山前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203008,220203,'新安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203009,220203,'遵义街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203010,220203,'榆树街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203012,220203,'东城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203013,220203,'承德街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203014,220203,'靠山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203100,220203,'乌拉街镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203101,220203,'缸窑镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203102,220203,'江密峰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203103,220203,'大口钦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203104,220203,'金珠镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203200,220203,'江北乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203400,220203,'龙潭经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220203401,220203,'金珠工业区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204001,220204,'德胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204002,220204,'南京街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204003,220204,'大东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204004,220204,'青岛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204005,220204,'向阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204006,220204,'北极街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204007,220204,'致和街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204008,220204,'长春路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204009,220204,'临江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204010,220204,'北山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204011,220204,'黄旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204100,220204,'大绥河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204101,220204,'搜登站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204102,220204,'越北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204200,220204,'欢喜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220204400,220204,'吉林船营经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211001,220211,'泰山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211002,220211,'江南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211003,220211,'石井街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211004,220211,'沿丰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211005,220211,'丰满街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211008,220211,'建华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211071,220211,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211100,220211,'旺起镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211200,220211,'江南乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211201,220211,'前二道乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220211270,220211,'小白山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221100,220221,'口前镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221101,220221,'双河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221102,220221,'西阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221103,220221,'北大湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221104,220221,'一拉溪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221171,220221,'万昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221172,220221,'永吉经济开发区特殊乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221200,220221,'金家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220221201,220221,'黄榆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220271001,220271,'九站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220271013,220271,'双吉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220272001,220272,'高新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220272002,220272,'新北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220273100,220273,'岔路河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281001,220281,'民主街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281002,220281,'长安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281003,220281,'河南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281004,220281,'奶子山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281005,220281,'拉法街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281006,220281,'河北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281007,220281,'新农街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281100,220281,'新站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281101,220281,'天岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281102,220281,'白石山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281103,220281,'漂河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281104,220281,'黄松甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281105,220281,'天北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281106,220281,'松江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281107,220281,'庆岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281200,220281,'乌林朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220281201,220281,'前进乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282001,220282,'明桦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282002,220282,'永吉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282003,220282,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282004,220282,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282005,220282,'启新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282100,220282,'夹皮沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282101,220282,'二道甸子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282102,220282,'红石砬子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282103,220282,'八道河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282104,220282,'常山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282105,220282,'金沙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282200,220282,'桦郊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282201,220282,'横道河子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220282204,220282,'公吉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283001,220283,'北城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283002,220283,'南城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283003,220283,'环城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283004,220283,'吉舒街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283005,220283,'滨河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283100,220283,'法特镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283101,220283,'白旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283102,220283,'溪河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283103,220283,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283104,220283,'小城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283105,220283,'上营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283106,220283,'水曲柳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283107,220283,'平安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283108,220283,'金马镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283109,220283,'开原镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283200,220283,'莲花乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283201,220283,'亮甲山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283202,220283,'新安乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283203,220283,'七里乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220283204,220283,'天德乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284001,220284,'福安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284002,220284,'东宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284003,220284,'河南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284070,220284,'磐石经济开发区特殊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284100,220284,'烟筒山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284101,220284,'红旗岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284102,220284,'明城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284103,220284,'石嘴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284104,220284,'驿马镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284105,220284,'牛心镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284106,220284,'呼兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284107,220284,'吉昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284108,220284,'松山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284109,220284,'黑石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284110,220284,'朝阳山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284111,220284,'富太镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284112,220284,'取柴河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220284200,220284,'宝山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220302001,220302,'仁兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220302002,220302,'英雄街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220302003,220302,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220302004,220302,'北沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220302005,220302,'地直街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220302200,220302,'平西乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220302400,220302,'红嘴高新技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303001,220303,'四平市铁东区平东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303002,220303,'四平市铁东区北市场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303003,220303,'四平市铁东区七马路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303004,220303,'四平市铁东区四马路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303005,220303,'四平市铁东区解放街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303006,220303,'四平市铁东区北门街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303007,220303,'四平市铁东区黄土坑街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303008,220303,'四平市铁东区平南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303100,220303,'四平市铁东区山门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303101,220303,'四平市铁东区石岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303102,220303,'四平市铁东区叶赫满族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220303200,220303,'四平市铁东区城东乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322001,220322,'富强街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322002,220322,'康平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322003,220322,'霍家店街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322100,220322,'梨树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322101,220322,'郭家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322102,220322,'榆树台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322103,220322,'孤家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322104,220322,'小城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322105,220322,'喇嘛甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322106,220322,'蔡家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322107,220322,'刘家馆子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322108,220322,'十家堡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322109,220322,'孟家岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322110,220322,'万发镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322111,220322,'东河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322112,220322,'沈洋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322113,220322,'林海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322114,220322,'小宽镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322200,220322,'白山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322201,220322,'泉眼岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322202,220322,'胜利乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322203,220322,'四棵树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322204,220322,'双河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220322205,220322,'金山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323001,220323,'永盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323002,220323,'永宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323100,220323,'伊通镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323101,220323,'二道镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323102,220323,'伊丹镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323103,220323,'马鞍山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323104,220323,'景台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323105,220323,'靠山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323106,220323,'大孤山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323107,220323,'小孤山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323108,220323,'营城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323109,220323,'西苇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323110,220323,'河源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323111,220323,'黄岭子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323200,220323,'新兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323201,220323,'莫里青乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220323202,220323,'三道乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382001,220382,'郑家屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382002,220382,'辽西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382003,220382,'辽南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382004,220382,'辽北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382005,220382,'辽东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382006,220382,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382100,220382,'茂林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382101,220382,'双山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382102,220382,'卧虎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382103,220382,'服先镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382104,220382,'王奔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382105,220382,'玻璃山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382106,220382,'兴隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382107,220382,'东明镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382200,220382,'那木乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382201,220382,'柳条乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382202,220382,'新立乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382203,220382,'永加乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220382402,220382,'双辽经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402001,220402,'东吉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402002,220402,'南康街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402003,220402,'北寿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402004,220402,'西宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402005,220402,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402006,220402,'向阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402007,220402,'新兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402008,220402,'福镇街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402070,220402,'辽源经济开发区特殊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402100,220402,'寿山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220402200,220402,'工农乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220403001,220403,'太安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220403002,220403,'仙城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220403003,220403,'东山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220403004,220403,'先锋街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220403005,220403,'富国街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220403006,220403,'安家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220403100,220403,'灯塔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421001,220421,'吉鹿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421002,220421,'祥鹿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421003,220421,'福鹿街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421100,220421,'东丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421101,220421,'大阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421102,220421,'横道河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421103,220421,'那丹伯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421104,220421,'猴石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421105,220421,'杨木林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421106,220421,'小四平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421107,220421,'黄河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421108,220421,'拉拉河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421109,220421,'沙河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421110,220421,'南屯基镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421111,220421,'大兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421200,220421,'三合满族朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220421201,220421,'二龙山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422100,220422,'白泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422101,220422,'渭津镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422102,220422,'安石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422103,220422,'辽河源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422104,220422,'泉太镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422105,220422,'建安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422106,220422,'安恕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422107,220422,'平岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422108,220422,'云顶镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422200,220422,'凌云乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422201,220422,'甲山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422202,220422,'足民乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220422203,220422,'金州乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502001,220502,'东昌街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502002,220502,'民主街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502003,220502,'老站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502004,220502,'团结街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502005,220502,'新站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502006,220502,'光明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502007,220502,'龙泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502008,220502,'陆港街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502009,220502,'滨江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502100,220502,'金厂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502120,220502,'通化经济开发区特殊乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502200,220502,'环通乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220502201,220502,'江东乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220503001,220503,'桃园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220503002,220503,'东通化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220503100,220503,'鸭园镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220503101,220503,'铁厂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220503102,220503,'五道江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220503200,220503,'二道江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521001,220521,'茂山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521002,220521,'东安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521100,220521,'快大茂镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521101,220521,'二密镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521102,220521,'果松镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521103,220521,'石湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521104,220521,'大安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521105,220521,'光华镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521106,220521,'兴林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521107,220521,'英额布镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521108,220521,'三棵榆树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521109,220521,'西江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521120,220521,'通化聚鑫经济开发区特殊乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521200,220521,'富江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521201,220521,'四棚乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521202,220521,'东来乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521203,220521,'大泉源满族朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521204,220521,'金斗朝鲜族满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220521401,220521,'东宝新村',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523001,220523,'东凤街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523002,220523,'朝辉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523003,220523,'西凤街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523100,220523,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523101,220523,'辉南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523102,220523,'样子哨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523103,220523,'杉松岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523104,220523,'石道河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523105,220523,'辉发城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523106,220523,'抚民镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523107,220523,'金川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523108,220523,'团林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523109,220523,'庆阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220523200,220523,'楼街朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524001,220524,'采胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524002,220524,'中岗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524003,220524,'导航街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524100,220524,'柳河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524101,220524,'三源浦朝鲜族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524102,220524,'五道沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524103,220524,'驼腰岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524104,220524,'孤山子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524105,220524,'圣水河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524106,220524,'罗通山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524107,220524,'安口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524108,220524,'向阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524109,220524,'红石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524110,220524,'凉水河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524111,220524,'亨通镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524200,220524,'柳南乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524201,220524,'时家店乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220524202,220524,'姜家店朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581001,220581,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581002,220581,'光明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581070,220581,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581071,220581,'解放街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581072,220581,'福民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581100,220581,'山城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581101,220581,'红梅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581102,220581,'海龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581103,220581,'新合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581104,220581,'曙光镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581105,220581,'中和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581106,220581,'黑山头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581107,220581,'水道镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581108,220581,'进化镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581109,220581,'一座营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581110,220581,'康大营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581111,220581,'牛心顶镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581112,220581,'杏岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581113,220581,'湾龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581114,220581,'兴华镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581115,220581,'双兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581201,220581,'李炉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581205,220581,'小杨满族朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220581206,220581,'吉乐乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582001,220582,'团结街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582002,220582,'黎明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582003,220582,'通胜街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582004,220582,'城东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582100,220582,'青石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582101,220582,'榆林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582102,220582,'花甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582103,220582,'头道镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582104,220582,'清河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582105,220582,'台上镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582106,220582,'财源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582107,220582,'大路镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582108,220582,'太王镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582200,220582,'麻线乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220582201,220582,'凉水朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602001,220602,'新建街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602002,220602,'通沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602003,220602,'东兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602004,220602,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602005,220602,'城南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602006,220602,'江北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602007,220602,'河口街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602008,220602,'板石街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602100,220602,'七道江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602101,220602,'六道江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602102,220602,'红土崖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220602103,220602,'三道沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605001,220605,'孙家堡子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605002,220605,'江源街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605003,220605,'正岔街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605004,220605,'城墙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605102,220605,'湾沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605103,220605,'松树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605104,220605,'砟子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605105,220605,'石人镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605106,220605,'大阳岔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220605107,220605,'大石人镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621100,220621,'抚松镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621101,220621,'松江河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621102,220621,'泉阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621103,220621,'露水河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621104,220621,'仙人桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621105,220621,'万良镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621106,220621,'新屯子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621107,220621,'东岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621108,220621,'漫江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621109,220621,'北岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621110,220621,'兴参镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621120,220621,'长白山保护开发区池西区特殊乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621121,220621,'长白山保护开发区池南区特殊乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621200,220621,'兴隆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621201,220621,'抽水乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220621202,220621,'沿江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220622100,220622,'靖宇镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220622101,220622,'三道湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220622102,220622,'龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220622103,220622,'那尔轰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220622104,220622,'花园口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220622105,220622,'景山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220622106,220622,'赤松镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220622201,220622,'濛江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220623100,220623,'长白镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220623101,220623,'八道沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220623102,220623,'十四道沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220623103,220623,'马鹿沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220623104,220623,'宝泉山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220623105,220623,'新房子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220623106,220623,'十二道沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220623200,220623,'金华乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681001,220681,'建国街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681002,220681,'新市街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681003,220681,'兴隆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681004,220681,'大湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681005,220681,'森工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681006,220681,'大栗子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681100,220681,'桦树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681101,220681,'六道沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681102,220681,'苇沙河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681103,220681,'花山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681104,220681,'闹枝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681105,220681,'四道沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220681200,220681,'蚂蚁河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702001,220702,'团结街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702002,220702,'文化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702003,220702,'民主街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702004,220702,'临江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702005,220702,'新区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702006,220702,'前进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702007,220702,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702008,220702,'工农街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702009,220702,'沿江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702010,220702,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702011,220702,'繁荣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702012,220702,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702013,220702,'石化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702014,220702,'伯都讷街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702015,220702,'长宁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702016,220702,'滨江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702017,220702,'镜湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702100,220702,'大洼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702101,220702,'善友镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702102,220702,'毛都站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702103,220702,'哈达山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702200,220702,'新城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702202,220702,'伯都乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702400,220702,'华侨农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702401,220702,'大洼商业渔场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702402,220702,'国营善友林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702403,220702,'国营八家子苗圃',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702404,220702,'良种繁育场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702405,220702,'哈达山林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220702406,220702,'雅达虹工业集中区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721100,220721,'前郭尔罗斯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721101,220721,'长山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721102,220721,'海渤日戈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721103,220721,'乌兰图嘎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721104,220721,'查干花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721105,220721,'王府站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721106,220721,'八郎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721107,220721,'哈拉毛都镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721108,220721,'查干湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721200,220721,'宝甸乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721201,220721,'平凤乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721203,220721,'达里巴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721204,220721,'吉拉吐乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721205,220721,'白依拉嘎乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721206,220721,'洪泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721207,220721,'额如乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721208,220721,'套浩太乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721209,220721,'长龙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721210,220721,'乌兰塔拉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721211,220721,'东三家子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721212,220721,'浩特芒哈乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721213,220721,'乌兰敖都乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721400,220721,'红旗农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721401,220721,'红光农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721402,220721,'红星牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721403,220721,'查干花种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721404,220721,'莲花泡农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721405,220721,'深井子牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721406,220721,'前郭尔罗斯蒙古族自治县国有林总场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721407,220721,'查干湖旅游经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721408,220721,'八郎农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721409,220721,'查干湖渔场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721411,220721,'长山余热鱼苗繁殖场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721412,220721,'库里渔场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721413,220721,'哈拉毛都良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721415,220721,'新庙泡渔场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220721417,220721,'吉林前郭经济技术开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722001,220722,'长盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722002,220722,'长治街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722003,220722,'长久街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722100,220722,'长岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722101,220722,'太平川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722102,220722,'巨宝山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722103,220722,'太平山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722104,220722,'前七号镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722105,220722,'新安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722106,220722,'三青山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722107,220722,'大兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722108,220722,'北正镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722109,220722,'流水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722110,220722,'永久镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722111,220722,'利发盛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722200,220722,'集体乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722201,220722,'光明乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722202,220722,'三县堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722203,220722,'海青乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722204,220722,'前进乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722205,220722,'东岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722206,220722,'腰坨子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722207,220722,'八十八乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722208,220722,'三团乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722209,220722,'三十号乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722400,220722,'长岭种马场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722401,220722,'长岭环城工业集中区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722405,220722,'太平川机械林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722406,220722,'三团机械林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722407,220722,'东岭机械林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722408,220722,'十四号种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722409,220722,'良种繁育场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220722410,220722,'前七号机械林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723001,220723,'荣业街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723002,220723,'驰誉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723003,220723,'如松街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723100,220723,'乾安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723101,220723,'大布苏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723102,220723,'水字镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723103,220723,'让字镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723104,220723,'所字镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723105,220723,'安字镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723200,220723,'余字乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723201,220723,'道字乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723202,220723,'严字乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723203,220723,'赞字乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723400,220723,'国营林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723401,220723,'腾字种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723402,220723,'大遐畜牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723403,220723,'乾安鹿场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723404,220723,'来字良种繁育基地',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220723405,220723,'地字种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220771200,220771,'兴原乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220771599,220771,'松原经济技术开发区特殊乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781001,220781,'和兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781002,220781,'育才街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781003,220781,'联盟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781004,220781,'士英街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781005,220781,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781100,220781,'三岔河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781101,220781,'长春岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781102,220781,'五家站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781103,220781,'陶赖昭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781104,220781,'蔡家沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781105,220781,'弓棚子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781106,220781,'三井子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781107,220781,'增盛镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781108,220781,'新万发镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781109,220781,'大林子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781110,220781,'新源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781111,220781,'得胜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781200,220781,'三骏满族蒙古族锡伯族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781201,220781,'永平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781203,220781,'新站乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781204,220781,'更新乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781206,220781,'肖家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781401,220781,'拉林灌区管理局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220781402,220781,'下岱吉灌区管理局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802001,220802,'海明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802002,220802,'长庆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802003,220802,'瑞光街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802004,220802,'明仁街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802005,220802,'铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802006,220802,'（工业园区）城南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802007,220802,'新立街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802009,220802,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802100,220802,'平安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802101,220802,'青山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802102,220802,'林海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802103,220802,'洮河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802104,220802,'平台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802105,220802,'到保镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802170,220802,'（查干浩特旅游经济开发区）岭下镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802200,220802,'东风乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802201,220802,'三合乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802202,220802,'东胜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802203,220802,'金祥乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802204,220802,'德顺蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802402,220802,'镇南种羊场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802403,220802,'白城牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802404,220802,'洮儿河农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802405,220802,'保民农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220802407,220802,'白城市生态新区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821100,220821,'镇赉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821101,220821,'坦途镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821102,220821,'东屏镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821103,220821,'大屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821104,220821,'沿江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821105,220821,'五棵树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821106,220821,'黑鱼泡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821200,220821,'哈吐气蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821201,220821,'莫莫格蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821202,220821,'建平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821203,220821,'嘎什根乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821400,220821,'四方坨子农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821402,220821,'良种繁育场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821403,220821,'九龙山马场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220821406,220821,'国营渔场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822001,220822,'树满街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822002,220822,'八区街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822003,220822,'迎新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822100,220822,'开通镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822101,220822,'瞻榆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822102,220822,'双岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822103,220822,'兴隆山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822104,220822,'边昭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822105,220822,'鸿兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822106,220822,'新华镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822107,220822,'乌兰花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822200,220822,'新发乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822201,220822,'新兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822202,220822,'向海蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822203,220822,'包拉温都蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822204,220822,'团结乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822205,220822,'十花道乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822206,220822,'八面乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822207,220822,'苏公坨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822400,220822,'通榆经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822401,220822,'三家子种牛场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220822405,220822,'新华牛场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220871001,220871,'幸福街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220871002,220871,'保平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220871003,220871,'西郊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881001,220881,'团结街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881002,220881,'富文街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881003,220881,'光明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881004,220881,'兴隆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881005,220881,'永康街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881006,220881,'通达街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881007,220881,'洮府街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881008,220881,'向阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881100,220881,'瓦房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881101,220881,'万宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881102,220881,'黑水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881103,220881,'那金镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881104,220881,'安定镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881105,220881,'福顺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881200,220881,'胡力吐蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881201,220881,'万宝乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881202,220881,'聚宝乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881203,220881,'东升乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881204,220881,'野马乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881205,220881,'永茂乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881206,220881,'蛟流河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881207,220881,'大通乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881209,220881,'二龙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881210,220881,'呼和车力蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220881402,220881,'市原种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882001,220882,'慧阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882002,220882,'临江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882003,220882,'长虹街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882004,220882,'锦华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882005,220882,'安北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882100,220882,'月亮泡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882101,220882,'安广镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882102,220882,'丰收镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882103,220882,'新平安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882104,220882,'两家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882105,220882,'舍力镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882106,220882,'大岗子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882107,220882,'叉干镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882108,220882,'龙沼镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882109,220882,'太山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882200,220882,'四棵树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882201,220882,'联合乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882202,220882,'大赉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882203,220882,'红岗子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882204,220882,'海坨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882205,220882,'新艾里蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882206,220882,'烧锅镇乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882207,220882,'乐胜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882400,220882,'大安经济开发区（省级）',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882401,220882,'新荒渔场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882402,220882,'东方红农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882404,220882,'五间房水库',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882406,220882,'风水山牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882407,220882,'东风马场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882408,220882,'良种繁育场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882409,220882,'大安马场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882410,220882,'安广猪场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(220882411,220882,'红旗饲养场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401001,222401,'进学街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401002,222401,'北山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401003,222401,'新兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401004,222401,'公园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401005,222401,'河南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401006,222401,'建工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401100,222401,'小营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401101,222401,'依兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401102,222401,'三道湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401105,222401,'朝阳川镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401400,222401,'延吉市林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401401,222401,'东山农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401402,222401,'延边原种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222401404,222401,'延边新兴工业集中区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222402001,222402,'向上街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222402002,222402,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222402003,222402,'月宫街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222402100,222402,'月晴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222402101,222402,'石岘镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222402102,222402,'长安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222402103,222402,'凉水镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403001,222403,'渤海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403002,222403,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403003,222403,'民主街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403004,222403,'丹江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403100,222403,'大石头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403101,222403,'黄泥河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403102,222403,'官地镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403103,222403,'沙河沿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403104,222403,'秋梨沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403105,222403,'额穆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403106,222403,'贤儒镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403107,222403,'大蒲柴河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403108,222403,'雁鸣湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403109,222403,'江源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403110,222403,'江南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403200,222403,'大桥乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403201,222403,'黑石乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403202,222403,'青沟子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403203,222403,'翰章乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403204,222403,'红石乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403400,222403,'长白山森工集团敦化林业有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403401,222403,'长白山森工集团黄泥河林业有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403402,222403,'长白山森工集团大石头林业有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403403,222403,'敦化市林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222403404,222403,'敖东鹿场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404001,222404,'靖和街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404002,222404,'新安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404003,222404,'河南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404060,222404,'近海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404100,222404,'春化镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404101,222404,'敬信镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404102,222404,'板石镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404103,222404,'英安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404200,222404,'马川子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404201,222404,'杨泡满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404202,222404,'三家子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404203,222404,'密江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404204,222404,'哈达门乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222404400,222404,'珲春林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405001,222405,'安民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405002,222405,'龙门街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405100,222405,'开山屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405102,222405,'老头沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405103,222405,'三合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405104,222405,'东盛涌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405105,222405,'智新镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405200,222405,'德新乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405201,222405,'白金乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405400,222405,'龙井市林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222405401,222405,'龙井大苏果树农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406001,222406,'民慧街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406002,222406,'光明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406003,222406,'文化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406100,222406,'八家子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406101,222406,'福洞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406102,222406,'头道镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406103,222406,'西城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406104,222406,'南坪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406105,222406,'东城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406106,222406,'崇善镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406107,222406,'龙城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406400,222406,'和龙林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406401,222406,'八家子林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222406402,222406,'和龙市林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424011,222424,'大川街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424012,222424,'新民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424013,222424,'长荣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424100,222424,'汪清镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424101,222424,'大兴沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424102,222424,'天桥岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424103,222424,'罗子沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424104,222424,'百草沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424105,222424,'春阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424106,222424,'复兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424107,222424,'东光镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424200,222424,'鸡冠乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424400,222424,'汪清林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424401,222424,'天桥岭林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222424402,222424,'大兴沟林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426001,222426,'长兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426002,222426,'瓮声街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426003,222426,'九龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426100,222426,'明月镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426101,222426,'松江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426102,222426,'二道白河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426103,222426,'两江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426104,222426,'石门镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426105,222426,'万宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426106,222426,'亮兵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426120,222426,'长白山保护开发区池北区特殊乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426200,222426,'新合乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426201,222426,'永庆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426400,222426,'白河林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426401,222426,'安图林业有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(222426402,222426,'安图县林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102001,230102,'兆麟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102002,230102,'新阳路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102003,230102,'抚顺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102004,230102,'共乐街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102005,230102,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102006,230102,'城乡路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102007,230102,'工农街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102008,230102,'尚志街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102009,230102,'斯大林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102010,230102,'通江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102011,230102,'经纬街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102012,230102,'工程街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102013,230102,'安静街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102014,230102,'安和街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102015,230102,'正阳河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102016,230102,'建国街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102017,230102,'康安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102018,230102,'爱建街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102019,230102,'群力街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102101,230102,'太平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102102,230102,'新发镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102103,230102,'新农镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230102104,230102,'榆树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103001,230103,'花园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103002,230103,'奋斗路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103003,230103,'革新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103004,230103,'文化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103005,230103,'大成街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103006,230103,'芦家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103007,230103,'荣市街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103009,230103,'燎原街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103010,230103,'松花江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103011,230103,'曲线街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103012,230103,'通达街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103013,230103,'七政街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103015,230103,'和兴路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103016,230103,'哈西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103017,230103,'保健路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103018,230103,'先锋路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103019,230103,'新春街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103020,230103,'跃进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103101,230103,'王岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103201,230103,'红旗满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103500,230103,'红旗农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230103579,230103,'南岗区农垦',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104001,230104,'靖宇街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104002,230104,'太古街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104003,230104,'东莱街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104004,230104,'滨江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104005,230104,'仁里街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104006,230104,'南市街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104007,230104,'崇俭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104008,230104,'振江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104009,230104,'东原街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104010,230104,'大兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104011,230104,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104012,230104,'南马街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104021,230104,'民强街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104022,230104,'大有坊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104023,230104,'南直路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104024,230104,'化工街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104025,230104,'火车头街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104026,230104,'新一街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104027,230104,'三棵树大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104028,230104,'水泥路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104029,230104,'太平大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104030,230104,'黎华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104031,230104,'新乐街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104102,230104,'永源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104109,230104,'巨源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104111,230104,'团结镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104112,230104,'民主镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104500,230104,'青年农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230104579,230104,'道外农垦',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108001,230108,'兴建街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108002,230108,'保国街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108003,230108,'联盟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108004,230108,'友协街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108005,230108,'新疆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108006,230108,'新伟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108007,230108,'平新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108008,230108,'建安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108009,230108,'平盛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108101,230108,'平房镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230108579,230108,'平房农垦',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109002,230109,'太阳岛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109003,230109,'松浦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109004,230109,'万宝街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109005,230109,'松北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109006,230109,'松安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109007,230109,'松祥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109008,230109,'船口街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109101,230109,'对青山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230109102,230109,'乐业镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110001,230110,'香坊大街街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110002,230110,'安埠街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110003,230110,'通天街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110004,230110,'新香坊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110005,230110,'铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110006,230110,'新成街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110007,230110,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110008,230110,'六顺街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110009,230110,'建筑街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110010,230110,'哈平路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110011,230110,'安乐街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110012,230110,'健康路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110013,230110,'大庆路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110014,230110,'进乡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110015,230110,'通乡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110016,230110,'和平路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110017,230110,'民生路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110018,230110,'文政街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110019,230110,'王兆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110020,230110,'黎明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110101,230110,'成高子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110102,230110,'幸福镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110103,230110,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110104,230110,'向阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110400,230110,'哈尔滨综合保税区地区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110500,230110,'香坊实验农场地区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230110579,230110,'香坊区农垦地区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111001,230111,'呼兰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111002,230111,'兰河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111003,230111,'腰堡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111004,230111,'利民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111005,230111,'康金街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111006,230111,'双井街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111007,230111,'建设路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111008,230111,'学院路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111009,230111,'长岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111010,230111,'沈家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111011,230111,'南京路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111012,230111,'裕民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111013,230111,'裕田街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111014,230111,'裕强街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111015,230111,'萧乡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111016,230111,'公园路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111105,230111,'二八镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111106,230111,'石人镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111107,230111,'白奎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111109,230111,'方台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111110,230111,'莲花镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111111,230111,'大用镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111114,230111,'利业镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111201,230111,'杨林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111203,230111,'许堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111205,230111,'孟家乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230111579,230111,'呼兰农垦',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112001,230112,'金城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112002,230112,'金都街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112003,230112,'通城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112004,230112,'河东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112005,230112,'阿什河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112006,230112,'玉泉街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112007,230112,'新利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112008,230112,'双丰街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112009,230112,'舍利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112010,230112,'小岭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112011,230112,'亚沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112012,230112,'交界街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112013,230112,'料甸街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112014,230112,'蜚克图街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112015,230112,'杨树街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112107,230112,'平山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112108,230112,'松峰山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112109,230112,'红星镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112112,230112,'金龙山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230112503,230112,'阿城原种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113002,230113,'五家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113003,230113,'新兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113004,230113,'兰棱街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113005,230113,'周家街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113006,230113,'公正街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113007,230113,'承旭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113008,230113,'承恩街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113009,230113,'永治街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113010,230113,'永和街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113011,230113,'幸福街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113104,230113,'韩甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113105,230113,'单城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113106,230113,'东官镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113107,230113,'农丰满族锡伯族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113108,230113,'杏山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113109,230113,'西官镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113110,230113,'联兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113111,230113,'永胜镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113112,230113,'胜丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113201,230113,'金城乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113203,230113,'青岭满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113209,230113,'临江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113210,230113,'水泉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113211,230113,'乐群满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113214,230113,'万隆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113216,230113,'希勤满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230113217,230113,'同心满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123100,230123,'依兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123101,230123,'达连河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123102,230123,'江湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123103,230123,'三道岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123104,230123,'道台桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123105,230123,'宏克利镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123200,230123,'团山子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123201,230123,'愚公乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123202,230123,'迎兰朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123400,230123,'依兰县林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123500,230123,'依兰农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230123501,230123,'松花江农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124100,230124,'方正镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124101,230124,'会发镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124102,230124,'大罗密镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124103,230124,'得莫利镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124200,230124,'天门乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124201,230124,'松南乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124202,230124,'德善乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124204,230124,'宝兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124400,230124,'方正林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230124500,230124,'沙河农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125100,230125,'宾州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125101,230125,'居仁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125102,230125,'宾西镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125103,230125,'糖坊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125104,230125,'宾安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125105,230125,'新甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125106,230125,'胜利镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125107,230125,'宁远镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125109,230125,'摆渡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125110,230125,'平坊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125111,230125,'满井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125112,230125,'常安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125201,230125,'永和乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125203,230125,'鸟河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125204,230125,'民和乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125205,230125,'经建乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125210,230125,'三宝乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125500,230125,'九龙山柞蚕育种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230125579,230125,'农垦农业职业学院',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126100,230126,'巴彦镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126101,230126,'兴隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126102,230126,'西集镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126103,230126,'洼兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126104,230126,'龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126105,230126,'巴彦港镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126106,230126,'龙庙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126107,230126,'万发镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126108,230126,'天增镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126110,230126,'黑山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126200,230126,'松花江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126202,230126,'富江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126204,230126,'华山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126205,230126,'丰乐乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126209,230126,'德祥乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126210,230126,'红光乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126212,230126,'山后乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126214,230126,'镇东乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126400,230126,'兴隆林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230126401,230126,'工业园区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127100,230127,'木兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127101,230127,'东兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127102,230127,'大贵镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127103,230127,'利东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127104,230127,'柳河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127105,230127,'新民镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127200,230127,'建国乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127203,230127,'吉兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230127400,230127,'兴隆林业局办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128100,230128,'通河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128101,230128,'乌鸦泡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128102,230128,'清河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128103,230128,'浓河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128104,230128,'凤山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128105,230128,'祥顺镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128106,230128,'富林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128107,230128,'三站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128400,230128,'清河林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128401,230128,'兴隆林业局办事处',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230128500,230128,'岔林河农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129100,230129,'延寿镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129101,230129,'六团镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129102,230129,'中和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129103,230129,'加信镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129104,230129,'延河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129105,230129,'玉河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129204,230129,'安山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129205,230129,'寿山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129209,230129,'青川乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129400,230129,'太平川',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230129500,230129,'庆阳农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183100,230183,'尚志镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183101,230183,'一面坡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183102,230183,'苇河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183103,230183,'亚布力镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183104,230183,'帽儿山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183105,230183,'亮河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183106,230183,'庆阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183107,230183,'石头河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183108,230183,'元宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183109,230183,'黑龙宫镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183202,230183,'长寿乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183204,230183,'乌吉密乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183206,230183,'鱼池乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183207,230183,'珍珠山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183208,230183,'老街基乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183209,230183,'马延乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183211,230183,'河东乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183400,230183,'苇河林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183401,230183,'亚布力林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230183402,230183,'哈尔滨市政府亚布力滑雪旅游度假区管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184100,230184,'五常镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184101,230184,'拉林满族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184102,230184,'山河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184103,230184,'小山子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184104,230184,'安家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184105,230184,'牛家满族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184106,230184,'杜家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184107,230184,'背荫河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184108,230184,'冲河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184109,230184,'沙河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184110,230184,'向阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184111,230184,'龙凤山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184200,230184,'兴盛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184201,230184,'志广乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184202,230184,'卫国乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184203,230184,'常堡乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184206,230184,'民意乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184209,230184,'红旗满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184210,230184,'八家子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184211,230184,'民乐朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184212,230184,'营城子满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184214,230184,'长山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184215,230184,'兴隆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184216,230184,'二河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230184400,230184,'山河屯林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230202001,230202,'五龙街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230202002,230202,'湖滨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230202003,230202,'江安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230202004,230202,'正阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230202005,230202,'彩虹街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230202006,230202,'南航街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230202007,230202,'大民街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230202579,230202,'齐齐哈尔局直',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230203002,230203,'中华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230203004,230203,'西大桥街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230203005,230203,'卜奎街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230203006,230203,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230203007,230203,'文化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230203198,230203,'区直辖村级区划',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204001,230204,'站前街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204002,230204,'南浦街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204003,230204,'通东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204004,230204,'光荣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204005,230204,'龙华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204006,230204,'北局宅街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204008,230204,'东湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204100,230204,'扎龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230204500,230204,'齐齐哈尔种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230205001,230205,'新兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230205002,230205,'新建街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230205005,230205,'林机街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230205006,230205,'道北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230205100,230205,'水师营满族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230205101,230205,'榆树屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206001,230206,'红岸街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206003,230206,'沿江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206004,230206,'电力街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206005,230206,'幸福街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206006,230206,'红宝石街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206007,230206,'北兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206008,230206,'铁北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206009,230206,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206200,230206,'长青乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230206202,230206,'杜尔门沁达斡尔族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230207001,230207,'东安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230207002,230207,'富强街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230207003,230207,'跃进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230207004,230207,'繁荣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230208001,230208,'梅里斯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230208101,230208,'雅尔塞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230208102,230208,'卧牛吐达斡尔族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230208103,230208,'达呼店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230208104,230208,'共和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230208105,230208,'梅里斯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230208200,230208,'莽格吐达斡尔族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221100,230221,'龙江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221101,230221,'景星镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221102,230221,'龙兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221103,230221,'山泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221104,230221,'七棵树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221105,230221,'杏山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221106,230221,'白山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221107,230221,'头站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221201,230221,'黑岗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221202,230221,'广厚乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221203,230221,'华民乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221204,230221,'哈拉海乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221215,230221,'鲁河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230221217,230221,'济沁河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223100,230223,'依安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223101,230223,'依龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223102,230223,'双阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223103,230223,'三兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223104,230223,'中心镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223105,230223,'新兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223200,230223,'富饶乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223201,230223,'解放乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223202,230223,'阳春乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223203,230223,'新发乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223204,230223,'太东乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223205,230223,'上游乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223206,230223,'红星乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223207,230223,'先锋乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230223208,230223,'新屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224100,230224,'泰来镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224101,230224,'平洋镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224102,230224,'汤池镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224103,230224,'江桥蒙古族镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224104,230224,'塔子城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224105,230224,'大兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224106,230224,'和平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224107,230224,'克利镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224200,230224,'胜利蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224209,230224,'宁姜蒙古族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224400,230224,'葡萄场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224401,230224,'果树场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224402,230224,'泰来县一苗圃',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224403,230224,'泰来县二苗圃',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224404,230224,'东方红机械林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224480,230224,'六三监狱',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224580,230224,'第一良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224581,230224,'第二良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224582,230224,'宏胜种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230224583,230224,'二龙涛农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225100,230225,'甘南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225101,230225,'兴十四镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225102,230225,'平阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225103,230225,'东阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225104,230225,'巨宝镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225201,230225,'长山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225202,230225,'中兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225203,230225,'兴隆乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225204,230225,'宝山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225206,230225,'查哈阳乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225500,230225,'查哈阳农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230225580,230225,'北京市双河农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227100,230227,'富裕镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227101,230227,'富路镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227102,230227,'富海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227103,230227,'二道湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227104,230227,'龙安桥镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227105,230227,'塔哈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227200,230227,'繁荣乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227201,230227,'绍文乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227202,230227,'忠厚乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230227203,230227,'友谊达斡尔族满族柯尔克孜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229100,230229,'克山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229101,230229,'北兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229102,230229,'西城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229103,230229,'古城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229104,230229,'北联镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229105,230229,'西河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229106,230229,'双河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229200,230229,'河南乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229203,230229,'河北乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229204,230229,'古北乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229205,230229,'西联乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229206,230229,'发展乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229207,230229,'西建乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229208,230229,'向华乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229210,230229,'曙光乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229400,230229,'克山县河北林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229401,230229,'克山县涌泉林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229402,230229,'克山县北联林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229580,230229,'克山县第一良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229581,230229,'克山县第二良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229583,230229,'克山县种猪场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230229584,230229,'克山县种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230100,230230,'克东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230101,230230,'宝泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230102,230230,'乾丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230103,230230,'玉岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230104,230230,'蒲峪路镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230202,230230,'润津乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230204,230230,'昌盛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230400,230230,'第一苗圃',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230401,230230,'第二苗圃',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230402,230230,'爱华林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230403,230230,'发展林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230404,230230,'东兴林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230580,230230,'红旗奶山羊场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230581,230230,'第一良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230582,230230,'第二良种繁殖场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230583,230230,'果树繁殖场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230584,230230,'种猪场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230230585,230230,'黑龙江省社会救助安置中心',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231100,230231,'拜泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231101,230231,'三道镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231102,230231,'兴农镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231103,230231,'长春镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231104,230231,'龙泉镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231105,230231,'国富镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231106,230231,'富强镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231200,230231,'新生乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231201,230231,'兴国乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231203,230231,'上升乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231204,230231,'兴华乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231206,230231,'大众乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231209,230231,'丰产乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231210,230231,'永勤乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231212,230231,'爱农乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230231214,230231,'时中乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281001,230281,'雨亭街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281002,230281,'通江街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281101,230281,'拉哈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281102,230281,'二克浅镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281103,230281,'学田镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281104,230281,'龙河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281105,230281,'讷南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281106,230281,'六合镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281107,230281,'长发镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281108,230281,'通南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281109,230281,'同义镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281110,230281,'九井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281111,230281,'老莱镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281201,230281,'孔国乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281207,230281,'和盛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281208,230281,'同心乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281210,230281,'兴旺鄂温克族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281400,230281,'龙河镇保安林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281401,230281,'龙河镇茂山林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281402,230281,'龙河镇国庆林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281403,230281,'学田镇富源林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281404,230281,'老莱镇宽余林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281405,230281,'新江林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281406,230281,'一良苗圃',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281480,230281,'黑龙江省老莱农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281581,230281,'六合镇黎明奶牛场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281582,230281,'孔国乡进化种猪场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281583,230281,'二克浅镇二里种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281584,230281,'龙河镇青色草原种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281585,230281,'第一良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281586,230281,'第二良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281587,230281,'第三良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230281588,230281,'第四良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302001,230302,'向阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302002,230302,'南山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302003,230302,'立新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302004,230302,'东风街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302005,230302,'红军路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302006,230302,'西鸡西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302007,230302,'西山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302200,230302,'红星乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230302201,230302,'西郊乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303001,230303,'桦木林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303002,230303,'大恒山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303003,230303,'小恒山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303004,230303,'二道河子街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303005,230303,'张新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303006,230303,'奋斗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303007,230303,'柳毛街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303200,230303,'红旗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230303201,230303,'柳毛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230304001,230304,'东兴街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230304002,230304,'矿里街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230304003,230304,'洗煤街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230304004,230304,'大通沟街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230304200,230304,'滴道河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230304201,230304,'兰岭乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230305001,230305,'街里街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230305002,230305,'穆棱街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230305003,230305,'平岗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230305101,230305,'梨树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230306001,230306,'城子河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230306002,230306,'正阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230306003,230306,'东海街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230306004,230306,'城西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230306005,230306,'杏花街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230306200,230306,'长青乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230306201,230306,'永丰乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230307001,230307,'麻山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230307101,230307,'麻山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321100,230321,'鸡东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321101,230321,'平阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321102,230321,'向阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321103,230321,'哈达镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321104,230321,'永安镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321105,230321,'永和镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321106,230321,'东海镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321107,230321,'兴农镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321200,230321,'鸡林乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321205,230321,'明德乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321206,230321,'下亮子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321400,230321,'林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230321500,230321,'八五一零农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381100,230381,'虎林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381101,230381,'东方红镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381102,230381,'迎春镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381103,230381,'虎头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381104,230381,'杨岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381105,230381,'东诚镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381106,230381,'宝东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381203,230381,'新乐乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381204,230381,'伟光乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381206,230381,'珍宝岛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381207,230381,'阿北乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381400,230381,'东方红林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381401,230381,'迎春林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381500,230381,'八五〇农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381501,230381,'八五四农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381502,230381,'八五六农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381503,230381,'八五八农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381504,230381,'庆丰农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230381505,230381,'云山农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382001,230382,'中心街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382100,230382,'密山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382101,230382,'连珠山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382102,230382,'当壁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382103,230382,'知一镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382104,230382,'黑台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382105,230382,'兴凯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382106,230382,'裴德镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382107,230382,'白鱼湾镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382200,230382,'柳毛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382201,230382,'杨木乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382202,230382,'兴凯湖乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382203,230382,'承紫河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382206,230382,'二人班乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382208,230382,'太平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382210,230382,'和平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382212,230382,'富源乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382400,230382,'林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382480,230382,'青年水库',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382481,230382,'煤炭工业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382482,230382,'经济开发区管理委员会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382501,230382,'牡丹江管理局局直',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382502,230382,'八五五农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382503,230382,'八五七农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382504,230382,'八五一一农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382505,230382,'兴凯湖农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382506,230382,'牡丹江管理局北大营管委会',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382507,230382,'牡丹江管理局双峰农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382580,230382,'水产养殖有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382581,230382,'种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382582,230382,'水田良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382583,230382,'市良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382584,230382,'校办企业公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230382585,230382,'蜂蜜山粮库有限公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230402001,230402,'北山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230402002,230402,'红军街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230402003,230402,'光明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230402004,230402,'胜利街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230402005,230402,'南翼街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230403001,230403,'育才街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230403002,230403,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230403003,230403,'新南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230403004,230403,'湖滨街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230403005,230403,'解放街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230403006,230403,'团结街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230404001,230404,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230404002,230404,'铁东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230404003,230404,'六号街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230404004,230404,'大陆街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230404005,230404,'富力街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230404006,230404,'麓林山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230405001,230405,'兴安路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230405002,230405,'兴建路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230405003,230405,'兴长路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230405004,230405,'峻德路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230405005,230405,'河东路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230405006,230405,'光宇街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230405100,230405,'红旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406001,230406,'工人村办街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406002,230406,'新一办街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406004,230406,'东山办街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406005,230406,'鹤兴办街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406100,230406,'新华镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406201,230406,'蔬园乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406202,230406,'东方红乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406400,230406,'鹤岗市林业局生活区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230406501,230406,'新华农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230407001,230407,'岭北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230407002,230407,'岭南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230407003,230407,'沟北街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230407004,230407,'沟南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421100,230421,'凤翔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421101,230421,'鹤北镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421102,230421,'名山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421103,230421,'团结镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421104,230421,'肇兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421105,230421,'云山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421200,230421,'东明朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421203,230421,'太平沟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421400,230421,'萝北县林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421401,230421,'鹤北林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421500,230421,'宝泉岭管理局局直',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421501,230421,'江滨农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421502,230421,'军川农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421503,230421,'名山农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421504,230421,'延军农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421505,230421,'共青农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421506,230421,'宝泉岭农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230421580,230421,'萝北县农业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422100,230422,'绥滨镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422101,230422,'绥东镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422102,230422,'忠仁镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422200,230422,'连生乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422201,230422,'北岗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422202,230422,'富强乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422203,230422,'北山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422204,230422,'福兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422205,230422,'新富乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422400,230422,'绥滨西林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422401,230422,'国营中兴边防林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422480,230422,'忠仁镇良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422481,230422,'绥东镇种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422500,230422,'二九〇农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422501,230422,'绥滨农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230422503,230422,'普阳农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230502001,230502,'二马路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230502002,230502,'八马路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230502003,230502,'中心站街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230502004,230502,'富安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230502006,230502,'长安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230502007,230502,'铁西街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230502008,230502,'学府街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230502200,230502,'安邦乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503001,230503,'中山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503002,230503,'北山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503003,230503,'南山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503004,230503,'东山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503005,230503,'中心街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503006,230503,'西山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503200,230503,'长胜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503400,230503,'岭东区青山旅游公司',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230503401,230503,'岭东区岭东经营所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230505001,230505,'振兴中路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230505002,230505,'振兴东路街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230505004,230505,'集贤街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230505005,230505,'东荣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230505101,230505,'太保镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506001,230506,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506002,230506,'跃进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506003,230506,'东保卫街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506004,230506,'七星街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506005,230506,'双阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506006,230506,'新安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506007,230506,'电厂街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506008,230506,'农场街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506101,230506,'七星镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506401,230506,'双鸭山林业局宝山经营所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230506402,230506,'双鸭山林业局大叶沟林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521100,230521,'福利镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521101,230521,'集贤镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521102,230521,'升昌镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521103,230521,'丰乐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521104,230521,'太平镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521201,230521,'腰屯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521202,230521,'兴安乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521204,230521,'永安乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521401,230521,'太平林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521402,230521,'丰乐林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521403,230521,'七星林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521404,230521,'峻山林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521405,230521,'爱林林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521406,230521,'腰屯林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521407,230521,'升平煤矿',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521480,230521,'黑龙江省双鸭山监狱',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521500,230521,'二九一农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521581,230521,'良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521582,230521,'种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230521583,230521,'果树示范场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522100,230522,'友谊镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522101,230522,'兴隆镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522102,230522,'龙山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522103,230522,'凤岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522200,230522,'兴盛乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522201,230522,'东建乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522202,230522,'庆丰乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522203,230522,'建设乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522204,230522,'友邻乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522205,230522,'新镇乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522206,230522,'成富朝鲜族满族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522501,230522,'红兴隆管理局局直',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230522502,230522,'友谊农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523100,230523,'宝清镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523101,230523,'七星泡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523102,230523,'青原镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523103,230523,'夹信子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523104,230523,'龙头镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523105,230523,'小城子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523106,230523,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523203,230523,'万金山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523204,230523,'尖山子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523209,230523,'七星河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523400,230523,'双鸭山林业局上游经营所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523401,230523,'双鸭山林业局南瓮泉经营所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523402,230523,'双鸭山林业局七一林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523403,230523,'双鸭山林业局七星河林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523404,230523,'双鸭山林业局红旗林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523405,230523,'双鸭山林业局三岔河林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523406,230523,'双鸭山林业局青龙林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523407,230523,'双鸭山林业局宝石经营所',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523408,230523,'双鸭山林业局七星河金矿',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523409,230523,'桦南林业局岚峰林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523500,230523,'五九七农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523501,230523,'八五二农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230523502,230523,'八五三农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524100,230524,'饶河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524101,230524,'小佳河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524102,230524,'西丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524103,230524,'五林洞镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524200,230524,'西林子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524201,230524,'四排乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524203,230524,'大佳河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524204,230524,'山里乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524207,230524,'大通河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524400,230524,'小佳河林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524401,230524,'威山林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524402,230524,'西丰林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524403,230524,'大牙克林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524404,230524,'石场林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524405,230524,'宝马山林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524406,230524,'大岱林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524407,230524,'永幸林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524408,230524,'奇源林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524409,230524,'芦源林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524410,230524,'五林洞林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524500,230524,'饶河农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524501,230524,'红旗岭农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524502,230524,'八五九农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524503,230524,'胜利农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230524504,230524,'红卫农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602013,230602,'萨尔图街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602014,230602,'会战街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602015,230602,'友谊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602016,230602,'东安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602017,230602,'东风街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602018,230602,'铁人街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602019,230602,'火炬街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602020,230602,'拥军街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602021,230602,'万宝街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602022,230602,'格林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230602023,230602,'绿园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230603011,230603,'兴化街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230603012,230603,'卧里屯街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230603013,230603,'东光街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230603014,230603,'龙凤街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230603015,230603,'三永街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230603016,230603,'龙政街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230603017,230603,'湿地街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230603100,230603,'龙凤镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604001,230604,'龙岗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604002,230604,'银浪街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604004,230604,'奋斗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604005,230604,'庆新街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604007,230604,'西宾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604009,230604,'乘风街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604010,230604,'旭园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604011,230604,'北湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604012,230604,'怡园街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604013,230604,'东湖街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604014,230604,'创业城街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230604101,230604,'喇嘛甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230605008,230605,'杏南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230605009,230605,'创业街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230605010,230605,'红岗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230605011,230605,'八百垧街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230605012,230605,'银河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230605013,230605,'解放街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230605100,230605,'杏树岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230605480,230605,'黑龙江红岗经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606007,230606,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606008,230606,'庆葡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606009,230606,'新华街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606010,230606,'高平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606011,230606,'林源街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606012,230606,'和苑街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606013,230606,'同福街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606100,230606,'大同镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606101,230606,'高台子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606102,230606,'太阳升镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606103,230606,'林源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606200,230606,'祝三乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606203,230606,'老山头乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606205,230606,'八井子乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230606206,230606,'双榆树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621100,230621,'肇州镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621101,230621,'永乐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621102,230621,'丰乐镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621103,230621,'朝阳沟镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621104,230621,'兴城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621105,230621,'二井镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621202,230621,'双发乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621203,230621,'托古乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621205,230621,'朝阳乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621206,230621,'永胜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621208,230621,'榆树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621211,230621,'新福乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621580,230621,'乐园良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230621581,230621,'卫星种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622100,230622,'肇源镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622101,230622,'三站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622102,230622,'二站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622103,230622,'茂兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622104,230622,'古龙镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622105,230622,'新站镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622106,230622,'头台镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622107,230622,'古恰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622200,230622,'福兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622201,230622,'薄荷台乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622203,230622,'和平乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622207,230622,'超等乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622208,230622,'民意乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622210,230622,'义顺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622211,230622,'浩德乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622212,230622,'大兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622500,230622,'肇源农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622581,230622,'种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622583,230622,'新立良种繁育场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622584,230622,'立陡山良种场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622586,230622,'果树示范场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622587,230622,'经济作物示范场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230622588,230622,'茂兴湖水产养殖场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623100,230623,'林甸镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623101,230623,'红旗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623102,230623,'花园镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623103,230623,'四季青镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623104,230623,'鹤鸣湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623200,230623,'东兴乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623201,230623,'宏伟乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623204,230623,'四合乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623400,230623,'林甸县长青林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623500,230623,'巨浪牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623580,230623,'国营苇场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230623581,230623,'新兴畜牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624100,230624,'杜尔伯特镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624101,230624,'胡吉吐莫镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624102,230624,'烟筒屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624103,230624,'他拉哈镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624104,230624,'连环湖镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624200,230624,'一心乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624201,230624,'克尔台乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624203,230624,'敖林西伯乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624204,230624,'巴彦查干乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624205,230624,'腰新乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624206,230624,'江湾乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624500,230624,'绿色草原牧场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230624501,230624,'大山种羊场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230671010,230671,'开发区黎明街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230671580,230671,'高新区农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230717001,230717,'朝阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230717002,230717,'前进街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230717003,230717,'红升街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230717004,230717,'旭日街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230717005,230717,'新欣街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230717006,230717,'南郡街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230717100,230717,'东升镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230717101,230717,'美溪镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230718001,230718,'乌马河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230718002,230718,'锦山街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230718003,230718,'曙光街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230718004,230718,'向阳街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230719001,230719,'双子河街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230719002,230719,'铁林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230719003,230719,'友好街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230719100,230719,'上甘岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722100,230722,'朝阳镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722101,230722,'乌云镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722102,230722,'乌拉嘎镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722103,230722,'保兴镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722200,230722,'常胜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722201,230722,'向阳乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722202,230722,'沪嘉乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722203,230722,'红光乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722205,230722,'青山乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722400,230722,'太平林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722402,230722,'清河林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230722404,230722,'马连林场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230723100,230723,'乌伊岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230723101,230723,'汤旺河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230724100,230724,'新青镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230724101,230724,'红星镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230724102,230724,'五营镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230725100,230725,'带岭镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230725101,230725,'朗乡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230726100,230726,'南岔镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230726101,230726,'晨明镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230726102,230726,'浩良河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230726200,230726,'迎春乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230751100,230751,'西林镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230751101,230751,'金山屯镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781100,230781,'铁力镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781101,230781,'双丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781102,230781,'桃山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781105,230781,'神树镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781106,230781,'日月峡镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781200,230781,'年丰朝鲜族乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781201,230781,'工农乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781202,230781,'王杨乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781400,230781,'铁力林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781401,230781,'双丰林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230781402,230781,'桃山林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230803007,230803,'西林街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230803008,230803,'建设街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230803009,230803,'长安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230803010,230803,'学府街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230803011,230803,'桥南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230803198,230803,'向阳区直辖村级区划',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230804007,230804,'永安街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230804008,230804,'港湾街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230804009,230804,'和平街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230804010,230804,'山水街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230804579,230804,'前进区农垦',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230805007,230805,'晓云街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230805008,230805,'佳东街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230805009,230805,'建国街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230805010,230805,'佳南街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230805100,230805,'建国镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230805200,230805,'松江乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811008,230811,'云环街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811009,230811,'英俊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811010,230811,'红旗街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811011,230811,'友谊街道',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811101,230811,'大来镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811102,230811,'敖其镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811103,230811,'望江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811104,230811,'长发镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811105,230811,'莲江口镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811106,230811,'西格木镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811107,230811,'沿江镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811108,230811,'四丰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811200,230811,'长青乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811208,230811,'平安乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811211,230811,'群胜乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811480,230811,'莲江口监狱',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230811579,230811,'郊区农垦',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822103,230822,'驼腰子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822104,230822,'石头河子镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822106,230822,'桦南镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822107,230822,'土龙山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822108,230822,'孟家岗镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822109,230822,'闫家镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822110,230822,'柳毛河镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822205,230822,'金沙乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822213,230822,'梨树乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822214,230822,'明义乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822215,230822,'大八浪乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822216,230822,'五道岗乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822400,230822,'桦南林业局',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822480,230822,'黑龙江桦南经济开发区',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822500,230822,'曙光农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230822580,230822,'桦南种畜场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826101,230826,'横头山镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826103,230826,'苏家店镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826104,230826,'悦来镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826105,230826,'新城镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826106,230826,'四马架镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826201,230826,'东河乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826202,230826,'梨丰乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826205,230826,'创业乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826207,230826,'星火乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826500,230826,'江川农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230826501,230826,'宝山农场',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230828101,230828,'香兰镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230828102,230828,'鹤立镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230828103,230828,'竹帘镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230828104,230828,'汤原镇',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230828201,230828,'汤旺乡',4,'2022-11-09 10:39:25','2022-11-09 11:10:46'),
	(230828203,230828,'胜利乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230828208,230828,'吉祥乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230828209,230828,'振兴乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230828210,230828,'太平川乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230828211,230828,'永发乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230828400,230828,'鹤立林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230828480,230828,'香兰监狱',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230828500,230828,'汤原农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230828501,230828,'梧桐河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881001,230881,'繁荣街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881002,230881,'兴华街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881100,230881,'同江镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881101,230881,'乐业镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881102,230881,'三村镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881103,230881,'临江镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881104,230881,'向阳镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881105,230881,'青河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881204,230881,'街津口乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881205,230881,'八岔乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881206,230881,'金川乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881207,230881,'银川乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881400,230881,'街津口林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881401,230881,'鸭北林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881500,230881,'勤得利农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881501,230881,'青龙山农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881502,230881,'前进农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881503,230881,'洪河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881504,230881,'鸭绿河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881505,230881,'浓江农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881580,230881,'良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881581,230881,'畜牧场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230881582,230881,'知青农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882001,230882,'城东街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882003,230882,'城西街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882102,230882,'富锦镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882103,230882,'长安镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882106,230882,'砚山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882107,230882,'头林镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882108,230882,'兴隆岗镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882109,230882,'宏胜镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882110,230882,'向阳川镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882111,230882,'二龙山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882112,230882,'上街基镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882113,230882,'锦山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882114,230882,'大榆树镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882400,230882,'石砬山林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882401,230882,'东风岗林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882402,230882,'太东林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882403,230882,'工农林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882404,230882,'富锦市国营原种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882405,230882,'富锦市国营果树示范场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882406,230882,'富锦市科研所',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882407,230882,'工业园区',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882500,230882,'建三江管理局局直',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882501,230882,'七星农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882502,230882,'大兴农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882503,230882,'创业农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882580,230882,'种猪场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230882581,230882,'种畜场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883100,230883,'抚远镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883101,230883,'寒葱沟镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883102,230883,'浓桥镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883103,230883,'乌苏镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883104,230883,'黑瞎子岛镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883105,230883,'通江镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883106,230883,'海青镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883201,230883,'浓江乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883203,230883,'别拉洪乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883204,230883,'鸭南乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883500,230883,'前哨农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883501,230883,'前锋农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230883502,230883,'二道河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902031,230902,'兴安街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902032,230902,'兴富街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902033,230902,'兴和街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902034,230902,'兴盛街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902035,230902,'欣源街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902036,230902,'北山街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902037,230902,'兴华街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902038,230902,'金沙街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902100,230902,'红旗镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902200,230902,'长兴乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902400,230902,'七台河经济开发区管理委员会',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230902480,230902,'金沙农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230903011,230903,'桃东街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230903012,230903,'桃南街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230903013,230903,'桃西街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230903014,230903,'桃北街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230903015,230903,'桃源街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230903016,230903,'桃山街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230903100,230903,'万宝河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904001,230904,'东风街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904003,230904,'富强街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904005,230904,'龙湖街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904006,230904,'东胜街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904007,230904,'湖东街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904008,230904,'通达街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904100,230904,'茄子河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904101,230904,'宏伟镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904200,230904,'铁山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904201,230904,'中心河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904500,230904,'北兴农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230904579,230904,'黑龙江红兴隆农垦宝利采金',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921001,230921,'新起街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921002,230921,'新华街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921003,230921,'元明街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921004,230921,'铁西街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921005,230921,'城西街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921100,230921,'勃利镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921101,230921,'小五站镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921102,230921,'大四站镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921103,230921,'双河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921104,230921,'倭肯镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921200,230921,'青山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921202,230921,'永恒乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921203,230921,'抢垦乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921204,230921,'杏树朝鲜族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(230921205,230921,'吉兴朝鲜族满族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231002001,231002,'新安街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231002002,231002,'长安街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231002003,231002,'七星街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231002004,231002,'五星街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231002008,231002,'东兴街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231002009,231002,'振兴街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231002101,231002,'兴隆镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231003001,231003,'阳明街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231003002,231003,'前进街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231003003,231003,'新兴街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231003004,231003,'桦林橡胶厂街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231003100,231003,'铁岭镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231003101,231003,'桦林镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231003102,231003,'磨刀石镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231003103,231003,'五林镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231004001,231004,'向阳街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231004002,231004,'黄花街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231004003,231004,'铁北街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231004004,231004,'新华街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231004005,231004,'大庆街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231004006,231004,'兴平街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231004007,231004,'北山街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231004100,231004,'三道关镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231005001,231005,'先锋街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231005002,231005,'火炬街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231005003,231005,'立新街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231005004,231005,'牡丹街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231005005,231005,'江滨街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231005006,231005,'沿江街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231005100,231005,'温春镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231005201,231005,'海南朝鲜族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025100,231025,'林口镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025101,231025,'古城镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025102,231025,'刁翎镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025104,231025,'朱家镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025105,231025,'柳树镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025106,231025,'三道通镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025107,231025,'龙爪镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025108,231025,'莲花镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025110,231025,'青山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025111,231025,'建堂镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025112,231025,'奎山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231025400,231025,'林口林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231071002,231071,'牡丹江经开区城乡街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231081100,231081,'绥芬河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231081101,231081,'阜宁镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083100,231083,'海林镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083101,231083,'长汀镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083102,231083,'横道镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083103,231083,'山市镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083104,231083,'柴河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083105,231083,'二道镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083106,231083,'新安朝鲜族镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083107,231083,'三道镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083400,231083,'牡林工程公司街道办事处',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083401,231083,'柴河林机厂街道办事处',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083402,231083,'大海林林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083403,231083,'海林林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083404,231083,'柴河林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083500,231083,'海林农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231083501,231083,'山市种奶牛场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084001,231084,'城区街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084100,231084,'宁安镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084101,231084,'东京城镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084102,231084,'渤海镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084103,231084,'石岩镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084104,231084,'沙兰镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084105,231084,'海浪镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084106,231084,'兰岗镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084107,231084,'镜泊镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084202,231084,'江南朝鲜族满族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084206,231084,'卧龙朝鲜族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084208,231084,'马河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084211,231084,'三陵乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084400,231084,'东京城林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231084500,231084,'宁安农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085100,231085,'八面通镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085101,231085,'穆棱镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085102,231085,'下城子镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085103,231085,'马桥河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085104,231085,'兴源镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085105,231085,'河西镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085200,231085,'福录乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085202,231085,'共和乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085400,231085,'八面通林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231085401,231085,'穆棱林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231086100,231086,'东宁镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231086101,231086,'三岔口镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231086102,231086,'大肚川镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231086103,231086,'老黑山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231086104,231086,'道河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231086105,231086,'绥阳镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231086400,231086,'绥阳林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102001,231102,'花园街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102002,231102,'兴安街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102003,231102,'海兰街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102004,231102,'西兴街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102101,231102,'西岗子镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102102,231102,'瑷珲镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102103,231102,'罕达汽镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102104,231102,'上马厂镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102200,231102,'幸福乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102201,231102,'四嘉子乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102202,231102,'坤河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102204,231102,'张地营子乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102205,231102,'西峰山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102206,231102,'新生乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102207,231102,'二站乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102407,231102,'大平林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102408,231102,'七二七林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102409,231102,'望峰林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102410,231102,'卡伦山林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102411,231102,'胜山林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102412,231102,'二站林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102413,231102,'三站林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102414,231102,'大岭林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102415,231102,'桦皮窑林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102416,231102,'滨南林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102417,231102,'江防林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102418,231102,'河南屯林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102421,231102,'西岗子试验林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102425,231102,'大新屯储木场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102480,231102,'宋集屯煤矿',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102481,231102,'西岗子煤矿',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102482,231102,'东方红煤矿',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102500,231102,'锦河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102501,231102,'红色边疆农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102580,231102,'奶牛场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102581,231102,'种畜场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102582,231102,'第二良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231102583,231102,'第一良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123100,231123,'奇克镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123101,231123,'逊河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123103,231123,'克林镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123201,231123,'干岔子乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123202,231123,'松树沟乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123203,231123,'车陆乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123204,231123,'新鄂乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123205,231123,'新兴乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123207,231123,'宝山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123402,231123,'道干林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123403,231123,'干岔子林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123404,231123,'新立林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123405,231123,'三间房林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123406,231123,'良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123407,231123,'种畜场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231123500,231123,'逊克农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124100,231124,'孙吴镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124101,231124,'辰清镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124201,231124,'西兴乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124202,231124,'沿江满族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124203,231124,'腰屯乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124204,231124,'卧牛河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124205,231124,'群山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124206,231124,'奋斗乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124207,231124,'红旗乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124208,231124,'正阳山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124210,231124,'清溪乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124402,231124,'前进林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124403,231124,'大河口林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124404,231124,'正阳林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124405,231124,'平山林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124406,231124,'沿江林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124407,231124,'辰清林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124408,231124,'红旗林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124409,231124,'向阳林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124410,231124,'良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231124411,231124,'种畜场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181001,231181,'兆麟街道地区',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181002,231181,'和平街道地区',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181003,231181,'北岗街道地区',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181004,231181,'庆华街道地区',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181005,231181,'铁西街道地区',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181006,231181,'铁南街道地区',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181101,231181,'通北镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181102,231181,'赵光镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181103,231181,'海星镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181104,231181,'石泉镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181105,231181,'二井镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181200,231181,'城郊乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181201,231181,'东胜乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181203,231181,'杨家乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181207,231181,'主星乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181400,231181,'通北林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181500,231181,'北安管理局局直',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181501,231181,'长水河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181502,231181,'赵光农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181503,231181,'红星农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231181504,231181,'建设农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182001,231182,'青山街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182101,231182,'龙镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182102,231182,'和平镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182103,231182,'五大连池镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182104,231182,'双泉镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182105,231182,'新发镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182106,231182,'团结镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182107,231182,'兴隆镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182108,231182,'朝阳山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182203,231182,'建设乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182205,231182,'太平乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182208,231182,'兴安乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182406,231182,'元青山林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182407,231182,'三九六林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182408,231182,'小兴安林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182409,231182,'二龙山林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182410,231182,'朝阳林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182411,231182,'引龙河林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182412,231182,'焦得布林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182414,231182,'小孤山林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182415,231182,'药泉林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182417,231182,'沾河林业局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182418,231182,'莲花管理委员会',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182427,231182,'二龙山蚕种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182429,231182,'畜牧场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182430,231182,'第二良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182480,231182,'花园劳教所',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182481,231182,'永丰监狱',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182482,231182,'华山监狱',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182483,231182,'凤凰山监狱',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182501,231182,'龙门农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182502,231182,'襄河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182503,231182,'龙镇农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182504,231182,'二龙山农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182505,231182,'引龙河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182506,231182,'尾山农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182507,231182,'格球山农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231182508,231182,'五大连池农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183100,231183,'嫩江镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183101,231183,'伊拉哈镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183102,231183,'双山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183103,231183,'多宝山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183104,231183,'海江镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183105,231183,'前进镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183106,231183,'长福镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183107,231183,'科洛镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183108,231183,'霍龙门镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183202,231183,'临江乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183206,231183,'联兴乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183207,231183,'白云乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183208,231183,'塔溪乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183211,231183,'长江乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183400,231183,'多宝山铜矿',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183500,231183,'九三管理局局直',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183501,231183,'鹤山农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183502,231183,'大西江农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183503,231183,'尖山农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183504,231183,'荣军农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183506,231183,'七星泡农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183507,231183,'嫩江农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183508,231183,'山河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183509,231183,'嫩北农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183510,231183,'建边农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231183581,231183,'马铃薯原种繁殖场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202001,231202,'紫来街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202002,231202,'爱路街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202003,231202,'大有街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202004,231202,'吉泰街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202005,231202,'东兴街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202006,231202,'北林街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202007,231202,'朝旭街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202008,231202,'春雷街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202009,231202,'北辰街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202010,231202,'康庄街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202011,231202,'先锋街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202012,231202,'东城街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202101,231202,'宝山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202102,231202,'绥胜满族镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202103,231202,'西长发镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202104,231202,'永安满族镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202105,231202,'太平川镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202106,231202,'秦家镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202107,231202,'双河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202108,231202,'三河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202109,231202,'四方台镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202110,231202,'津河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202111,231202,'张维镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202113,231202,'东津镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202114,231202,'东富镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202115,231202,'兴福镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202116,231202,'三井镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202201,231202,'红旗满族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202202,231202,'连岗乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202203,231202,'新华乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202212,231202,'五营乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202213,231202,'兴和朝鲜族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231202579,231202,'绥化局直',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221001,231221,'东风街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221002,231221,'前进街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221003,231221,'东胜街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221004,231221,'兴安街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221100,231221,'望奎镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221101,231221,'通江镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221102,231221,'卫星镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221103,231221,'海丰镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221104,231221,'莲花镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221105,231221,'惠七满族镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221106,231221,'先锋镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221107,231221,'火箭镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221108,231221,'东郊镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221109,231221,'灯塔镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221202,231221,'灵山满族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221203,231221,'后三乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221209,231221,'东升乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221210,231221,'恭六乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221211,231221,'厢白满族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221400,231221,'白四林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221580,231221,'种畜场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221581,231221,'第一良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231221582,231221,'第二良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222001,231222,'颜河街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222002,231222,'顺达街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222003,231222,'兰亚街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222004,231222,'正阳街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222101,231222,'兰西镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222102,231222,'榆林镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222103,231222,'临江镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222104,231222,'平山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222105,231222,'红光镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222106,231222,'远大镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222107,231222,'康荣镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222108,231222,'燎原镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222109,231222,'奋斗镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222202,231222,'北安乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222203,231222,'长江乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222204,231222,'兰河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222205,231222,'红星乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222207,231222,'长岗乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222210,231222,'星火乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222580,231222,'第一原种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222581,231222,'第二原种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231222582,231222,'兰西县畜牧技术推广服务中心',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223001,231223,'北城街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223002,231223,'西城街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223003,231223,'靖城街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223004,231223,'东城街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223100,231223,'青冈镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223101,231223,'中和镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223102,231223,'祯祥镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223103,231223,'兴华镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223104,231223,'永丰镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223105,231223,'芦河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223106,231223,'民政镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223107,231223,'柞岗镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223108,231223,'劳动镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223109,231223,'迎春镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223110,231223,'德胜镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223111,231223,'昌盛镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223202,231223,'建设乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223203,231223,'新村乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223212,231223,'连丰乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223400,231223,'青冈县林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223401,231223,'青冈县互利营林站',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223402,231223,'青冈县果树场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223580,231223,'青冈县种马场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223581,231223,'青冈县种羊场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231223582,231223,'青冈县原种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224001,231224,'吉康街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224002,231224,'庆瑞街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224003,231224,'平顺街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224004,231224,'安泰街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224101,231224,'庆安镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224102,231224,'民乐镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224103,231224,'大罗镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224104,231224,'平安镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224105,231224,'勤劳镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224106,231224,'久胜镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224107,231224,'同乐镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224108,231224,'柳河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224201,231224,'建民乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224202,231224,'巨宝山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224206,231224,'丰收乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224208,231224,'发展乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224210,231224,'致富乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224211,231224,'欢胜乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224400,231224,'国有林场管理局',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231224500,231224,'柳河农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225001,231225,'明阳街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225002,231225,'明源街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225003,231225,'明新街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225004,231225,'明泉街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225100,231225,'明水镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225101,231225,'兴仁镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225102,231225,'永兴镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225103,231225,'崇德镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225104,231225,'通达镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225106,231225,'双兴镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225203,231225,'永久乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225204,231225,'树人乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225205,231225,'光荣乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225206,231225,'繁荣乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225207,231225,'通泉乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225208,231225,'育林乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225400,231225,'国营林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225580,231225,'县联社马场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225581,231225,'明水种畜场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225582,231225,'育林畜牧场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225583,231225,'国营第一良种',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225584,231225,'国营第二良种',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231225585,231225,'国营第三良种',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226001,231226,'车站街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226002,231226,'建设街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226003,231226,'西北街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226004,231226,'东南街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226100,231226,'绥棱镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226101,231226,'上集镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226102,231226,'四海店镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226103,231226,'双岔河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226104,231226,'阁山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226105,231226,'长山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226200,231226,'靠山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226201,231226,'后头乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226205,231226,'克音河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226206,231226,'绥中乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226207,231226,'泥尔河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226400,231226,'绥棱县国有林场阁山林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226401,231226,'绥棱县国有林场四海店林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226402,231226,'绥棱县国有林场三吉台林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226403,231226,'绥棱县国有林场半截河林场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226404,231226,'黑龙江省绥棱林业局有限公司',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226500,231226,'黑龙江北大荒农垦集团绥棱农场有限公司',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226580,231226,'种马场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226581,231226,'良种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231226582,231226,'绥棱县猪场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281001,231281,'铁西街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281002,231281,'新兴街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281003,231281,'安虹街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281004,231281,'东城街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281100,231281,'安达镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281101,231281,'任民镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281103,231281,'万宝山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281104,231281,'昌德镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281105,231281,'升平镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281106,231281,'羊草镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281107,231281,'老虎岗镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281108,231281,'中本镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281109,231281,'太平庄镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281110,231281,'吉兴岗镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281111,231281,'卧里屯镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281112,231281,'火石山镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281113,231281,'古大湖镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281209,231281,'先源乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281500,231281,'安达畜牧场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281581,231281,'原种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281583,231281,'红旗泡水库管理所',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231281584,231281,'东湖水库管理站',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282001,231282,'朝阳区街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282002,231282,'东升区街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282003,231282,'西园区街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282004,231282,'正阳区街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282100,231282,'肇东镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282101,231282,'昌五镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282102,231282,'宋站镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282103,231282,'五站镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282104,231282,'尚家镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282105,231282,'姜家镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282106,231282,'里木店镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282107,231282,'四站镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282108,231282,'涝洲镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282109,231282,'五里明镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282110,231282,'黎明镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282111,231282,'西八里镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282112,231282,'海城镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282201,231282,'太平乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282204,231282,'向阳乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282205,231282,'洪河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282206,231282,'跃进乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282212,231282,'德昌乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282213,231282,'宣化乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282214,231282,'安民乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282215,231282,'明久乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282500,231282,'四方山农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231282501,231282,'涝洲鱼种场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283100,231283,'海伦镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283101,231283,'海北镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283102,231283,'伦河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283103,231283,'共合镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283104,231283,'海兴镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283105,231283,'祥富镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283106,231283,'东风镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283107,231283,'百祥镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283108,231283,'向荣镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283109,231283,'永富镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283110,231283,'长发镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283111,231283,'联发镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283112,231283,'前进镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283113,231283,'共荣镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283114,231283,'东林镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283115,231283,'永和镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283208,231283,'海南乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283210,231283,'乐业乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283211,231283,'福民乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283212,231283,'丰山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283218,231283,'爱民乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283220,231283,'扎音河乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283221,231283,'双录乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283400,231283,'海伦市森林资源保护中心',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283401,231283,'东方红水库地区',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283500,231283,'海伦农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283501,231283,'红光农场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283581,231283,'海伦市董家农作物种植场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(231283582,231283,'海伦市东方农牧场',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232701100,232701,'西林吉镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232701101,232701,'图强镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232701102,232701,'阿木尔镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232701103,232701,'兴安镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232701104,232701,'北极镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232701105,232701,'古莲镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232721100,232721,'呼玛镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232721101,232721,'韩家园镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232721200,232721,'三卡乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232721201,232721,'金山乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232721202,232721,'兴华乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232721203,232721,'鸥浦乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232721204,232721,'白银纳鄂伦春族民族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232721205,232721,'北疆乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232722100,232722,'塔河镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232722101,232722,'瓦拉干镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232722102,232722,'盘古镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232722103,232722,'古驿镇',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232722200,232722,'十八站鄂伦春族乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232722201,232722,'依西肯乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232722202,232722,'开库康乡',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232761001,232761,'东山街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232761002,232761,'卫东街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232761003,232761,'红旗街道',4,'2022-11-09 10:39:26','2022-11-09 11:10:46'),
	(232761004,232761,'长虹街道',4,'2022-11