/*
Navicat MySQL Data Transfer

Source Server         : hw_test_v5_qiye_20231225
Source Server Version : 50741
Source Host           : 49.4.21.141:45611
Source Database       : crmeb

Target Server Type    : MYSQL
Target Server Version : 50741
File Encoding         : 65001

Date: 2025-08-26 10:19:07
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for eb_virtual_order
-- ----------------------------
DROP TABLE IF EXISTS `eb_virtual_order`;
CREATE TABLE `eb_virtual_order` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
    `virtual_order_no` varchar(255) DEFAULT NULL COMMENT '虚拟订单号',
    `mer_id` int(11) unsigned NOT NULL COMMENT '商户ID',
    `uid` int(11) unsigned NOT NULL COMMENT '用户id',
    `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
    `product_name` varchar(128) NOT NULL COMMENT '商品名称',
    `attr_value_id` int(11) NOT NULL COMMENT '商品规格值 ID',
    `sku` varchar(128) NOT NULL COMMENT '商品sku',
    `price` decimal(8,2) NOT NULL COMMENT '商品单价',
    `pay_num` int(11) NOT NULL DEFAULT '0' COMMENT '购买数量',
    `total_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '订单总额',
    `deal_num` int(11) NOT NULL DEFAULT '0' COMMENT '成交数量',
    `refund_num` int(11) NOT NULL DEFAULT '0' COMMENT '退款数量',
    `create_order_request` text COMMENT '订单创建请求源数据jsonstring',
    `pre_order_info_vo` text COMMENT '订单预处理源数据jsonstring',
    `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '订单状态（0：待支付，1：待发货,6：已完成）',
    `source_id` varchar(255) DEFAULT NULL COMMENT '源头业务编号,目前有考培的sourceId和风评的sourceId',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `virtual_order_no` (`virtual_order_no`) USING BTREE,
    KEY `mer_id` (`mer_id`) USING BTREE,
    KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='虚拟订单表';

-- ----------------------------
-- Table structure for eb_virtual_order_operate
-- ----------------------------
DROP TABLE IF EXISTS `eb_virtual_order_operate`;
CREATE TABLE `eb_virtual_order_operate` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
    `operate_no` varchar(255) DEFAULT NULL COMMENT '操作单号',
    `virtual_order_no` varchar(255) DEFAULT NULL COMMENT '虚拟订单号',
    `mer_id` int(11) unsigned NOT NULL COMMENT '商户ID',
    `uid` int(11) unsigned NOT NULL COMMENT '用户id',
    `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
    `product_name` varchar(128) NOT NULL COMMENT '商品名称',
    `attr_value_id` int(11) NOT NULL COMMENT '商品规格值 ID',
    `sku` varchar(128) NOT NULL COMMENT '商品sku',
    `price` decimal(8,2) NOT NULL COMMENT '商品单价',
    `operate_num` int(11) NOT NULL DEFAULT '0' COMMENT '操作数量',
    `total_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '操作总额',
    `operate_type` varchar(20) NOT NULL COMMENT '操作类型:退款 refund，成交 deal',
    `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `operate_no` (`operate_no`) USING BTREE,
    KEY `virtual_order_no` (`virtual_order_no`) USING BTREE,
    KEY `mer_id` (`mer_id`) USING BTREE,
    KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='虚拟订单操作表';

-- ----------------------------
-- Table structure for eb_huifu_wallet_trade_recon
-- ----------------------------
DROP TABLE IF EXISTS `eb_huifu_wallet_trade_recon`;
CREATE TABLE `eb_huifu_wallet_trade_recon` (
    `isv_org_id` varchar(255) DEFAULT NULL COMMENT '平台号',
    `order_no` varchar(255) DEFAULT NULL COMMENT '订单号',
    `trade_no` varchar(255) NOT NULL COMMENT '交易号',
    `out_trade_no` varchar(255) DEFAULT NULL COMMENT '外部交易号',
    `trade_type` varchar(50) DEFAULT NULL COMMENT '交易类型：UNIFIED_WITHHOLD、VOSTRO_SUB_ACCOUNT',
    `order_amt` varchar(20) DEFAULT NULL COMMENT '订单金额',
    `trade_amt` varchar(20) DEFAULT NULL COMMENT '交易金额',
    `bank_fee` varchar(20) DEFAULT NULL COMMENT '手续费',
    `ccy` varchar(10) DEFAULT NULL COMMENT '币种',
    `status` varchar(20) DEFAULT NULL COMMENT '状态：FINISH',
    `create_time` varchar(30) DEFAULT NULL COMMENT '创建时间',
    `finish_time` varchar(30) DEFAULT NULL COMMENT '完成时间',
    `relate_trade_no` varchar(255) DEFAULT NULL COMMENT '关联交易号',
    PRIMARY KEY (`trade_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包对账未匹配到数据';