--  平台服务费配置

DROP TABLE IF EXISTS bcx_platform_fee_config;
CREATE TABLE `bcx_platform_fee_config`
(
    `id`                      int(11)   NOT NULL AUTO_INCREMENT COMMENT '平台服务费配置id',
    `level`                   int(2)             DEFAULT '0' COMMENT '0-平台 1-商户 3-商品 4-sku',
    `mer_id`                  int(11)            DEFAULT NULL COMMENT '商户id',
    `product_id`              int(11)            DEFAULT NULL COMMENT '商品id',
    `sku_id`                  int(11)            DEFAULT NULL COMMENT 'sku id',
    `sell_fee_type`           int(2)             DEFAULT '0' COMMENT '售卖服务费类型：0-百分比 1-金额',
    `sell_fee`                decimal(8, 2)      DEFAULT '0.00' COMMENT '售卖服务费',
    `sell_fee_priority`       int(2)             DEFAULT '0' COMMENT '销售分账优先级 0-平台 1-商户',
    `lease_fee_type`          int(2)             DEFAULT '0' COMMENT '租赁服务费类型：0-百分比 1-金额',
    `lease_fee`               decimal(8, 2)      DEFAULT '0.00' COMMENT '租赁服务费',
    `lease_fee_priority`      int(2)             DEFAULT '0' COMMENT '租赁分账优先级 0-平台 1-商户',
    `instalment_fee_type`     int(2)             DEFAULT '0' COMMENT '分期服务费类型：0-百分比 1-金额',
    `period3_fee`             decimal(8, 2)      DEFAULT '0.00' COMMENT '分期3期 服务费',
    `period6_fee`             decimal(8, 2)      DEFAULT '0.00' COMMENT '分期6期 服务费',
    `period9_fee`             decimal(8, 2)      DEFAULT '0.00' COMMENT '分期9期 服务费',
    `period12_fee`            decimal(8, 2)      DEFAULT '0.00' COMMENT '分期12期 服务费',
    `instalment_fee_priority` int(2)             DEFAULT '0' COMMENT '分期分账优先级 0-平台 1-商户',
    `create_time`             timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`             timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='平台服务费-配置表';

CREATE TABLE `bcx_platform_fee`
(
    `id`             int(11)      NOT NULL AUTO_INCREMENT COMMENT '平台服务费id',
    `order_no`       varchar(255) NOT NULL COMMENT '平台费单号',
    `order_type`     int(2)       NOT NULL COMMENT '平台费类型： 0-订单  1-分期单',
    `plat_fee`       decimal(8, 2)         DEFAULT '0.00' COMMENT '平台费',
    `trans_priority` int(1)                DEFAULT '0' COMMENT '分账优先级 0-平台 1-商户',
    `config`         varchar(2550)          DEFAULT NULL COMMENT '原始配置',
    `create_time`    timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`    timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='平台服务费';
-- 已更新到dev test
