package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 获取对账文件下载链接接口 <ant.mybank.bkcloudfunds.recon.query>
 * 响应模型
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsReconQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = -8459419962598845465L;

    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 账单日期
     *
     * 格式为yyyyMMdd(20201101<=Date<=Today)
     */
    @XmlElement(name = "Date")
    private String date;

    /**
     * 外部交易号
     * <p>
     * 由合作方系统生成，只能包含字母、数字、下划线；需保证合作方系统不重复
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 下载账单类型
     *
     * 01-云资金对账单
     * 02-云资金对账明细
     * 03-云资金账户变动
     */
    @XmlElement(name = "Type")
    private String type;

    /**
     * 对账文件下载链接
     */
    @XmlElement(name = "DownloadUrl")
    private String downloadUrl;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
}