package com.zbkj.service.wangshang.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.zbkj.service.huifu.init.CoppsMerchantConfig;
import com.zbkj.service.huifu.init.OppsMerchantConfig;
import com.zbkj.service.huifu.v2.*;
import com.zbkj.service.wangshang.api.config.MybankConfig;
import com.zbkj.service.wangshang.api.domain.RespInfo;
import com.zbkj.service.wangshang.api.domain.model.*;
import com.zbkj.service.wangshang.api.domain.model.order.BkcloudfundsOrderWithholdApplyRequestModel;
import com.zbkj.service.wangshang.api.domain.model.order.BkcloudfundsOrderWithholdApplyResponseModel;
import com.zbkj.service.wangshang.api.domain.model.uploadphoto.MerchantprodMerchantUploadphotoRequestModel;
import com.zbkj.service.wangshang.api.domain.model.uploadphoto.MerchantprodMerchantUploadphotoResponseModel;
import com.zbkj.service.wangshang.api.service.*;
import com.zbkj.service.wangshang.api.service.base.MerchantprodMerchantUploadphotoRequest;
import com.zbkj.service.wangshang.api.service.base.MerchantprodMerchantUploadphotoResponse;
import com.zbkj.service.wangshang.api.service.order.BkcloudfundsOrderWithholdApplyRequest;
import com.zbkj.service.wangshang.api.service.order.BkcloudfundsOrderWithholdApplyResponse;
import com.zbkj.service.wangshang.constants.WSBusiCode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;


public class WSApiRequest extends BaseCommon {

    private static final Logger logger = LoggerFactory.getLogger(WSApiRequest.class);
    public final static String MERCHANTKEY = "plat_c_pay";
    public final static String OUTMERCHANTID = "123456789";

    static {
        // 1. 数据初始化
        try {
            doInit(OppsMerchantConfig.getMerchantConfig());
            //添加C端商户配置
            addMerConfig(CoppsMerchantConfig.getMerchantConfig(),MERCHANTKEY);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> api(WSBusiCode code, Map<String, Object> map) throws Exception {
        Map<String, Object> response = Maps.newHashMap();
        RespInfo info;
        MybankClient mybankClient;
        // 3. 发起API调用
        switch (code) {
            case JSQUERY:
                response = doExecute(V2MerchantBasicdataSettlementQuery.method(map));
                break;
            case CWQUERY:
                response = doExecute(V2TradeAcctpaymentAcctlogQuery.method(map));
                break;
            case YEQUERY:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：商户余额查询接口< ant.mybank.bkcloudfunds.balance.query>
                BkcloudfundsBalanceQueryRequest balanceQueryRequest = new BkcloudfundsBalanceQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsBalanceQueryRequestModel balanceQueryRequestModel = new BkcloudfundsBalanceQueryRequestModel();
                balanceQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                balanceQueryRequestModel.setMerchantId(map.get("merchantId").toString());

                balanceQueryRequest.setRequestBody(balanceQueryRequestModel);

                System.out.println(balanceQueryRequest.getRequestHead().getFunction() + "=========>>" + balanceQueryRequest.getRequestHead().getReqMsgId());
                BkcloudfundsBalanceQueryResponse balanceQueryResponse = mybankClient.execute(balanceQueryRequest);
                BkcloudfundsBalanceQueryResponseModel balanceQueryResponseModel = balanceQueryResponse.getBkcloudfundsBalanceQuery().getBkcloudfundsBalanceQueryResponseModel();

                // 客户端请求报文
                System.out.println("客户端请求报文=" + balanceQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + balanceQueryResponse.getXmlContent());
                info = balanceQueryResponseModel.getRespInfo();
                if("F".equals(info.getResultStatus())){
                    response.put("resp_code","90010000");
                    response.put("resp_desc",info.getResultMsg());
                }else{
                    String str = new String(Base64.getDecoder().decode(balanceQueryResponseModel.getBalanceList()), StandardCharsets.UTF_8);
                    System.out.println(str);
                    JSONArray arr = JSONArray.parseArray(str);
                    for (Object balance : arr){
                        JSONObject  json = JSONObject.parseObject(JSON.toJSONString(balance));
                        //FREEZE-表示当前处于冻结（未分账）的余额。冻结余额
                        //BALANCE-标识当前可用于提现或余额支付的余额。可用余额
                        //金额totalAmount单位为分
                        response.put(json.get("accountType").toString(), json.get("totalAmount").toString());//单位 分
                    }
                    response.put("request_content",balanceQueryResponse.getRequestContent());
                    response.put("response_content",balanceQueryResponse.getXmlContent());
                    response.put("resp_code",info.getResultCode()+"0000");
                    response.put("resp_desc",info.getResultMsg());
                }
                break;
            case YEPAY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口 协议授权代扣接口 <ant.mybank.bkcloudfunds.order.withhold.apply>
                BkcloudfundsOrderWithholdApplyRequest bkcloudfundsOrderWithholdApplyRequest = new BkcloudfundsOrderWithholdApplyRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsOrderWithholdApplyRequestModel bkcloudfundsOrderWithholdApplyRequestModel = new BkcloudfundsOrderWithholdApplyRequestModel();
                bkcloudfundsOrderWithholdApplyRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                bkcloudfundsOrderWithholdApplyRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
                bkcloudfundsOrderWithholdApplyRequestModel.setScene(map.get("scene").toString());
                String tol = (new BigDecimal(map.get("ordAmt").toString())).multiply(BigDecimal.valueOf(100)).toString().replace(".00","");
                bkcloudfundsOrderWithholdApplyRequestModel.setTotalAmount(tol);
                if("PROTOCOL_WITHHOLD_SUPPORT_FREEZE".equals(map.get("scene").toString())){
                    bkcloudfundsOrderWithholdApplyRequestModel.setFreezeAmount((new BigDecimal(map.get("freezeAmount").toString())).multiply(BigDecimal.valueOf(100)).toString().replace(".00",""));
                    bkcloudfundsOrderWithholdApplyRequestModel.setAvailableAmount((new BigDecimal(map.get("availableAmount").toString())).multiply(BigDecimal.valueOf(100)).toString().replace(".00",""));
                }
                bkcloudfundsOrderWithholdApplyRequestModel.setCurrency("CNY");
                bkcloudfundsOrderWithholdApplyRequestModel.setPayerId(map.get("outHuifuId").toString());
                bkcloudfundsOrderWithholdApplyRequestModel.setPayerType("MERCHANT");
                bkcloudfundsOrderWithholdApplyRequestModel.setPayeeId(map.get("inWalletAccountNo").toString());
                bkcloudfundsOrderWithholdApplyRequestModel.setPayeeType("MERCHANT");
                bkcloudfundsOrderWithholdApplyRequestModel.setMemo(map.get("comment").toString());
                bkcloudfundsOrderWithholdApplyRequestModel.setExtInfo("");

                bkcloudfundsOrderWithholdApplyRequest.setRequestBody(bkcloudfundsOrderWithholdApplyRequestModel);

                System.out.println(bkcloudfundsOrderWithholdApplyRequest.getRequestHead().getFunction() + "=========>>" + bkcloudfundsOrderWithholdApplyRequest.getRequestHead().getReqMsgId());

                BkcloudfundsOrderWithholdApplyResponse bkcloudfundsOrderWithholdApplyResponse = mybankClient.execute(bkcloudfundsOrderWithholdApplyRequest);
                BkcloudfundsOrderWithholdApplyResponseModel bkcloudfundsOrderWithholdApplyResponseModel = bkcloudfundsOrderWithholdApplyResponse.getBkcloudfundsOrderWithholdApply().getBkcloudfundsOrderWithholdApplyResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + bkcloudfundsOrderWithholdApplyResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + bkcloudfundsOrderWithholdApplyResponse.getXmlContent());
                info = bkcloudfundsOrderWithholdApplyResponseModel.getRespInfo();
                response.put("request_content",bkcloudfundsOrderWithholdApplyResponse.getRequestContent());
                response.put("response_content",bkcloudfundsOrderWithholdApplyResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("hf_seq_id", bkcloudfundsOrderWithholdApplyResponseModel.getOperateNo());
                response.put("req_seq_id", bkcloudfundsOrderWithholdApplyResponseModel.getOutTradeNo());
                break;
            case ZHYEQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：账户场景余额查询<ant.mybank.bkcloudfunds.merchant.scene.balance.query>
                BkcloudfundsMerchantSceneBalanceQueryRequest merchantSceneBalanceQueryRequest = new BkcloudfundsMerchantSceneBalanceQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsMerchantSceneBalanceQueryRequestModel merchantSceneBalanceQueryRequestModel = new BkcloudfundsMerchantSceneBalanceQueryRequestModel();
                merchantSceneBalanceQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                merchantSceneBalanceQueryRequestModel.setMerchantId(map.get("merchantId").toString());
//                merchantSceneBalanceQueryRequestModel.setExtInfo("");

                merchantSceneBalanceQueryRequest.setRequestBody(merchantSceneBalanceQueryRequestModel);

                System.out.println(merchantSceneBalanceQueryRequest.getRequestHead().getFunction() + "=========>>" + merchantSceneBalanceQueryRequest.getRequestHead().getReqMsgId());
                BkcloudfundsMerchantSceneBalanceQueryResponse merchantSceneBalanceQueryResponse = mybankClient.execute(merchantSceneBalanceQueryRequest);
                BkcloudfundsMerchantSceneBalanceQueryResponseModel merchantSceneBalanceQueryResponseModel = merchantSceneBalanceQueryResponse.getBkcloudfundsMerchantSceneBalanceQuery().getBkcloudfundsMerchantSceneBalanceQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchantSceneBalanceQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchantSceneBalanceQueryResponse.getXmlContent());
                info = merchantSceneBalanceQueryResponseModel.getRespInfo();
                response.put("request_content",merchantSceneBalanceQueryResponse.getRequestContent());
                response.put("response_content",merchantSceneBalanceQueryResponse.getXmlContent());
                if("F".equals(info.getResultStatus())){
                    response.put("resp_code","90010000");
                    response.put("resp_desc",info.getResultMsg());
                }else{
                    response.put("resp_code",info.getResultCode()+"0000");
                    response.put("resp_desc",info.getResultMsg());
                    if("F".equals(info.getResultStatus())){
                        break;
                    }
                    String str = new String(Base64.getDecoder().decode(merchantSceneBalanceQueryResponseModel.getBalanceInfo()), StandardCharsets.UTF_8);
                    System.out.println(str);
                    //{"WITHDRAW":"0","PAY":"14900","BALANCE_FREEZE":"1000"}表是可以提现0， 可以支付14900分，余额冻结部分1000分
                    Map<String,Object> map1 = JSONObject.parseObject(str,Map.class);
                    response.putAll(map1);
                }
                break;
            case DKQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：协议授权代扣查询结果<ant.mybank.bkcloudfunds.protocol.withhold.query>
                BkcloudfundsProtocolWithholdQueryRequest protocolWithholdQueryRequest = new BkcloudfundsProtocolWithholdQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsProtocolWithholdQueryRequestModel protocolWithholdQueryRequestModel = new BkcloudfundsProtocolWithholdQueryRequestModel();
                protocolWithholdQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                protocolWithholdQueryRequestModel.setOperateNo(map.get("hfSeqId").toString());
                protocolWithholdQueryRequestModel.setOutTradeNo(map.get("reqSeqId").toString());

                protocolWithholdQueryRequest.setRequestBody(protocolWithholdQueryRequestModel);

                System.out.println(protocolWithholdQueryRequest.getRequestHead().getFunction() + "=========>>" + protocolWithholdQueryRequest.getRequestHead().getReqMsgId());
                BkcloudfundsProtocolWithholdQueryResponse protocolWithholdQueryResponse = mybankClient.execute(protocolWithholdQueryRequest);
                BkcloudfundsProtocolWithholdQueryResponseModel protocolWithholdQueryResponseModel = protocolWithholdQueryResponse.
                        getBkcloudfundsProtocolWithholdQuery().getBkcloudfundsProtocolWithholdQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + protocolWithholdQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + protocolWithholdQueryResponse.getXmlContent());
                info = protocolWithholdQueryResponseModel.getRespInfo();
                response.put("request_content",protocolWithholdQueryResponse.getRequestContent());
                response.put("response_content",protocolWithholdQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("ord_amt", protocolWithholdQueryResponseModel.getTotalAmount());
                response.put("trans_finish_time", protocolWithholdQueryResponseModel.getFinishDate());
                response.put("trans_stat", protocolWithholdQueryResponseModel.getStatus());//状态(SUCCESS, DEALING，FAIL)
                break;
            case BATCHQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：协议授权代扣查询结果<ant.mybank.bkcloudfunds.protocol.withhold.query>
                BkcloudfundsVostroChargeBatchQueryRequest vostroChargeBatchQueryRequest = new BkcloudfundsVostroChargeBatchQueryRequest(MybankConfig.appId);
                //以下方法为demo的model入参方式
                BkcloudfundsVostroChargeBatchQueryRequestModel vostroChargeBatchQueryRequestModel = new BkcloudfundsVostroChargeBatchQueryRequestModel();
                vostroChargeBatchQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                vostroChargeBatchQueryRequestModel.setMerchantId(map.get("merchantId").toString());
                if(map.get("orderNo") != null){
                    vostroChargeBatchQueryRequestModel.setOrderNo(map.get("orderNo").toString());
                }
                vostroChargeBatchQueryRequestModel.setVostroScene("");
                vostroChargeBatchQueryRequestModel.setStartTime(map.get("startTime").toString());//20200722
                vostroChargeBatchQueryRequestModel.setEndTime(map.get("endTime").toString());
                vostroChargeBatchQueryRequestModel.setPageIndex("1");
                vostroChargeBatchQueryRequestModel.setPageSize("50");

                vostroChargeBatchQueryRequest.setRequestBody(vostroChargeBatchQueryRequestModel);

                System.out.println(vostroChargeBatchQueryRequest.getRequestHead().getFunction() + "=========>>" + vostroChargeBatchQueryRequest.getRequestHead().getReqMsgId());

                BkcloudfundsVostroChargeBatchQueryResponse vostroChargeBatchQueryResponse = mybankClient.execute(vostroChargeBatchQueryRequest);
                BkcloudfundsVostroChargeBatchQueryResponseModel vostroChargeBatchQueryResponseModel = vostroChargeBatchQueryResponse.getBkcloudfundsVostroChargeBatchQuery().getBkcloudfundsVostroChargeBatchQueryResponseModel();

                // 客户端请求报文
                System.out.println("客户端请求报文=" + vostroChargeBatchQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + vostroChargeBatchQueryResponse.getXmlContent());
                info = vostroChargeBatchQueryResponseModel.getRespInfo();
                response.put("request_content",vostroChargeBatchQueryResponse.getRequestContent());
                response.put("response_content",vostroChargeBatchQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                String vostroInfoList = new String(Base64.getDecoder().decode(vostroChargeBatchQueryResponseModel.getVostroInfoList()), StandardCharsets.UTF_8);
                System.out.println(vostroInfoList);
                List<VostroInfo> vostroInfoListJsonArray = JSONArray.parseArray(vostroInfoList,VostroInfo.class);
                for (VostroInfo vostroInfo : vostroInfoListJsonArray){
                    vostroInfo.changeAmount(map.get("TRADE_DEPOSIT").toString());
                }
                response.put("vostroInfoList", vostroInfoListJsonArray);
                break;
            case REFUNDAPPLY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);

                //实例化具体API对应的request类,当前调用API接口：支付退回申请< ant.mybank.bkcloudfunds.refund.apply>
                BkcloudfundsRefundApplyRequest refundApplyRequest = new BkcloudfundsRefundApplyRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsRefundApplyRequestModel refundApplyRequestModel = new BkcloudfundsRefundApplyRequestModel();
                refundApplyRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                refundApplyRequestModel.setParticipantType("MERCHANT");
                refundApplyRequestModel.setParticipantId(map.get("merchantId").toString());
                refundApplyRequestModel.setRelateOrderNo(map.get("orderNo").toString());
                refundApplyRequestModel.setRelateTransNo("");
                refundApplyRequestModel.setOutRefundNo(map.get("reqSeqId").toString());
                refundApplyRequestModel.setRefundAmount(map.get("refundAmount").toString());
                refundApplyRequestModel.setCurrency("CNY");
                refundApplyRequestModel.setRefundReason("退款");
                refundApplyRequestModel.setExtInfo("");
                refundApplyRequestModel.setMemo("退款");

                refundApplyRequest.setRequestBody(refundApplyRequestModel);

                BkcloudfundsRefundApplyResponse refundApplyResponse = mybankClient.execute(refundApplyRequest);
                BkcloudfundsRefundApplyResponseModel refundApplyResponseModel = refundApplyResponse.getBkcloudfundsRefundApply().getBkcloudfundsRefundApplyResponseModel();

                // 客户端请求报文
                System.out.println("客户端请求报文=" + refundApplyResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + refundApplyResponse.getXmlContent());
                info = refundApplyResponseModel.getRespInfo();
                response.put("request_content",refundApplyResponse.getRequestContent());
                response.put("response_content",refundApplyResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("orderNo", refundApplyResponseModel.getRefundOrderNo());
                response.put("outRefundNo", refundApplyResponseModel.getOutRefundNo());
                break;
            case BREFUNDQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：支付退回查询接口< ant.mybank.bkcloudfunds.refund.query>
                BkcloudfundsRefundQueryRequest refundQueryRequest = new BkcloudfundsRefundQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsRefundQueryRequestModel refundQueryRequestModel = new BkcloudfundsRefundQueryRequestModel();
                refundQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                refundQueryRequestModel.setRelateOrderNo(map.get("relateOrderNo").toString());
                refundQueryRequestModel.setParticipantType("SUBACCOUNT");
                refundQueryRequestModel.setParticipantId(map.get("merchantId").toString());
                refundQueryRequestModel.setOutRefundNo(map.get("reqSeqId").toString());
                refundQueryRequestModel.setRefundOrderNo(map.get("orderNo").toString());

                refundQueryRequest.setRequestBody(refundQueryRequestModel);

                BkcloudfundsRefundQueryResponse refundQueryResponse = mybankClient.execute(refundQueryRequest);
                BkcloudfundsRefundQueryResponseModel refundQueryResponseModel = refundQueryResponse.getBkcloudfundsRefundQuery().getBkcloudfundsRefundQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + refundQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + refundQueryResponse.getXmlContent());
                info = refundQueryResponseModel.getRespInfo();
                response.put("request_content",refundQueryResponse.getRequestContent());
                response.put("response_content",refundQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("relateOrderNo", refundQueryResponseModel.getRelateOrderNo());//关联网商订单号
                response.put("refundOrderNo", refundQueryResponseModel.getRefundOrderNo());//退款网商订单号
                response.put("channelRefundOrderNo", refundQueryResponseModel.getChannelRefundOrderNo());//聚合支付渠道退款单号
                response.put("outRefundNo", refundQueryResponseModel.getOutRefundNo());//外部退款交易号
                response.put("refundAmount", refundQueryResponseModel.getRefundAmount());//退款金额。币种同原交易
                response.put("status", refundQueryResponseModel.getStatus());//状态(SUCCESS, FAIL,DEALING)
                response.put("participantActualRefundAmount", refundQueryResponseModel.getParticipantActualRefundAmount());//商户实际退款金额
                response.put("refundFinishDate", refundQueryResponseModel.getRefundFinishDate());//退款完成时间（成功时出现）
                break;
            case YEUNFREEZE:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);

                BkcloudfundsMerchantAccountUnfreezeApplyRequest merchantAccountUnfreezeApplyRequest = new BkcloudfundsMerchantAccountUnfreezeApplyRequest(MybankConfig.appId);

                BkcloudfundsMerchantAccountUnfreezeApplyRequestModel merchantAccountUnfreezeApplyRequestModel = new BkcloudfundsMerchantAccountUnfreezeApplyRequestModel();

                merchantAccountUnfreezeApplyRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                merchantAccountUnfreezeApplyRequestModel.setAccountType("BALANCE");
                merchantAccountUnfreezeApplyRequestModel.setAmount(map.get("ordAmt").toString());
                merchantAccountUnfreezeApplyRequestModel.setCurrency("CNY");
                merchantAccountUnfreezeApplyRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
                merchantAccountUnfreezeApplyRequestModel.setMerchantId(map.get("merchantId").toString());
                merchantAccountUnfreezeApplyRequestModel.setExtInfo("");
                merchantAccountUnfreezeApplyRequest.setRequestBody(merchantAccountUnfreezeApplyRequestModel);
                BkcloudfundsMerchantAccountUnfreezeApplyResponse merchantAccountUnfreezeApplyResponse = mybankClient.execute(merchantAccountUnfreezeApplyRequest);
                BkcloudfundsMerchantAccountUnfreezeApplyResponseModel merchantAccountUnfreezeApplyResponseModel = merchantAccountUnfreezeApplyResponse.getBkcloudfundsMerchantAccountUnfreezeApply().
                            getBkcloudfundsMerchantAccountUnfreezeApplyResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchantAccountUnfreezeApplyResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchantAccountUnfreezeApplyResponse.getXmlContent());
                info = merchantAccountUnfreezeApplyResponseModel.getRespInfo();
                response.put("request_content",merchantAccountUnfreezeApplyResponse.getRequestContent());
                response.put("response_content",merchantAccountUnfreezeApplyResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("operateNo", merchantAccountUnfreezeApplyResponseModel.getOperateNo());
                break;
            case TAUTHSTATUS:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口 协议代扣授权状态查询接口<ant.mybank.merchantprod.merchant.arrangement.info.query>
                MerchantprodMerchantArrangementInfoQueryRequest merchantprodMerchantArrangementInfoQueryRequest = new MerchantprodMerchantArrangementInfoQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                MerchantprodMerchantArrangementInfoQueryRequestModel merchantprodMerchantArrangementInfoQueryRequestModel = new MerchantprodMerchantArrangementInfoQueryRequestModel();

                merchantprodMerchantArrangementInfoQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);

                merchantprodMerchantArrangementInfoQueryRequestModel.setMerchantId(map.get("merchantId").toString());

                merchantprodMerchantArrangementInfoQueryRequestModel.setArrangementType("SUB_ACCOUNT_WITHHOLD");
                merchantprodMerchantArrangementInfoQueryRequest.setRequestBody(merchantprodMerchantArrangementInfoQueryRequestModel);
                MerchantprodMerchantArrangementInfoQueryResponse merchantprodMerchantArrangementInfoQueryResponse = mybankClient.execute(merchantprodMerchantArrangementInfoQueryRequest);
                MerchantprodMerchantArrangementInfoQueryResponseModel merchantArrangementInfoQueryResponseModel = merchantprodMerchantArrangementInfoQueryResponse.getMerchantprodMerchantArrangementInfoQuery().getMerchantprodMerchantArrangementInfoQueryResponseModel();

                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchantprodMerchantArrangementInfoQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchantprodMerchantArrangementInfoQueryResponse.getXmlContent());
                info = merchantArrangementInfoQueryResponseModel.getRespInfo();
                response.put("request_content",merchantprodMerchantArrangementInfoQueryResponse.getRequestContent());
                response.put("response_content",merchantprodMerchantArrangementInfoQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("arrangementNo", merchantArrangementInfoQueryResponseModel.getArrangementNo());
                response.put("status", merchantArrangementInfoQueryResponseModel.getStatus());
                break;
            case TAUTH:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口 解约申请审核确认接口：<ant.mybank.merchantprod.merchant.arrangement.audit>
                MerchantprodMerchantArrangeMentAuditRequest merchantArrangeMentAuditRequest = new MerchantprodMerchantArrangeMentAuditRequest(MybankConfig.appId);
                //以下方法为demo的model入参方式
                MerchantprodMerchantArrangeMentAuditRequestModel merchantArrangeMentAuditRequestModel = new MerchantprodMerchantArrangeMentAuditRequestModel();
                merchantArrangeMentAuditRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                //TODO ArrangementNo 合约号
                merchantArrangeMentAuditRequestModel.setArrangementNo(map.get("arrangementNo").toString());
                merchantArrangeMentAuditRequestModel.setAuditResult(map.get("auditResult").toString());//审核结果 AGREE -同意 AGREE -同意
                merchantArrangeMentAuditRequestModel.setMerchantId(map.get("merchantId").toString());

                merchantArrangeMentAuditRequest.setRequestBody(merchantArrangeMentAuditRequestModel);

                MerchantprodMerchantArrangeMentAuditResponse merchantArrangeMentAuditResponse = mybankClient.execute(merchantArrangeMentAuditRequest);

                MerchantprodMerchantArrangeMentAuditResponseModel merchantArrangeMentAuditResponseModel = merchantArrangeMentAuditResponse.getMerchantprodMerchantArrangeMentAudit().getMerchantprodMerchantArrangeMentAuditResponseModel();

                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchantArrangeMentAuditResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchantArrangeMentAuditResponse.getXmlContent());
                info = merchantArrangeMentAuditResponseModel.getRespInfo();
                response.put("request_content",merchantArrangeMentAuditResponse.getRequestContent());
                response.put("response_content",merchantArrangeMentAuditResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                break;
            case ZDCONFIG:
                response = doExecute(V2MerchantBusiBillConfig.method(map));
                break;
            case ZDREPLAY:
                response = doExecute(V2TradeCheckReplay.method(map));
                break;
            case ZDQUERY:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：获取对账文件下载链接接口<ant.mybank.bkcloudfunds.recon.query>
                BkcloudfundsReconQueryRequest reconQueryRequest = new BkcloudfundsReconQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsReconQueryRequestModel reconQueryRequestModel = new BkcloudfundsReconQueryRequestModel();
                reconQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                reconQueryRequestModel.setDate(map.get("fileDate").toString());//"20201102"
                reconQueryRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
                reconQueryRequestModel.setType("01");//账单类型 01-云资金对账单 02-云资金对账明细
                reconQueryRequestModel.setExtInfo("");

                reconQueryRequest.setRequestBody(reconQueryRequestModel);

                System.out.println(reconQueryRequest.getRequestHead().getFunction() + "=========>>" + reconQueryRequest.getRequestHead().getReqMsgId());
                BkcloudfundsReconQueryResponse reconQueryResponse = mybankClient.execute(reconQueryRequest);
                BkcloudfundsReconQueryResponseModel reconQueryResponseModel =
                        reconQueryResponse.getBkcloudfundsReconQuery().getBkcloudfundsReconQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + reconQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + reconQueryResponse.getXmlContent());
                info = reconQueryResponseModel.getRespInfo();
                response.put("request_content",reconQueryResponse.getRequestContent());
                response.put("response_content",reconQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                String str = new String(Base64.getDecoder().decode(reconQueryResponseModel.getDownloadUrl()), StandardCharsets.UTF_8);
                System.out.println(str);
                response.put("downloadUrl", str);//电子回单号
                response.put("outTradeNo", reconQueryResponseModel.getOutTradeNo());//电子回单号
                break;
            case TXQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：单笔提现查询接口（异步接口）<ant.mybank.bkcloudfunds.withdraw.query>
                BkcloudfundsWithdrawQueryRequest withdrawQueryRequest = new BkcloudfundsWithdrawQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsWithdrawQueryRequestModel withdrawQueryRequestModel = new BkcloudfundsWithdrawQueryRequestModel();
                withdrawQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                withdrawQueryRequestModel.setMerchantId(map.get("merchantId").toString());
                withdrawQueryRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
                withdrawQueryRequestModel.setOrderNo(map.get("orderNo").toString());

                withdrawQueryRequest.setRequestBody(withdrawQueryRequestModel);

                System.out.println(withdrawQueryRequest.getRequestHead().getFunction() + "=========>>" + withdrawQueryRequest.getRequestHead().getReqMsgId());
                BkcloudfundsWithdrawQueryResponse withdrawQueryResponse = mybankClient.execute(withdrawQueryRequest);
                BkcloudfundsWithdrawQueryResponseModel withdrawQueryResponseModel = withdrawQueryResponse.getBkcloudfundsWithdrawQuery().getBkcloudfundsWithdrawQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + withdrawQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + withdrawQueryResponse.getXmlContent());
                info = withdrawQueryResponseModel.getRespInfo();
                response.put("request_content",withdrawQueryResponse.getRequestContent());
                response.put("response_content",withdrawQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("orderNo", withdrawQueryResponseModel.getOrderNo());//
                response.put("totalAmount", withdrawQueryResponseModel.getTotalAmount());//
                response.put("platformFee", withdrawQueryResponseModel.getPlatformFee());//
                response.put("status", withdrawQueryResponseModel.getStatus());//
                response.put("bankCardNo", withdrawQueryResponseModel.getBankCardNo());//
                response.put("bankCertName", withdrawQueryResponseModel.getBankCertName());//
                response.put("withdrawApplyDate", withdrawQueryResponseModel.getWithdrawApplyDate());//
                response.put("withdrawFinishDate", withdrawQueryResponseModel.getWithdrawFinishDate());//
                response.put("memo", withdrawQueryResponseModel.getMemo());//
                response.put("errorDesc", withdrawQueryResponseModel.getErrorDesc());//
                break;
            case FEEFILEQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkOpenApiUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：单笔提现查询接口（异步接口）<ant.mybank.bkcloudfunds.withdraw.query>
                BkmbpStmtApplyResultCommonQueryRequest bkmbpStmtApplyResultCommonQueryRequest = new BkmbpStmtApplyResultCommonQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkmbpStmtApplyResultCommonQueryRequestModel bkmbpStmtApplyResultCommonQueryRequestModel = new BkmbpStmtApplyResultCommonQueryRequestModel();
                bkmbpStmtApplyResultCommonQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                String  stmtType = map.get("stmtType").toString();
                //1.品牌商收费账单明细文件（PLAT_FEE_STMT_BILL），2.品牌商收费日账单文件（PLAT_FEE_DAY_SUMMARY_STMT_BILL），3.品牌商收费月账单文件（PLAT_FEE_MON_SUMMARY_STMT_BILL）
                stmtType = "1".equals(stmtType)?"PLAT_FEE_STMT_BILL":"2".equals(stmtType)?"PLAT_FEE_DAY_SUMMARY_STMT_BILL":"PLAT_FEE_MON_SUMMARY_STMT_BILL";
                bkmbpStmtApplyResultCommonQueryRequestModel.setStmtType(stmtType);
                bkmbpStmtApplyResultCommonQueryRequestModel.setOutRequestNo(map.get("outRequestNo").toString());
                bkmbpStmtApplyResultCommonQueryRequestModel.setBackOrderNo(map.get("backOrderNo").toString());

                bkmbpStmtApplyResultCommonQueryRequest.setRequestBody(bkmbpStmtApplyResultCommonQueryRequestModel);

                System.out.println(bkmbpStmtApplyResultCommonQueryRequest.getRequestHead().getFunction() + "=========>>" + bkmbpStmtApplyResultCommonQueryRequest.getRequestHead().getReqMsgId());
                BkmbpStmtApplyResultCommonQueryResponse bkmbpStmtApplyResultCommonQueryResponse = mybankClient.execute(bkmbpStmtApplyResultCommonQueryRequest);
                BkmbpStmtApplyResultCommonQueryResponseModel bkmbpStmtApplyResultCommonQueryResponseModel = bkmbpStmtApplyResultCommonQueryResponse.getBkmbpStmtApplyResultCommonQuery().getBkmbpStmtApplyResultCommonQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + bkmbpStmtApplyResultCommonQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + bkmbpStmtApplyResultCommonQueryResponse.getXmlContent());
                info = bkmbpStmtApplyResultCommonQueryResponseModel.getRespInfo();
                response.put("request_content",bkmbpStmtApplyResultCommonQueryResponse.getRequestContent());
                response.put("response_content",bkmbpStmtApplyResultCommonQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("outRequestNo", bkmbpStmtApplyResultCommonQueryResponseModel.getOutRequestNo());//
                response.put("stmtType", bkmbpStmtApplyResultCommonQueryResponseModel.getStmtType());//
                response.put("backOrderNo", bkmbpStmtApplyResultCommonQueryResponseModel.getBackOrderNo());//
                response.put("status", bkmbpStmtApplyResultCommonQueryResponseModel.getStatus());//
                response.put("pdfDownloadUrl", bkmbpStmtApplyResultCommonQueryResponseModel.getPdfDownloadUrl());//
                break;
            case WYPAY:
                response = doExecute(V2TradeOnlinepaymentBankingFrontpay.method(map));
                break;
            case FEEFILEAPPLY:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：申请电子业务凭证<ant.mybank.bkcloudfunds.electronicreceipt.apply>@2.0.0
                BkmbpStmtFeeFileApplyRequest bkmbpStmtFeeFileApplyRequest = new BkmbpStmtFeeFileApplyRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkmbpStmtFeeFileApplyRequestModel bkmbpStmtFeeFileApplyRequestModel = new BkmbpStmtFeeFileApplyRequestModel();
                bkmbpStmtFeeFileApplyRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                bkmbpStmtFeeFileApplyRequestModel.setStartTime(map.get("startTime").toString());//账单日期，格式为yyyyMMddhhmmss
                bkmbpStmtFeeFileApplyRequestModel.setEndTime(map.get("endTime").toString());//账单日期，格式为yyyyMMddhhmmss
                stmtType = map.get("stmtType").toString();
                //1.品牌商收费账单明细文件（PLAT_FEE_STMT_BILL），2.品牌商收费日账单文件（PLAT_FEE_DAY_SUMMARY_STMT_BILL），3.品牌商收费月账单文件（PLAT_FEE_MON_SUMMARY_STMT_BILL）
                stmtType = "1".equals(stmtType)?"PLAT_FEE_STMT_BILL":"2".equals(stmtType)?"PLAT_FEE_DAY_SUMMARY_STMT_BILL":"PLAT_FEE_MON_SUMMARY_STMT_BILL";
                bkmbpStmtFeeFileApplyRequestModel.setStmtType(stmtType);//下载账单类型
                bkmbpStmtFeeFileApplyRequestModel.setOutRequestNo(map.get("reqSeqId").toString());//外部交易号

                bkmbpStmtFeeFileApplyRequest.setRequestBody(bkmbpStmtFeeFileApplyRequestModel);

                System.out.println(bkmbpStmtFeeFileApplyRequest.getRequestHead().getFunction() + "=========>>" + bkmbpStmtFeeFileApplyRequest.getRequestHead().getReqMsgId());

                BkmbpStmtFeeFileApplyResponse bkmbpStmtFeeFileApplyResponse = mybankClient.execute(bkmbpStmtFeeFileApplyRequest);
                BkmbpStmtFeeFileApplyResponseModel bkmbpStmtFeeFileApplyResponseModel = bkmbpStmtFeeFileApplyResponse.getBkmbpStmtFeeFileApply().getBkmbpStmtFeeFileApplyResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + bkmbpStmtFeeFileApplyResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + bkmbpStmtFeeFileApplyResponse.getXmlContent());
                info = bkmbpStmtFeeFileApplyResponseModel.getRespInfo();
                response.put("request_content",bkmbpStmtFeeFileApplyResponse.getRequestContent());
                response.put("response_content",bkmbpStmtFeeFileApplyResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("backOrderNo", bkmbpStmtFeeFileApplyResponseModel.getBackOrderNo());//回单号
                break;
            case HDAPPLY:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：申请电子业务凭证<ant.mybank.bkcloudfunds.electronicreceipt.apply>@2.0.0
                BkcloudfundsElectronicreceiptApplyRequest electronicreceiptApplyRequest = new BkcloudfundsElectronicreceiptApplyRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsElectronicreceiptApplyRequestModel electronicreceiptApplyRequestModel = new BkcloudfundsElectronicreceiptApplyRequestModel();
                electronicreceiptApplyRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                electronicreceiptApplyRequestModel.setMerchantId(map.get("merchantId").toString());//商户编号
                electronicreceiptApplyRequestModel.setOrderNo(map.get("orderNo").toString());//订单号
                electronicreceiptApplyRequestModel.setOutTradeNo(map.get("reqSeqId").toString());

                electronicreceiptApplyRequest.setRequestBody(electronicreceiptApplyRequestModel);

                System.out.println(electronicreceiptApplyRequest.getRequestHead().getFunction() + "=========>>" + electronicreceiptApplyRequest.getRequestHead().getReqMsgId());

                BkcloudfundsElectronicreceiptApplyResponse electronicreceiptApplyResponse = mybankClient.execute(electronicreceiptApplyRequest);
                BkcloudfundsElectronicreceiptApplyResponseModel electronicreceiptApplyResponseModel = electronicreceiptApplyResponse.getBkcloudfundsElectronicreceiptApply().getBkcloudfundsElectronicreceiptApplyResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + electronicreceiptApplyResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + electronicreceiptApplyResponse.getXmlContent());
                info = electronicreceiptApplyResponseModel.getRespInfo();
                response.put("request_content",electronicreceiptApplyResponse.getRequestContent());
                response.put("response_content",electronicreceiptApplyResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("receiptNo", electronicreceiptApplyResponseModel.getReceiptNo());//电子回单号
                break;
            case HDBATCHAPPLY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：申请汇总电子业务凭证<ant.mybank.bkcloudfunds.electronicreceipt.batchapply>@2.0.0
                BkcloudfundsElectronicreceiptBatchApplyRequest electronicreceiptBatchApplyRequest = new BkcloudfundsElectronicreceiptBatchApplyRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsElectronicreceiptBatchApplyRequestModel electronicreceiptBatchApplyRequestModel = new BkcloudfundsElectronicreceiptBatchApplyRequestModel();
                electronicreceiptBatchApplyRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                electronicreceiptBatchApplyRequestModel.setMerchantId(map.get("merchantId").toString());
                electronicreceiptBatchApplyRequestModel.setStartDate(map.get("startDate").toString());
                electronicreceiptBatchApplyRequestModel.setEndDate(map.get("endDate").toString());
                electronicreceiptBatchApplyRequestModel.setOutTradeNo(map.get("reqSeqId").toString());

                electronicreceiptBatchApplyRequest.setRequestBody(electronicreceiptBatchApplyRequestModel);

                System.out.println(electronicreceiptBatchApplyRequest.getRequestHead().getFunction() + "=========>>" + electronicreceiptBatchApplyRequest.getRequestHead().getReqMsgId());
                BkcloudfundsElectronicreceiptBatchApplyResponse electronicreceiptBatchApplyResponse = mybankClient.execute(electronicreceiptBatchApplyRequest);
                BkcloudfundsElectronicreceiptBatchApplyResponseModel electronicreceiptBatchApplyResponseModel = electronicreceiptBatchApplyResponse.getBkcloudfundsElectronicreceiptBatchApply().getBkcloudfundsElectronicreceiptBatchApplyResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + electronicreceiptBatchApplyResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + electronicreceiptBatchApplyResponse.getXmlContent());
                info = electronicreceiptBatchApplyResponseModel.getRespInfo();
                response.put("request_content",electronicreceiptBatchApplyResponse.getRequestContent());
                response.put("response_content",electronicreceiptBatchApplyResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("receiptNo", electronicreceiptBatchApplyResponseModel.getReceiptNo());//电子回单号
                break;
            case HDQUERY:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：查询电子业务凭证结果<ant.mybank.bkcloudfunds.electronicreceipt.query>@2.0.0
                BkcloudfundsElectronicreceiptQueryRequest electronicreceiptQueryRequest = new BkcloudfundsElectronicreceiptQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsElectronicreceiptQueryRequestModel electronicreceiptQueryRequestModel = new BkcloudfundsElectronicreceiptQueryRequestModel();
                electronicreceiptQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                electronicreceiptQueryRequestModel.setMerchantId(map.get("merchantId").toString());
                electronicreceiptQueryRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
                electronicreceiptQueryRequestModel.setReceiptNo(map.get("receiptNo").toString());//电子回单号

                electronicreceiptQueryRequest.setRequestBody(electronicreceiptQueryRequestModel);

                System.out.println(electronicreceiptQueryRequest.getRequestHead().getFunction() + "=========>>" + electronicreceiptQueryRequest.getRequestHead().getReqMsgId());
                BkcloudfundsElectronicreceiptQueryResponse electronicreceiptQueryResponse = mybankClient.execute(electronicreceiptQueryRequest);
                BkcloudfundsElectronicreceiptQueryResponseModel electronicreceiptQueryResponseModel = electronicreceiptQueryResponse.getBkcloudfundsElectronicreceiptQuery().getBkcloudfundsElectronicreceiptQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + electronicreceiptQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + electronicreceiptQueryResponse.getXmlContent());
                info = electronicreceiptQueryResponseModel.getRespInfo();
                response.put("request_content",electronicreceiptQueryResponse.getRequestContent());
                response.put("response_content",electronicreceiptQueryResponse.getXmlContent());
                if("01".equals(electronicreceiptQueryResponseModel.getStatus())){
                    response.put("resp_code","90030000");
                    response.put("resp_desc","电子回单申请中，请稍后尝试");
                }else{
                    response.put("resp_code",info.getResultCode()+"0000");
                    response.put("resp_desc",info.getResultMsg());
                    if("F".equals(info.getResultStatus())){
                        break;
                    }
                    str = new String(Base64.getDecoder().decode(electronicreceiptQueryResponseModel.getPdfDownloadUrl()), StandardCharsets.UTF_8);
                    System.out.println(str);
                    response.put("PdfDownloadUrl", str);
                }
                break;
            case ENCHASHMENT:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：商户单笔提现申请接口<ant.mybank.bkcloudfunds.withdraw.apply>
                BkcloudfundsWithdrawApplyRequest withdrawApplyRequest = new BkcloudfundsWithdrawApplyRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsWithdrawApplyRequestModel withdrawApplyRequestModel = new BkcloudfundsWithdrawApplyRequestModel();
                withdrawApplyRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                withdrawApplyRequestModel.setMerchantId(map.get("merchantId").toString());
                withdrawApplyRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
                withdrawApplyRequestModel.setTotalAmount(map.get("cashAmt").toString());
                withdrawApplyRequestModel.setCurrency("CNY");
                withdrawApplyRequestModel.setPlatformFee(map.get("platformFee").toString());
                withdrawApplyRequestModel.setFeeCurrency("CNY");
                withdrawApplyRequestModel.setMemo("账户提现申请");

                withdrawApplyRequest.setRequestBody(withdrawApplyRequestModel);

                System.out.println(withdrawApplyRequest.getRequestHead().getFunction() + "=========>>" + withdrawApplyRequest.getRequestHead().getReqMsgId());
                BkcloudfundsWithdrawApplyResponse withdrawApplyResponse = mybankClient.execute(withdrawApplyRequest);
                BkcloudfundsWithdrawApplyResponseModel withdrawApplyResponseModel = withdrawApplyResponse.getBkcloudfundsWithdrawApply().getBkcloudfundsWithdrawApplyResponseModel();
                info = withdrawApplyResponseModel.getRespInfo();
                response.put("request_content",withdrawApplyResponse.getRequestContent());
                response.put("response_content",withdrawApplyResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("orderNo", withdrawApplyResponseModel.getOrderNo());
                break;
            case XYREFUNDAPPLY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：协议代扣退款申请接口<ant.mybank.bkcloudfunds.protocol.withhold.refund.apply>
                ProtocolWithholdRefundApplyRequest request = new ProtocolWithholdRefundApplyRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                ProtocolWithholdRefundApplyRequestModel protocolWithholdRefundApplyRequestModel = new ProtocolWithholdRefundApplyRequestModel();
                protocolWithholdRefundApplyRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                //outType 1.出方为商户 2.出方为平台
                if("1".equals(map.get("outType").toString())){
                    protocolWithholdRefundApplyRequestModel.setParticipantType("MERCHANT");
                    protocolWithholdRefundApplyRequestModel.setParticipantId(map.get("merchantId").toString());
                }else{
                    protocolWithholdRefundApplyRequestModel.setParticipantType("PLATFORM");
                    protocolWithholdRefundApplyRequestModel.setParticipantId(MybankConfig.isvOrgId);
                }
                protocolWithholdRefundApplyRequestModel.setOutRefundNo(map.get("reqSeqId").toString());
                protocolWithholdRefundApplyRequestModel.setRelateOrderNo(map.get("orderNo").toString());
                protocolWithholdRefundApplyRequestModel.setRelateTransNo(map.get("oldReqSeqId").toString());
                protocolWithholdRefundApplyRequestModel.setRefundAmount(map.get("cashAmt").toString());
                protocolWithholdRefundApplyRequestModel.setRefundReason(map.get("reason").toString());
                protocolWithholdRefundApplyRequestModel.setMemo(map.get("memo").toString());
                protocolWithholdRefundApplyRequestModel.setCurrency("CNY");

                request.setRequestBody(protocolWithholdRefundApplyRequestModel);

                System.out.println(request.getRequestHead().getFunction() + "=========>>" + request.getRequestHead().getReqMsgId());
                ProtocolWithholdRefundApplyResponse applyResponse = mybankClient.execute(request);
                // 客户端请求报文
                System.out.println("客户端请求报文=" + applyResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + applyResponse.getXmlContent());
                ProtocolWithholdRefundApplyResponseModel responseModel = applyResponse.getRefundApply().getModel();
                info = responseModel.getRespInfo();
                response.put("request_content",applyResponse.getRequestContent());
                response.put("response_content",applyResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("orderNo", responseModel.getRefundOrderNo());
                break;
            case XYREFUNDQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：协议代扣退款结果查询接口<ant.mybank.bkcloudfunds.protocol.withhold.refund.query>
                ProtocolWithholdRefundQueryRequest protocolWithholdRefundQueryRequest = new ProtocolWithholdRefundQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                ProtocolWithholdRefundQueryRequestModel protocolWithholdRefundQueryRequestModel = new ProtocolWithholdRefundQueryRequestModel();
                protocolWithholdRefundQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                protocolWithholdRefundQueryRequestModel.setParticipantType(MybankConfig.isvOrgId.equals(map.get("merchantId").toString())?"PLATFORM":"MERCHANT");
                protocolWithholdRefundQueryRequestModel.setParticipantId(map.get("merchantId").toString());
                protocolWithholdRefundQueryRequestModel.setRelateOrderNo(map.get("oldHfSeqId").toString());
                protocolWithholdRefundQueryRequestModel.setOutRefundNo(map.get("reqSeqId").toString());
                protocolWithholdRefundQueryRequestModel.setRefundOrderNo(map.get("hfSeqId").toString());

                protocolWithholdRefundQueryRequest.setRequestBody(protocolWithholdRefundQueryRequestModel);

                System.out.println(protocolWithholdRefundQueryRequest.getRequestHead().getFunction() + "=========>>" + protocolWithholdRefundQueryRequest.getRequestHead().getReqMsgId());
                ProtocolWithholdRefundQueryResponse queryResponse = mybankClient.execute(protocolWithholdRefundQueryRequest);
                ProtocolWithholdRefundQueryResponseModel protocolWithholdRefundQueryResponseModel = queryResponse.getProtocolWithholdRefundQuery().getModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + queryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + queryResponse.getXmlContent());
                info = protocolWithholdRefundQueryResponseModel.getRespInfo();
                response.put("request_content",queryResponse.getRequestContent());
                response.put("response_content",queryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("refundOrderNo", protocolWithholdRefundQueryResponseModel.getRefundOrderNo());
                response.put("relateOrderNo", protocolWithholdRefundQueryResponseModel.getRelateOrderNo());
                response.put("channelRefundOrderNo", protocolWithholdRefundQueryResponseModel.getChannelRefundOrderNo());
                response.put("outRefundNo", protocolWithholdRefundQueryResponseModel.getOutRefundNo());
                response.put("refundAmount", protocolWithholdRefundQueryResponseModel.getRefundAmount());
                response.put("status", protocolWithholdRefundQueryResponseModel.getStatus());
                response.put("participantActualRefundAmount", protocolWithholdRefundQueryResponseModel.getParticipantActualRefundAmount());
                response.put("errorDesc", protocolWithholdRefundQueryResponseModel.getErrorDesc());
                response.put("relateTransNo", protocolWithholdRefundQueryResponseModel.getRelateTransNo());
                break;
            case ENCHASHMENTCONFIRM:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：商户单笔提现确认接口< ant.mybank.bkcloudfunds.withdraw.applyconfirm>
                BkcloudfundsWithdrawApplyConfirmRequest withdrawApplyConfirmRequest = new BkcloudfundsWithdrawApplyConfirmRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                BkcloudfundsWithdrawApplyConfirmRequestModel withdrawApplyConfirmRequestModel = new BkcloudfundsWithdrawApplyConfirmRequestModel();
                withdrawApplyConfirmRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                withdrawApplyConfirmRequestModel.setMerchantId(map.get("merchantId").toString());
                withdrawApplyConfirmRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
                withdrawApplyConfirmRequestModel.setOrderNo(map.get("orderNo").toString());
                withdrawApplyConfirmRequestModel.setPlatformFee(map.get("platformFee").toString());
                withdrawApplyConfirmRequestModel.setFeeCurrency("CNY");
                withdrawApplyConfirmRequestModel.setTotalAmount(map.get("cashAmt").toString());
                withdrawApplyConfirmRequestModel.setCurrency("CNY");
                withdrawApplyConfirmRequestModel.setSmsCode(map.get("smsCode").toString());
                withdrawApplyConfirmRequestModel.setMemo("账户提现确认");

                withdrawApplyConfirmRequest.setRequestBody(withdrawApplyConfirmRequestModel);

                System.out.println(withdrawApplyConfirmRequest.getRequestHead().getFunction() + "=========>>" + withdrawApplyConfirmRequest.getRequestHead().getReqMsgId());
                BkcloudfundsWithdrawApplyConfirmResponse withdrawApplyConfirmResponse = mybankClient.execute(withdrawApplyConfirmRequest);
                BkcloudfundsWithdrawApplyConfirmResponseModel withdrawApplyConfirmResponseModel = withdrawApplyConfirmResponse.getBkcloudfundsWithdrawApplyConfirm().getBkcloudfundsWithdrawApplyConfirmResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + withdrawApplyConfirmResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + withdrawApplyConfirmResponse.getXmlContent());
                info = withdrawApplyConfirmResponseModel.getRespInfo();
                response.put("request_content",withdrawApplyConfirmResponse.getRequestContent());
                response.put("response_content",withdrawApplyConfirmResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("orderNo", withdrawApplyConfirmResponseModel.getOrderNo());
                response.put("outTradeNo", withdrawApplyConfirmResponseModel.getOutTradeNo());
                break;
            case UPLOAD:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.uploadphotoUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：图片上传接口<ant.mybank.merchantprod.merchant.uploadphoto>
                MerchantprodMerchantUploadphotoRequest merchantUploadphotoRequest = new MerchantprodMerchantUploadphotoRequest();

                //以下方法为demo的model入参方式
                MerchantprodMerchantUploadphotoRequestModel uploadphotoRequestModel = new MerchantprodMerchantUploadphotoRequestModel();
                uploadphotoRequestModel.setAppId(MybankConfig.appId);
                uploadphotoRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                uploadphotoRequestModel.setOutTradeNo(UUID.randomUUID().toString().replace("-", ""));
                uploadphotoRequestModel.setPhotoType(map.get("type").toString());//01 身份证正面,02 身份证反面,03 营业执照
                uploadphotoRequestModel.setReqTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern(MybankConstants.DATE_TIME_FORMAT)));

                File picture = new File(map.get("filePath").toString());//测试项目文件，正常调用时可以通过file对象传参
                uploadphotoRequestModel.setPicture(picture);

                merchantUploadphotoRequest.setUploadphotoRequestModel(uploadphotoRequestModel);
                System.out.println("[requestUrl：" + MybankConfig.uploadphotoUrl + "] " + merchantUploadphotoRequest.getApiFunction() + " =========>> " + merchantUploadphotoRequest.getUploadphotoRequestModel().getOutTradeNo());
                MerchantprodMerchantUploadphotoResponse uploadphotoResponse = mybankClient.execute(merchantUploadphotoRequest);
                MerchantprodMerchantUploadphotoResponseModel uploadphotoResponseModel = uploadphotoResponse.getMerchantUploadphoto().getMerchantUploadphotoResponseModel();
                info = uploadphotoResponseModel.getRespInfo();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + uploadphotoResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + uploadphotoResponse.getXmlContent());
                logger.info(">>>>>>>>> 网商上传接口 返回报文："+uploadphotoResponse.getXmlContent());
                response.put("request_content",uploadphotoResponse.getRequestContent());
                response.put("response_content",uploadphotoResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("photoUrl", uploadphotoResponseModel.getPhotoUrl());
                break;
            case ENT:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                MerchantprodMerchAppletPreRegisterRequest merchAppletPreRegisterRequest = new MerchantprodMerchAppletPreRegisterRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                MerchantprodMerchAppletPreRegisterRequestModel merchAppletPreRegisterRequestModel = new MerchantprodMerchAppletPreRegisterRequestModel();
                merchAppletPreRegisterRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                merchAppletPreRegisterRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
                merchAppletPreRegisterRequestModel.setOutMerchantId(map.get("reqSeqId").toString());
                merchAppletPreRegisterRequestModel.setMerchantType("03");
                merchAppletPreRegisterRequestModel.setMerchantName(map.get("regName").toString());
                merchAppletPreRegisterRequestModel.setDealType("02");
                merchAppletPreRegisterRequestModel.setCertPhotoA(map.get("certPhotoA").toString());
                merchAppletPreRegisterRequestModel.setCertPhotoB(map.get("certPhotoB").toString());
                merchAppletPreRegisterRequestModel.setLicensePhoto(map.get("licensePhoto").toString());
                MerchantDetail md = new MerchantDetail();
                md.setContactMobile(map.get("contactMobile").toString());
                md.setContactName(map.get("contactName").toString());
                md.setHandlePersonMobile(map.get("contactMobile").toString());
                md.setHandlePerson(map.get("contactName").toString());
                md.setHandlerPersonCertType("01");
                md.setHandlePersonCertNo(map.get("contactIdcardNo").toString());
                String legalCertType = map.get("legalCertType").toString();
                legalCertType = StringUtils.isEmpty(legalCertType)?"00":legalCertType;
//            {value:'00',label:'身份证'},
//            {value:'01',label:'护照'},
//            {value:'02',label:'军官证'},
//            {value:'03',label:'士兵证'},
//            {value:'04',label:'回乡证'},
//            {value:'05',label:'户口本'},
//            {value:'06',label:'外国护照'},
//            {value:'09',label:'警官证'},
//            {value:'11',label:'港澳台同胞通行证'}
                legalCertType = "00".equals(legalCertType)?"01":
                        "01".equals(legalCertType)?"02":
                                "02".equals(legalCertType)?"01":
                                        "03".equals(legalCertType)?"01":
                                                "04".equals(legalCertType)?"01":
                                                        "05".equals(legalCertType)?"01":
                                                                "06".equals(legalCertType)?"02":
                                                                        "09".equals(legalCertType)?"01":
                                                                                "11".equals(legalCertType)?"115":
                                                                                        "12".equals(legalCertType)?"114":"01";
                md.setPrincipalCertType(legalCertType);
//                md.setPrincipalCertType("01");
                md.setPrincipalCertVld(map.get("legalCertEndDate").toString());
                md.setPrincipalCertNo(map.get("legalCertNo").toString());
                md.setPrincipalMobile(map.get("contactMobile").toString());
                md.setPrincipalPerson(map.get("legalName").toString());
                md.setBussAuthNo(map.get("licenseCode").toString());
                md.setBussAuthVld(map.get("licenseEndDate").toString());
                String bussAuthType = map.get("regName").toString().contains("培训学校")?"45":"12";
                md.setBussAuthType(bussAuthType);
                md.setProvince(map.get("regProvId").toString());
                md.setCity(map.get("regAreaId").toString());
                md.setDistrict(map.get("regDistrictId").toString());
                md.setAddress(map.get("regDetail").toString());
                merchAppletPreRegisterRequestModel.setMerchantDetail(Base64.getEncoder().encodeToString(JSONObject.toJSONString(md).getBytes(StandardCharsets.UTF_8)));
                BankCardParam bcp = new BankCardParam();
                bcp.setBankCardNo(map.get("card_no").toString());
                bcp.setBankCertName(map.get("card_name").toString());
                bcp.setBranchName(map.get("branch_name").toString());
                bcp.setBranchProvince(map.get("prov_id").toString());
                bcp.setBranchCity(map.get("area_id").toString());
                bcp.setAccountType("02");
                bcp.setContactLine(map.get("branch_code").toString());
                bcp.setSettlementAccountType("01");
                merchAppletPreRegisterRequestModel.setBankCardParam(Base64.getEncoder().encodeToString(JSONObject.toJSONString(bcp).getBytes(StandardCharsets.UTF_8)));
                merchAppletPreRegisterRequest.setRequestBody(merchAppletPreRegisterRequestModel);
                MerchantprodMerchAppletPreRegisterResponse merchAppletPreRegisterResponse = mybankClient.execute(merchAppletPreRegisterRequest);
                MerchantprodMerchAppletPreRegisterResponseModel merchAppletPreRegisterResponseModel =
                        merchAppletPreRegisterResponse.getMerchantprodMerchAppletPreRegister().getMerchantprodMerchAppletPreRegisterResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchAppletPreRegisterResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchAppletPreRegisterResponse.getXmlContent());
                info = merchAppletPreRegisterResponseModel.getRespInfo();
                response.put("request_content",merchAppletPreRegisterResponse.getRequestContent());
                response.put("response_content",merchAppletPreRegisterResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("orderNo", merchAppletPreRegisterResponseModel.getOrderNo());
                break;
            case ENTMODIFY:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：商户信息修改< ant.mybank.merchantprod.merch.async.updateMerchant>
                MerchantprodMerchAsyncUpdateMerchantRequest merchUpdateMerchantRequest = new MerchantprodMerchAsyncUpdateMerchantRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                MerchantprodMerchAsyncUpdateMerchantRequestModel merchUpdateMerchantRequestModel = new MerchantprodMerchAsyncUpdateMerchantRequestModel();
                merchUpdateMerchantRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                merchUpdateMerchantRequestModel.setMerchantId(map.get("merchantId").toString());//商户号
                merchUpdateMerchantRequestModel.setDealType("01");
                //json格式base64编码
                MerchantUpdDetail mud = new MerchantUpdDetail();
                mud.setContactMobile(map.get("contactMobile").toString());
                mud.setContactName(map.get("contactName").toString());
                mud.setPrincipalCertVld(map.get("legalCertEndDate").toString());
                mud.setPrincipalMobile(map.get("contactMobile").toString());
                mud.setBussAuthVld(map.get("licenseEndDate").toString());
                mud.setProvince(map.get("regProvId").toString());
                mud.setCity(map.get("regAreaId").toString());
                mud.setDistrict(map.get("regDistrictId").toString());
                mud.setAddress(map.get("regDetail").toString());
                mud.setCertPhotoA(map.get("certPhotoA").toString());
                mud.setCertPhotoB(map.get("certPhotoB").toString());
                mud.setLicensePhoto(map.get("licensePhoto").toString());
                merchUpdateMerchantRequestModel.setMerchantDetail(Base64.getEncoder().encodeToString(JSONObject.toJSONString(mud).getBytes(StandardCharsets.UTF_8)));
                BankCardParam bcpu = new BankCardParam();
                bcpu.setBankCardNo(map.get("card_no").toString());
//                bcpu.setBankCertName(map.get("card_name").toString());
                bcpu.setBranchName(map.get("branch_name").toString());
                bcpu.setBranchProvince(map.get("prov_id").toString());
                bcpu.setBranchCity(map.get("area_id").toString());
                bcpu.setAccountType("02");
                bcpu.setContactLine(map.get("branch_code").toString());
                bcpu.setSettlementAccountType("01");
                merchUpdateMerchantRequestModel.setBankCardParam(cn.hutool.core.codec.Base64.encode(JSONObject.toJSONString(bcpu),StandardCharsets.UTF_8));
                merchUpdateMerchantRequestModel.setOutTradeNo(map.get("reqSeqId").toString());
//                merchUpdateMerchantRequestModel.setMcc("");
//                merchUpdateMerchantRequestModel.setAuthCode("");//验证码

                merchUpdateMerchantRequest.setRequestBody(merchUpdateMerchantRequestModel);
                MerchantprodMerchAsyncUpdateMerchantResponse merchUpdateMerchantResponse = mybankClient.execute(merchUpdateMerchantRequest);
                MerchantprodMerchAsyncUpdateMerchantResponseModel merchUpdateMerchantResponseModel = merchUpdateMerchantResponse.getMerchantprodMerchAsyncUpdateMerchant().getMerchantprodMerchAsyncUpdateMerchantResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchUpdateMerchantResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchUpdateMerchantResponse.getXmlContent());
                info = merchUpdateMerchantResponseModel.getRespInfo();
                response.put("request_content",merchUpdateMerchantResponse.getRequestContent());
                response.put("response_content",merchUpdateMerchantResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("outTradeNo", merchUpdateMerchantResponseModel.getOrderNo());//外部交易号
                break;
            case YHACTIVE:
                String outMchId = map.get("merchantId").toString();
                String profile = MybankConfig.bkServerUrl.contains("dev.com")?"test":"prod";
                String uid = "2088602759753149";
                String url = "alipays://platformapi/startapp?appId=2021001187624111&nbupdate=syncforce&query=outMchId%3D"+outMchId+"%26isv%3D"+MybankConfig.isvOrgId+"%26app%3Dbkclfs%26t%3DREGISTER";
                if("test".equalsIgnoreCase(profile)) {
                    url = "alipays://platformapi/startapp?appId=2021002115660005&nbupdate=syncforce&query=outMchId%3D"+outMchId+"%26isv%3D"+MybankConfig.isvOrgId+"%26app%3Dbkclfs%26t%3DREGISTER%26uid%3D"+uid;
                }
                response.put("resp_code","00000000");
                response.put("resp_desc","");
                response.put("url", url);
                break;
            case YHLOGIN:
                outMchId = map.get("merchantId").toString();
                profile = MybankConfig.bkServerUrl.contains("dev.com")?"test":"prod";
                uid = "2088602759753149";
                url = "alipays://platformapi/startapp?appId=2021001187624111&nbupdate=syncforce&query=mchId%3D"+outMchId+"%26isv%3D"+MybankConfig.isvOrgId+"%26app%3Dbkclfs%26t%3DLOGIN";
                if("test".equalsIgnoreCase(profile)) {
                    url = "alipays://platformapi/startapp?appId=2021002115660005&nbupdate=syncforce&query=mchId%3D"+outMchId+"%26isv%3D"+MybankConfig.isvOrgId+"%26app%3Dbkclfs%26t%3DLOGIN%26uid%3D"+uid;
                }
                response.put("resp_code","00000000");
                response.put("resp_desc","");
                response.put("url", url);
                break;
            case SHRZQUERY:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：商户入驻结果查询<ant.mybank.merchantprod.merch.register.query>
                MerchantprodMerchRegisterQueryRequest merchRegisterQueryRequest = new MerchantprodMerchRegisterQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                MerchantprodMerchRegisterQueryRequestModel merchRegisterQueryRequestModel = new MerchantprodMerchRegisterQueryRequestModel();
                merchRegisterQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                merchRegisterQueryRequestModel.setOrderNo(map.get("orderNo").toString());

                merchRegisterQueryRequest.setRequestBody(merchRegisterQueryRequestModel);
                MerchantprodMerchRegisterQueryResponse merchRegisterQueryResponse = mybankClient.execute(merchRegisterQueryRequest);
                MerchantprodMerchRegisterQueryResponseModel merchRegisterQueryResponseModel = merchRegisterQueryResponse.getMerchantprodMerchRegisterQuery().getMerchantprodMerchRegisterQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchRegisterQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchRegisterQueryResponse.getXmlContent());
                info = merchRegisterQueryResponseModel.getRespInfo();
                response.put("request_content",merchRegisterQueryResponse.getRequestContent());
                response.put("response_content",merchRegisterQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("registerStatus", merchRegisterQueryResponseModel.getRegisterStatus());//0：注册中 1：成功 2：失败
                response.put("merchantId", merchRegisterQueryResponseModel.getMerchantId());//商户号
                response.put("failReason", merchRegisterQueryResponseModel.getFailReason());//失败原因
                break;
            case SHXGQUERY:
                //实例化客户端 TODO
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：商户入驻结果查询<ant.mybank.merchantprod.merch.async.updateMerchant.query>
                MerchantprodMerchAsyncUpdateMerchantQueryRequest merchAsyncUpdateMerchantQueryRequest = new MerchantprodMerchAsyncUpdateMerchantQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                MerchantprodMerchAsyncUpdateMerchantQueryRequestModel merchAsyncUpdateMerchantQueryRequestModel = new MerchantprodMerchAsyncUpdateMerchantQueryRequestModel();
                merchAsyncUpdateMerchantQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                merchAsyncUpdateMerchantQueryRequestModel.setOrderNo(map.get("orderNo").toString());

                merchAsyncUpdateMerchantQueryRequest.setRequestBody(merchAsyncUpdateMerchantQueryRequestModel);
                MerchantprodMerchAsyncUpdateMerchantQueryResponse merchAsyncUpdateMerchantQueryResponse = mybankClient.execute(merchAsyncUpdateMerchantQueryRequest);
                MerchantprodMerchAsyncUpdateMerchantQueryResponseModel merchAsyncUpdateMerchantQueryResponseModel = merchAsyncUpdateMerchantQueryResponse.getMerchantprodMerchAsyncUpdateMerchantQuery().getMerchantprodMerchAsyncUpdateMerchantQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchAsyncUpdateMerchantQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchAsyncUpdateMerchantQueryResponse.getXmlContent());
                info = merchAsyncUpdateMerchantQueryResponseModel.getRespInfo();
                response.put("request_content",merchAsyncUpdateMerchantQueryResponse.getRequestContent());
                response.put("response_content",merchAsyncUpdateMerchantQueryResponse.getXmlContent());
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                if("F".equals(info.getResultStatus())){
                    break;
                }
                response.put("status", merchAsyncUpdateMerchantQueryResponseModel.getStatus());//0：注册中 1：成功 2：失败
                response.put("merchantId", merchAsyncUpdateMerchantQueryResponseModel.getMerchantId());//商户号
                response.put("failReason", merchAsyncUpdateMerchantQueryResponseModel.getFailReason());//失败原因
                break;
            case SHQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：商户信息查询接口<ant.mybank.merchantprod.merch.query>
                MerchantprodMerchQueryRequest merchQueryRequest = new MerchantprodMerchQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                MerchantprodMerchQueryRequestModel merchQueryRequestModel = new MerchantprodMerchQueryRequestModel();
                merchQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                merchQueryRequestModel.setMerchantId(map.get("merchantId").toString());

                merchQueryRequest.setRequestBody(merchQueryRequestModel);
                MerchantprodMerchQueryResponse merchQueryResponse = mybankClient.execute(merchQueryRequest);
                MerchantprodMerchQueryResponseModel merchQueryResponseModel = merchQueryResponse.getMerchantprodMerchQuery().getMerchantprodMerchQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchQueryResponse.getXmlContent());
                info = merchQueryResponseModel.getRespInfo();
                String merchantDetail = new String(Base64.getDecoder().decode(merchQueryResponseModel.getMerchantDetail()), StandardCharsets.UTF_8);
                System.out.println(merchantDetail);
                JSONObject a = JSONObject.parseObject(merchantDetail);
                if(StringUtils.isNotEmpty(merchQueryResponseModel.getBankCardParam())){
                    String bankCardParam = new String(Base64.getDecoder().decode(merchQueryResponseModel.getBankCardParam()), StandardCharsets.UTF_8);
                    System.out.println(bankCardParam);
                    a.putAll(JSONObject.parseObject(bankCardParam));
                }
                response.put("request_content",merchQueryResponse.getRequestContent());
                response.put("response_content",merchQueryResponse.getXmlContent());
                response.put("merchantDetail",a);
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                break;
            case YHQUERY:
                //实例化客户端
                mybankClient = new DefaultMybankClient(MybankConfig.bkServerUrl, MybankConfig.privateKey, MybankConfig.mybankPublicKey, MybankConfig.checkPublicKey);
                //实例化具体API对应的request类,当前调用API接口：小程序入驻结果查询接口<ant.mybank.merchantprod.merch.applet.register.query>
                MerchantprodMerchAppletRegisterQueryRequest merchAppletRegisterQueryRequest = new MerchantprodMerchAppletRegisterQueryRequest(MybankConfig.appId);

                //以下方法为demo的model入参方式
                MerchantprodMerchAppletRegisterQueryRequestModel merchAppletRegisterQueryRequestModel = new MerchantprodMerchAppletRegisterQueryRequestModel();
                merchAppletRegisterQueryRequestModel.setIsvOrgId(MybankConfig.isvOrgId);
                merchAppletRegisterQueryRequestModel.setOutMerchantId(map.get("merchantId").toString());

                merchAppletRegisterQueryRequest.setRequestBody(merchAppletRegisterQueryRequestModel);
                MerchantprodMerchAppletRegisterQueryResponse merchAppletRegisterQueryResponse = mybankClient.execute(merchAppletRegisterQueryRequest);
                MerchantprodMerchAppletRegisterQueryResponseModel merchAppletRegisterQueryResponseModel = merchAppletRegisterQueryResponse.getMerchantprodMerchAppletRegisterQuery().getMerchantprodMerchAppletRegisterQueryResponseModel();
                // 客户端请求报文
                System.out.println("客户端请求报文=" + merchAppletRegisterQueryResponse.getRequestContent());
                // 服务端返回报文
                System.out.println("服务端返回报文=" + merchAppletRegisterQueryResponse.getXmlContent());
                response.put("request_content",merchAppletRegisterQueryResponse.getRequestContent());
                response.put("response_content",merchAppletRegisterQueryResponse.getXmlContent());
                info = merchAppletRegisterQueryResponseModel.getRespInfo();
                response.put("resp_code",info.getResultCode()+"0000");
                response.put("resp_desc",info.getResultMsg());
                response.put("registerStatus", merchAppletRegisterQueryResponseModel.getRegisterStatus());//0：注册中 1：成功 2：失败
                break;
            case BUSIMODIFY:
                //与商户入驻合并了
                response = doExecute(V2UserBusiModify.method(map));
                break;
            case BUSIOPEN:
                //与商户入驻合并了
                response = doExecute(V2UserBusiOpen.method(map));
                break;
            case JSPAY:
                response = doExecute(V2TradePaymentJspay.method(map),MERCHANTKEY);
                break;
            case SCANPAYQUERY:
                response = doExecute(V2TradePaymentScanpayQuery.method(map),MERCHANTKEY);
                break;
            case SCANPAYREFUND:
                response = doExecute(V2TradePaymentScanpayRefund.method(map),MERCHANTKEY);
                break;
            case REFUNDQUERY:
                response = doExecute(V2TradePaymentScanpayRefundquery.method(map),MERCHANTKEY);
                break;
            default:
                response = null;
        }
        System.out.println("返回数据:" + JSONObject.toJSONString(response));
        return response;
    }

}
