package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2UserBusiOpenRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.zbkj.service.huifu.constants.HFProfileConstants;
import com.zbkj.service.huifu.core.Identify;

import java.util.HashMap;
import java.util.Map;

/**
 * 用户业务入驻 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2UserBusiOpenRequest.class)
public class V2UserBusiOpen {

    public static V2UserBusiOpenRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2UserBusiOpenRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2UserBusiOpenRequest.class);
//        V2UserBusiOpenRequest request = new V2UserBusiOpenRequest();
        // 汇付ID
//        request.setHuifuId("");
        // 请求流水号
//        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 渠道商/商户汇付Id
        request.setUpperHuifuId(HFProfileConstants.HUIFU_ID);

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 结算信息配置
        // extendInfoMap.put("&lt;span class&#x3D;&quot;extend settle_config&quot;&gt;settle_config&lt;/span&gt;", "");
        // 结算卡信息
        extendInfoMap.put("card_info", map);
        // 取现配置列表
         extendInfoMap.put("cash_config", getCashConfigs(map));
        // 文件列表
        // extendInfoMap.put("&lt;span class&#x3D;&quot;extend file_list&quot;&gt;file_list&lt;/span&gt;", "");
        // 延迟入账开关
        // extendInfoMap.put("delay_flag", "");
        return extendInfoMap;
    }

    private static String getCashConfigs(Map<String, Object> map) {
        JSONArray dtoList = new JSONArray();
        if(String.valueOf(map.get("cash_type")).contains("D1")){
            JSONObject d1 = new JSONObject();
            // 业务类型 D1：下一自然日到银行账户
            d1.put("cash_type", "D1");
            // 取现手续费率（%）
            d1.put("fee_rate", "0.00");
            dtoList.add(d1);
        }
        if(String.valueOf(map.get("cash_type")).contains("D0")){
            JSONObject d0 = new JSONObject();
            // 业务类型 D0：当日到银行账户；
            d0.put("cash_type", "D0");
            // 取现手续费率（%）
            d0.put("fee_rate", "0.02");
            dtoList.add(d0);
        }
        return dtoList.toJSONString();
    }
}
