package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.response.*;
import com.zbkj.common.response.bcx.BcxProductRiskResponse;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 商品表 Mapper 接口
 * </p>
 *
 * @author HZW
 * @since 2022-07-19
 */
public interface ProductDao extends BaseMapper<Product> {
    /**
     * 平台端商品分页列表
     * @param map 查询参数
     */
    List<PlatformProductListResponse> getPlatformPageList(Map<String, Object> map);

    /**
     * 移动端商品列表
     * @param map 查询参数
     */
    List<ProductFrontResponse> findH5List(Map<String, Object> map);

    /**
     * 商品搜索分页列表（活动）
     * @param map 查询参数
     */
    List<ProductActivityResponse> getActivitySearchPage(Map<String, Object> map);

    /**
     * 商品搜索分页列表（活动）商户
     * @param map 查询参数
     */
    List<ProductActivityResponse> getActivitySearchPageByMerchant(Map<String, Object> map);

    List<BcxProductInfoResponse> getPcProductList(Map<String,Object> map);

    List<BcxProductRiskResponse> getRiskProduct();
}
