package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.response.MerchantOrderPageResponse;
import com.zbkj.common.response.PlatformOrderPageResponse;
import com.zbkj.common.response.bcx.BcxOrderSummaryInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 订单表 Mapper 接口
 * </p>
 *
 * @author HZW
 * @since 2022-09-19
 */
public interface OrderDao extends BaseMapper<Order> {

    /**
     * 获取用户购买的商品数量
     * @param uid 用户ID
     * @param proId 商品ID
     * @param productType 商品类型
     */
    Integer getProductNumCount(@Param(value = "uid") Integer uid, @Param(value = "proId") Integer proId, @Param(value = "productType") Integer productType);

    List<PlatformOrderPageResponse> queryPlatformOrderList(Map<String, Object> params);

    BcxOrderSummaryInfo queryPlatformOrderSummary(Map<String, Object> queryParam);

    List<MerchantOrderPageResponse> queryMerchantOrderList(Map<String, Object> queryParam);

    BcxOrderSummaryInfo queryMerchantOrderSummary(Map<String, Object> queryParam);
}
