package com.zbkj.front.controller;


import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxProductBenefitsResponse;
import com.zbkj.common.response.BcxProductDetailResponse;
import com.zbkj.common.response.BcxProductInfoResponse;
import com.zbkj.common.response.BcxProductMenuResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.front.service.FrontProductService;
import com.zbkj.service.service.BcxProductMenuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * PC商品控制器
 */
@Slf4j
@RestController
@RequestMapping("api/front/pc")
@Api(tags = "PC商品控制器")
public class PcProductController {

    @Autowired
    private FrontProductService productService;
    @Autowired
    private BcxProductMenuService bcxProductMenuService;

    @ApiOperation(value = "PC商城应用市场 首页商品列表")
    @RequestMapping(value = "/product/index", method = RequestMethod.GET)
    public CommonResult<List<BcxProductInfoResponse>> getPcProductList() {
        return CommonResult.success(productService.findPcIndexProductList());
    }

    @ApiOperation(value = "PC商城应用市场 首页菜单列表")
    @RequestMapping(value = "/product/menu", method = RequestMethod.GET)
    public CommonResult<List<BcxProductMenuResponse>> getPcProductMenuList() {
        return CommonResult.success(bcxProductMenuService.getCacheTree(0));
    }

    @ApiOperation(value = "PC商城应用市场 按名字,类别搜索商品")
    @RequestMapping(value = "/product/search", method = RequestMethod.GET)
    public CommonResult<List<BcxProductInfoResponse>> getPcProductByNameAndCategory(@RequestParam(value = "name", required = false) String name,
                                                                                    @RequestParam(value = "firstCategoryId", required = false) String firstCategory,
                                                                                    @RequestParam(value = "secondCategoryId", required = false) String secondCategory,
                                                                                    @RequestParam(value = "thirdCategoryId", required = false) String thirdCategory) {
        return CommonResult.success(productService.findPcProductByNameAndCategory(name, firstCategory, secondCategory, thirdCategory));
    }

    @ApiOperation(value = "PC商品详情")
    @RequestMapping(value = "/product/detail/{id}", method = RequestMethod.GET)
    public CommonResult<BcxProductDetailResponse> getPCProductDetail(@Validated @PathVariable Integer id) {
        return CommonResult.success(productService.getPcProductDetail(id));
    }

    @ApiOperation(value = "福利商品列表")
    @RequestMapping(value = "/benefits", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxProductBenefitsResponse>> getBenefitsList(@ModelAttribute PageParamRequest pageRequest) {
        return CommonResult.success(CommonPage.restPage(productService.findBenefitsList(pageRequest)));
    }
}



