package com.zbkj.common.response.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 订单设备导入响应对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxOrderDeviceNoImportResponse对象", description = "订单设备导入响应对象")
public class BcxOrderDeviceNoImportResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "导入结果")
    private String msg;

    @ApiModelProperty(value = "第几行")
    private Integer rowIndex;

    @ApiModelProperty(value = "导入是否成功")
    private Boolean success;
}
