package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * description: v5区域表 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxRegionResponse对象", description = "v5区域表 response对象")
public class BcxRegionResponse implements Serializable {


    @ApiModelProperty(value = "区域code")
    private String regionCode;

    @ApiModelProperty(value = "上级区域code")
    private String parentCode;
    
    @ApiModelProperty(value = "区域名称")
    private String regionName;

    @ApiModelProperty(value = "子区域列表")
    private List<BcxRegionResponse> childrenList;

    public void addChildren(BcxRegionResponse children) {
        if (childrenList == null) {
            childrenList = new ArrayList<>();
        }
        childrenList.add(children);
    }
}