package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 线下支付凭证请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxPayOfflineFileRequest对象", description = "线下支付凭证请求对象")
public class BcxPayOfflineFileRequest implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "线下支付凭证id")
    private Integer id;

    @ApiModelProperty(value = "线下支付id")
    private Integer payOfflineId;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "支付凭证url")
    private String fileUrl;
}
