package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * <b> 创建虚拟订单转实际订单请求对象 </b>
 * @author ZXF
 * @create 2025/08/26 0026 17:34
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="CreateVirtualOrderRequest对象", description="创建虚拟订单转实际订单请求对象")
public class CreateVirtualOrderRequest implements Serializable {

    private static final long serialVersionUID = -6133994384185333872L;

    @ApiModelProperty(value = "虚拟订单号列(多个逗号隔开)", required = true)
    @NotBlank(message = "虚拟订单号列不能为空")
    private String virtualOrderNos;

    @ApiModelProperty(value = "源单id")
    private String sourceId;
}
