package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <b>任务残留表（当某方法回传数据给第三方时未成功传递的单子会在当前表记录，用于定时器多次尝试回传如果传递成功，则成功的记录会销毁） </b>
 *
 * @author zxf
 * @注意事项 </b>
 * <b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_task_residual")
@ApiModel(value="TaskResidual对象", description="任务残留表")
public class TaskResidual implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**    方法名     */
    @ApiModelProperty(value = "方法名")
    private String methodName;
    /**    注释     */
    @ApiModelProperty(value = "注释")
    private String annotation;
    /**    类全称     */
    @ApiModelProperty(value = "类全称")
    private String className;
    /**    参数个数     */
    @ApiModelProperty(value = "参数个数")
    private int paramNum = 0;
    /**    参数类型数组     */
    @ApiModelProperty(value = "参数类型数组")
    private String paramTypeArr;
    /**    参数值数组     */
    @ApiModelProperty(value = "参数值数组")
    private String paramValueArr;
    /**    创建时间     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**    是否夜间执行     */
    @ApiModelProperty(value = "是否夜间执行")
    private String isNightlyRun = "0";

    public TaskResidual(){}

    public TaskResidual(String methodName, String annotation, String className, int paramNum, String paramTypeArr, String paramValueArr){
        this.methodName = methodName;
        this.annotation = annotation;
        this.className = className;
        this.paramNum = paramNum;
        this.paramTypeArr = paramTypeArr;
        this.paramValueArr = paramValueArr;
        this.createTime = new Date();
    }

    public TaskResidual(String methodName, String annotation, String className, int paramNum, String paramTypeArr, String paramValueArr, String isNightlyRun){
        this.methodName = methodName;
        this.annotation = annotation;
        this.className = className;
        this.paramNum = paramNum;
        this.paramTypeArr = paramTypeArr;
        this.paramValueArr = paramValueArr;
        this.isNightlyRun = isNightlyRun;
        this.createTime = new Date();
    }

}